

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSurveyBackupCopyJobStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSurveyBackupCopyJobStats.sp,v $ $Id: ParseSurveyBackupCopyJobStats.sp,v 1.1.2.8 2020/12/17 02:46:41 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseSurveyBackupCopyJobStats')
BEGIN
	print '>>> Drop Stored Procedure: ParseSurveyBackupCopyJobStats <<<'
	drop procedure ParseSurveyBackupCopyJobStats
END
IF EXISTS (select * from GxQscripts where name='ParseSurveyBackupCopyJobStats')
	delete from GxQscripts where name = 'ParseSurveyBackupCopyJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSurveyBackupCopyJobStats')
	delete from GXDBVersions where aliasname = 'ParseSurveyBackupCopyJobStats'
GO
print '... Creating Procedure: ParseSurveyBackupCopyJobStats'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseSurveyBackupCopyJobStats
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseSurveyBackupCopyJobStats 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @queylastMonth      DATE
DECLARE @queryFirstMonth    DATE
--DECLARE @isPrivate 			INT = 0
--SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig (NoLOCK) WHERE Name = 'isPrivate'
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF object_id('tempdb.dbo.#SurveyBackupCopyJobStats') IS NOT null DROP TABLE #SurveyBackupCopyJobStats
IF object_id('tempdb.dbo.#BackupCopyDailyJobs') IS NOT null DROP TABLE #BackupCopyDailyJobs
IF object_id('tempdb.dbo.#tmpAggregateJobs') IS NOT null DROP TABLE #tmpAggregateJobs
CREATE TABLE #SurveyBackupCopyJobStats
(
	CommservUniqueID INT NOT NULL,
	JobId INT,
	SnapJobIDActedOn  INT,
	AppId INT,
	BkpLevel INT,
	Status INT,
	ScanType INT,
	StartDate INT,
	EndDate INT,
	SizeChangePct INT,
	TransferTime INT,
	ProtectedObjects BIGINT,
	FailedObjects BIGINT,
	FailedFolders BIGINT,
	DataProtected BIGINT,
	DataCompressed BIGINT,
	DataTransferred BIGINT,
	DataWritten BIGINT,
	ErrorCode VARCHAR(32),
	FailureReason NVARCHAR(512),
	StoragePolicy NVARCHAR(144),
	StoragePolicyID INT NULL,
	SchedulePolicy NVARCHAR(256) NULL,
	ScheduleName NVARCHAR(256) NULL,
	Attempts INT NULL,
	InitFrom INT NULL,
	Phases INT NULL,
	failureErrorCode	INT NULL
 )
	   IF  (@ErrorCode = 0)
	    BEGIN
			--populate data to detail backupcopy job IN TEMP TABLE FIRST
			INSERT INTO #SurveyBackupCopyJobStats(CommservUniqueID,JobId, SnapJobIDActedOn, AppId, BkpLevel, Status, ScanType, StartDate, EndDate,
	                                        SizeChangePct, TransferTime, ProtectedObjects, FailedObjects, FailedFolders, DataProtected, DataCompressed,
											DataTransferred, DataWritten, ErrorCode, FailureReason, StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName,
											Attempts, InitFrom, Phases, failureErrorCode
											)
	SELECT
		@CSUniqueId,
        csInfo.n.value('@JobId', 'INT'),
		csInfo.n.value('@SnapJobIDActedOn', 'INT'),
        csInfo.n.value('@AppId', 'INT'),
        csInfo.n.value('@BkpLevel', 'INT'),
        csInfo.n.value('@Status', 'INT'),
        csInfo.n.value('@ScanType', 'INT'),
        csInfo.n.value('@StartDate', 'INT'),
        csInfo.n.value('@EndDate', 'INT'),
        csInfo.n.value('@SizeChangePct', 'INT'),
        csInfo.n.value('@TransferTime', 'INT'),
        csInfo.n.value('@ProtectedObjects', 'BIGINT'),
        csInfo.n.value('@FailedObjects', 'BIGINT'),
        csInfo.n.value('@FailedFolders', 'BIGINT'),
        csInfo.n.value('@DataProtected', 'BIGINT'),
        csInfo.n.value('@DataCompressed', 'BIGINT'),
        csInfo.n.value('@DataTransferred', 'BIGINT'),
        csInfo.n.value('@DataWritten', 'BIGINT'),
        csInfo.n.value('@ErrorCode', 'VARCHAR(32)'),
        csInfo.n.value('@FailureReason', 'NVARCHAR(512)'),
        csInfo.n.value('@StoragePolicy', 'NVARCHAR(144)'),
        ISNULL(csInfo.n.value('@DataArchGroupId', 'INT'),0),
        csInfo.n.value('@SchedulePolicy', 'NVARCHAR(256)'),
        csInfo.n.value('@ScheduleName', 'NVARCHAR(256)'),
        csInfo.n.value('@Attempts', 'INT'),
        ISNULL(csInfo.n.value('@InitFrom', 'INT'),0),
        ISNULL(csInfo.n.value('@Phases'  , 'INT'),0),
        ISNULL(csInfo.n.value('@failureErrorCode'  , 'INT'),0)
    FROM
        @ResultXml.nodes('/JobDetails/BackupCopyJobStats') AS csInfo(n)
		SELECT @ErrorCode = @@ERROR
	END
		IF (@ErrorCode = 0)
		BEGIN
			--populate data to detail backupcopy job IN TEMP TABLE FIRST
			--- below logic will handly mutli surveys in one day scenarios
             DELETE FROM TCF
			 FROM  #SurveyBackupCopyJobStats TCF
			 INNER JOIN CF_SurveyBackupCopyJobStats CF
			 ON CF.CommservUniqueID = TCF.CommservUniqueID
			 AND CF.jobid = TCF.jobid
			 AND CF.SnapJobIDActedOn = TCF.SnapJobIDActedOn
			INSERT INTO CF_SurveyBackupCopyJobStats(CommservUniqueID,JobId, SnapJobIDActedOn, AppId, BkpLevel, Status, ScanType, StartDate, EndDate,
												SizeChangePct, TransferTime, ProtectedObjects, FailedObjects, FailedFolders, DataProtected, DataCompressed,
												DataTransferred, DataWritten, ErrorCode, FailureReason, StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName,
												Attempts, InitFrom, Phases, failureErrorCode
												)
            SELECT CommservUniqueID,JobId, SnapJobIDActedOn, AppId, BkpLevel, Status, ScanType, StartDate, EndDate,
					SizeChangePct, TransferTime, ProtectedObjects, FailedObjects, FailedFolders, DataProtected, DataCompressed,
					DataTransferred, DataWritten, ErrorCode, FailureReason, StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName,
					Attempts, InitFrom, Phases, failureErrorCode
            FROM #SurveyBackupCopyJobStats
			SELECT @ErrorCode = @@ERROR
  END
	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseSurveyBackupCopyJobStats 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSurveyBackupCopyJobStats')
	delete from GxQscripts where name = 'ParseSurveyBackupCopyJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSurveyBackupCopyJobStats')
	delete from GXDBVersions where aliasname = 'ParseSurveyBackupCopyJobStats'
GO

insert into GXDBVersions values(2, 'ParseSurveyBackupCopyJobStats',  '00010001000200080000', 'ParseSurveyBackupCopyJobStats', '00010001000200080000')
GO

