

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSourceDeDupEfficiency.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSourceDeDupEfficiency.sp,v $ $Id: ParseSourceDeDupEfficiency.sp,v 1.4.60.6 2020/12/17 02:48:23 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseSourceDeDupEfficiency')
BEGIN
	print '>>> Drop Stored Procedure: ParseSourceDeDupEfficiency <<<'
	drop procedure ParseSourceDeDupEfficiency
END
IF EXISTS (select * from GxQscripts where name='ParseSourceDeDupEfficiency')
	delete from GxQscripts where name = 'ParseSourceDeDupEfficiency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSourceDeDupEfficiency')
	delete from GXDBVersions where aliasname = 'ParseSourceDeDupEfficiency'
GO
print '... Creating Procedure: ParseSourceDeDupEfficiency'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseSourceDeDupEfficiency
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseSourceDeDupEfficiencyTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveySourceDeDupEfficiency (
		CommServUniqueId, SurveyResultId, LogDateUTC, LogDate,
		NonMAClients, NonMASubClients, NonMASCWithSourceDeDup, AvgDeDupSavings)
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@NonMAClients', 'BIGINT'),
		csInfo.n.value('@NonMASubClients', 'BIGINT'),
		csInfo.n.value('@NonMASCWithSourceDeDup', 'BIGINT'),
		csInfo.n.value('@AvgDeDupSavings', 'FLOAT')
	FROM
		@ResultXml.nodes('/SourceDeDupEfficiency') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveySubclientsNoSourceDedup (
		SurveyResultId, ClientName, AgentName, InstanceName, BackupsetName, SubclientName, SubclientDedupProp, ClientDedupProp,
		StoragePolicyName, PrimaryCopyName, DedupOnSource, ProtectedBytes, NwTransBytes)
	SELECT
		@ResultId,
		csInfo.n.value('@client','NVARCHAR(256)'),
		csInfo.n.value('@agent','VARCHAR(256)'),
		csInfo.n.value('@instance','NVARCHAR(512)'),
		csInfo.n.value('@backupset','NVARCHAR(128)'),
		csInfo.n.value('@subclient','NVARCHAR(128)'),
		ISNULL(csInfo.n.value('@subclientDedupProp','INT'), 0),
		ISNULL(csInfo.n.value('@clientDedupProp','INT'), 0),
		ISNULL(csInfo.n.value('@storagePolicy','NVARCHAR(144)'), ''),
		ISNULL(csInfo.n.value('@primaryCopy','NVARCHAR(64)'), ''),
		ISNULL(csInfo.n.value('@dedupOnSource','INT'), 0),
		ISNULL(csInfo.n.value('@protectedBytes','BIGINT'), 0),
		ISNULL(csInfo.n.value('@nwTransBytes','BIGINT'), 0)
	FROM
		@ResultXml.nodes('/SourceDeDupEfficiency/Subclient') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseSourceDeDupEfficiencyTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSourceDeDupEfficiency')
	delete from GxQscripts where name = 'ParseSourceDeDupEfficiency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSourceDeDupEfficiency')
	delete from GXDBVersions where aliasname = 'ParseSourceDeDupEfficiency'
GO

insert into GXDBVersions values(2, 'ParseSourceDeDupEfficiency',  '00010004006000060000', 'ParseSourceDeDupEfficiency', '00010004006000060000')
GO

