

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLicCurrentDetailsV2.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLicCurrentDetailsV2.sp,v $ $Id: ParseLicCurrentDetailsV2.sp,v 1.1.2.2 2018/08/30 22:24:06 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseLicCurrentDetailsV2')
BEGIN
	print '>>> Drop Stored Procedure: ParseLicCurrentDetailsV2 <<<'
	drop procedure ParseLicCurrentDetailsV2
END
IF EXISTS (select * from GxQscripts where name='ParseLicCurrentDetailsV2')
	delete from GxQscripts where name = 'ParseLicCurrentDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicCurrentDetailsV2')
	delete from GXDBVersions where aliasname = 'ParseLicCurrentDetailsV2'
GO
print '... Creating Procedure: ParseLicCurrentDetailsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseLicCurrentDetailsV2
  @QueryId INTEGER,
  @ResultId INTEGER,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLicCurrentDetailsV2Tran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @FileName NVARCHAR(1024)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#CurrentDetails') IS NOT NULL
    DROP TABLE #CurrentDetails
CREATE TABLE #CurrentDetails
(
	Date						DATETIME,
	nJobType					INT,
	AppId						INT,
	JobId						INT,
	ClientId					INT,
	AppTypeId					INT,
	SPId						INT,
	AppSizeMB					BIGINT,
	LicType						INT,
	IsVM						INT,
	CapacityFlag				INT,
	Organization				NVARCHAR(1024),
	OrgGUID						VARCHAR(40),
	ObjectName					NVARCHAR(1024),
	Association					NVARCHAR(255),
	PlanName					NVARCHAR(1024)
)
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(256) = 'BULK INSERT #CurrentDetails FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--handle comma in the column values
	UPDATE #CurrentDetails SET
	Organization = CASE WHEN Organization IS NOT NULL AND CHARINDEX('<COMMA>', Organization) > 0 THEN REPLACE (Organization,'<COMMA>',',')
						ELSE Organization
					END,
	ObjectName = CASE WHEN ObjectName IS NOT NULL AND CHARINDEX('<COMMA>', ObjectName) > 0 THEN REPLACE (ObjectName,'<COMMA>',',')
					  ELSE ObjectName
					END,
	Association = CASE WHEN Association IS NOT NULL AND CHARINDEX('<COMMA>', Association) > 0 THEN REPLACE (Association,'<COMMA>',',')
					   ELSE Association
					END,
	PlanName = CASE WHEN PlanName IS NOT NULL AND CHARINDEX('<COMMA>', PlanName) > 0 THEN REPLACE (PlanName,'<COMMA>',',')
					   ELSE PlanName
					END
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT 1 FROM #CurrentDetails)
BEGIN
	--for each CommCell, remove existing data from the cloud tables for storing latest usages. Only the latest usages are required always
	DELETE FROM cf_SurveyLicCurrentUsageDetails WHERE CommServUniqueId=@CSUniqueId
	DELETE FROM cf_SurveyLicCurrentCALDetails WHERE CommServUniqueId=@CSUniqueId
	--insert newly uploaded current usages into cloud tables
	INSERT cf_SurveyLicCurrentUsageDetails
	SELECT @CSUniqueId,GETDATE(),nJobType,AppId,JobId,ClientId,AppTypeId,SPId,AppSizeMB,LicType,IsVM,CapacityFlag,Organization,OrgGUID,PlanName
	FROM #CurrentDetails
	WHERE IsVM<>-2
	SELECT @ErrorCode = @@ERROR
	IF 	@ErrorCode = 0
	BEGIN
		INSERT cf_SurveyLicCurrentCALDetails
		SELECT @CSUniqueId,GETDATE(),nJobType,ClientId,AppId,AppTypeId,LicType,JobId,AppSizeMB,SPId,ObjectName,Association,Organization,OrgGUID,PlanName
		FROM #CurrentDetails
		WHERE IsVM=-2
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId INT, Flags INT) 
  		DECLARE	@LatestParsedResultId INT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLicCurrentDetailsV2Tran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLicCurrentDetailsV2')
	delete from GxQscripts where name = 'ParseLicCurrentDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicCurrentDetailsV2')
	delete from GXDBVersions where aliasname = 'ParseLicCurrentDetailsV2'
GO

insert into GXDBVersions values(2, 'ParseLicCurrentDetailsV2',  '00010001000200020000', 'ParseLicCurrentDetailsV2', '00010001000200020000')
GO

