

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLicCCLPeakSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLicCCLPeakSummary.sp,v $ $Id: ParseLicCCLPeakSummary.sp,v 1.1.2.4 2020/12/17 02:47:38 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseLicCCLPeakSummary')
BEGIN
	print '>>> Drop Stored Procedure: ParseLicCCLPeakSummary <<<'
	drop procedure ParseLicCCLPeakSummary
END
IF EXISTS (select * from GxQscripts where name='ParseLicCCLPeakSummary')
	delete from GxQscripts where name = 'ParseLicCCLPeakSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicCCLPeakSummary')
	delete from GXDBVersions where aliasname = 'ParseLicCCLPeakSummary'
GO
print '... Creating Procedure: ParseLicCCLPeakSummary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseLicCCLPeakSummary
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLicCCLPeakSummaryTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @FileName NVARCHAR(1024)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#Lic_CCLPeakSummary') IS NOT NULL
    DROP TABLE #Lic_CCLPeakSummary
CREATE TABLE #Lic_CCLPeakSummary
(
	MonthStart           DATETIME,
    UsageType            integer,
    PeakType             integer,
    AppTypeId            integer,
    LicType              integer,
    Usage		         BIGINT,
    CapacityFlag         integer,
    VMFlag               integer
)
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(256) = 'BULK INSERT #Lic_CCLPeakSummary FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND EXISTS (SELECT 1 FROM #Lic_CCLPeakSummary)
BEGIN
	--for each CommCell, remove existing CCL peak summary from the cloud table. Deletion should be done for all the months for which the new data has been uploaded from CS
	DELETE FROM Lic_PeakSummary
	WHERE CommServUniqueId = @CSUniqueId AND PeakType=0
	AND MonthStart IN (SELECT DISTINCT MonthStart FROM #Lic_CCLPeakSummary)
	--insert newly uploaded CCL peak summary into cloud table
	INSERT Lic_PeakSummary
	SELECT DISTINCT @CSUniqueId, MonthStart, UsageType, 0, AppTypeId, LicType, Usage, CapacityFlag, VMFlag
	FROM #Lic_CCLPeakSummary
	SELECT @ErrorCode = @@ERROR
END
IF OBJECT_ID('tempdb..#Lic_CCLPeakSummary') IS NOT NULL DROP TABLE #Lic_CCLPeakSummary
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLicCCLPeakSummaryTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLicCCLPeakSummary')
	delete from GxQscripts where name = 'ParseLicCCLPeakSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLicCCLPeakSummary')
	delete from GXDBVersions where aliasname = 'ParseLicCCLPeakSummary'
GO

insert into GXDBVersions values(2, 'ParseLicCCLPeakSummary',  '00010001000200040000', 'ParseLicCCLPeakSummary', '00010001000200040000')
GO

