

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDeDupStoreConfig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDeDupStoreConfig.sp,v $ $Id: ParseDeDupStoreConfig.sp,v 1.4.60.12 2020/12/17 02:53:02 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseDeDupStoreConfig')
BEGIN
	print '>>> Drop Stored Procedure: ParseDeDupStoreConfig <<<'
	drop procedure ParseDeDupStoreConfig
END
IF EXISTS (select * from GxQscripts where name='ParseDeDupStoreConfig')
	delete from GxQscripts where name = 'ParseDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'ParseDeDupStoreConfig'
GO
print '... Creating Procedure: ParseDeDupStoreConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseDeDupStoreConfig
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDeDupStoreConfigTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @WeekStart DATETIME = DATEADD(WEEK, DATEDIFF(WEEK, 0, @LogDate), 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDeDupStoreConfig
		(CommServUniqueId
		,SurveyResultId
		,LogDateUTC
		,LogDate
		,MediaAgentId
		,MediaAgentName
		,SIDBStoreId
		,SubstoreId
		,idxAccessPathId
		,SIDBStoreAliasName
		,accessPath
		,MACount
		,SIDBCountForMA
		,SubstoreCountForMA
		,SubstoreCountForStore
		,SealedStatus
		,SIDBStoreStatus
		,TotalDataSizeMB
		,SealedTime
		,TotalRecords
		,SealedReason
		,DDBDiskTotalSpaceMB
		,DDBDiskFreeSpaceMB
		,DDBUsedDiskSpaceMB)
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(256)'),
		csInfo.n.value('@SIDBStoreId', 'INTEGER'),
		csInfo.n.value('@SubstoreId', 'INTEGER'),
		csInfo.n.value('@idxAccessPathId', 'INTEGER'),
		csInfo.n.value('@SIDBStoreAliasName', 'NVARCHAR(256)'),
		csInfo.n.value('@AccessPath', 'NVARCHAR(256)'),
		csInfo.n.value('@MACount', 'INTEGER'),
		csInfo.n.value('@SIDBCountForMA', 'INTEGER'),
		csInfo.n.value('@SubstoreCountForMA', 'INTEGER'),
		csInfo.n.value('@SubstoreCountForStore', 'INTEGER'),
		csInfo.n.value('@SealedStatus', 'VARCHAR(16)'),
		ISNULL(csInfo.n.value('@SIDBStoreStatus', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalDataSizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@SealedTime', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalRecords', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@SealedReason', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@DDBDiskTotalSpaceMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@DDBDiskFreeSpaceMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@DDBUsedDiskSpaceMB', 'BIGINT'), 0)
	FROM
		@ResultXml.nodes('/DedupStoreConfigXML/DedupStoreConfig') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyDeDupStoreConfigPeakSize
	SET	DDBUsedDiskSpaceMB = CASE WHEN ISNULL(S.DDBUsedDiskSpaceMB, 0) > ISNULL(P.DDBUsedDiskSpaceMB,0) THEN ISNULL(S.DDBUsedDiskSpaceMB, 0) ELSE ISNULL(P.DDBUsedDiskSpaceMB, 0) END,
		DDBDiskFreeSpaceMB = CASE WHEN (ISNULL(S.DDBDiskFreeSpaceMB, 0) < ISNULL(P.DDBDiskFreeSpaceMB, 0)) OR ISNULL(P.DDBDiskFreeSpaceMB, 0) <= 0 THEN ISNULL(S.DDBDiskFreeSpaceMB, 0) ELSE ISNULL(P.DDBDiskFreeSpaceMB, 0) END
	FROM cf_SurveyDeDupStoreConfig S
		INNER JOIN cf_SurveyDeDupStoreConfigPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.WeekStart = @WeekStart AND P.SIDBStoreId = S.SIDBStoreId AND P.SubstoreId = S.SubstoreId
	WHERE S.DDBDiskTotalSpaceMB > 0 AND S.DDBDiskFreeSpaceMB > 0 and S.SurveyResultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDeDupStoreConfigPeakSize (
		CommServUniqueId, WeekStart, SIDBStoreId, SubstoreId, DDBUsedDiskSpaceMB, DDBDiskFreeSpaceMB)
	SELECT
		@CSUniqueId, @WeekStart, S.SIDBStoreId, S.SubstoreId,
		ISNULL(MAX(S.DDBUsedDiskSpaceMB), 0), ISNULL(MIN(S.DDBDiskFreeSpaceMB), 0)
	FROM cf_SurveyDeDupStoreConfig S
		LEFT OUTER JOIN cf_SurveyDeDupStoreConfigPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.WeekStart = @WeekStart AND P.SIDBStoreId = S.SIDBStoreId AND P.SubstoreId = S.SubstoreId
	WHERE P.CommServUniqueId IS NULL and S.SurveyResultId = @ResultId
	GROUP BY S.SIDBStoreId, S.SubstoreId
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDeDupStoreConfigTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDeDupStoreConfig')
	delete from GxQscripts where name = 'ParseDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'ParseDeDupStoreConfig'
GO

insert into GXDBVersions values(2, 'ParseDeDupStoreConfig',  '00010004006000120000', 'ParseDeDupStoreConfig', '00010004006000120000')
GO

