

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDRBkpStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDRBkpStatus.sp,v $ $Id: ParseDRBkpStatus.sp,v 1.2.60.8 2020/12/17 02:54:50 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseDRBkpStatus')
BEGIN
	print '>>> Drop Stored Procedure: ParseDRBkpStatus <<<'
	drop procedure ParseDRBkpStatus
END
IF EXISTS (select * from GxQscripts where name='ParseDRBkpStatus')
	delete from GxQscripts where name = 'ParseDRBkpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpStatus')
	delete from GXDBVersions where aliasname = 'ParseDRBkpStatus'
GO
print '... Creating Procedure: ParseDRBkpStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseDRBkpStatus
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDRBkpStatusTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDRStats
	(
		CommServUniqueId,
		SurveyResultId,
		LogDateUTC,
		LogDate,
		SuccessfulDRJobs,
		FailedDRJobs,
		LastSuccessfulDRTime,
		AverageFullBkpPeriodInDays,
		AverageDiffBkpFreq,
		LastFailedDRTime,
		DRBkpLocation,
		LastCweDRTime
	)
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@DR_No_Of_Success', 'BIGINT'),
		csInfo.n.value('@DR_No_Of_Failure', 'BIGINT'),
		csInfo.n.value('@Last_Successful_Dr', 'INTEGER'),
		csInfo.n.value('@full_backup_time_period', 'DECIMAL(10, 2)'),
		csInfo.n.value('@differential_backup_frequency', 'DECIMAL(10, 2)'),
		csInfo.n.value('@Last_Failed_Dr', 'INTEGER'),
		csInfo.n.value('@DRBkpLocation', 'NVARCHAR(256)'),
		csInfo.n.value('@Last_Cwe_Dr', 'INTEGER')
	FROM
		@ResultXml.nodes('/DRstats') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDRJobDetails
	(
		CommservUniqueId,
		SurveyResultId,
		JobId,
		Status,
		StartDate,
		EndDate,
		ErrorCode,
		FailureErrorCode,
		FailureReason,
		StoragePolicy,
		StoragePolicyCopy,
		Library,
		Barcode,
		LocationType,
		LocationName
	)
	SELECT
		@CSUniqueId,
		@ResultId,
		csInfo.n.value('@JobId', 'INT'),
		csInfo.n.value('@JobStatus', 'INT'),
		csInfo.n.value('@StartTime', 'INT'),
		csInfo.n.value('@EndTime', 'INT'),
		csInfo.n.value('@ErrorCode', 'VARCHAR(32)'),
		csInfo.n.value('@FailureErrorCode', 'INT'),
		csInfo.n.value('@FailureReason', 'NVARCHAR(512)'),
		csInfo.n.value('@SPName', 'NVARCHAR(256)'),
		csInfo.n.value('@SPCopyName', 'NVARCHAR(256)'),
		csInfo.n.value('@LibraryName', 'NVARCHAR(256)'),
		csInfo.n.value('@Barcode', 'NVARCHAR(256)'),
		csInfo.n.value('@LocationType', 'NVARCHAR(256)'),
		csInfo.n.value('@LocationName', 'NVARCHAR(256)')
	FROM
		@ResultXml.nodes('/DRstats/LastDRJobDetails') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDRBkpStatusTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDRBkpStatus')
	delete from GxQscripts where name = 'ParseDRBkpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpStatus')
	delete from GXDBVersions where aliasname = 'ParseDRBkpStatus'
GO

insert into GXDBVersions values(2, 'ParseDRBkpStatus',  '00010002006000080000', 'ParseDRBkpStatus', '00010002006000080000')
GO

