

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCustomQueryResult.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCustomQueryResult.sp,v $ $Id: ParseCustomQueryResult.sp,v 1.1.2.5 2020/12/17 02:52:56 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCustomQueryResult')
BEGIN
	print '>>> Drop Stored Procedure: ParseCustomQueryResult <<<'
	drop procedure ParseCustomQueryResult
END
IF EXISTS (select * from GxQscripts where name='ParseCustomQueryResult')
	delete from GxQscripts where name = 'ParseCustomQueryResult'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCustomQueryResult')
	delete from GXDBVersions where aliasname = 'ParseCustomQueryResult'
GO
print '... Creating Procedure: ParseCustomQueryResult'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCustomQueryResult
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON
-- This stored procedure is used for parsing custom queries with QueryId >= 10000
DECLARE	@StartDate	DATETIME = GETUTCDATE()
DECLARE	@Duration	INTEGER  = 0
DECLARE @ErrorCode	INTEGER  = 0
DECLARE @ErrorMsg	NVARCHAR(MAX)
DECLARE @LogString	NVARCHAR(MAX)
IF @LogLevel > 1
BEGIN
	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started'
	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
END
SET @LogString = ''
BEGIN TRY
--  QUERY SPECIFIC CODE BEGIN --
	DECLARE @TableName	NVARCHAR(100) = (SELECT DataTableName FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)
	DECLARE @InsertSql	NVARCHAR(MAX) = 'INSERT INTO ' + @TableName + '	SELECT CommservSurveyResults_ID'
	DECLARE	@varname	NVARCHAR(100)
	DECLARE	@vartype	NVARCHAR(100)
	IF @TableName IS NULL
	BEGIN
		SET @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - DataTableName is not set'
		INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
		RETURN
	END
	IF  OBJECT_ID(@TableName) IS NULL
	BEGIN
		SET @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - DataTable does not exist'
		INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
		RETURN
	END
	DECLARE @ColumnTable TABLE (columnId INT, columnName NVARCHAR(200), columnType NVARCHAR(200))
	INSERT	INTO @ColumnTable
	SELECT	c.column_id,
			c.name,
			t.name + CASE WHEN t.name = 'varchar' THEN '(' + CASE WHEN c.max_length = -1 THEN 'max' ELSE CAST(c.max_length AS VARCHAR(20)) END + ')'
					WHEN t.name = 'nvarchar' THEN '(' + CASE WHEN c.max_length = -1 THEN 'max' ELSE CAST(c.max_length/2 AS VARCHAR(20)) END + ')'
					WHEN t.name = 'decimal' THEN '(' + CAST(c.precision AS VARCHAR(20)) + ', ' + CAST(c.scale AS VARCHAR(20)) + ')'
					ELSE '' END
	FROM	sys.columns c INNER JOIN sys.types t ON c.user_type_id = t.user_type_id
	WHERE	c.object_id = object_id(@TableName)
	DECLARE columns CURSOR FOR
		SELECT columnName, columnType FROM @ColumnTable WHERE columnId > 1 ORDER BY columnId
	OPEN columns
		FETCH NEXT FROM columns INTO @varname, @vartype
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @InsertSql = @InsertSql + ',' + 'a.n.value(''@' + @varname + ''' , ''' + @vartype + ''')'
		FETCH NEXT FROM columns INTO @varname, @vartype
	END
	CLOSE columns
	DEALLOCATE columns
	SET @InsertSql = @InsertSql + '	FROM cf_CommservSurveyResults CROSS APPLY CollectedResults.nodes(''SurveyResults/' + @TableName + ''') AS a(n) WHERE CommservSurveyResults_ID = ' + CAST(@ResultId AS VARCHAR(20))
	EXEC sp_executesql @InsertSql
	SELECT @ErrorCode = @@ERROR
	IF  @ErrorCode > 0
	BEGIN
		SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE())
		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))
	END
--  QUERY SPECIFIC CODE END --
END TRY
BEGIN CATCH
	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE()
	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE())
	SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + @ErrorMsg
END CATCH
IF  @ErrorCode > 0
BEGIN
	UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
END
ELSE
BEGIN
	DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT)
	DECLARE	@LatestParsedResultId BIGINT = 0
	SELECT	@LatestParsedResultId = CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults
	WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1
	SELECT @ErrorCode = @@ERROR
	IF @ErrorCode = 0
	BEGIN
		IF @LatestParsedResultId = 0
			INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1
		ELSE
		IF @LatestParsedResultId < @ResultId
			INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0
		ELSE
			INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0
  		SELECT @ErrorCode = @@ERROR
	END
	IF @ErrorCode = 0
	BEGIN
  		UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL
		FROM	cf_CommservSurveyResults R
				INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId
  		SELECT @ErrorCode = @@ERROR
	END
	IF @ErrorCode = 0 AND @LogLevel > 1
	BEGIN
		SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE())
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).'
	END
	ELSE IF @ErrorCode <> 0
	BEGIN
		SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE())
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))
	END
END
IF	@LogString <> ''
BEGIN
	SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) +')' + @LogString)
	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCustomQueryResult')
	delete from GxQscripts where name = 'ParseCustomQueryResult'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCustomQueryResult')
	delete from GXDBVersions where aliasname = 'ParseCustomQueryResult'
GO

insert into GXDBVersions values(2, 'ParseCustomQueryResult',  '00010001000200050000', 'ParseCustomQueryResult', '00010001000200050000')
GO

