

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCompanyDailyBkpJobStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCompanyDailyBkpJobStatus.sp,v $ $Id: ParseCompanyDailyBkpJobStatus.sp,v 1.1.2.2 2020/12/17 02:52:08 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCompanyDailyBkpJobStatus')
BEGIN
	print '>>> Drop Stored Procedure: ParseCompanyDailyBkpJobStatus <<<'
	drop procedure ParseCompanyDailyBkpJobStatus
END
IF EXISTS (select * from GxQscripts where name='ParseCompanyDailyBkpJobStatus')
	delete from GxQscripts where name = 'ParseCompanyDailyBkpJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCompanyDailyBkpJobStatus')
	delete from GXDBVersions where aliasname = 'ParseCompanyDailyBkpJobStatus'
GO
print '... Creating Procedure: ParseCompanyDailyBkpJobStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCompanyDailyBkpJobStatus
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCompanyDailyBkpJobsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @LastDate DATETIME
IF object_id('tempdb.dbo.#tmpDailyJobs') IS NOT null DROP TABLE #tmpDailyJobs
CREATE TABLE #tmpDailyJobs
(
    CommServUniqueId INT,
    JobEndDate DATETIME,
    ClientGroupId INT,
    TotalJobs INT,
    CompletedJobs INT,
    CWEJobs INT,
    CWWJobs INT,
    FailedJobs INT,
    KilledJobs INT,
    SkippedJobs INT,
    BackupSize BIGINT,
    DataWritten BIGINT,
    COJobs BIGINT,
    FTSJobs BIGINT,
)
IF object_id('tempdb.dbo.#tmpAggregateJobs') IS NOT null DROP TABLE #tmpAggregateJobs
CREATE TABLE #tmpAggregateJobs
(
    CommServUniqueId INT,
    MonthStart DATETIME,
    ClientGroupId INT,
    TotalJobs INT,
    CompletedJobs INT,
    CWEJobs INT,
    CWWJobs INT,
    FailedJobs INT,
    KilledJobs INT,
    SkippedJobs INT,
    BackupSize BIGINT,
    DataWritten BIGINT,
    COJobs BIGINT,
    FTSJobs BIGINT,
)
    IF  @ErrorCode = 0
    BEGIN
        INSERT INTO #tmpDailyJobs
        SELECT
            @CSUniqueId,
            csInfo.n.value('@JobEndDate', 'DATE'),
            ISNULL(csInfo.n.value('@ClientGroupId', 'INT'),0),
            csInfo.n.value('@TotalJobs', 'INT'),
            csInfo.n.value('@CompletedJobs', 'INT'),
            csInfo.n.value('@CWEJobs', 'INT'),
            csInfo.n.value('@CWWJobs', 'INT'),
            csInfo.n.value('@FailedJobs', 'INT'),
            csInfo.n.value('@KilledJobs', 'INT'),
            csInfo.n.value('@SkippedJobs', 'INT'),
            csInfo.n.value('@BackupSize', 'BIGINT'),
            csInfo.n.value('@DataWritten', 'BIGINT'),
            ISNULL(csInfo.n.value('@CommittedJobs','BIGINT'), 0),
            ISNULL(csInfo.n.value('@FailedToStartJobs','BIGINT'), 0)
        FROM
            @ResultXml.nodes('/BackupStatsXML/DailyJobStats') AS csInfo(n)
        SELECT @ErrorCode = @@ERROR
    END
    IF  @ErrorCode = 0
    BEGIN
        SET @LastDate = (SELECT MAX(JobEndDate) FROM cf_SurveyCompanyDailyBkpJobStats WHERE CommServUniqueId = @CSUniqueId)
        SELECT @ErrorCode = @@ERROR
    END
    IF  @ErrorCode = 0
    BEGIN
        UPDATE  #tmpDailyJobs
        SET     TotalJobs -= S.TotalJobs, CompletedJobs -= S.CompletedJobs, CWEJobs -= S.CWEJobs, CWWJobs -= S.CWWJobs,
                FailedJobs -= S.FailedJobs, KilledJobs -= S.KilledJobs, SkippedJobs -= S.SkippedJobs, BackupSize -= S.BackupSize, DataWritten -= S.DataWritten,
                COJobs -= S.CommittedJobs, FTSJobs -= S.FailedToStartJobs
        FROM    #tmpDailyJobs T INNER JOIN cf_SurveyCompanyDailyBkpJobStats S
            ON T.CommServUniqueId = S. CommServUniqueId AND T.JobEndDate = S.JobEndDate AND T.ClientGroupID = S.ClientGroupID
        WHERE   T.JobEndDate <= @LastDate
        SELECT @ErrorCode = @@ERROR
    END
    IF  @ErrorCode = 0
    BEGIN
        MERGE cf_SurveyCompanyDailyBkpJobStats AS T
        USING #tmpDailyJobs S
            ON T.CommServUniqueId = S. CommServUniqueId AND T.JobEndDate = S.JobEndDate AND T.ClientGroupID = S.ClientGroupID
        WHEN MATCHED THEN
            UPDATE SET TotalJobs += S.TotalJobs, CompletedJobs += S.CompletedJobs, CWEJobs += S.CWEJobs, CWWJobs += S.CWWJobs,
                FailedJobs += S.FailedJobs, KilledJobs += S.KilledJobs, SkippedJobs += S.SkippedJobs, BackupSize += S.BackupSize, DataWritten += S.DataWritten,
                CommittedJobs += S.COJobs ,FailedToStartJobs +=S.FTSJobs
        WHEN NOT MATCHED AND (S.ClientGroupID = 0 OR S.TotalJobs > 0) THEN
            INSERT (CommServUniqueId, JobEndDate, ClientGroupID, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, BackupSize, DataWritten, CommittedJobs,FailedToStartJobs)
            VALUES (S.CommServUniqueId, S.JobEndDate, S.ClientGroupID, S.TotalJobs, S.CompletedJobs, S.CWEJobs, S.CWWJobs, S.FailedJobs, S.KilledJobs, S.SkippedJobs, S.BackupSize, S.DataWritten, S.COJobs,S.FTSJobs);
        SELECT @ErrorCode = @@ERROR
    END
    IF  @ErrorCode = 0 AND EXISTS (SELECT * FROM #tmpDailyJobs)
    BEGIN
        DECLARE @MonthStartDate DATETIME = GETDATE()
        SET @MonthStartDate = (SELECT MIN(JobEndDate) FROM #tmpDailyJobs WHERE CommServUniqueId = @CSUniqueId)
        SELECT @MonthStartDate = DATEADD(month, DATEDIFF(month, 0, @MonthStartDate), 0)
        INSERT INTO #tmpAggregateJobs
        SELECT  CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, JobEndDate), 0), ClientGroupID,
                SUM(TotalJobs), SUM(CompletedJobs), SUM(CWEJobs), SUM(CWWJobs), SUM(FailedJobs), SUM(KilledJobs), SUM(SkippedJobs), SUM(BackupSize), SUM(DataWritten),
                SUM(committedjobs),SUM(FailedToStartJobs)
        FROM    cf_SurveyCompanyDailyBkpJobStats (NOLOCK)
        where   CommServUniqueId = @CSUniqueId AND JobEndDate >= @MonthStartDate
        GROUP BY CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, JobEndDate), 0), ClientGroupID
        SELECT @ErrorCode = @@ERROR
    END
    IF  @ErrorCode = 0  AND EXISTS (SELECT * FROM #tmpAggregateJobs)
    BEGIN
        MERGE cf_SurveyCompanyMonthlyBkpJobStats AS T
        USING #tmpAggregateJobs S
            ON T.CommServUniqueId = S. CommServUniqueId AND T.MonthStart = S.MonthStart AND T.ClientGroupID = S.ClientGroupID
        WHEN MATCHED THEN
            UPDATE SET TotalJobs = S.TotalJobs, CompletedJobs = S.CompletedJobs, CWEJobs = S.CWEJobs, CWWJobs = S.CWWJobs,
                FailedJobs = S.FailedJobs, KilledJobs = S.KilledJobs, SkippedJobs = S.SkippedJobs, BackupSize = S.BackupSize, DataWritten = S.DataWritten,
                CommittedJobs = S.COJobs ,FailedToStartJobs =S.FTSJobs
        WHEN NOT MATCHED AND (S.ClientGroupID = 0 OR S.TotalJobs > 0) THEN
            INSERT (CommServUniqueId, MonthStart, ClientGroupID, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, BackupSize, DataWritten,CommittedJobs,FailedToStartJobs)
            VALUES (S.CommServUniqueId, S.MonthStart, S.ClientGroupID, S.TotalJobs, S.CompletedJobs, S.CWEJobs, S.CWWJobs, S.FailedJobs, S.KilledJobs, S.SkippedJobs, S.BackupSize, S.DataWritten,S.COJobs,S.FTSJobs);
        SELECT @ErrorCode = @@ERROR
    END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCompanyDailyBkpJobsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCompanyDailyBkpJobStatus')
	delete from GxQscripts where name = 'ParseCompanyDailyBkpJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCompanyDailyBkpJobStatus')
	delete from GXDBVersions where aliasname = 'ParseCompanyDailyBkpJobStatus'
GO

insert into GXDBVersions values(2, 'ParseCompanyDailyBkpJobStatus',  '00010001000200020000', 'ParseCompanyDailyBkpJobStatus', '00010001000200020000')
GO

