

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCommcellSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCommcellSummary.sp,v $ $Id: ParseCommcellSummary.sp,v 1.6.2.22 2020/12/18 18:57:33 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCommcellSummary')
BEGIN
	print '>>> Drop Stored Procedure: ParseCommcellSummary <<<'
	drop procedure ParseCommcellSummary
END
IF EXISTS (select * from GxQscripts where name='ParseCommcellSummary')
	delete from GxQscripts where name = 'ParseCommcellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommcellSummary')
	delete from GXDBVersions where aliasname = 'ParseCommcellSummary'
GO
print '... Creating Procedure: ParseCommcellSummary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCommcellSummary
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCommcellSummaryTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF OBJECT_ID('tempdb..#CommcellSummary') IS NOT NULL DROP TABLE #CommcellSummary
CREATE TABLE #CommcellSummary
(
	SurveyResultId		bigint NOT NULL,
	ProtectedClients	INT	NOT NULL,
	NotProtectedClients int NOT NULL,
	ExcludedClients		int NOT NULL,
	TotalJobs			bigint NOT NULL,
	FailedJobs			bigint NOT NULL,
	SuccessfulJobs		bigint NOT NULL,
	Strike3Clients		int NOT NULL,
	Strike2Clients		int NOT NULL,
	Strike1Clients		int NOT NULL,
	Strike3SubClients	int NOT NULL,
	Strike2SubClients	int NOT NULL,
	Strike1SubClients	int NOT NULL,
	TotalAppSizeGB		FLOAT NULL,
	TotalMediaSizeGB	FLOAT NULL,
	StrikeDays			int NULL,
	Strike3VMs			int NULL,
	Strike2VMs			int NULL,
	Strike1VMs			int NULL,
	ProtectedLaptops	INT	NULL,
	NotProtectedLaptops INT NULL,
	ExcludedLaptops		INT NULL,
	ProtectedVMs		INT	NULL,
	NotProtectedVMs		INT NULL,
	ExcludedVMs			INT NULL,
	FullStrike3			INT NULL,
	FullStrike2			INT NULL,
	FullStrike1			INT NULL
)
IF OBJECT_ID('tempdb..#SurveySLASummary') IS NOT NULL DROP TABLE #SurveySLASummary
CREATE TABLE #SurveySLASummary
(
	SurveyResultId		BIGINT NOT NULL,
	Days				INT	NOT NULL,
	ProtectedClients	INT	NOT NULL,
	NotProtectedClients INT NOT NULL,
	ExcludedClients		INT NOT NULL,
	AsOfDate			DATETIME NULL
)
IF OBJECT_ID('tempdb..#SurveySLAHistory') IS NOT NULL DROP TABLE #SurveySLAHistory
CREATE TABLE #SurveySLAHistory
(
	CommServUniqueId	INT NOT NULL,
	MonthBegin			DATETIME NOT NULL,
	nClientsMet			INT,
	nClientsMissed		INT
)
IF OBJECT_ID('tempdb..#MonthlyStrike') IS NOT NULL DROP TABLE #MonthlyStrike
CREATE TABLE #MonthlyStrike (MonthIntv DATE, Strike0Count INT, Strike1Count INT, Strike2Count INT, Strike3Count INT, ClientsCount INT, VMClientsCount INT)
DECLARE @LastUpdatedMonth DATE
DECLARE @NextMonth DATETIME
DECLARE @Today DATETIME = GETDATE()
IF  MONTH(@Today) = MONTH(DATEADD(DD, 1, @Today))
	SET @NextMonth = DATEADD(MM, DATEDIFF(MM, 0, @Today) + 1, 0)
ELSE
	SET @NextMonth = DATEADD(MM, DATEDIFF(MM, 0, @Today) + 2, 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #CommcellSummary(SurveyResultId,ProtectedClients,NotProtectedClients,ExcludedClients,TotalJobs,FailedJobs,SuccessfulJobs,
		Strike3Clients,Strike2Clients,Strike1Clients,Strike3SubClients,Strike2SubClients,Strike1SubClients, TotalAppSizeGB, TotalMediaSizeGB,
		StrikeDays, Strike3VMs, Strike2VMs, Strike1VMs, ProtectedLaptops,NotProtectedLaptops,ExcludedLaptops,ProtectedVMs,NotProtectedVMs,ExcludedVMs,
		FullStrike3, FullStrike2, FullStrike1)
	SELECT
		@ResultId,
		ISNULL(csInfo.n.value('@ProtectedClients',    '[INT]'), 0),
		ISNULL(csInfo.n.value('@NotProtectedClients', '[INT]'), 0),
		ISNULL(csInfo.n.value('@ExcludedClients' ,    '[INT]'), 0),
		ISNULL(csInfo.n.value('@TotalJobs',        '[BIGINT]'), 0),
		ISNULL(csInfo.n.value('@FailedJobs' ,      '[BIGINT]'), 0),
		ISNULL(csInfo.n.value('@SuccessfulJobs',   '[BIGINT]'), 0),
		ISNULL(csInfo.n.value('@Strike3Clients',      '[INT]'), 0),
		ISNULL(csInfo.n.value('@Strike2Clients',      '[INT]'), 0),
		ISNULL(csInfo.n.value('@Strike1Clients',      '[INT]'), 0),
		ISNULL(csInfo.n.value('@Strike3SubClients',   '[INT]'), 0),
		ISNULL(csInfo.n.value('@Strike2SubClients',   '[INT]'), 0),
		ISNULL(csInfo.n.value('@Strike1SubClients',   '[INT]'), 0),
		ISNULL(csInfo.n.value('@TotalAppSizeGB',    '[FLOAT]'), 0),
		ISNULL(csInfo.n.value('@TotalMediaSizeGB',  '[FLOAT]'), 0),
		ISNULL(csInfo.n.value('@StrikeDays',          '[INT]'), -1),
		ISNULL(csInfo.n.value('@Strike3VMs',          '[INT]'), 0),
		ISNULL(csInfo.n.value('@Strike2VMs',          '[INT]'), 0),
		ISNULL(csInfo.n.value('@Strike1VMs',          '[INT]'), 0),
		ISNULL(csInfo.n.value('@ProtectedLaptops',    '[INT]'), 0),
		ISNULL(csInfo.n.value('@NotProtectedLaptops', '[INT]'), 0),
		ISNULL(csInfo.n.value('@ExcludedLaptops',     '[INT]'), 0),
		ISNULL(csInfo.n.value('@ProtectedVMs',        '[INT]'), 0),
		ISNULL(csInfo.n.value('@NotProtectedVMs',     '[INT]'), 0),
		ISNULL(csInfo.n.value('@ExcludedVMs',         '[INT]'), 0),
		ISNULL(csInfo.n.value('@FullStrike3',         '[INT]'), 0),
		ISNULL(csInfo.n.value('@FullStrike2',         '[INT]'), 0),
		ISNULL(csInfo.n.value('@FullStrike1',         '[INT]'), 0)
	FROM
		@ResultXml.nodes('CommCellSummaryXML') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveySLASummary(SurveyResultId, days, ProtectedClients, NotProtectedClients, ExcludedClients, AsOfDate)
	SELECT
		@ResultId,
		csInfo.n.value('@days', 'INT'),
		ISNULL(csInfo.n.value('@ProtectedClients' , 'INT'),0),
		ISNULL(csInfo.n.value('@NotProtectedClients' , 'INT'),0),
		ISNULL(csInfo.n.value('@ExcludedClients' , 'INT'),0),
		ISNULL(csInfo.n.value('../@SLAEndDate', 'DATETIME'), @LogDate)
	FROM
		@ResultXml.nodes('CommCellSummaryXML/MultiDaySLA') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveySLAHistory (CommServUniqueId, MonthBegin, nClientsMet, nClientsMissed)
	SELECT
		@CSUniqueId,
		csInfo.n.value('@MonthBegin', '[DATETIME]') AS MonthBegin,
		ISNULL(csInfo.n.value('@nClientsMet', '[INT]'), 0) AS nClientsMet,
		ISNULL(csInfo.n.value('@nClientsMissed', '[INT]'), 0) AS nClientsMissed
	FROM
		@ResultXml.nodes('CommCellSummaryXML/SLATrend') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MonthlyStrike
	SELECT
		csInfo.n.value('@MonthStart', 'DATE'),
		ISNULL(csInfo.n.value('@Strike0', 'INTEGER'),0),
		ISNULL(csInfo.n.value('@Strike1', 'INTEGER'),0),
		ISNULL(csInfo.n.value('@Strike2', 'INTEGER'),0),
		ISNULL(csInfo.n.value('@Strike3', 'INTEGER'),0),
		ISNULL(csInfo.n.value('@ClientsCount', 'INTEGER'),0),
		ISNULL(csInfo.n.value('@VMClientsCount', 'INTEGER'),0)
	FROM
		@ResultXml.nodes('/CommCellSummaryXML/MonthlyStrike') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_CommcellSummary (
			SurveyResultId,ProtectedClients,NotProtectedClients,ExcludedClients,TotalJobs,FailedJobs,SuccessfulJobs,
			Strike3Clients,Strike2Clients,Strike1Clients,Strike3SubClients,Strike2SubClients,Strike1SubClients, TotalAppSizeGB, TotalMediaSizeGB,
			StrikeDays, Strike3VMs, Strike2VMs, Strike1VMs, ProtectedLaptops,NotProtectedLaptops,ExcludedLaptops,ProtectedVMs,NotProtectedVMs,ExcludedVMs,
			FullStrike3, FullStrike2, FullStrike1)
	SELECT	SurveyResultId,ProtectedClients,NotProtectedClients,ExcludedClients,TotalJobs,FailedJobs,SuccessfulJobs,
			Strike3Clients,Strike2Clients,Strike1Clients,Strike3SubClients,Strike2SubClients,Strike1SubClients, TotalAppSizeGB, TotalMediaSizeGB,
			StrikeDays, Strike3VMs, Strike2VMs, Strike1VMs, ProtectedLaptops,NotProtectedLaptops,ExcludedLaptops,ProtectedVMs,NotProtectedVMs,ExcludedVMs,
			FullStrike3, FullStrike2, FullStrike1
	FROM	#CommcellSummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveySLASummary (
			SurveyResultId, days, ProtectedClients, NotProtectedClients, ExcludedClients, AsOfDate)
	SELECT	SurveyResultId, days, ProtectedClients, NotProtectedClients, ExcludedClients, AsOfDate
	FROM	#SurveySLASummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	SET @LastUpdatedMonth = (SELECT MAX(MonthBegin) FROM cf_SurveySLAHistory WHERE CommServUniqueId = @CSUniqueId)
	MERGE cf_SurveySLAHistory S
	USING #SurveySLAHistory T
		ON S.CommServUniqueId = T.CommServUniqueId AND S.MonthBegin = T.MonthBegin
	WHEN MATCHED AND T.MonthBegin = @LastUpdatedMonth THEN
		UPDATE SET nClientsMet = T.nClientsMet, nClientsMissed = T.nClientsMissed
	WHEN NOT MATCHED AND T.MonthBegin < @NextMonth THEN
		INSERT (CommServUniqueId, MonthBegin, nClientsMet, nClientsMissed)
		VALUES (T.CommServUniqueId, T.MonthBegin, T.nClientsMet, T.nClientsMissed);
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCommcellSummaryTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCommcellSummary')
	delete from GxQscripts where name = 'ParseCommcellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommcellSummary')
	delete from GXDBVersions where aliasname = 'ParseCommcellSummary'
GO

insert into GXDBVersions values(2, 'ParseCommcellSummary',  '00010006000200220000', 'ParseCommcellSummary', '00010006000200220000')
GO

