

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseClientGroupAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseClientGroupAssociation.sp,v $ $Id: ParseClientGroupAssociation.sp,v 1.3.60.16 2020/12/17 02:49:20 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseClientGroupAssociation')
BEGIN
	print '>>> Drop Stored Procedure: ParseClientGroupAssociation <<<'
	drop procedure ParseClientGroupAssociation
END
IF EXISTS (select * from GxQscripts where name='ParseClientGroupAssociation')
	delete from GxQscripts where name = 'ParseClientGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientGroupAssociation')
	delete from GXDBVersions where aliasname = 'ParseClientGroupAssociation'
GO
print '... Creating Procedure: ParseClientGroupAssociation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseClientGroupAssociation
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseClientGroupAssociationTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
CREATE TABLE #ClientGroupAssociationOld
(
	CommservUniqueId	INT,
	ClientGroupId		INT,
	ClientId			INT,
	DeletedDate			DATETIME
)
CREATE TABLE #ClientGroupAssociationNew
(
	ClientGroupId		INT,
	ClientId			INT
)
DECLARE @FileName NVARCHAR(1024)
IF 	@ErrorCode = 0
BEGIN
	SELECT	@FileName = CAST(CollectedResults as NVARCHAR(1024))
	FROM	cf_CommservSurveyResults WITH (NOLOCK)
	WHERE 	CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #ClientGroupAssociationNew FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT TOP 1 0 FROM #ClientGroupAssociationNew)
BEGIN
	INSERT INTO #ClientGroupAssociationOld (
			CommservUniqueId, ClientGroupId, ClientId, DeletedDate)
	SELECT	O.CommservUniqueId, O.ClientGroupId, O.ClientId, CASE WHEN O.DeletedDate IS NULL THEN @LogDate ELSE NULL END
	FROM	cf_SurveyClientGroupAssociation O
			LEFT OUTER JOIN #ClientGroupAssociationNew N
		 ON O.CommservUniqueId = @CSUniqueId AND N.ClientGroupId = O.ClientGroupId AND N.ClientId = O.ClientId
	WHERE	O.CommservUniqueId = @CSUniqueId AND (N.ClientId IS NULL AND O.DeletedDate IS NULL OR N.ClientId IS NOT NULL AND O.DeletedDate IS NOT NULL)
	SELECT @ErrorCode = @@ERROR
	IF 	@ErrorCode = 0
	BEGIN
		DELETE	N
		FROM	#ClientGroupAssociationNew N
				INNER JOIN cf_SurveyClientGroupAssociation AS CGA
			 ON CGA.CommservUniqueId = @CSUniqueId AND CGA.ClientGroupId = N.ClientGroupId AND CGA.ClientId = N.ClientId
		SELECT @ErrorCode = @@ERROR
	END
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT ClientId FROM #ClientGroupAssociationOld)
BEGIN
	UPDATE	CGA SET DeletedDate = O.DeletedDate
	FROM	cf_SurveyClientGroupAssociation AS CGA
			INNER JOIN #ClientGroupAssociationOld AS O
		 ON CGA.CommservUniqueId = O.CommservUniqueId AND CGA.ClientGroupId = O.ClientGroupId AND CGA.ClientId = O.ClientId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT ClientId FROM #ClientGroupAssociationNew)
BEGIN
	INSERT	INTO cf_SurveyClientGroupAssociation (
			CommservUniqueId, ClientGroupId, ClientId, AddedDate, DeletedDate)
	SELECT	@CSUniqueId, ClientGroupId, ClientId, @LogDate, NULL
	FROM	#ClientGroupAssociationNew
	SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0
BEGIN
    CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
    INSERT INTO #ClientGroupsString
    SELECT DISTINCT @CSUniqueId, ClientId, N'' FROM #ClientGroupAssociationNew
    UNION
    SELECT DISTINCT CommservUniqueId, ClientId, N'' FROM #ClientGroupAssociationOld
    IF EXISTS (SELECT 1 FROM #ClientGroupsString)
	BEGIN
	    EXEC GetClientGroupsString @CSUniqueId
	    UPDATE C
	    SET C.ClientGroups = CG.ClientGroups
	    FROM cf_SurveyClient C
	    INNER JOIN #ClientGroupsString CG ON C.CommServUniqueId = CG.CommservUniqueId AND C.ClientId = CG.ClientId
	    WHERE C.CommServUniqueID = @CSUniqueId
    END
    DROP TABLE #ClientGroupsString
    SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseClientGroupAssociationTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseClientGroupAssociation')
	delete from GxQscripts where name = 'ParseClientGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientGroupAssociation')
	delete from GXDBVersions where aliasname = 'ParseClientGroupAssociation'
GO

insert into GXDBVersions values(2, 'ParseClientGroupAssociation',  '00010003006000160000', 'ParseClientGroupAssociation', '00010003006000160000')
GO

