

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCleanupMAAndStorage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCleanupMAAndStorage.sp,v $ $Id: ParseCleanupMAAndStorage.sp,v 1.1.2.10 2020/12/17 02:55:44 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCleanupMAAndStorage')
BEGIN
	print '>>> Drop Stored Procedure: ParseCleanupMAAndStorage <<<'
	drop procedure ParseCleanupMAAndStorage
END
IF EXISTS (select * from GxQscripts where name='ParseCleanupMAAndStorage')
	delete from GxQscripts where name = 'ParseCleanupMAAndStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCleanupMAAndStorage')
	delete from GXDBVersions where aliasname = 'ParseCleanupMAAndStorage'
GO
print '... Creating Procedure: ParseCleanupMAAndStorage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCleanupMAAndStorage
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCleanupMAAndStorageTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF OBJECT_ID('tempdb.#tempSurveyMAAndPolicyCleanup') IS NOT NULL DROP TABLE #tempSurveyMAAndPolicyCleanup
CREATE TABLE #tempSurveyMAAndPolicyCleanup(CommservUniqueId INT,RsultId INT, QueryID INT, Query XML)
IF 	@ErrorCode = 0
BEGIN
    INSERT INTO #tempSurveyMAAndPolicyCleanup
    SELECT
        @CSUniqueId,
		@ResultId,
        csInfo.n.value('@QueryId', 'INT'),
        csInfo.n.value('@Query', 'NVARCHAR(MAX)')
    FROM
		@ResultXml.nodes('/MAPolicyCleanup/MAPolicyCleanupXML') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyMANotUsed
    select
        @ResultId,
        csInfo.n.value('@MAId','INT') ,
		csInfo.n.value('@MediaAgent','NVARCHAR(MAX)')
	from #tempSurveyMAAndPolicyCleanup T
		CROSS APPLY Query .nodes('MANotUsedDetails/MANotUsed') AS csInfo(n)
    where
		T.QueryId = 1 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    INSERT INTO cf_SurveyArrayWithoutClient
    select
        @ResultId,
        csInfo.n.value('@ArrayId','INT') ,
        csInfo.n.value('@ArrayName','NVARCHAR(MAX)')
	from #tempSurveyMAAndPolicyCleanup T
		CROSS APPLY Query .nodes('ArrayWithNoClientDetails/ArrayWithNoClient') AS csInfo(n)
    where
		T.QueryId = 2 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    INSERT INTO cf_SurveyArrayWithOrphanSnap
    select
        @ResultId,
        csInfo.n.value('@ArrayId','INT') ,
        csInfo.n.value('@ArrayName','NVARCHAR(MAX)'),
        csInfo.n.value('@SnapEngineName','NVARCHAR(MAX)'),
        csInfo.n.value('@DeletedClientId','INT')
	from #tempSurveyMAAndPolicyCleanup T
		CROSS APPLY Query .nodes('ArrayWithOrphanSnapDetails/ArrayWithOrphanSnap') AS csInfo(n)
    where
		T.QueryId = 3 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    --check if result is from old or new collection query
    IF ( select Query.exist('ArrayWithFailtoDeleteSnapDetails/ArrayWithFailtoDeleteSnap[(@JobCount)]')
            from #tempSurveyMAAndPolicyCleanup where QueryID = 4
        ) = 0
        --result is from old collection query
        --aggregate JobIds to JobCount and insert into table
    BEGIN
        INSERT INTO cf_SurveyDeleteFailSnapArray
            SELECT @ResultId,ArrayId,ArrayName,ClientId,COUNT(ArrayId),SnapCount
                FROM
                (
                select
                csInfo.n.value('@ArrayId','INT') AS ArrayId ,
                csInfo.n.value('@ArrayName','NVARCHAR(MAX)') AS ArrayName,
                csInfo.n.value('@ClientId','INT') AS ClientId,
                csInfo.n.value('@SnapCount','INT') AS SnapCount
                from #tempSurveyMAAndPolicyCleanup T
                CROSS APPLY Query .nodes('ArrayWithFailtoDeleteSnapDetails/ArrayWithFailtoDeleteSnap') AS csInfo(n)
                where T.QueryId = 4 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
                )
                AS X
            GROUP BY X.ArrayId,X.ArrayName,X.ClientId,X.SnapCount
    END
    ELSE
        --result is from new collection query
        --insert directly to table
    BEGIN
        INSERT INTO cf_SurveyDeleteFailSnapArray
        select
            @ResultId,
            csInfo.n.value('@ArrayId','INT') ,
            csInfo.n.value('@ArrayName','NVARCHAR(MAX)'),
            csInfo.n.value('@ClientId','INT'),
            csInfo.n.value('@JobCount','BIGINT') ,
            csInfo.n.value('@SnapCount','INT')
    	from #tempSurveyMAAndPolicyCleanup T
    		CROSS APPLY Query .nodes('ArrayWithFailtoDeleteSnapDetails/ArrayWithFailtoDeleteSnap') AS csInfo(n)
    	where
    		T.QueryId = 4 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
    END
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    INSERT INTO cf_SurveyDIPError
    select
        @ResultId,
        csInfo.n.value('@ClientId','INT') ,
        csInfo.n.value('@ClientInterface','VARCHAR(MAX)'),
        csInfo.n.value('@MAId','INT'),
        csInfo.n.value('@MAInterface','VARCHAR(MAX)') ,
        csInfo.n.value('@errorCode','VARCHAR(MAX)')
	from #tempSurveyMAAndPolicyCleanup T
		CROSS APPLY Query .nodes('DIPErrorDetails/DIPError') AS csInfo(n)
    where
		T.QueryId = 5 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    INSERT INTO cf_SurveyCleanupLibrary
    select
        @ResultId,
        csInfo.n.value('@LibraryId','INT') ,
        csInfo.n.value('@LibraryName','NVARCHAR(MAX)'),
        csInfo.n.value('@Flags','INT')
	from #tempSurveyMAAndPolicyCleanup T
		CROSS APPLY Query .nodes('LibrariesWithoutSPDetails/LibrariesWithoutSP') AS csInfo(n)
    where
		T.QueryId = 6 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
    INSERT INTO cf_SurveyCleanupPolicy
    select
        @ResultId,
        csInfo.n.value('@SPId','INT') ,
        csInfo.n.value('@SPName','NVARCHAR(MAX)'),
        csInfo.n.value('@copyId','INT'),
        csInfo.n.value('@CopyName','VARCHAR(MAX)'),
        csInfo.n.value('@dedupSaving','DECIMAL(10,2)'),
        csInfo.n.value('@Flags','INT')
	from #tempSurveyMAAndPolicyCleanup T
		CROSS APPLY Query .nodes('CleanupSPDetails/CleanupSP') AS csInfo(n)
    where  T.QueryId = 7 AND T.CommservUniqueId = @CSUniqueId AND T.RsultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCleanupMAAndStorageTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCleanupMAAndStorage')
	delete from GxQscripts where name = 'ParseCleanupMAAndStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCleanupMAAndStorage')
	delete from GXDBVersions where aliasname = 'ParseCleanupMAAndStorage'
GO

insert into GXDBVersions values(2, 'ParseCleanupMAAndStorage',  '00010001000200100000', 'ParseCleanupMAAndStorage', '00010001000200100000')
GO

