

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCCRDiskLibrary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCCRDiskLibrary.sp,v $ $Id: ParseCCRDiskLibrary.sp,v 1.1.2.6 2018/12/27 18:45:56 vikashkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseCCRDiskLibrary')
BEGIN
	print '>>> Drop Stored Procedure: ParseCCRDiskLibrary <<<'
	drop procedure ParseCCRDiskLibrary
END
IF EXISTS (select * from GxQscripts where name='ParseCCRDiskLibrary')
	delete from GxQscripts where name = 'ParseCCRDiskLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRDiskLibrary')
	delete from GXDBVersions where aliasname = 'ParseCCRDiskLibrary'
GO
print '... Creating Procedure: ParseCCRDiskLibrary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCCRDiskLibrary
  @CSUID INT,
  @UpdateTime DATETIME,
  @FullFileName VARCHAR(1024),
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
--   BULK INSERT from a csv file
-------------------------------------------------------------------------------
	SET NOCOUNT ON
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parsing CCRDiskLibrary'
	IF @isPrintOn = 1 PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	DECLARE @ProcessSurveyResultTran INT = 0
	IF OBJECT_ID('tempdb..#TempCCRDiskLibrary') IS NOT NULL DROP TABLE #TempCCRDiskLibrary
	CREATE TABLE #TempCCRDiskLibrary
	(
		Library nvarchar(256),
		MountPath nvarchar(512),
		SpaceLeftGB DECIMAL(32,2),
		DiskReservedSpaceMB int
	)
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #TempCCRDiskLibrary FROM ''' + @FullFileName + ''' WITH (FIRSTROW = 2, FIELDTERMINATOR ='','', ROWTERMINATOR ='',\n'' )';
	BEGIN TRY
		EXEC(@sql);
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRDiskLibrary - BULK INSERT failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF @ErrorCode = 0
	BEGIN
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		DELETE FROM CCRDiskLibrary WHERE CommservUniqueId = @CSUID AND UpdateTime <= @UpdateTime
		IF EXISTS (SELECT * FROM #TempCCRDiskLibrary)
		BEGIN
			INSERT INTO CCRDiskLibrary (CommservUniqueId, UpdateTime, Library, MountPath, SpaceLeftGB, DiskReservedSpaceMB)
			SELECT	@CSUID, @UpdateTime, Library, MountPath, SpaceLeftGB, DiskReservedSpaceMB FROM #TempCCRDiskLibrary
		END
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			IF (@ProcessSurveyResultTran = 1)
			BEGIN
				ROLLBACK TRANSACTION ProcessSurveyResultTran
				SET @ProcessSurveyResultTran = 0
			END
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRDiskLibrary - INSERT INTO CCRDiskLibrary failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		IF @isPrintOn = 1 PRINT @ErrorString
			INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END
	DROP TABLE #TempCCRDiskLibrary
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCCRDiskLibrary')
	delete from GxQscripts where name = 'ParseCCRDiskLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRDiskLibrary')
	delete from GXDBVersions where aliasname = 'ParseCCRDiskLibrary'
GO

insert into GXDBVersions values(2, 'ParseCCRDiskLibrary',  '00010001000200060000', 'ParseCCRDiskLibrary', '00010001000200060000')
GO

