

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseBillingEntities.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseBillingEntities.sp,v $ $Id: ParseBillingEntities.sp,v 1.3.60.5 2020/12/17 02:47:59 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseBillingEntities')
BEGIN
	print '>>> Drop Stored Procedure: ParseBillingEntities <<<'
	drop procedure ParseBillingEntities
END
IF EXISTS (select * from GxQscripts where name='ParseBillingEntities')
	delete from GxQscripts where name = 'ParseBillingEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBillingEntities')
	delete from GXDBVersions where aliasname = 'ParseBillingEntities'
GO
print '... Creating Procedure: ParseBillingEntities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseBillingEntities
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseBillingEntitiesTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
CREATE TABLE #BillingEntity (GUID VARCHAR(64), Name NVARCHAR(255), Description NVARCHAR(255), ContactInfo NVARCHAR(2048), ModifiedTime DATETIME)
CREATE TABLE #EntityMembers (GUID VARCHAR(64), ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #BillingEntity (GUID, Name, Description, ContactInfo, ModifiedTime)
	SELECT
		csInfo.n.value('@GUID', 'VARCHAR(64)'),
		csInfo.n.value('@Name', 'NVARCHAR(255)'),
		csInfo.n.value('@Description', 'NVARCHAR(256)'),
		csInfo.n.value('@ContactInfo', 'NVARCHAR(2048)'),
		csInfo.n.value('@ModifiedTime','DATETIME')
	FROM
		cf_CommservSurveyResults
		CROSS APPLY CollectedResults.nodes('/BillingEntities/Entity') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #EntityMembers (GUID, ClientId, AppTypeId, InstanceId, BackupsetId, AppId)
	SELECT
		csInfo.n.value('@GUID', 'VARCHAR(64)'),
		csInfo.n.value('@ClientID', 'INT'),
		csInfo.n.value('@AppTypeId', 'INT'),
		csInfo.n.value('@InstanceId', 'INT'),
		csInfo.n.value('@BackupsetId', 'INT'),
		csInfo.n.value('@AppID', 'INT')
	FROM
		cf_CommservSurveyResults
		CROSS APPLY CollectedResults.nodes('/BillingEntities/Member') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	#BillingEntity
	FROM	cf_SurveyBillingEntity E INNER JOIN #BillingEntity T ON E.GUID = T.GUID
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO cf_SurveyBillingEntity
	SELECT	GUID, Name, Description, ContactInfo, ModifiedTime
	FROM	#BillingEntity
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	#EntityMembers
	FROM	#EntityMembers T
			INNER JOIN cf_SurveyBillingEntity E ON E.GUID = T.GUID
			INNER JOIN cf_SurveyBillingEntityMember M ON M.EntityID = E.ID
				AND M.ClientId = T.ClientId AND M.AppTypeId = T.AppTypeId
				AND M.InstanceId = T.InstanceId AND M.BackupsetId = T.BackupsetId AND M.AppId = T.AppId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO cf_SurveyBillingEntityMember (EntityID, CommServUniqueId, ClientGroupId, ClientId, AppTypeId, InstanceId, BackupsetId, AppId)
	SELECT	E.ID, @CSUniqueId, 0, M.ClientId, M.AppTypeId, M.InstanceId, M.BackupsetId, M.AppId
	FROM	#EntityMembers M
			INNER JOIN cf_SurveyBillingEntity E ON M.GUID = E.GUID
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseBillingEntitiesTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseBillingEntities')
	delete from GxQscripts where name = 'ParseBillingEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBillingEntities')
	delete from GXDBVersions where aliasname = 'ParseBillingEntities'
GO

insert into GXDBVersions values(2, 'ParseBillingEntities',  '00010003006000050000', 'ParseBillingEntities', '00010003006000050000')
GO

