

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseAdminJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseAdminJobDetails.sp,v $ $Id: ParseAdminJobDetails.sp,v 1.1.2.8 2020/12/17 02:48:41 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseAdminJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: ParseAdminJobDetails <<<'
	drop procedure ParseAdminJobDetails
END
IF EXISTS (select * from GxQscripts where name='ParseAdminJobDetails')
	delete from GxQscripts where name = 'ParseAdminJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAdminJobDetails')
	delete from GXDBVersions where aliasname = 'ParseAdminJobDetails'
GO
print '... Creating Procedure: ParseAdminJobDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseAdminJobDetails
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseAdminJobDetailsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF object_id('tempdb.dbo.#SurveyJobStats') is not null DROP TABLE #SurveyJobStats
IF object_id('tempdb.dbo.#RunningJobStats') is not null DROP TABLE #RunningJobStats
IF object_id('tempdb.dbo.#tmpDailyJobs') IS NOT null DROP TABLE #tmpDailyJobs
IF object_id('tempdb.dbo.#tmpAggregateJobs') IS NOT null DROP TABLE #tmpAggregateJobs
CREATE TABLE #SurveyJobStats (
	CommservUniqueId INT, JobId INT, Status INT, OpType INT, subOpType INT, BkpLevel INT, StartDate INT, EndDate INT,
	DataProtected BIGINT, ErrorCode VARCHAR(32), FailureReason NVARCHAR(512), StoragePolicy NVARCHAR(144), StoragePolicyID INT,
	SchedulePolicy NVARCHAR(256), ScheduleName NVARCHAR(256), Attempts INT, InitFrom INT, Phases INT, failureErrorCode INT,workflowName NVARCHAR(256))
CREATE TABLE #RunningJobStats (
	CommservUniqueId INT, JobId INT, OpType INT, subOpType INT, BkpLevel INT, StartDate INT, State INT, InitFrom INT, FailureReason NVARCHAR(MAX))
CREATE TABLE #tmpDailyJobs(
	CommServUniqueId INT,
	JobEndDate DATETIME,
	TJobs INT,
	CJobs INT,
	CWEJobs INT,
	CWWJobs INT,
	FJobs INT,
	KJobs INT,
	SJobs INT,
	BackupSize BIGINT
)
CREATE TABLE #tmpAggregateJobs
(
    CommServUniqueId INT,
    MonthStart DATETIME,
    TotalJobs INT,
    CompletedJobs INT,
    CWEJobs INT,
    CWWJobs INT,
    FailedJobs INT,
    KilledJobs INT,
    SkippedJobs INT,
    BackupSize BIGINT
)
DECLARE @LastDate DATETIME
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyJobStats (
		CommservUniqueId, JobId, Status, OpType, subOpType, BkpLevel, StartDate, EndDate,
		DataProtected, ErrorCode, FailureReason,
		StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName, Attempts, InitFrom, Phases, failureErrorCode, workflowName)
	SELECT DISTINCT
		CommcellIdNameMap_ID,
		csInfo.n.value('@JobId', 'INT'),
		csInfo.n.value('@Status', 'INT'),
		csInfo.n.value('@OpType', 'INT'),
		csInfo.n.value('@SubOpType', 'INT'),
		csInfo.n.value('@BkpLevel', 'INT'),
		csInfo.n.value('@StartDate', 'INT'),
		csInfo.n.value('@EndDate', 'INT'),
		csInfo.n.value('@DataProtected', 'BIGINT'),
		csInfo.n.value('@ErrorCode', 'VARCHAR(32)'),
		csInfo.n.value('@FailureReason', 'NVARCHAR(512)'),
		csInfo.n.value('@StoragePolicy', 'NVARCHAR(144)'),
		ISNULL(csInfo.n.value('@StoragePolicyID', 'INT'),1),
		csInfo.n.value('@SchedulePolicy', 'NVARCHAR(256)'),
		csInfo.n.value('@ScheduleName', 'NVARCHAR(256)'),
		csInfo.n.value('@Attempts', 'INT'),
		ISNULL(csInfo.n.value('@InitFrom', 'INT'),0),
		ISNULL(csInfo.n.value('@Phases'  , 'INT'),0),
		ISNULL(csInfo.n.value('@failureErrorCode'  , 'INT'),0),
		csInfo.n.value('@workflowName', 'NVARCHAR(256)')
	FROM
		cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/JobDetails/JobStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #RunningJobStats (
		CommservUniqueId, JobId, OpType, subOpType, BkpLevel, StartDate, State, InitFrom, FailureReason)
	SELECT DISTINCT
		CommcellIdNameMap_ID,
		csInfo.n.value('@JobId', 'INT'),
		csInfo.n.value('@OpType', 'INT'),
		csInfo.n.value('@SubOpType', 'INT'),
		csInfo.n.value('@BkpLevel', 'INT'),
		csInfo.n.value('@StartDate', 'INT'),
		csInfo.n.value('@State', 'INT'),
		csInfo.n.value('@InitFrom', 'INT'),
		ISNULL(csInfo.n.value('@FailureReason', 'NVARCHAR(MAX)'), '')
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/JobDetails/RunningJobStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE  #SurveyJobStats
	FROM	cf_SurveyAdminJobStats S
	WHERE	#SurveyJobStats.CommservUniqueId = S.CommservUniqueId AND #SurveyJobStats.JobId = S.JobId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAdminJobStats (
			CommservUniqueId, JobId, Status, OpType, BkpLevel, StartDate, EndDate,
			DataProtected, ErrorCode, FailureReason,
			StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName, Attempts, InitFrom, Phases, failureErrorCode, WorkflowName, subOpType)
	SELECT	CommservUniqueId, JobId, Status, OpType, BkpLevel, StartDate, EndDate,
			DataProtected, ErrorCode, FailureReason,
			StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName, Attempts, InitFrom, Phases, failureErrorCode, workflowName, subOpType
	FROM	#SurveyJobStats
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE cf_SurveyRunningAdminJobStats RS
	USING #RunningJobStats R
		ON RS.CommservUniqueId= R.CommservUniqueId AND R.JobId= RS.JobId AND R.JobId>0
	WHEN MATCHED THEN
		UPDATE SET RS.State = R.State
	WHEN NOT MATCHED  THEN
		INSERT (CommservUniqueId, JobId, OpType, BkpLevel, StartDate, State, InitFrom, failureReason,subOpType)
		VALUES (R.CommservUniqueId, R.JobId, R.OpType, R.BkpLevel, R.StartDate, R.State, R.InitFrom, R.FailureReason,R.subOpType);
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseAdminJobDetailsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseAdminJobDetails')
	delete from GxQscripts where name = 'ParseAdminJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAdminJobDetails')
	delete from GXDBVersions where aliasname = 'ParseAdminJobDetails'
GO

insert into GXDBVersions values(2, 'ParseAdminJobDetails',  '00010001000200080000', 'ParseAdminJobDetails', '00010001000200080000')
GO

