

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/GetSecurityAssociationDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/GetSecurityAssociationDetails.sp,v $ $Id: GetSecurityAssociationDetails.sp,v 1.1.2.28.4.3 2021/04/07 20:01:25 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetSecurityAssociationDetails')
BEGIN
	print '>>> Drop Stored Procedure: GetSecurityAssociationDetails <<<'
	drop procedure GetSecurityAssociationDetails
END
IF EXISTS (select * from GxQscripts where name='GetSecurityAssociationDetails')
	delete from GxQscripts where name = 'GetSecurityAssociationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSecurityAssociationDetails')
	delete from GXDBVersions where aliasname = 'GetSecurityAssociationDetails'
GO
print '... Creating Procedure: GetSecurityAssociationDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetSecurityAssociationDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL
AS
--  QUERY SPECIFIC CODE BEGIN --
--Create temptable to store attribute and status of attribute
IF OBJECT_ID('tempdb..#ResultTable') IS NOT NULL
	DROP TABLE #ResultTable
create table #ResultTable (
	commcellid INT,
	attrName varchar(256) ,
	paramID INT,
	paramName nvarchar(1024),
    status INT,
	remarks nvarchar(1024),
	action nvarchar(1024) DEFAULT '')
--create table AggregateStatus to store aggregated results for further processing
IF OBJECT_ID('tempdb..#AggregateStatus') IS NOT NULL
	DROP TABLE #AggregateStatus
create table #AggregateStatus (
	status int,
	scount int,
	ccid int
)
--Create table ccid_list to store list of all commcells that will be processed
IF OBJECT_ID('tempdb..#ccid_list') IS NOT NULL
	DROP TABLE #ccid_list
CREATE TABLE #ccid_list (ccid int, SurveyResultId bigint, IPAddress nvarchar(1024), Version int)
--if @i_CommServUniqueID is specified, then process just that commcell
IF @i_CommServUniqueID <> 0
	INSERT INTO #ccid_list (ccid) VALUES (@i_CommServUniqueID)
--otherwise we process all commcells in the group mentioned
ELSE
	INSERT INTO #ccid_list (ccid)
		SELECT CommcellIdNameMap_ID FROM cf_CommcellGroupAssoc WHERE CommCellGroupId = @i_GroupId
UPDATE #ccid_list SET SurveyResultId = (SELECT SurverResultId from dbo.cf_SurveyResultFuncV1(250, ccid ,1,null,null,@i_UserId,0))
--get IP of commcell
UPDATE #ccid_list SET IPAddress = ( SELECT WebConsoleURL from cf_WebConsoleURL CWU
								INNER JOIN dbo.cf_SurveyResultFuncV1(160,ccid,1,null,null,@i_UserId,0) SRF
								ON SRF.SurverResultId = CWU.SurveyResultId)
UPDATE #ccid_list
	SET IPAddress =
		CONCAT('http://',
		CASE WHEN  charindex(',',CurrCSIpAddress) > 0
			THEN LEFT(CurrCSIpAddress,charindex(',', CurrCSIpAddress) - 1)
		ELSE CurrCSIpAddress
		END
		, '/webconsole')
		FROM cf_CommcellIdNameMap CNM WITH (NOLOCK)
			INNER JOIN #ccid_list CL ON CNM.ID = CL.ccid
		WHERE IPAddress IS NULL OR IPAddress = 'N/A'
IF(DB_ID('commserv')IS NOT NULL)
	BEGIN
	--check if local or remote machine
	UPDATE #ccid_list SET IPAddress = '../..'
		FROM cf_CommcellIdNameMap CCNM
		INNER JOIN commserv.dbo.APP_CommCell AC ON CCNM.CommServGUID = AC.csGUID
		INNER JOIN #ccid_list CL ON CL.ccid = CCNM.ID
		WHERE AC.id = 2
	END
--check if it is private or cloud metrics reporting
DECLARE @isPrivate  INT = 0
SELECT  @isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig (NOLOCK) WHERE Name = 'isPrivate'
--in cloud, we need to give the store links for various downloads within cloud.commvault.com only and not the respective cs
IF (@isPrivate = 0)
	UPDATE #ccid_list SET IPAddress = 'http://cloud.commvault.com/webconsole'
--store data from cf_MetricSecurityStatus of latest survey into temptable
IF OBJECT_ID('tempdb..#DataTable') IS NOT NULL
	DROP TABLE #DataTable
CREATE TABLE #DataTable (ccid INT, attrName varchar(256), attrVal nvarchar(max))
INSERT INTO #DataTable
	SELECT CL.ccid, attrName,attrVal FROM cf_MetricSecurityStatus MSS WITH (NOLOCK)
		INNER JOIN #ccid_list CL ON MSS.SurveyResultId = CL.SurveyResultId
--Compute status for each item in cf_MetricSecurityStatus
--1 Good, 2 Warning, 3 Critical, 4 Info
DECLARE @tempStatus INT = 0
DECLARE @tempRemarks nvarchar(1024)
DECLARE @tempAction nvarchar(1024)
--Version - Info
UPDATE #ccid_list SET Version = attrVal FROM #DataTable DT
	INNER JOIN #ccid_list CL ON CL.ccid = DT.ccid
	WHERE attrName = 'version'
--2Factor Authentication - Info
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid,'2FAEnabled',2501,4,
			CASE WHEN attrVal = 1
				THEN 'Enabled'
				ELSE 'Disabled<br>Commvault recommends you enable this feature'
			END,
			CASE WHEN  attrVal = 1
				THEN ''
				ELSE '<a href="https://documentation.commvault.com/commvault/v11/article?p=7887.htm" target="_blank" >How to enable two factor authentication</a>'
			END
		FROM #DataTable
			WHERE attrName = '2FAEnabled'
--SSO Method - Info
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid,'SSOMethod',2502,4,
			CASE WHEN (CONVERT(XML, attrVal)).value('count(/SSODetails/ProviderDetails)', 'int') < 1
				THEN 'No Single sign-on Providers are configured.'
				ELSE CONVERT(nvarchar(3),(CONVERT(XML, attrVal)).value('count(/SSODetails/ProviderDetails)', 'int')) + ' Single sign-on Provider(s) are configured.'
			END,
			CASE WHEN (CONVERT(XML, attrVal)).value('count(/SSODetails/ProviderDetails)', 'int') < 1
				THEN ''
				ELSE
					CASE WHEN @isPrivate = 1
						THEN '<a href="../../reportsplus/reportViewer.jsp?reportId=32d8f8f0-5838-49f0-92b5-cfc1ced25c67&input.userCommcellId=%5B'+CAST(ccid AS VARCHAR(16))+'%5D" target="_blank" >View report</a>'
						--in cloud give documentation as action
						ELSE '<a href="https://documentation.commvault.com/commvault/v11/article?p=3788.htm" target="_blank" >Read more</a>'
	END
	END
		FROM #DataTable
			WHERE attrName = 'SSOMethod'
--Get Password Complexity Workflow Enabled
    --if it is not enabled, give link to enable as action in Password Complexity Level's action column
--Password Complexity Workflow Enabled - Does not affect status
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT DT.ccid, 'PasswordComplexityLevel', 2503, 0,
		CASE WHEN attrVal = 1 THEN ''
			WHEN attrVal = -1 THEN ', Check Password Complexity workflow is not deployed'
			ELSE ', Check Password Complexity workflow is disabled'
		END,
		CASE WHEN attrVal = 1 THEN ''
			WHEN attrVal = -1 THEN 'Deploy <a href="'+CL.IPAddress+'/softwarestore/#!/136/670/7484"  target="_blank" >Check Password Complexity</a> workflow.'
			ELSE '<a href="http://documentation.commvault.com/commvault/v11/article?p=49636.htm"  target="_blank" >How to enable a workflow</a> '
            END
	FROM #DataTable DT
			INNER JOIN #ccid_list CL ON CL.ccid = DT.ccid
			WHERE attrName = 'PCWEnabled'
--Password Complexity Level - Warning
UPDATE #ResultTable SET
	status = CASE WHEN DT.attrVal <2 THEN 2 ELSE 1 END,
	action = CASE WHEN DT.attrVal < 2
			THEN action
				+ CASE WHEN action = '' THEN '' ELSE '<br>' END
				+ '<a href="http://documentation.commvault.com/additionalsetting/details?name=passwordComplexityLevel"  target="_blank" >Set password complexity level to 2 or higher</a>'
			ELSE action
			END,
	remarks = '<a href="https://documentation.commvault.com/commvault/v11/article?p=8091.htm"  target="_blank" >Level '
				+ (select attrVal from #DataTable where attrName = 'PasswordComplexityLevel' and ccid = RT.commcellid)
				+ '</a>' + remarks
	FROM #DataTable DT
	INNER JOIN #ResultTable RT ON DT.ccid = RT.commcellid AND DT.attrName = 'PasswordComplexityLevel'
	WHERE RT.attrName = 'PasswordComplexityLevel'
--Failed Login Attempt Limits Enabled - Warning
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid,'FailedLoginAttemptLimit',2504,
		CASE WHEN attrVal > 0 THEN 1 ELSE 2 END,
		CASE WHEN attrVal > 0 THEN 'The account will lock after ' + attrVal + ' failed log-on attempts.'
			ELSE 'No limit is set for failed log-on attempts.<br>Commvault recommends you set a limit'
		END,
		'<a href="https://documentation.commvault.com/commvault/v11/article?p=8080.htm" target="_blank" >How to set a failed log-on attempts limit</a>'
	FROM #DataTable WHERE attrName = 'FailedLoginAttemptLimit'
--Account Lock Duration - Info
	--this is relevant only if Failed Login Attempts Limit has been set
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid,'AccountLockDuration',2505,4,
				'The account will be locked for '
				+ (dbo.ConvertSecondsToStdFormat(DT.attrVal))
				,'<a href="https://documentation.commvault.com/commvault/v11/article?p=8080.htm" target="_blank" >How to set the account lock duration</a>'
	FROM #DataTable DT
	INNER JOIN #ResultTable RT ON RT.commcellid = DT.ccid
	WHERE DT.attrName = 'AccountLockDuration' AND RT.attrName = 'FailedLoginAttemptLimit' AND RT.status = 1
--Web Console Timeout Enabled - Info
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid,'WebTimeout',2506,4,
		CASE WHEN attrVal > -1
			THEN 'Command Center will timeout after '
				+ CASE WHEN (SELECT attrVal FROM #DataTable WHERE attrName = 'SessionTimeoutType' AND ccid = DT.ccid )  = 1
					THEN  CONVERT( NVARCHAR(10),(CONVERT(INT, (attrVal)) /60))
					ELSE attrVal
					END
				+ ' minutes'
			ELSE 'Command Center will timeout after 30 minutes.'
		END,
		'<a href="https://documentation.commvault.com/commvault/v11/article?p=4352.htm" target="_blank" >How to change the timeout period</a>'
	FROM #DataTable DT WHERE attrName = 'SessionTimeoutVal'
--GUI Timeout Enabled - Warning
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid,'GuiTimeout',2507,
		CASE WHEN attrVal > 0 THEN 1
			ELSE 2
			END,
		CASE WHEN attrVal > 0 THEN 'Commcell Console will timeout after ' + attrVal + ' minutes.'
			ELSE 'Commcell Console will not timeout.<br>Commvault recommends you set a timeout'
			END,
		'<a href="http://documentation.commvault.com/commvault/v11/article?p=8642.htm" target="_blank" >How to set the timeout period</a>'
	FROM #DataTable WHERE attrName = 'GuiTimeout'
--for audit trail retention periods, we display the reccomendend period in terms of months and years...
--... unless the current setting is lower than the reccomended one. Here we will show it as days because the user has to input in terms of days.
--Audit Trail Retention Days for Critical - Warning
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'AuditTrailRetentionDaysCritical', 25081,
		CASE WHEN attrVal >= 365 THEN 1 ELSE 2 END,
		'Current setting: <b>'
		+ dbo.HumaniseDays(attrVal, CASE WHEN attrVal >= 365 THEN 1 ELSE 2 END)
		+ '</b> <br>Recommended: '
		+ dbo.HumaniseDays(365, CASE WHEN attrVal >= 365 THEN 1 ELSE 2 END)
		+ CASE WHEN attrVal >= 365 THEN '' ELSE ' (365 days)' END,
		CASE WHEN attrVal >= 365 THEN ''
			ELSE '<a href="http://documentation.commvault.com/commvault/v11/article?p=7754.htm" target="_blank" >How to change audit trail retention period</a>'
			END
	FROM #DataTable WHERE attrName = 'AuditTrailRetentionDaysCritical'
--Audit Trail Retention Days for High - Warning
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'AuditTrailRetentionDaysHigh', 25082,
		CASE WHEN attrVal >= 365 THEN 1 ELSE 2 END,
		'Current setting : <b>'
		+ dbo.HumaniseDays(attrVal, CASE WHEN attrVal >= 365 THEN 1 ELSE 2 END)
		+ '</b> <br>Recommended: '
		+ dbo.HumaniseDays(365, CASE WHEN attrVal >= 365 THEN 1 ELSE 2 END)
		+ CASE WHEN attrVal >= 365 THEN '' ELSE ' (365 days)' END,
		CASE WHEN attrVal >= 365 THEN ''
			ELSE '<a href="http://documentation.commvault.com/commvault/v11/article?p=7754.htm" target="_blank" >How to change audit trail retention period</a>'
		END
	FROM #DataTable WHERE attrName = 'AuditTrailRetentionDaysHigh'
--Audit Trail Retention Days for Medium - Warning
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'AuditTrailRetentionDaysMedium', 25083,
		CASE WHEN attrVal >= 240 THEN 1 ELSE 2 END,
		'Current setting : <b>'
		+ dbo.HumaniseDays(attrVal, CASE WHEN attrVal >= 240 THEN 1 ELSE 2 END)
		+ '</b> <br>Recommended: '
		+ dbo.HumaniseDays(240, CASE WHEN attrVal >= 240 THEN 1 ELSE 2 END)
		+ CASE WHEN attrVal >= 240 THEN '' ELSE ' (240 days)' END,
		CASE WHEN attrVal >= 240 THEN ''
			ELSE '<a href="http://documentation.commvault.com/commvault/v11/article?p=7754.htm" target="_blank" >How to change audit trail retention period</a>'
		END
	FROM #DataTable WHERE attrName = 'AuditTrailRetentionDaysMedium'
--Audit Trail Retention Days for Low - Warning
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'AuditTrailRetentionDaysLow', 25084,
		CASE WHEN attrVal >= 120 THEN 1 ELSE 2 END,
		'Current setting : <b>'
		+ dbo.HumaniseDays(attrVal, CASE WHEN attrVal >= 120 THEN 1 ELSE 2 END)
		+ '</b> <br>Recommended: '
		+ dbo.HumaniseDays(120, CASE WHEN attrVal >= 120 THEN 1 ELSE 2 END)
		+ CASE WHEN attrVal >= 120 THEN '' ELSE ' (120 days)' END,
		CASE WHEN attrVal >= 120 THEN ''
			ELSE '<a href="http://documentation.commvault.com/commvault/v11/article?p=7754.htm" target="_blank" >How to change audit trail retention period</a>'
		END
	FROM #DataTable WHERE attrName = 'AuditTrailRetentionDaysLow'
--Security Cleanup Report
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'cleanupReport', 2509,4,
		'&#9679; '
		+ ISNULL(NULLIF(CONVERT(NVARCHAR(10),
			(SELECT COUNT(csInfo.UserGroupName) from cf_SurveyCleanupUserGroup csInfo
				INNER JOIN dbo.cf_SurveyResultFuncV1(214,0,1,NULL,NULL,@i_UserId,-1) AS rv ON rv.SurverResultId = csInfo.SurveyResultId AND csInfo.flags & 2 > 0
				WHERE ccid = rv.CommServUniqueId)
			),'0'),'No')
		+ ' user groups without users<br>&#9679; '
		+ ISNULL(NULLIF(CONVERT(NVARCHAR(10),
			(SELECT COUNT(csInfo.UserGroupName) from cf_SurveyCleanupUserGroup csInfo
				INNER JOIN dbo.cf_SurveyResultFuncV1(214,0,1,NULL,NULL,@i_UserId,-1) AS rv ON rv.SurverResultId = csInfo.SurveyResultId AND csInfo.flags & 1 > 0
				WHERE ccid = rv.CommServUniqueId)
			),'0'),'No')
		+ ' users without security associations<br>&#9679; '
		+ ISNULL(NULLIF(CONVERT(NVARCHAR(10),
			(SELECT count(csInfo.UserName) from cf_SurveyUserNotLoggedIn csInfo
				INNER JOIN dbo.cf_SurveyResultFuncV1(214,0,1,NULL,NULL,@i_UserId,-1) AS rv ON rv.SurverResultId = csInfo.SurveyResultId
				WHERE ccid = rv.CommServUniqueId)
			),'0'),'No')
		+ ' users not logged-in in 30 days',
		'<a href="../../reportsplus/reportViewer.jsp?reportId=790a0b61-7f90-4f1f-ceb6-2e454263cb2a&pageName=Security&input.CommCell=%5B'+CAST(ccid AS VARCHAR(16))+'%5D" target="_blank" >View report</a>'
	FROM #ccid_list
--User and user group permissions report (UserCapabilities.xml, built-in report)
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT DT.ccid, 'userPermissionsReport', 25010, 4,
		'View users in master group',
		--this is a commserv report and cannot be viewed from cloud, so we provide documentation link instead
		CASE WHEN @isPrivate = 0
			THEN '<a href="https://documentation.commvault.com/commvault/v11/article?p=39208.htm" target="_blank" >Read more</a>'
			ELSE '<a href="'+CL.IPAddress+'/reportsplus/reportViewer.jsp?reportId=2530e3e4-33d1-44a0-e24d-c0d3d2fba0d1&pageName=UserListing&input.Commcell=%5B%22'+attrVal+'%22%5D&input.userGroups=%5B%22master%22%5D" target="_blank" >View report</a>'
	END
	FROM #DataTable DT
	INNER JOIN #ccid_list CL ON DT.ccid = CL.ccid
		WHERE attrName ='CommcellAliasName'
	--Number of Storage Pools without Primary Encryption - Info
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT DT.ccid, 'StoragePoolsWithoutEncryption', 25011, 4,
		CASE WHEN (SELECT attrVal FROM #DataTable  WHERE attrName = 'StoragePoolsWithoutPrimaryEncryption' AND ccid = DT.ccid) = 0
			THEN 'All storage pools are encrypted'
			ELSE (SELECT attrVal FROM #DataTable  WHERE attrName = 'StoragePoolsWithoutPrimaryEncryption' AND ccid = DT.ccid)
				+ ' storage pools without encryption'
		END,
		CASE WHEN (SELECT CONVERT(INT, attrVal) FROM #DataTable WHERE attrName = 'ClientEncryptionReportId' AND ccid = DT.ccid) = 0
			THEN '<a href="'+CL.IPAddress+'/softwarestore/#!/135/663/11437" target="_blank" >Install report to view details</a>'
								WHEN @isPrivate = 0 THEN '<a href="http://documentation.commvault.com/commvault/v11/article?p=7764.htm" target="_blank" >Read more</a>'
			ELSE '<a href="'+CL.IPAddress+'/reportsplus/reportViewer.jsp?reportId=ClientEncryptionInformation&pageName=StoragePoolConfiguration" target="_blank" >View report</a>'
							END
	FROM #DataTable DT
	INNER JOIN #ccid_list CL ON DT.ccid = CL.ccid
	WHERE DT.attrName = 'StoragePoolsCount' AND CONVERT(INT, DT.attrVal) > 0 AND CL.Version >= 16
--Number of Secure Mount Paths - Critical
--give link to report for all cases
--get total number of mount paths
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT DT.ccid, 'SecureMountPaths-Secure', 25013,
		CASE WHEN (SELECT attrVal FROM #DataTable  WHERE attrName = 'SecureMountPaths-Secure' AND ccid = DT.ccid) = DT.attrVal
			THEN 1 ELSE 3
		END,
		CASE WHEN (SELECT attrVal FROM #DataTable  WHERE attrName = 'SecureMountPaths-Secure' AND ccid = DT.ccid) = DT.attrVal
			THEN 'All mount paths are secured against ransomware.'
			ELSE 'Some mount paths are not secured against ransomware. <br>Commvault recommends you enable this feature'
		END,
		CASE WHEN (SELECT attrVal FROM #DataTable  WHERE attrName = 'SecureMountPaths-Secure' AND ccid = DT.ccid) = DT.attrVal
			THEN ''
	ELSE
				CASE WHEN (SELECT CONVERT(INT, attrVal) FROM #DataTable WHERE attrName = 'RansomwareReportId' AND ccid = DT.ccid) = 0
					THEN '<a href="'+CL.IPAddress+'/softwarestore/store.do#!/147/0/15365" target="_blank" >Install app</a>'
										WHEN @isPrivate = 0 THEN '<a href="http://documentation.commvault.com/commvault/v11/article?p=9400.htm" target="_blank" >Enable Protection</a>'
					ELSE '<a href="'+CL.IPAddress+'/reportsplus/reportViewer.jsp?reportId='
						+(SELECT attrVal FROM #DataTable WHERE attrName = 'RansomwareReportId' AND ccid = DT.ccid)
						+'" target="_blank" >View report</a>'
									END
			END
	FROM #DataTable DT
	INNER JOIN #ccid_list CL ON DT.ccid = CL.ccid
	WHERE attrName = 'SecureMountPaths-Total' AND attrVal > 0
--File Activity Anomaly Alert - Critical
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT DT.ccid, 'FileActivityAlert', 25014,
		CASE WHEN attrVal = 1 THEN 1 ELSE 3 END,
		CASE WHEN attrVal = 1
			THEN 'Enabled'
			ELSE
				CASE WHEN attrVal = 0 THEN 'Disabled' ELSE 'Deleted' END
				+ '<br>Commvault recommends you enable this alert'
		END,
		CASE WHEN attrVal = 1
			THEN ''
			ELSE '<a href="http://documentation.commvault.com/commvault/v11/article?p=5199.htm" target="_blank">How to enable an alert</a><br>&#9679; The alert is triggered by event code 7:211|7:212 given as regular expression.<br>&#9679; Use regular expression as 7:211|7:212|7:293 in feature release later than 22 <br>&#9679 Use regular expression as 7:211|7:212|7:293|7:269 in feature release later than 25<br>&#9679; The alert should not have any criteria other than Error Code selected'
		END
	FROM #DataTable DT
	INNER JOIN #ccid_list CL ON DT.ccid = CL.ccid
	WHERE CL.Version >= 16 AND attrName = 'FileActivityAlert'
--Users with Master Capabilities - Info (UsersWithMasterCapabilities.xml, built-in report)
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'UsersWithMasterCapabilities', 25018, 4,
		'View and manage the users with master capabilities',
		'<a href="../../reportsplus/reportViewer.jsp?reportId=34c700c5-8661-45cf-db46-946f73e013ab&input.CommCell=%5B'+CAST(ccid AS VARCHAR(16))+'%5D" target="_blank" >View report</a>'
	FROM #ccid_list
--DR backup - Good if configured either on cloud(commvault or third party) or on UNC
INSERT INTO #ResultTable (commcellid,attrName,paramID)
    SELECT ccid, 'DRBackupToCloud', 25029
    FROM #ccid_list
UPDATE R
SET status = 2,
    remarks = 'DR backup is not configured to cloud or UNC path',
    action = '<a href="https://documentation.commvault.com/commvault/v11/article?p=43517_1.htm" target="_blank" >How to configure DR backup</a>'
FROM #ResultTable R
INNER JOIN cf_SurveyDRBkpConfiguration cSDR ON R.commcellid = cSDR.CommServUniqueId AND R.paramID = 25029 and ISNULL(cSDR.UseCommvaultCloud,0) + ISNULL(cSDR.UseThirdpartyCloud,0) = 0 and cSDR.IsUingNetworkPath = 'false'
cross apply dbo.cf_SurveyResultFuncV1(31, commcellid, 1, NULL, NULL, @i_UserId, NULL) cSRF
where cSRF.SurverResultId = cSDR.SurveyResultId
UPDATE #ResultTable
SET status = 1,
    remarks = 'DR backup is configured',
    action = ''
WHERE
    paramID = 25029 AND status IS NULL
--KMS for password encryption - Info
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
SELECT ccid, 'KMSForEncryption', 25030, 4,
	attrVal + ' key management service is used.',
	'<a href="https://documentation.commvault.com/commvault/v11/article?p=118009.htm"  target="_blank" >How to configure a key management service</a>'
FROM #DataTable WHERE attrName = 'KMSForEncryption'
--Granular Authorization workflows - Info
IF OBJECT_ID('tempdb..#GranularWfs') IS NOT NULL
	DROP TABLE #GranularWfs
CREATE TABLE #GranularWfs ( ccid int, WFname varchar(200), WFstatus int);
INSERT INTO #GranularWfs
	SELECT ccid,attrName,attrVal from #DataTable where attrName IN ('GetProcessAuthEnabled', 'DeleteClientAuthorization', 'Delete Jobs Authorization', 'RestoreRequestAuthorization', 'DeleteBackupSetAuthorization', 'DeleteStoragePolicyAuthorization','DeleteLibraryMountPathAuthorization')
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT GWF.ccid,WFname,
			CASE WHEN WFname = 'GetProcessAuthEnabled' THEN 25024
			WHEN WFname = 'DeleteClientAuthorization' THEN 25021
			WHEN WFname = 'Delete Jobs Authorization' THEN 25019
			WHEN WFname = 'RestoreRequestAuthorization' THEN 25025
			WHEN WFname = 'DeleteBackupSetAuthorization' THEN 25020
			WHEN WFname = 'DeleteStoragePolicyAuthorization' THEN 25023
			ELSE 25022 END,
			4,
			CASE WHEN WFstatus=1 THEN 'Enabled.'
				WHEN WFstatus = 0 THEN 'Disabled.'
				ELSE 'Not Deployed.' END,
			CASE WHEN WFstatus = 1 THEN ''
				WHEN WFstatus=0 THEN '<a href="http://documentation.commvault.com/commvault/v11/article?p=49636.htm"  target="_blank" >How to enable a workflow</a>'
				--the download link should directly install the workflow on the commcell machine
				WHEN WFstatus = -1 AND WFname = 'GetProcessAuthEnabled' THEN 'Deploy <a href="'+IPAddress+'/softwarestore/#!/136/670/11878" target="_blank" >Get And Process Authorization</a> workflow'
				WHEN WFstatus = -1 AND WFname = 'DeleteClientAuthorization' THEN 'Deploy <a href="'+IPAddress+'/softwarestore/#!/136/670/13880" target="_blank" >Delete Client Authorization </a> workflow'
				WHEN WFstatus = -1 AND WFname = 'Delete Jobs Authorization' THEN 'Deploy <a href="'+IPAddress+'/softwarestore/#!/136/670/11876" target="_blank" >Delete Jobs Authorization</a> workflow'
				WHEN WFstatus = -1 AND WFname = 'RestoreRequestAuthorization' THEN 'Deploy <a href="'+IPAddress+'/softwarestore/#!/136/670/12221" target="_blank" >Restore Request Authorization</a> workflow'
				WHEN WFstatus = -1 AND WFname = 'DeleteBackupSetAuthorization' THEN 'Deploy <a href="'+IPAddress+'/softwarestore/#!/136/670/13879" target="_blank" >Delete BackupSet Authorization</a> workflow'
				WHEN WFstatus = -1 AND WFname = 'DeleteStoragePolicyAuthorization' THEN 'Deploy <a href="'+IPAddress+'/softwarestore/#!/136/670/13882" target="_blank" >Delete Storage Policy Authorization</a> workflow'
				WHEN WFstatus = -1 AND WFname = 'DeleteLibraryMountPathAuthorization' THEN 'Deploy <a href="'+IPAddress+'/softwarestore/#!/136/670/11877" target="_blank" >Delete Library Mount Path Authorization</a> workflow'
				ELSE '' END
			FROM #GranularWfs GWF
			INNER JOIN #ccid_list CL ON GWF.ccid = CL.ccid
--RequiresAuthenticationForInstalls feature - Warning
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'RequiresAuthenticationForInstalls', 25026,
		CASE WHEN attrVal = 0 THEN 2 ELSE 1 END,
		CASE WHEN attrVal = 0
			THEN 'Authentication is not required<br>Commvault recommends you enable this setting'
			ELSE 'Authentication is required'
		END,
		CASE WHEN attrVal = 0
			THEN '<a href="http://documentation.commvault.com/commvault/v11/article?p=8077.htm" target="_blank" >How to change this setting</a>'
			ELSE ''
	END
	FROM #DataTable
		WHERE attrName = 'RequiresAuthenticationForInstalls'
--KMS - only if v11 - Info (KeyManagementServers.xml, built-in report)
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'KMS', 25027, 4,
		CASE WHEN CONVERT(XML, attrval).value('count(/KMSDetails/KMS)', 'int') < 1
			THEN 'No Key Management Servers are configured.'
			ELSE CONVERT(XML, attrval).value('count(/KMSDetails/KMS)', 'nvarchar(20)') + ' Key Management Server(s) are configured.'
		END,
		CASE WHEN CONVERT(XML, attrval).value('count(/KMSDetails/KMS)', 'int') < 1
			THEN '<a href="https://documentation.commvault.com/commvault/v11/article?p=7861.htm" target="_blank" >How to add a key management server</a>'
			ELSE '<a href="../../reportsplus/reportViewer.jsp?reportId=e98ca73a-378f-4486-9d03-7b6351c6987f&input.userCommcellId=%5B'+CAST(ccid AS VARCHAR(16))+'%5D" target="_blank" >View report</a>'
		END
	FROM #DataTable
		WHERE attrName = 'KMS'
--DLP, add only if entry is present (DataLossPrevention.xml, built-in report)
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'DLP', 25028, 4,
		'See if laptop clients have enabled Data loss prevention',
		'<a href="../../reportsplus/reportViewer.jsp?reportId=61d61051-322c-41a9-f601-328a9af1c17e&input.userCommcellId=%5B'+CAST(ccid AS VARCHAR(16))+'%5D" target="_blank" >View report</a>'
	FROM #DataTable
		WHERE attrName = 'DLP' AND attrVal <> '<DLP/>'
--Tenant Security
--Privacy feature - Info
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT ccid, 'PrivacyFeature', 25015, 4,
		CASE WHEN attrVal = 1
			THEN 'Enabled'
			ELSE 'Disabled<br>Commvault recommends you enable this feature'
		END,
		CASE WHEN attrVal = 1
			THEn ''
			ELSE '<a href="http://documentation.commvault.com/commvault/v11/article?p=97847.htm" target="_blank" >How to enable privacy feature</a>'
	END
	FROM #DataTable WHERE attrName = 'PrivacyFeature'
--Client Encryption - Info
--if report does not exist, give store link (report should be installed on commcell machine)
--if it exists, give link to report on private setup. In cloud, give documentation link
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT DT.ccid, 'ClientEncryption', 25016, 4,
		'View client computer encryption settings',
		CASE WHEN attrVal = 0
			THEN '<a href="'+CL.IPAddress+'/softwarestore/#!/135/663/11437" target="_blank" >Install report to view details</a>'
								WHEN @isPrivate = 0 THEN '<a href="http://documentation.commvault.com/commvault/v11/article?p=7764.htm" target="_blank" >Read more</a>'
			ELSE '<a href="'+CL.IPAddress+'/reportsplus/reportViewer.jsp?reportId=ClientEncryptionInformation" target="_blank" >View report</a>'
							END
	FROM #DataTable DT
	INNER JOIN #ccid_list CL ON DT.ccid = CL.ccid
		WHERE attrName = 'ClientEncryptionReportId' AND CL.Version >= 16
-- Owners who set passkey for restores - Info
INSERT INTO #ResultTable (commcellid,attrName,paramID,status,remarks,action)
	SELECT DT.ccid, 'PasskeyForRestore', 25017, 4,
		CASE WHEN CONVERT(XML, attrVal).value('count(/PasskeyForRestore/ClientDetails)', 'int') = 0
			THEN 'No client computer owners have enabled the passkey for restore operations<br>Commvault recommends you enable this feature'
			ELSE CONVERT(XML, attrVal).value('count(/PasskeyForRestore/ClientDetails)', 'nvarchar(1024)') + ' client computer owner(s) have enabled the passkey for restore operations'
		END,
		'<a href="http://documentation.commvault.com/commvault/v11_sp20/article?p=125415.htm" target="_blank" >How to enable passkey for restores</a> <br> <a href="http://documentation.commvault.com/commvault/v11_sp20/article?p=120586.htm" target="_blank" >How to configure passkey for restores</a>'
	FROM #DataTable DT
	INNER JOIN #ccid_list CL ON DT.ccid = CL.ccid
		WHERE CL.Version >= 16 AND DT.attrName = 'PasskeyForRestore'
UPDATE RT  SET RT.paramName = SHP.ParameterName FROM #ResultTable RT
	INNER JOIN cf_SurveyHealthParam SHP ON RT.paramID = SHP.ParamId
IF (@blaggregate = 0)
	BEGIN
		INSERT INTO #AggregateStatus
		SELECT status, COUNT(status), commcellid
				FROM #ResultTable RT
				GROUP BY status, commcellid
		INSERT INTO #AggregateStatus
			SELECT 5, SUM(scount), AGS.ccid
			FROM #ccid_list CL
			INNER JOIN #AggregateStatus AGS ON CL.ccid = AGS.ccid
			GROUP BY AGS.ccid
	END
IF (@blaggregate = 1)
	select * from #ResultTable order by paramID,commcellid
ELSE
	BEGIN
		--This table is created in RptGetServerHealth
		IF OBJECT_ID('tempdb..#SecurityAssociationSummary') IS NOT NULL
			INSERT INTO #SecurityAssociationSummary
			SELECT * FROM #AggregateStatus AS T
				PIVOT (MIN(scount) FOR status IN ([1],[2],[3],[4],[5])) AS PT
	END
--drop the temptables
IF OBJECT_ID('tempdb..#ResultTable') IS NOT NULL
	DROP TABLE #ResultTable
IF OBJECT_ID('tempdb..#DataTable') IS NOT NULL
	DROP TABLE #DataTable
IF OBJECT_ID('tempdb..#AggregateStatus') IS NOT NULL
	DROP TABLE #AggregateStatus
IF OBJECT_ID('tempdb..#ccid_list') IS NOT NULL
	DROP TABLE #ccid_list
--  QUERY SPECIFIC CODE END --
GO

IF EXISTS (select * from GxQscripts where name = 'GetSecurityAssociationDetails')
	delete from GxQscripts where name = 'GetSecurityAssociationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSecurityAssociationDetails')
	delete from GXDBVersions where aliasname = 'GetSecurityAssociationDetails'
GO

insert into GXDBVersions values(2, 'GetSecurityAssociationDetails',  'v1.1.2.28.4.3', 'GetSecurityAssociationDetails', 'v1.1.2.28.4.3')
GO

