

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/GetLinearGrowthRate.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/GetLinearGrowthRate.sp,v $ $Id: GetLinearGrowthRate.sp,v 1.1.2.5 2020/09/01 01:12:53 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetLinearGrowthRate')
BEGIN
	print '>>> Drop Stored Procedure: GetLinearGrowthRate <<<'
	drop procedure GetLinearGrowthRate
END
IF EXISTS (select * from GxQscripts where name='GetLinearGrowthRate')
	delete from GxQscripts where name = 'GetLinearGrowthRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLinearGrowthRate')
	delete from GXDBVersions where aliasname = 'GetLinearGrowthRate'
GO
print '... Creating Procedure: GetLinearGrowthRate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetLinearGrowthRate
  @i_Dummy INT = 0
AS
SET NOCOUNT ON
/* Caller will create this temp table
CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
*/
DELETE	T
FROM	#GrowthData T
		INNER JOIN (
			SELECT	CommservUniqueId, EntityId, EntityName, MAX(SeqId) AS NumOfData
			FROM	#GrowthData
			GROUP BY CommservUniqueId, EntityId, EntityName
		) S ON T.CommservUniqueId = S.CommservUniqueId AND T.EntityId = S.EntityId AND T.EntityName = S.EntityName
WHERE	NumOfData <= 2
UPDATE	T SET Y = (T.Y - S.Y)/(T.X - S.X)
FROM	#GrowthData T
		INNER JOIN (
			SELECT	CommservUniqueId, EntityId, EntityName, X, Y, (SeqId+1) AS SeqId
			FROM	#GrowthData
		) S ON T.CommservUniqueId = S.CommservUniqueId AND T.EntityId = S.EntityId AND T.EntityName = S.EntityName AND T.SeqId = S.SeqId
DELETE	#GrowthData WHERE SeqId = 1
-- Ignore the first growth data if it is significantly high
DELETE	T
FROM	#GrowthData T
		INNER JOIN (
			SELECT	CommservUniqueId, EntityId, EntityName, AVG(Y) AS AvgY, ISNULL(STDEV(Y), 0) AS StDevY, COUNT(SeqId) AS DataCnt
			FROM	#GrowthData
			WHERE	SeqId > 2
			GROUP BY CommservUniqueId, EntityId, EntityName
		) S ON T.CommservUniqueId = S.CommservUniqueId AND T.EntityId = S.EntityId AND T.EntityName = S.EntityName
WHERE	T.SeqId = 2 AND (T.Y - AvgY) > StDevY
DELETE	T
FROM	#GrowthData T
		INNER JOIN (
			SELECT	CommservUniqueId, EntityId, EntityName, AVG(Y) AS AvgY, ISNULL(STDEV(Y), 0) AS StDevY, COUNT(SeqId) AS DataCnt
			FROM	#GrowthData
			GROUP BY CommservUniqueId, EntityId, EntityName
		) S ON T.CommservUniqueId = S.CommservUniqueId AND T.EntityId = S.EntityId AND T.EntityName = S.EntityName
WHERE	ABS(T.Y - AvgY) > StDevY AND DataCnt > 4
INSERT INTO #GrowthRate
SELECT	CommservUniqueId, EntityId, EntityName, AVG(Y), ISNULL(STDEV(Y), 0)
FROM	#GrowthData
GROUP BY CommservUniqueId, EntityId, EntityName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetLinearGrowthRate')
	delete from GxQscripts where name = 'GetLinearGrowthRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLinearGrowthRate')
	delete from GXDBVersions where aliasname = 'GetLinearGrowthRate'
GO

insert into GXDBVersions values(2, 'GetLinearGrowthRate',  '00010001000200050000', 'GetLinearGrowthRate', '00010001000200050000')
GO

