

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/GetClientGroupsString.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/GetClientGroupsString.sp,v $ $Id: GetClientGroupsString.sp,v 1.4.50.7 2020/06/18 00:25:17 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetClientGroupsString')
BEGIN
	print '>>> Drop Stored Procedure: GetClientGroupsString <<<'
	drop procedure GetClientGroupsString
END
IF EXISTS (select * from GxQscripts where name='GetClientGroupsString')
	delete from GxQscripts where name = 'GetClientGroupsString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientGroupsString')
	delete from GXDBVersions where aliasname = 'GetClientGroupsString'
GO
print '... Creating Procedure: GetClientGroupsString'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientGroupsString
  @i_CellUniqueID INT = 0,
  @i_ClientID INT = 0,
  @i_AsOfDate DATETIME = NULL
AS
SET NOCOUNT ON
/* Caller will create this temp table
CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
*/
CREATE TABLE #ClientGroupList (CommservUniqueId INT, Key1 BIGINT, Key2 BIGINT, ClientGroups NVARCHAR(MAX))
CREATE TABLE #ClientGroupKey  (CommservUniqueId INT, ClientId INT, Key1 BIGINT, Key2 BIGINT)
CREATE TABLE #ClientGroupDate (CommservUniqueId INT, AsOfDate DATETIME)
IF @i_AsOfDate IS NULL
BEGIN
	IF EXISTS (SELECT * FROM #ClientGroupsString)
		INSERT INTO #ClientGroupKey
		SELECT	CGA.CommservUniqueId, CGA.ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
		FROM	cf_SurveyClientGroupAssociation CGA WITH(NOLOCK)
				INNER JOIN #ClientGroupsString CG ON CG.CommservUniqueId = CGA.CommservUniqueId AND CG.ClientId = CGA.ClientId
		WHERE	DeletedDate IS NULL
		GROUP BY CGA.CommservUniqueId, CGA.ClientId
	ELSE
	IF @i_CellUniqueID > 0 AND @i_ClientID > 0
		INSERT INTO #ClientGroupKey
		SELECT	CommservUniqueId, ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
		FROM	cf_SurveyClientGroupAssociation WITH(NOLOCK)
		WHERE	CommservUniqueId = @i_CellUniqueID AND ClientId = @i_ClientID AND DeletedDate IS NULL
		GROUP BY CommservUniqueId, ClientId
	ELSE
	IF @i_CellUniqueID > 0
		INSERT INTO #ClientGroupKey
		SELECT	CommservUniqueId, ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
		FROM	cf_SurveyClientGroupAssociation WITH(NOLOCK)
		WHERE	CommservUniqueId = @i_CellUniqueID AND DeletedDate IS NULL
		GROUP BY CommservUniqueId, ClientId
	ELSE
		INSERT INTO #ClientGroupKey
		SELECT	CommservUniqueId, ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
		FROM	cf_SurveyClientGroupAssociation WITH(NOLOCK)
		WHERE	DeletedDate IS NULL
		GROUP BY CommservUniqueId, ClientId
END
ELSE
BEGIN
	IF @i_CellUniqueID > 0
		INSERT	INTO #ClientGroupDate
		SELECT	CommservUniqueId, CASE WHEN MIN(ISNULL(AddedDate, '01/01/1970')) <= @i_AsOfDate THEN @i_AsOfDate ELSE NULL END
		FROM	cf_SurveyClientGroupAssociation WITH(NOLOCK)
		WHERE	CommservUniqueId = @i_CellUniqueID
		GROUP BY CommservUniqueId
	ELSE
		INSERT	INTO #ClientGroupDate
		SELECT	CommservUniqueId, CASE WHEN MIN(ISNULL(AddedDate, '01/01/1970')) <= @i_AsOfDate THEN @i_AsOfDate ELSE NULL END
		FROM	cf_SurveyClientGroupAssociation WITH(NOLOCK)
		GROUP BY CommservUniqueId
	IF EXISTS (SELECT * FROM #ClientGroupsString)
		INSERT INTO #ClientGroupKey
		SELECT	CGA.CommservUniqueId, CGA.ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
		FROM	cf_SurveyClientGroupAssociation CGA WITH(NOLOCK)
				INNER JOIN #ClientGroupsString CG ON CG.CommservUniqueId = CGA.CommservUniqueId AND CG.ClientId = CGA.ClientId
				INNER JOIN #ClientGroupDate D ON CGA.CommservUniqueId = D.CommservUniqueId
		WHERE	(AsOfDate IS NULL AND DeletedDate IS NULL OR
				 AsOfDate IS NOT NULL AND (AddedDate IS NULL OR AddedDate < AsOfDate) AND (DeletedDate IS NULL OR DeletedDate >= AsOfDate))
		GROUP BY CGA.CommservUniqueId, CGA.ClientId
	ELSE
	IF @i_CellUniqueID > 0 AND @i_ClientID > 0
		INSERT INTO #ClientGroupKey
		SELECT	CGA.CommservUniqueId, ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
		FROM	cf_SurveyClientGroupAssociation CGA WITH(NOLOCK)
				INNER JOIN #ClientGroupDate D ON CGA.CommservUniqueId = D.CommservUniqueId
		WHERE	ClientId = @i_ClientID
			AND (AsOfDate IS NULL AND DeletedDate IS NULL OR
				 AsOfDate IS NOT NULL AND (AddedDate IS NULL OR AddedDate < AsOfDate) AND (DeletedDate IS NULL OR DeletedDate >= AsOfDate))
		GROUP BY CGA.CommservUniqueId, ClientId
	ELSE
		INSERT INTO #ClientGroupKey
		SELECT	CGA.CommservUniqueId, ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
		FROM	cf_SurveyClientGroupAssociation CGA WITH(NOLOCK)
				INNER JOIN #ClientGroupDate D ON CGA.CommservUniqueId = D.CommservUniqueId
		WHERE	(AsOfDate IS NULL AND DeletedDate IS NULL OR
				 AsOfDate IS NOT NULL AND (AddedDate IS NULL OR AddedDate < AsOfDate) AND (DeletedDate IS NULL OR DeletedDate >= AsOfDate))
		GROUP BY CGA.CommservUniqueId, ClientId
END
CREATE CLUSTERED INDEX ClientGroupKey_idx ON #ClientGroupKey (CommservUniqueId, Key1, Key2, ClientId)
IF @i_AsOfDate IS NULL
	DECLARE ClientGroupListCursor CURSOR LOCAL FORWARD_ONLY FOR
	SELECT	CG.CommservUniqueId, Key1, Key2, CG.ClientGroupName
	FROM	cf_SurveyClientGroup CG WITH(NOLOCK)
			INNER JOIN cf_SurveyClientGroupAssociation CGA WITH(NOLOCK) ON CG.CommservUniqueId = CGA.CommservUniqueId AND CG.ClientGroupId = CGA.ClientGroupId
 			INNER JOIN (
				SELECT	CommservUniqueId, Key1, Key2, MIN(ClientId) AS ClientId
 				FROM	#ClientGroupKey
 				GROUP BY CommservUniqueId, Key1, Key2) T ON CGA.CommservUniqueId = T.CommservUniqueId AND CGA.ClientId = T.ClientId
	WHERE	CGA.DeletedDate IS NULL
	ORDER BY CG.CommservUniqueId, Key1, Key2, CG.ClientGroupId
ELSE
	DECLARE ClientGroupListCursor CURSOR LOCAL FORWARD_ONLY FOR
	SELECT	CG.CommservUniqueId, Key1, Key2, CG.ClientGroupName
	FROM	cf_SurveyClientGroup CG WITH(NOLOCK)
			INNER JOIN cf_SurveyClientGroupAssociation CGA WITH(NOLOCK) ON CG.CommservUniqueId = CGA.CommservUniqueId AND CG.ClientGroupId = CGA.ClientGroupId
			INNER JOIN #ClientGroupDate D ON CGA.CommservUniqueId = D.CommservUniqueId
 			INNER JOIN (
				SELECT	CommservUniqueId, Key1, Key2, MIN(ClientId) AS ClientId
 				FROM	#ClientGroupKey
 				GROUP BY CommservUniqueId, Key1, Key2) T ON CGA.CommservUniqueId = T.CommservUniqueId AND CGA.ClientId = T.ClientId
	WHERE	(AsOfDate IS NULL AND CGA.DeletedDate IS NULL OR
			 AsOfDate IS NOT NULL AND (CGA.AddedDate IS NULL OR CGA.AddedDate < AsOfDate) AND (CGA.DeletedDate IS NULL OR CGA.DeletedDate >= AsOfDate))
	ORDER BY CG.CommservUniqueId, Key1, Key2, CG.ClientGroupId
DECLARE	@cc		INT = 0
DECLARE	@cell	INT = 0
DECLARE	@k1		BIGINT = 0
DECLARE	@k2		BIGINT = 0
DECLARE	@key1	BIGINT = 0
DECLARE	@key2	BIGINT = 0
DECLARE	@name	NVARCHAR(512) = ''
DECLARE	@list	NVARCHAR(MAX) = ''
OPEN ClientGroupListCursor
 	FETCH NEXT FROM ClientGroupListCursor INTO @cc, @k1, @k2, @name
WHILE @@FETCH_STATUS = 0
BEGIN
 	IF	@cell IN (0, @cc) AND @k1 = @key1 AND @k2 = @key2
 		SET @list = (@list + '; ' + @name)
 	ELSE
 	BEGIN
 		IF	@cell > 0 AND @key1 > 0 AND @key2 > 0
 			INSERT	INTO #ClientGroupList
 			SELECT	@cell, @key1, @key2, @list
 		SET	@cell = @cc
 		SET @list = @name
 		SET	@key1 = @k1
 		SET @key2 = @k2
 	END
 	FETCH NEXT FROM ClientGroupListCursor INTO @cc, @k1, @k2, @name
END
CLOSE ClientGroupListCursor
DEALLOCATE ClientGroupListCursor
IF	@cell > 0 AND @key1 > 0 AND @key2 > 0
 	INSERT	INTO #ClientGroupList
 	SELECT	@cell, @key1, @key2, @list
IF NOT EXISTS (SELECT * FROM #ClientGroupsString)
	INSERT INTO #ClientGroupsString
	SELECT	K.CommservUniqueId, K.ClientId, L.ClientGroups
	FROM	#ClientGroupKey K, #ClientGroupList L
	WHERE	K.CommservUniqueId = L.CommservUniqueId AND K.Key1 = L.Key1 AND K.Key2 = L.Key2
ELSE
	UPDATE  C SET clientGroups = L.ClientGroups
	FROM    #ClientGroupsString C
	INNER JOIN #ClientGroupKey K ON C.CommservUniqueId = K.CommservUniqueId AND C.clientId = K.ClientId
	INNER JOIN #ClientGroupList L ON K.CommservUniqueId = L.CommservUniqueId AND K.Key1 = L.Key1 AND K.Key2 = L.Key2
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientGroupsString')
	delete from GxQscripts where name = 'GetClientGroupsString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientGroupsString')
	delete from GXDBVersions where aliasname = 'GetClientGroupsString'
GO

insert into GXDBVersions values(2, 'GetClientGroupsString',  '00010004005000070000', 'GetClientGroupsString', '00010004005000070000')
GO

