

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/FetchDataForPrediction.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/FetchDataForPrediction.sp,v $ $Id: FetchDataForPrediction.sp,v 1.1.2.3 2020/12/17 02:52:29 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='FetchDataForPrediction')
BEGIN
	print '>>> Drop Stored Procedure: FetchDataForPrediction <<<'
	drop procedure FetchDataForPrediction
END
IF EXISTS (select * from GxQscripts where name='FetchDataForPrediction')
	delete from GxQscripts where name = 'FetchDataForPrediction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FetchDataForPrediction')
	delete from GXDBVersions where aliasname = 'FetchDataForPrediction'
GO
print '... Creating Procedure: FetchDataForPrediction'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure FetchDataForPrediction
  @i_CommServUniqueID INT = 0,
  @i_LibraryId INT = 0,
  @i_MissingValuesRatio FLOAT = 0.2,
  @i_MinimumReqDataPoints INT = 20,
  @i_weekly INT = 0,
  @endDate DATETIME = NULL
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb..#Days') IS NOT NULL DROP TABLE #Days
IF OBJECT_ID('tempdb..#DesiredCCIDAndLib') IS NOT NULL DROP TABLE #DesiredCCIDAndLib
CREATE TABLE #Days (DayNo int, CommServUniqueId INT, LibraryId INT)
CREATE TABLE #DesiredCCIDAndLib (DayNo INT, CommServUniqueId INT, LibraryId INT, MinSurveyResultId BIGINT, MaxSurveyResultId BIGINT, MaxLogDateUTC DATETIME, MinLogDateUTC DATETIME,
			DistinctDatesInDay INT, TotalRows INT,
	  SurveyResultId BIGINT, LogDateUTC DATETIME, LogDate DATETIME, totalDataWrittenGB FLOAT, totalFreeSpaceGB FLOAT, totalAppSizeGB FLOAT, totalSpaceGB FLOAT)
SET @endDate = ISNULL(@endDate, GETUTCDATE())
DECLARE @startDayNo INT = 0
DECLARE @limit INT = DATEDIFF(Day, (SELECT MIN(LogDateUTC) FROM cf_Survey96DiskLibDetails  WITH(NOLOCK)), @endDate)
DECLARE @CCID INT = 0
;with Days10(DayOrderNo) AS
(
	SELECT @startDayNo
	UNION ALL
	SELECT DayOrderNo + 10
	FROM Days10
	WHERE DayOrderNo < @limit
),
Days(dNo, cnt) AS
(
	SELECT DayOrderNo, 0 FROM Days10
	UNION ALL
	SELECT dNo+1, cnt+1 FROM Days WHERE cnt < 9
)
--select * from Days order by dNo
INSERT INTO #Days
Select dNo, CommServUniqueId, LibraryId
	FROM Days
		INNER JOIN (SELECT CommServUniqueId, LibraryId, MIN(LogDateUTC) AS MinLogDateUTC FROM cf_Survey96DiskLibDetails WITH(NOLOCK)
						WHERE @i_CommServUniqueID = 0 OR (CommServUniqueId = @i_CommServUniqueID AND (@i_LibraryId = 0 OR LibraryId = @i_LibraryId))
						GROUP BY CommServUniqueId, LibraryId
						HAVING COUNT(*) > @i_MinimumReqDataPoints) S
			ON dNo <= DATEDIFF(Day, MinLogDateUTC, @endDate)
;with Data2(DayNo, CommServUniqueId, LibraryId, MinSurveyResultId, MaxSurveyResultId, MaxLogDateUTC, MinLogDateUTC, DistinctDatesInDay, TotalRows) AS
(
	SELECT D.DayNo, D.CommServUniqueId, D.LibraryId, MIN(SurveyResultId), MAX(SurveyResultId), MAX(LogDateUTC), MIN(LogDateUTC),
			Count(DISTINCT CONVERT(date, LogDateUTC)) As 'DistinctDates In Day',
			Count(*) AS 'Total Rows'
	from #Days D LEFT OUTER JOIN cf_Survey96DiskLibDetails DL  WITH(NOLOCK)
		ON D.DayNo = DATEDIFF(Day, LogDateUTC, @endDate)
			AND D.CommServUniqueId = DL.CommServUniqueId AND D.LibraryId = DL.LibraryId
	where  @i_CommServUniqueID = 0 OR D.CommServUniqueId = @i_CommServUniqueID
	group by D.CommServUniqueId, D.LibraryId, D.DayNo
)
,DesiredCCIDAndLib3(CommServUniqueId, LibraryId, NoOfNonNulls, DataPointsRatio) AS
(
	SELECT CommServUniqueId, LibraryId,COUNT(MaxSurveyResultId) AS 'No Of Non-Nulls', COUNT(MaxSurveyResultId)/(1.0*COUNT(*))
	FROM Data2
	GROUP BY CommServUniqueId, LibraryId
	HAVING COUNT(MaxSurveyResultId)/(1.0*COUNT(*)) > (1.0-@i_MissingValuesRatio) AND COUNT(MaxSurveyResultId) > @i_MinimumReqDataPoints-- 'No Of Non-Nulls' are maximum, atleast > 20
)
INSERT INTO #DesiredCCIDAndLib (DayNo, CommServUniqueId, LibraryId, MinSurveyResultId, MaxSurveyResultId, MaxLogDateUTC, MinLogDateUTC, DistinctDatesInDay, TotalRows)
select T.DayNo, T.CommServUniqueId, T.LibraryId, T.MinSurveyResultId, T.MaxSurveyResultId, T.MaxLogDateUTC, T.MinLogDateUTC, T.DistinctDatesInDay, T.TotalRows
FROM Data2 T INNER JOIN DesiredCCIDAndLib3 DE
		ON T.CommServUniqueId = DE.CommServUniqueId and T.LibraryId = DE.LibraryId
Update T
SET SurveyResultId = DiskLib.SurveyResultId,
	LogDateUTC = DiskLib.LogDateUTC,
	LogDate = DiskLib.LogDate,
	totalDataWrittenGB = DiskLib.totalDataWrittenGB,
	totalFreeSpaceGB = DiskLib.totalFreeSpaceGB,
	totalAppSizeGB = DiskLib.totalAppSizeGB,
	totalSpaceGB = DiskLib.totalSpaceGB
FROM #DesiredCCIDAndLib T INNER JOIN cf_Survey96DiskLibDetails DiskLib WITH(NOLOCK)
		ON T.CommServUniqueId = DiskLib.CommServUniqueId and T.LibraryId = DiskLib.LibraryId AND T.MinSurveyResultId = DiskLib.SurveyResultId
IF @i_weekly = 1
BEGIN
	SELECT DayNo As DayNo, MaxSurveyResultId AS SurveyResultId, LogDateUTC, D.CommServUniqueId, D.LibraryId AS LibId,
			totalDataWrittenGB AS CVDataGB,
			totalFreeSpaceGB  AS FreeSpaceGB,
			--ISNULL(totalAppSizeGB,0) ,
			totalSpaceGB AS TotalSpaceGB,
			(totalSpaceGB-totalDataWrittenGB-totalFreeSpaceGB) AS NonCVDataGB
	FROM #DesiredCCIDAndLib D
		INNER JOIN (SELECT CommServUniqueId,LibraryId, DATEPART(WEEK,LogDateUTC) AS WeekNo FROM #DesiredCCIDAndLib
						GROUP BY CommServUniqueId,LibraryId, DATEPART(WEEK,LogDateUTC) HAVING COUNT(*) = 7) W
			ON D.CommServUniqueId = W.CommServUniqueId AND D.LibraryId = W.LibraryId AND DATEPART(WEEK,D.LogDateUTC)  = WeekNo
	ORDER BY D.CommServUniqueId, D.LibraryId, D.DayNo desc
END
ELSE
BEGIN
	SELECT DayNo As DayNo, MaxSurveyResultId AS SurveyResultId, LogDateUTC,CommServUniqueId, LibraryId AS LibId,
			totalDataWrittenGB AS CVDataGB,
			totalFreeSpaceGB  AS FreeSpaceGB,
			--ISNULL(totalAppSizeGB,0) ,
			totalSpaceGB AS TotalSpaceGB,
			(totalSpaceGB-totalDataWrittenGB-totalFreeSpaceGB) AS NonCVDataGB
	FROM #DesiredCCIDAndLib
	ORDER BY CommServUniqueId, LibraryId, DayNo desc
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'FetchDataForPrediction')
	delete from GxQscripts where name = 'FetchDataForPrediction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FetchDataForPrediction')
	delete from GXDBVersions where aliasname = 'FetchDataForPrediction'
GO

insert into GXDBVersions values(2, 'FetchDataForPrediction',  '00010001000200030000', 'FetchDataForPrediction', '00010001000200030000')
GO

