

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CustomReportDCStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CustomReportDCStatus.sp,v $ $Id: CustomReportDCStatus.sp,v 1.1.2.2 2017/09/28 14:32:05 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CustomReportDCStatus <<<'

IF EXISTS (select * from sysobjects where name='CustomReportDCStatus')
	drop procedure CustomReportDCStatus
IF EXISTS (select * from GxQscripts where name='CustomReportDCStatus')
	delete from GxQscripts where name = 'CustomReportDCStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CustomReportDCStatus')
	delete from GXDBVersions where aliasname = 'CustomReportDCStatus'
GO
print '... Creating Procedure: CustomReportDCStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CustomReportDCStatus
  @i_userId INT,
  @i_customReportId INT
AS
SET NOCOUNT ON
	DECLARE @retStatus  INT
	IF NOT EXISTS (SELECT * FROM [CommServ].[dbo].[APP_Reports] WITH(NOLOCK) WHERE reportId = @i_customReportId) --Report doesnt Exist
	BEGIN
		SET @retStatus = -1
	END
	IF OBJECT_ID('tempdb..#queryTbl') IS NOT NULL
		DROP TABLE #queryTbl
	--Get the query ids using the report ID
	CREATE TABLE #queryTbl(queryId INT, isCollectionDone INT DEFAULT 0, lastupdatedTime DATETIME)
	INSERT INTO #queryTbl
	SELECT
		CAST(REPLACE(collectionTable, 'cf_MetricsQuery', '') AS INT), 0, 0
	FROM [CommServ].[dbo].[APP_DataSet] WITH(NOLOCK) WHERE reportId = @i_customReportId AND offline = 2
	IF EXISTS (SELECT 1 FROM #queryTbl) --Report doesnt exists in [cf_CommservSurveyQueries] , Deploy is not yet done.
		AND EXISTS (SELECT * FROM cf_CommservSurveyQueries WITH(NOLOCK) WHERE QueryId IN (SELECT queryId FROM #queryTbl))
	BEGIN
		UPDATE #queryTbl SET lastupdatedTime = q.LastUpdatedTime
		FROM #queryTbl qT
				INNER JOIN cf_CommservSurveyQueries Q WITH(NOLOCK)
					ON q.QueryId = qT.queryId
		UPDATE #queryTbl SET isCollectionDone = 1
			FROM #queryTbl qT
				INNER JOIN cf_CommservSurveyResults R WITH(NOLOCK)
					ON qT.queryId = R.QueryId
						AND r.ShredStatus = 2
						AND r.Flags = 1
						AND r.LogDateUTC >= qt.lastupdatedTime
		IF NOT EXISTS (SELECT * from #queryTbl WHERE isCollectionDone = 0) --check for the latest Data collection for any commserv
		BEGIN
			SET @retStatus = 0
		END
		ELSE --data collection is not completed for any CS.
		BEGIN
			SET @retStatus = 1
		END
	END
	ELSE
	BEGIN
		SET @retStatus = -1
	END
	IF OBJECT_ID('tempdb..#queryTbl') IS NOT NULL
		DROP TABLE #queryTbl
	SELECT @retStatus AS 'repStatus'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CustomReportDCStatus')
	delete from GxQscripts where name = 'CustomReportDCStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CustomReportDCStatus')
	delete from GXDBVersions where aliasname = 'CustomReportDCStatus'
GO

insert into GXDBVersions values(2, 'CustomReportDCStatus',  '00010001000200020000', 'CustomReportDCStatus', '00010001000200020000')
GO

