

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CalculateLastConnectionTime.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CalculateLastConnectionTime <<<'

IF EXISTS (select * from sysobjects where name='CalculateLastConnectionTime')
	drop procedure CalculateLastConnectionTime
IF EXISTS (select * from GxQscripts where name='CalculateLastConnectionTime')
	delete from GxQscripts where name = 'CalculateLastConnectionTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CalculateLastConnectionTime')
	delete from GXDBVersions where aliasname = 'CalculateLastConnectionTime'
GO
print '... Creating Procedure: CalculateLastConnectionTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CalculateLastConnectionTime
AS
BEGIN
	IF OBJECT_ID('tempdb.dbo.#LastConnectionTimeResults') IS NOT NULL
	begin
		update #LastConnectionTimeResults
		set LastConnectionTimeDate = (
case when isnull((B.STATUS), -1) IN (2)
				then
					isnull(ISNULL(B.ModifiedTime, B.CreatedTime), 0)
				else
					0
				end
		)
		from #LastConnectionTimeResults A
		LEFT JOIN CVMetricsServiceConnections as B with(nolock)
		ON A.CSID = B.CommservUniqueId
		update #LastConnectionTimeResults
		set LastConnectionTimeDate =
		(
		case
when (D.status IN (1, 7, 0)) or  (B.status IN (4))
				then
					case
						   when isnull(A.RequestTime, 0) > isnull(B.CreatedTime, 0) AND isnull(A.RequestTime, 0) > isnull(B.ModifiedTime, 0)
						   THEN isnull(A.RequestTime,0)
						   when isnull(B.CreatedTime, 0) > isnull(A.RequestTime, 0) AND isnull(B.CreatedTime, 0) > isnull(B.ModifiedTime, 0)
						   THEN isnull(B.CreatedTime,0)
						   when isnull(B.ModifiedTime, 0) > isnull(A.RequestTime, 0) AND isnull(B.ModifiedTime, 0) > isnull(B.CreatedTime, 0)
						   THEN isnull(B.ModifiedTime,0)
					end
when (B.status IN (3))
				then
					case
						   when isnull(A.RequestTime, 0) > isnull(B.ModifiedTime, 0)
						   THEN isnull(A.RequestTime,0)
						   else isnull(B.ModifiedTime,0)
					end
		end
		)
		from
		CVMetricsServiceConnections as B with(nolock)
		INNER JOIN #LastConnectionTimeResults C
			   ON C.CSID = B.CommservUniqueId
AND (B.status IN ((4), 3))
		LEFT OUTER JOIN (
			   select cvm.ServiceConnectionId,
			   (
			   case when isnull(max(cvm.CreatedTime),0) > isnull(max(cvm.ModifiedTime),0)
			   then
					  isnull(max(cvm.CreatedTime),0)
			   else
					  isnull(max(cvm.ModifiedTime),0)
			   end
			   ) as RequestTime
			   from CVMetricsServiceClientRequest as cvm with(nolock)
			   group by cvm.ServiceConnectionId
		) A
		ON A.ServiceConnectionId = B.CommservUniqueId
		LEFT JOIN (
			   select cvm.ServiceConnectionId, cvm.status
			   from CVMetricsServiceClientRequest as cvm with(nolock)
		) D
		ON A.ServiceConnectionId = D.ServiceConnectionId
	end
END
GO

IF EXISTS (select * from GxQscripts where name = 'CalculateLastConnectionTime')
	delete from GxQscripts where name = 'CalculateLastConnectionTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CalculateLastConnectionTime')
	delete from GXDBVersions where aliasname = 'CalculateLastConnectionTime'
GO

insert into GXDBVersions values(2, 'CalculateLastConnectionTime',  '00000000000000000000', 'CalculateLastConnectionTime', '00000000000000000000')
GO

