

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CM_ManageBillingGroup.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CM_ManageBillingGroup.sp,v $ $Id: CM_ManageBillingGroup.sp,v 1.1.2.10 2019/05/14 21:47:43 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CM_ManageBillingGroup')
BEGIN
	print '>>> Drop Stored Procedure: CM_ManageBillingGroup <<<'
	drop procedure CM_ManageBillingGroup
END
IF EXISTS (select * from GxQscripts where name='CM_ManageBillingGroup')
	delete from GxQscripts where name = 'CM_ManageBillingGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_ManageBillingGroup')
	delete from GXDBVersions where aliasname = 'CM_ManageBillingGroup'
GO
print '... Creating Procedure: CM_ManageBillingGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CM_ManageBillingGroup
  @i_UserId INT		= NULL,
  @i_Option INT		= 1,
  @i_XML NTEXT	= ''
AS
--Option 1, Add a new billing group and license types associated to it
--Option 2, Modify an existing billing group & its associated licenses
--Option 3, Delete an existing billing group & its associated licenses
/****** Note: We will reuse this same stored procedure for aggregator management also as both actions are similar and can use the same XML inputs  ******/
--Option 4, Add a new aggregator with commcell groups associated to it
--Option 5, Modify an existing aggregator & its commcell group associations
--Option 6, Delete an existing aggregator & its associations
--Option 7, Add a new partner with service providers associated to it
--Option 8, Modify an existing partner & its service provider associations
--Option 9, Delete an existing partner & its associations
SET NOCOUNT ON
-- ----------------------------------------------------------------------------
--   VARIABLES
-- ----------------------------------------------------------------------------
DECLARE @idoc				INT
DECLARE @retValue			INT
DECLARE @billingGroupId		INT = 0
DECLARE @billingGroupName	VARCHAR(1024) = ''
DECLARE @description		VARCHAR(MAX) = ''
DECLARE @countingType		INT
DECLARE @billingGroupType	INTEGER
DECLARE @planName			NVARCHAR(1024)
DECLARE @entityType			INT
DECLARE @errMsg				VARCHAR(256)
-- ----------------------------------------------------------------------------
--   Start a Transaction
-- ----------------------------------------------------------------------------
BEGIN TRANSACTION
	-- ----------------------------------------------------------------------------
	--   SETTINGS
	-- ----------------------------------------------------------------------------
	SET @retValue       = 0
	SET @errMsg      = 'Procedure Completed Successfully'
	-- ----------------------------------------------------------------------------
	--   TRY-CATCH Block
	-- ----------------------------------------------------------------------------
	BEGIN TRY
		--   PARSE XML
		EXEC sp_xml_preparedocument @idoc OUTPUT, @i_XML
		IF @i_Option = 1
		BEGIN
			--Add new billing group
			SELECT @billingGroupName=billingGroupName,@description=description,@countingType=countingType,@billingGroupType=billingGroupType,@planName=planName
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupName	VARCHAR(1024),
					description			VARCHAR(MAX),
					countingType		INTEGER,
					billingGroupType	INTEGER,
					planName			NVARCHAR(1024))
			IF EXISTS (SELECT * FROM cm_BillingGroup WITH (NOLOCK) WHERE billingGroupName=@billingGroupName)
			BEGIN
				SET @errMsg='Insertion not allowed as this Billing Group name already exists'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				INSERT INTO cm_BillingGroup VALUES (@billingGroupName,@description,@countingType,@billingGroupType,0,@planName)
				SELECT @billingGroupId=SCOPE_IDENTITY()
				--Add new billing group associations
				INSERT cm_BillingGroupToLicenseMap
				SELECT @billingGroupId,licenseId,licenseType
				FROM   OPENXML(@idoc, '/WebReport_BillingGroup/licenseList', 3)
				WITH	(licenseType	INTEGER,
						 licenseId		INTEGER)
				SET @errMsg='Billing Group has been created successfully'
			END
		END
		ELSE IF @i_Option = 2
		BEGIN
			--Update Billing Group table with new Billing Group name & Description
			SELECT @billingGroupId=billingGroupId, @billingGroupName=billingGroupName, @description=description, @countingType=countingType, @billingGroupType=billingGroupType, @planName=planName
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupId		INTEGER,
					billingGroupName	VARCHAR(1024),
					description			VARCHAR(MAX),
					countingType		INTEGER,
					billingGroupType	INTEGER,
					planName			NVARCHAR(1024))
			IF EXISTS (SELECT * FROM cm_BillingGroup WITH (NOLOCK) WHERE billingGroupName=@billingGroupName AND billingGroupId <> @billingGroupId)
			BEGIN
				SET @errMsg='Updation not allowed as this Billing Group name already exists'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				UPDATE cm_BillingGroup SET billingGroupName=@billingGroupName, description=@description, countingType=@countingType, flag=@billingGroupType, planName=@planName WHERE billingGroupId=@billingGroupId
				--Delete all existing mappings of this billing group and then insert latest ones
				DELETE FROM cm_BillingGroupToLicenseMap where billingGroupId=@billingGroupId
				INSERT cm_BillingGroupToLicenseMap
				SELECT @billingGroupId,licenseId,licenseType
				FROM   OPENXML(@idoc, '/WebReport_BillingGroup/licenseList', 3)
				WITH	(licenseType	INTEGER,
						 licenseId		INTEGER)
				SET @errMsg='Billing Group has been modified successfully'
			END
		END
		ELSE IF @i_Option = 3
		BEGIN
			--Delete a billing group
			SELECT @billingGroupId=billingGroupId
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupId INTEGER)
			DELETE FROM cm_ContractToBillingGroupMap where billingGroupId=@billingGroupId -- delete all contract associations to the billing group to be deleted
			DELETE FROM cm_BillingGroupToLicenseMap where billingGroupId=@billingGroupId -- delete all licenses associated to the billing group to be deleted
			DELETE FROM cm_BillingGroup WHERE billingGroupId = @billingGroupId
			SET @errMsg='Billing Group has been deleted successfully'
		END
		ELSE IF @i_Option = 4
		BEGIN
			--Add new aggregator
			SELECT @billingGroupName=billingGroupName,@description=description,@countingType=countingType
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupName	VARCHAR(1024),
					description			VARCHAR(MAX),
					countingType		INTEGER)
			IF EXISTS (SELECT * FROM cm_Aggregator WITH (NOLOCK) WHERE aggregatorName=@billingGroupName)
			BEGIN
				SET @errMsg='Insertion not allowed as this Service Provider name already exists'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				INSERT INTO cm_Aggregator VALUES (@billingGroupName,@description,0,0)
				SELECT @billingGroupId=SCOPE_IDENTITY()
				--Add new aggregator associations
				INSERT cm_AggregatorAssoc
				SELECT @billingGroupId,licenseId,0,0
				FROM   OPENXML(@idoc, '/WebReport_BillingGroup/licenseList', 3)
				WITH	(licenseType	INTEGER,
						 licenseId		INTEGER)
				SET @errMsg='Service Provider has been created successfully'
			END
		END
		ELSE IF @i_Option = 5
		BEGIN
			--Update Aggregator table with new Aggregator name & Description
			SELECT @billingGroupId=billingGroupId, @billingGroupName=billingGroupName, @description=description, @countingType=countingType
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupId		INTEGER,
					billingGroupName	VARCHAR(1024),
					description			VARCHAR(MAX),
					countingType		INTEGER)
			IF EXISTS (SELECT * FROM cm_Aggregator WITH (NOLOCK) WHERE aggregatorName=@billingGroupName AND aggregatorId <> @billingGroupId)
			BEGIN
				SET @errMsg='Updation not allowed as this Service Provider name already exists'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				UPDATE cm_Aggregator SET aggregatorName=@billingGroupName, aggregatorDescription=@description WHERE aggregatorId=@billingGroupId
				--Delete all existing mappings of this aggregator and then insert latest ones
				DELETE FROM cm_AggregatorAssoc where aggregatorId=@billingGroupId
				INSERT cm_AggregatorAssoc
				SELECT @billingGroupId,licenseId,0,0
				FROM   OPENXML(@idoc, '/WebReport_BillingGroup/licenseList', 3)
				WITH	(licenseType	INTEGER,
						 licenseId		INTEGER)
				SET @errMsg='Service Provider has been modified successfully'
			END
		END
		ELSE IF @i_Option = 6
		BEGIN
			--Delete an aggregator
			SELECT @billingGroupId=billingGroupId
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupId INTEGER)
			DELETE FROM cm_AggregatorToContractMap where aggregatorId=@billingGroupId -- delete all contract associations to this aggregator
			DELETE FROM cm_AggregatorAssoc where aggregatorId = @billingGroupId -- delete all commcell group associations of this aggregator
			DELETE FROM cm_PartnerAssoc where aggregatorId = @billingGroupId -- delete all partner associations of this aggregator
			DELETE FROM cm_Aggregator WHERE aggregatorId = @billingGroupId -- delete this aggregator
			SET @errMsg='Service Provider has been deleted successfully'
		END
		ELSE IF @i_Option = 7
		BEGIN
			--Add new partner
			SELECT @billingGroupName=billingGroupName,@description=description,@countingType=countingType
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupName	VARCHAR(1024),
					description			VARCHAR(MAX),
					countingType		INTEGER)
			IF EXISTS (SELECT * FROM cm_Partner WITH (NOLOCK) WHERE partnerName=@billingGroupName)
			BEGIN
				SET @errMsg='Insertion not allowed as this Partner name already exists'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				INSERT INTO cm_Partner VALUES (@billingGroupName,@description,0,0)
				SELECT @billingGroupId=SCOPE_IDENTITY()
				--Add new partner associations
				INSERT cm_PartnerAssoc
				SELECT @billingGroupId,licenseId,0,0
				FROM   OPENXML(@idoc, '/WebReport_BillingGroup/licenseList', 3)
				WITH	(licenseType	INTEGER,
						 licenseId		INTEGER)
				SET @errMsg='Partner has been created successfully'
			END
		END
		ELSE IF @i_Option = 8
		BEGIN
			--Update partner table with new partner name & Description
			SELECT @billingGroupId=billingGroupId, @billingGroupName=billingGroupName, @description=description, @countingType=countingType
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupId		INTEGER,
					billingGroupName	VARCHAR(1024),
					description			VARCHAR(MAX),
					countingType		INTEGER)
			IF EXISTS (SELECT * FROM cm_Partner WITH (NOLOCK) WHERE partnerName=@billingGroupName AND partnerId <> @billingGroupId)
			BEGIN
				SET @errMsg='Updation not allowed as this Partner name already exists'
				SET @retValue = -1
			END
			ELSE
			BEGIN
				UPDATE cm_Partner SET partnerName=@billingGroupName, partnerDescription=@description WHERE partnerId=@billingGroupId
				--Delete all existing mappings of this partner and then insert latest ones
				DELETE FROM cm_PartnerAssoc where partnerId=@billingGroupId
				INSERT cm_PartnerAssoc
				SELECT @billingGroupId,licenseId,0,0
				FROM   OPENXML(@idoc, '/WebReport_BillingGroup/licenseList', 3)
				WITH	(licenseType	INTEGER,
						 licenseId		INTEGER)
				SET @errMsg='Partner has been modified successfully'
			END
		END
		ELSE IF @i_Option = 9
		BEGIN
			--Delete a partner
			SELECT @billingGroupId=billingGroupId
			FROM   OPENXML(@idoc, '/WebReport_BillingGroup', 0)
			WITH   (billingGroupId INTEGER)
			DELETE FROM cm_PartnerToContractMap where partnerId=@billingGroupId -- delete all contract associations to this partner
			DELETE FROM cm_PartnerAssoc where partnerId = @billingGroupId -- delete all service provider associatins of this partner
			DELETE FROM cm_Partner WHERE partnerId = @billingGroupId -- delete this partner
			SET @errMsg='Partner has been deleted successfully'
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		SET @retValue=ERROR_NUMBER()
		SET @errMsg=ERROR_MESSAGE()
	END CATCH
---- ----------------------------------------------------------------------------
----   CLEAN UP
---- ----------------------------------------------------------------------------
EXEC sp_xml_removedocument @idoc
IF @retValue <> 0
	ROLLBACK TRANSACTION
ELSE
	COMMIT TRANSACTION
-- ----------------------------------------------------------------------------
--   Return back transaction details
-- ----------------------------------------------------------------------------
SELECT @retValue AS errorCode, @errMsg AS errorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CM_ManageBillingGroup')
	delete from GxQscripts where name = 'CM_ManageBillingGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_ManageBillingGroup')
	delete from GXDBVersions where aliasname = 'CM_ManageBillingGroup'
GO

insert into GXDBVersions values(2, 'CM_ManageBillingGroup',  '00010001000200100000', 'CM_ManageBillingGroup', '00010001000200100000')
GO

