

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CM_BillingDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CM_BillingDetails.sp,v $ $Id: CM_BillingDetails.sp,v 1.1.2.16 2020/10/23 13:15:53 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CM_BillingDetails')
BEGIN
	print '>>> Drop Stored Procedure: CM_BillingDetails <<<'
	drop procedure CM_BillingDetails
END
IF EXISTS (select * from GxQscripts where name='CM_BillingDetails')
	delete from GxQscripts where name = 'CM_BillingDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_BillingDetails')
	delete from GXDBVersions where aliasname = 'CM_BillingDetails'
GO
print '... Creating Procedure: CM_BillingDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CM_BillingDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Option INT = 0,
  @i_RptType INT = 0, --0 (commcell groups), 1 (service providers), 2 (partners)
  @i_RptTypeId INT = 0, --0 (commcell groups Id), 1 (service provider Id), 2 (partner Id)
  @i_BillingCycle INT = 0, --0 (monthly), 1 (quarterly)
  @i_MonthString VARCHAR(20) = '' --details is generated for this month
AS
SET NOCOUNT ON
DECLARE @retValue INT = 0
DECLARE @errMsg	VARCHAR(256) = 'Procedure Completed Successfully'
BEGIN TRY
	IF @i_Option=1--list of commcell groups
	BEGIN
		SELECT DISTINCT CG.id AS id, CG.name AS name FROM cf_CommcellGroup CG
		INNER JOIN cf_CommCellGroupAssoc CGA ON CGA.CommCellGroupId=CG.id
		INNER JOIN cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON SR.CommServUniqueId=CGA.CommCellIdNameMap_ID
		WHERE CG.id IN (SELECT DISTINCT clientGroupId FROM cm_ClientGroupToContractMap)
	END
	IF @i_Option=2--list of service providers
	BEGIN
		DECLARE @ccGrps TABLE(ccGrpId INT, ccGrpName NVARCHAR(512))
		INSERT @ccGrps
		EXEC CM_BillingDetails @i_UserId, @i_GroupId, 1
		SELECT DISTINCT A.aggregatorId AS id, A.aggregatorName AS name FROM cm_Aggregator A
		INNER JOIN cm_AggregatorAssoc AA ON AA.aggregatorId=A.aggregatorId
		INNER JOIN @ccGrps CG ON CG.ccGrpId=AA.commCellGroupId
		WHERE A.aggregatorId IN (SELECT DISTINCT aggregatorId FROM cm_AggregatorToContractMap)
	END
	IF @i_Option=3--list of partners
	BEGIN
		DECLARE @ccGrps1 TABLE(ccGrpId INT, ccGrpName NVARCHAR(512))
		INSERT @ccGrps1
		EXEC CM_BillingDetails @i_UserId, @i_GroupId, 1
		DECLARE @aggregators TABLE(aggregatorId INT, aggregatorName NVARCHAR(255))
		INSERT @aggregators
		SELECT DISTINCT A.aggregatorId, A.aggregatorName FROM cm_Aggregator A
		INNER JOIN cm_AggregatorAssoc AA ON AA.aggregatorId=A.aggregatorId
		INNER JOIN @ccGrps1 CG ON CG.ccGrpId=AA.commCellGroupId
		WHERE A.aggregatorId IN (SELECT DISTINCT aggregatorId FROM cm_AggregatorToContractMap)
		SELECT DISTINCT P.partnerId AS id, P.partnerName AS name FROM cm_Partner P
		INNER JOIN cm_PartnerAssoc PA ON PA.partnerId=P.partnerId
		INNER JOIN @aggregators AG ON AG.aggregatorId=PA.aggregatorId
		WHERE P.partnerId IN (SELECT DISTINCT partnerId FROM cm_PartnerToContractMap)
	END
	ELSE IF @i_Option=4
	BEGIN
		IF object_id('tempdb.dbo.#tempDetailsV4') IS NOT null DROP TABLE #tempDetailsV4
			CREATE TABLE #tempDetailsV4(month DATETIME, bgId INT, countingType INT, billingVersion INT, csid INT, ClientId INT, ClientName NVARCHAR(255), SubclientId INT, SubclientName NVARCHAR(255), AppTypeId INT, LicType INT, BackupSetId INT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024), JobId INT, JobType INT, AppSizeMB BIGINT, ObjectName NVARCHAR(1024), ObjectId INT, Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024), LicTypeName VARCHAR(128), AppTypeName VARCHAR(255), bgName NVARCHAR(255), CommCellId VARCHAR(32), CommCell NVARCHAR(520), CountingTypeName VARCHAR(20), JobTypeName VARCHAR(20), BillingVersionName VARCHAR(5), RunTimeUTC DATETIME, ccgrpId INT, aggregatorId INT, partnerId INT, BasePlanName NVARCHAR(1024))
		DECLARE @month DATETIME = NULL
		SET @month=CONVERT(DATE,@i_MonthString)
		IF @month=NULL OR @month > GETDATE()
		BEGIN
			SET @month=DATEADD(DAY,-DAY(GETDATE())+1, CAST(GETDATE() AS DATE))
		END
		DECLARE @secondDay DATETIME = NULL
		DECLARE @lastMonth DATETIME = NULL
		DECLARE @endMonth NVARCHAR(10) = ''
		SET @secondDay=(CONVERT (DATETIME,@month)+1)
		SET @endMonth=CONVERT(NVARCHAR(10),@secondDay,101)
		DECLARE @endMonthOrig NVARCHAR(10) = @endMonth
		DECLARE @ccGrpId INT = 0
		IF @i_RptType=0--CommCell Group
		BEGIN
			IF @i_BillingCycle=0--monthly
			BEGIN
				EXEC CM_GenerateInvoice @i_UserId, @i_RptTypeId, @endMonth, 0, 0, 1, 3
			END
			ELSE--quarterly
			BEGIN
				EXEC CM_GenerateInvoice @i_UserId, @i_RptTypeId, @endMonth, 0, 0, 1, 3
				SET @lastMonth=CONVERT(DATETIME, @endMonth)
				SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
				SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
				EXEC CM_GenerateInvoice @i_UserId, @i_RptTypeId, @endMonth, 0, 0, 1, 3
				SET @lastMonth=CONVERT(DATETIME, @endMonth)
				SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
				SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
				EXEC CM_GenerateInvoice @i_UserId, @i_RptTypeId, @endMonth, 0, 0, 1, 3
			END
			UPDATE #tempDetailsV4 SET ccgrpId=@i_RptTypeId WHERE ccgrpId IS NULL
		END
		ELSE IF @i_RptType=1--Service Provider
		BEGIN
			SET @ccGrpId=0
			DECLARE @spCursor AS CURSOR;
			SET @spCursor = CURSOR FAST_FORWARD FOR
			SELECT commCellGroupId FROM cm_AggregatorAssoc WITH (NOLOCK) WHERE aggregatorId=@i_RptTypeId;
			OPEN @spCursor;
			FETCH NEXT FROM @spCursor INTO @ccGrpId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @endMonth = @endMonthOrig
				IF @i_BillingCycle=0--monthly
				BEGIN
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_RptTypeId, 1, 3
				END
				ELSE--quarterly
				BEGIN
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_RptTypeId, 1, 3
					SET @lastMonth=CONVERT(DATETIME, @endMonth)
					SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
					SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_RptTypeId, 1, 3
					SET @lastMonth=CONVERT(DATETIME, @endMonth)
					SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
					SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_RptTypeId, 1, 3
				END
				UPDATE #tempDetailsV4 SET ccgrpId=@ccGrpId, aggregatorId=@i_RptTypeId WHERE ccgrpId IS NULL
				--Now loop back to the next commcell
				FETCH NEXT FROM @spCursor INTO @ccGrpId;
			END
			CLOSE @spCursor;
			DEALLOCATE @spCursor;
		END
		ELSE IF @i_RptType=2--Partner
		BEGIN
			DECLARE @spId INT = 0
			DECLARE @partnerCursor AS CURSOR;
			SET @partnerCursor = CURSOR FAST_FORWARD FOR
			SELECT aggregatorId FROM cm_PartnerAssoc WITH (NOLOCK) WHERE partnerId=@i_RptTypeId;
			OPEN @partnerCursor;
			FETCH NEXT FROM @partnerCursor INTO @spId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @ccGrpId=0
				DECLARE @aggCursor AS CURSOR;
				SET @aggCursor = CURSOR FAST_FORWARD FOR
				SELECT commCellGroupId FROM cm_AggregatorAssoc WITH (NOLOCK) WHERE aggregatorId=@spId;
				OPEN @aggCursor;
				FETCH NEXT FROM @aggCursor INTO @ccGrpId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @endMonth = @endMonthOrig
					IF @i_BillingCycle=0--monthly
					BEGIN
						EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 3
					END
					ELSE--quarterly
					BEGIN
						EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 3
						SET @lastMonth=CONVERT(DATETIME, @endMonth)
						SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
						SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
						EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 3
						SET @lastMonth=CONVERT(DATETIME, @endMonth)
						SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
						SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
						EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 3
					END
					UPDATE #tempDetailsV4 SET ccgrpId=@ccGrpId, aggregatorId=@spId, partnerId=@i_RptTypeId WHERE ccgrpId IS NULL
					--Now loop back to the next commcell
					FETCH NEXT FROM @aggCursor INTO @ccGrpId;
				END
				CLOSE @aggCursor;
				DEALLOCATE @aggCursor;
				--Now loop back to the next service provider
				FETCH NEXT FROM @partnerCursor INTO @spId;
			END
			CLOSE @partnerCursor;
			DEALLOCATE @partnerCursor;
		END
		ALTER TABLE #tempDetailsV4 ADD ccgrpName NVARCHAR(512) NULL, aggregatorName NVARCHAR(255) NULL, partnerName VARCHAR(255) NULL;
		UPDATE T SET T.LicTypeName=ISNULL(L.name,'N/A'), T.AppTypeName=ISNULL(A.name,'N/A'), T.bgName=B.billingGroupName,
		T.CommCellId=dbo.ConvertBigIntToHexStr(CC.CommCellID), T.CommCell=CC.CustomerName+' - '+CC.CommServName,
		T.CountingTypeName=CASE WHEN T.CountingType=0 THEN 'CAL Usage' WHEN T.CountingType=1 THEN 'Capacity Usage' ELSE T.CountingTypeName END,
		T.JobTypeName=CASE WHEN T.JobType=0 THEN 'Backup' WHEN T.JobType=1 THEN 'Archive' WHEN T.JobType=2 THEN 'Snapshot' WHEN T.JobType=3 THEN 'Replication' ELSE T.JobTypeName END,
		T.BillingVersionName=CASE WHEN T.billingVersion=4 THEN 'V4' WHEN T.billingVersion=3 THEN 'V3' WHEN T.billingVersion=2 THEN 'V2' WHEN T.billingVersion=1 THEN 'V1' ELSE T.BillingVersionName END,
		T.RunTimeUTC=GETUTCDATE(), T.ccgrpId=(CASE WHEN T.ccgrpId IS NULL THEN -1 ELSE T.ccgrpId END), T.aggregatorId=(CASE WHEN T.aggregatorId IS NULL THEN -1 ELSE T.aggregatorId END),
		T.partnerId=(CASE WHEN T.partnerId IS NULL THEN -1 ELSE T.partnerId END), T.ccgrpName=ISNULL(CG.name,'N/A'), T.aggregatorName=ISNULL(AG.aggregatorName,'N/A'), T.partnerName=ISNULL(PG.partnerName,'N/A')
		FROM #tempDetailsV4 T
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=T.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=T.AppTypeId
		INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON B.billingGroupId = T.bgid
		INNER JOIN cf_CommcellIdNameMap CC WITH (NOLOCK) ON CC.ID=T.csid
		LEFT JOIN cf_CommcellGroup CG WITH (NOLOCK) ON CG.id=T.ccgrpId
		LEFT JOIN cm_Aggregator AG WITH (NOLOCK) ON AG.aggregatorId=T.aggregatorId
		LEFT JOIN cm_Partner PG WITH (NOLOCK) ON PG.partnerId=T.partnerId
		DECLARE @FSOnlyServerLicType INT = 100029, @DLOnlyLicType INT = 200002, @APPServerLicType INT = 100030, @LiveSyncVMLicType INT = 200016, @DRVMLicType INT = 100040, @FSOnlyVMLicType INT = 200017
        DECLARE @VMWithAppLicType INT = 200003, @VMOnlyLicType INT = 200001, @ProtectedVMLicType INT = 100019, @VirtualMachineLicType INT = 100011, @VMSocketsLicType INT = 100018
        DECLARE @DPELicType INT = 100002, @DAELicType INT = 100004, @DPSLicType INT = 100005, @DPRLicType INT = 100006
		DECLARE @epUsers INT = 100024, @sharingUsers INT = 100025, @eDiscoveryUsers INT = 100026, @mSimUsers INT = 100028, @CIObjects INT = 100017, @appStoreUsage INT = 100031, @dedupeStoreSpace INT = 100016, @diskLibrarySpace INT = 100015
		DECLARE @mbUsers INT = 200011, @spUsers INT = 200012, @gmUsers INT = 200013, @gdUsers INT = 200014, @odUsers INT = 200015, @sfUsers INT = 200018, @ntUsers INT = 200019, @ciUsers INT = 300001, @csUsers INT = 300002, @cmUsers INT = 300003, @hyperScale INT = 200021
		DECLARE @activateFO INT = 100038, @activateEDFiles INT = 100034, @activateEDEmails INT = 100035, @activateSFiles INT = 100036, @activateSEmails INT = 100037
		DECLARE @metallicT1 INT = 100041, @metallicT2 INT = 100042, @metallicT3 INT = 100043, @metallicT4 INT = 100044, @metallicT5 INT = 100045, @metallicT6 INT = 100046, @metallicT7 INT = 100047, @metallicT8 INT = 100048, @metallicT9 INT = 100049, @metallicT10 INT = 100050
		--add name-id mappings for client, vm, subclient and storage policy to usages collected from V2 & V3 tables. MR 265698
		--do this only for V2 & V3 details (billingVersion=2, 3). V4 is already handled in cm_generateInvoice stored proc
        UPDATE T SET T.ClientName=ISNULL(CL.ClientName,'N/A'), T.SubclientName=ISNULL(SCL.SubclientName, 'N/A'), T.SPName=ISNULL(SP.PolicyName, 'N/A')
        FROM #tempDetailsV4 T
        LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=T.ClientId AND CL.CommServUniqueId=T.csid
        LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=T.SubclientId AND SCL.ClientId=T.ClientId AND SCL.CommServUniqueId=T.csid
        LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=T.spId AND SP.CommServUniqueId=T.csid
		WHERE billingVersion <> 4
        UPDATE T SET T.ObjectName=ISNULL(VMCL.ClientName,'N/A')
        FROM #tempDetailsV4 T
        LEFT JOIN cf_SurveyClient VMCL WITH (NOLOCK) ON VMCL.ClientId=T.ObjectId AND VMCL.CommServUniqueId=T.csid
        WHERE T.licType IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
		AND billingVersion <> 4
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, CASE WHEN CountingType=1 THEN JobId ELSE -1 END AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
		-1 AS AppTypeId, 'N/A' AS AppTypeName, -1 InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
		ObjectId AS VMId, ObjectName AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		CASE WHEN CountingType=1 THEN AppSizeMB ELSE -1 END AS AppSizeMB, CASE WHEN CountingType=1 THEN CAST(AppSizeMB AS FLOAT)/1024 ELSE -1 END AS AppSizeGB, CASE WHEN CountingType=1 THEN CAST(AppSizeMB AS FLOAT)/1024/1024 ELSE -1 END AS AppSizeTB,
		csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType IN (@VMOnlyLicType, @VMWithAppLicType, @ProtectedVMLicType, @VirtualMachineLicType, @DRVMLicType) AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 JobId, 'N/A' AS JobTypeName, ClientId AS ClientId, ClientName+' (source)' AS ClientName,
		-1 AS AppTypeId, 'N/A' AS AppTypeName, -1 InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
		-1 AS VMId, ObjectName+' (destination)' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		-1 AS AppSizeMB, -1 AS AppSizeGB, -1 AS AppSizeTB,
		csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType IN (@LiveSyncVMLicType) AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
		-1 AS AppTypeId, 'N/A' AS AppTypeName, -1 InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
		-1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, ObjectName AS HypervisorHost, AppSizeMB AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		-1 AS AppSizeMB, -1 AS AppSizeGB, -1 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType IN (@VMSocketsLicType) AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
		-1 AS AppTypeId, 'N/A' AS AppTypeName, -1 InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
		-1 AS VMId, 'N/A' AS 'VMName', ObjectId AS UserId, ObjectName AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		-1 AS AppSizeMB, -1 AS AppSizeGB, -1 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType IN (@epUsers, @sharingUsers, @eDiscoveryUsers) AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
		-1 AS AppTypeId, 'N/A' AS AppTypeName, -1 InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
		-1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, ObjectName AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		-1 AS AppSizeMB, -1 AS AppSizeGB, -1 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType IN (@mSimUsers, @mbUsers, @spUsers, @gmUsers, @gdUsers, @odUsers, @sfUsers, @ntUsers, @ciUsers, @csUsers, @cmUsers) AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
		-1 AS AppTypeId, 'N/A' AS AppTypeName, -1 InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
		-1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, CAST(AppSizeMB AS FLOAT)/1000000 AS UsageInMillions, ObjectName AS SearchEngine,
		-1 AS AppSizeMB, -1 AS AppSizeGB, -1 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType IN (@CIObjects) AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, ObjectId AS ClientId, 'N/A' AS ClientName,
		-1 AS AppTypeId, 'N/A' AS AppTypeName, -1 InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
		-1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		CASE WHEN CountingType=1 THEN AppSizeMB ELSE -1 END AS AppSizeMB, CASE WHEN CountingType=1 THEN CAST(AppSizeMB AS FLOAT)/1024 ELSE -1 END AS AppSizeGB, CASE WHEN CountingType=1 THEN CAST(AppSizeMB AS FLOAT)/1024/1024 ELSE -1 END AS AppSizeTB,
		csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType IN (@appStoreUsage, @dedupeStoreSpace, @diskLibrarySpace) AND billingVersion<>2
		UNION
        SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
        -1 AS AppTypeId, 'N/A' AS AppTypeName, InstanceId AS InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, SubclientId AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
        -1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
        AppSizeMB, CAST(AppSizeMB AS FLOAT)/1024 AS AppSizeGB, CAST(AppSizeMB AS FLOAT)/1024/1024 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,ClientName AS 'Storage Pool',  CAST(BackupSetId AS FLOAT)/1024/1024 AS 'Total Capacity', BackupSetName AS 'Appliance Type', ClientId AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
        FROM #tempDetailsV4
        WHERE LicType IN (@hyperScale) AND billingVersion<>2
		UNION
        SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, ClientId, ClientName,
        -1 AS AppTypeId, 'N/A' AS AppTypeName, -1 AS InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
        -1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
        AppSizeMB, CAST(AppSizeMB AS FLOAT)/1024 AS AppSizeGB, CAST(AppSizeMB AS FLOAT)/1024/1024 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
        FROM #tempDetailsV4
        WHERE LicType IN (@activateFO, @activateEDFiles, @activateSFiles) AND billingVersion<>2
		UNION
        SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
        -1 AS AppTypeId, 'N/A' AS AppTypeName, -1 AS InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
        -1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
        -1 AS AppSizeMB, -1 AS AppSizeGB, -1 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', AppSizeMB AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
        FROM #tempDetailsV4
        WHERE LicType IN (@activateEDEmails, @activateSEmails) AND billingVersion<>2
		UNION
        SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, -1 AS JobId, 'N/A' AS JobTypeName, -1 AS ClientId, 'N/A' AS ClientName,
        -1 AS AppTypeId, 'N/A' AS AppTypeName, -1 AS InstanceId, 'N/A' AS InstanceName, -1 AS BackupSetId, 'N/A' AS BackupSetName, -1 AS SubclientId, 'N/A' AS SubclientName, -1 AS SPId, 'N/A' AS SPName,
        -1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
        AppSizeMB, CAST(AppSizeMB AS FLOAT)/1024 AS AppSizeGB, CAST(AppSizeMB AS FLOAT)/1024/1024 AS AppSizeTB, csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,ClientName AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', ClientId AS 'Storage Pool ID', -1 AS 'User Count', ObjectId AS 'Container ID', ObjectName AS 'Container'
        FROM #tempDetailsV4
        WHERE LicType IN (@metallicT1, @metallicT2, @metallicT3, @metallicT4, @metallicT5, @metallicT6, @metallicT7, @metallicT8, @metallicT9, @metallicT10) AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, JobId, JobTypeName, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName, BackupSetId, BackupSetName,
		SubclientId, SubclientName, SPId, SPName, -1 AS VMId, 'N/A' AS 'VMName', -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		CASE WHEN CountingType=1 THEN AppSizeMB ELSE -1 END AS AppSizeMB, CASE WHEN CountingType=1 THEN CAST(AppSizeMB AS FLOAT)/1024 ELSE -1 END AS AppSizeGB, CASE WHEN CountingType=1 THEN CAST(AppSizeMB AS FLOAT)/1024/1024 ELSE -1 END AS AppSizeTB,
		csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE LicType NOT IN (@VMOnlyLicType, @VMWithAppLicType, @ProtectedVMLicType, @VirtualMachineLicType, @VMSocketsLicType, @epUsers, @sharingUsers, @eDiscoveryUsers, @mSimUsers, @CIObjects, @appStoreUsage, @dedupeStoreSpace, @diskLibrarySpace, @LiveSyncVMLicType, @mbUsers, @spUsers, @gmUsers, @gdUsers, @odUsers, @sfUsers, @ntUsers, @ciUsers, @csUsers, @cmUsers, @hyperScale, @DRVMLicType,
		@activateFO, @activateEDFiles, @activateSFiles, @activateEDEmails, @activateSEmails, @metallicT1, @metallicT2, @metallicT3, @metallicT4, @metallicT5, @metallicT6, @metallicT7, @metallicT8, @metallicT9, @metallicT10)
		AND billingVersion<>2
		UNION
		SELECT DISTINCT month, bgId, bgName, CountingTypeName, LicType, LicTypeName, JobId, JobTypeName, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName, BackupSetId, BackupSetName,
		SubclientId, SubclientName, SPId, SPName, ObjectId AS VMId, ObjectName AS VMName, -1 AS UserId, 'N/A' AS UserName, 'N/A' AS SMTP, 'N/A' AS HypervisorHost, -1 AS Sockets, -1 AS UsageInMillions, 'N/A' AS SearchEngine,
		AppSizeMB, CAST(AppSizeMB AS FLOAT)/1024 AS AppSizeGB, CAST(AppSizeMB AS FLOAT)/1024/1024 AS AppSizeTB,	csid, CommCellId, CommCell, OrgGUID, Organization, PlanName, RunTimeUTC, BillingVersionName, ccgrpId, ccgrpName, aggregatorId, aggregatorName, partnerId, partnerName, BasePlanName
		,'N/A' AS 'Storage Pool',  -1 AS 'Total Capacity', 'N/A' AS 'Appliance Type', -1 AS 'Storage Pool ID', -1 AS 'User Count', -1 AS 'Container ID', 'N/A' AS 'Container'
		FROM #tempDetailsV4
		WHERE billingVersion=2
		IF object_id('tempdb.dbo.#tempDetailsV4') IS NOT null DROP TABLE #tempDetailsV4
	END
END TRY
BEGIN CATCH
	SET @retValue=ERROR_NUMBER()
	SET @errMsg=ERROR_MESSAGE()
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CM_BillingDetails')
	delete from GxQscripts where name = 'CM_BillingDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_BillingDetails')
	delete from GXDBVersions where aliasname = 'CM_BillingDetails'
GO

insert into GXDBVersions values(2, 'CM_BillingDetails',  '00010001000200160000', 'CM_BillingDetails', '00010001000200160000')
GO

