

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/AppCreateCLRFunctions.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/AppCreateCLRFunctions.sp,v $ $Id: AppCreateCLRFunctions.sp,v 1.1.2.9 2020/09/16 15:19:07 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCreateCLRFunctions')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCLRFunctions <<<'
	drop procedure AppCreateCLRFunctions
END
IF EXISTS (select * from GxQscripts where name='AppCreateCLRFunctions')
	delete from GxQscripts where name = 'AppCreateCLRFunctions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCLRFunctions')
	delete from GXDBVersions where aliasname = 'AppCreateCLRFunctions'
GO
print '... Creating Procedure: AppCreateCLRFunctions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateCLRFunctions
  @i_FullDLLPath NVARCHAR(MAX)
AS
    DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
    DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	DECLARE @windows TINYINT = 1
    DECLARE @linux TINYINT = 2
    DECLARE @osType TINYINT = 0
    DECLARE @nl VARCHAR(4) = ''
    DECLARE @versionSQL NVARCHAR(MAX)
	DECLARE @windowsDBCLRDLLPath NVARCHAR(MAX)
	DECLARE @linuxDBCLRDLLPath NVARCHAR(MAX)
	DECLARE @linuxTimezoneCLRDLLPath NVARCHAR(MAX)
	DECLARE @o_retVal INTEGER
    DECLARE @sqlQuery NVARCHAR(MAX)
	DECLARE @finalDLLPath NVARCHAR(MAX)
	SET @versionSQL = @@VERSION
    SET @osType = IIF((@versionSQL LIKE '%Linux%'), @linux, @windows)
    SET @nl = IIF((@osType = @windows), (CHAR(13) + CHAR(10)), CHAR(10))	-- CRLF(Windows), LF(Linux newline)
	SET NOCOUNT ON
	-- Setting correct dll paths based on the platform.
	IF (@osType = @windows)
	BEGIN
		SET @windowsDBCLRDLLPath = @i_FullDLLPath
		SET @sqlQuery = 'USE MASTER
						IF NOT EXISTS (SELECT name FROM syslogins WHERE name = ''CVDBCLRLogin'')
						BEGIN
							IF NOT EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVDBCLRKey'')
							CREATE ASYMMETRIC KEY CVDBCLRKey FROM EXECUTABLE FILE = ''' + @windowsDBCLRDLLPath + '''
							CREATE LOGIN CVDBCLRLogin FROM ASYMMETRIC KEY CVDBCLRKey
							GRANT UNSAFE ASSEMBLY TO CVDBCLRLogin
						END '
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF  @o_retVal <> 0 GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SET @linuxDBCLRDLLPath = @i_FullDLLPath + '/cv_dbclr_safe.dll'
		SET @linuxTimezoneCLRDLLPath = @i_FullDLLPath + '/cv_dbclr_timezone_safe.dll'
	END
	-- Enabling 'show advanced options' (for displaying sp_configure)
	SET @sqlQuery = 'USE MASTER
                    EXEC sp_configure ''show advanced options'', 1
                    RECONFIGURE WITH OVERRIDE'
    EXECUTE sp_executeSql @sqlQuery
    SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	-- Enabling CLR Integration
    SET @sqlQuery = 'USE MASTER
                    EXEC sp_configure ''clr enabled'', 1
                    RECONFIGURE WITH OVERRIDE'
    EXECUTE sp_executeSql @sqlQuery
    SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	-- For SQL Server 2017+, we need to disable 'clr strict security'.
    IF (@releaseNumber >= 14)
    BEGIN
        IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr strict security' AND CAST(value_in_use AS INT) = 1)
        BEGIN
            SET @sqlQuery = 'USE MASTER;
                    EXEC sp_configure ''clr strict security'' , 0;
                    RECONFIGURE WITH OVERRIDE;
            '
            EXECUTE sp_executeSql @sqlQuery
            SET @o_retVal = @@ERROR
            IF  @o_retVal <> 0 GOTO CX_EXIT
        END
    END
	-- Dropping all objects linked to existing assemblies.
	DECLARE @objcur CURSOR
    DECLARE @object_id INT
    DECLARE @type char(2)
	SET @objcur=CURSOR FOR
        (SELECT sO.object_id, sO.TYPE FROM sys.objects sO
        INNER JOIN sys.assembly_modules sAM ON sO.object_id = sAM.object_id
        INNER JOIN sys.assemblies sA ON sAM.assembly_id = sA.assembly_id
        WHERE sA.name in ('dbCLR', 'timezoneclr'))
	SET @sqlQuery = N''
	OPEN @objcur
    FETCH NEXT FROM @objcur INTO @object_id,@type
    WHILE @@FETCH_STATUS = 0
    BEGIN
	    IF @type = 'P' OR @type = 'PC'
            SET @sqlQuery += 'DROP PROCEDURE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
        ELSE IF @type = 'FS'
            SET @sqlQuery += 'DROP FUNCTION ' +  OBJECT_NAME(@object_id) + '; ' + @nl
        ELSE IF @type = 'AF'
            SET @sqlQuery += 'DROP AGGREGATE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
        FETCH NEXT FROM @objcur INTO @object_id,@type
    END
    DEALLOCATE @objcur
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	-- Dropping existing assemblies.
	SET @sqlQuery = 'IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''dbclr'')
                        DROP ASSEMBLY [dbclr] '
    EXECUTE sp_executeSql @sqlQuery
    SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''timezoneclr'')
                        DROP ASSEMBLY [timezoneclr] '
    EXECUTE sp_executeSql @sqlQuery
    SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	-- Creating new assemblies.
	IF (@osType = @windows)
	BEGIN
		SET @sqlQuery = 'CREATE ASSEMBLY dbclr FROM N''' + @windowsDBCLRDLLPath + ''' WITH PERMISSION_SET = UNSAFE ' + @nl
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF  @o_retVal <> 0 GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SET @sqlQuery = 'CREATE ASSEMBLY dbclr FROM N''' + @linuxDBCLRDLLPath + ''' WITH PERMISSION_SET = SAFE ' + @nl
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF  @o_retVal <> 0 GOTO CX_EXIT
		SET @sqlQuery = 'CREATE ASSEMBLY timezoneclr FROM N''' + @linuxTimezoneCLRDLLPath + ''' WITH PERMISSION_SET = SAFE ' + @nl
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF  @o_retVal <> 0 GOTO CX_EXIT
	END
	-- Register new CLR functions for CVCloud below.
	DECLARE @timezoneAssemblyName NVARCHAR(MAX) = N'dbclr'
	IF (@osType = @linux)
	BEGIN
		SET @timezoneAssemblyName = 'timezoneclr'
	END
	-- Function : UTCToLocalDateTimeConversion
    SET @sqlQuery = 'CREATE FUNCTION [dbo].[UTCToLocalDateTimeConversion] (@UTCTime DATETIME, @timeZoneName NVARCHAR(255))
                    	RETURNS DATETIME
                    	WITH EXECUTE AS CALLER
                    	AS
                    	EXTERNAL NAME [' + @timezoneAssemblyName + '].[UserDefinedFunctions].[UTCToLocalDateTimeConversion]'
    EXECUTE sp_executeSql @sqlQuery
    SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	-- Function : LocalToUTCDateTimeConversion
    SET @sqlQuery = 'CREATE FUNCTION [dbo].[LocalToUTCDateTimeConversion] (@LocalTime DATETIME, @timeZoneName NVARCHAR(255))
                        RETURNS DATETIME
                        WITH EXECUTE AS CALLER
                        AS
                        EXTERNAL NAME [' + @timezoneAssemblyName + '].[UserDefinedFunctions].[LocalToUTCDateTimeConversion]'
    EXECUTE sp_executeSql @sqlQuery
    SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	-- Exiting
	CX_EXIT:
    	SELECT @o_retVal
    	RETURN @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCLRFunctions')
	delete from GxQscripts where name = 'AppCreateCLRFunctions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCLRFunctions')
	delete from GXDBVersions where aliasname = 'AppCreateCLRFunctions'
GO

insert into GXDBVersions values(2, 'AppCreateCLRFunctions',  '00010001000200090000', 'AppCreateCLRFunctions', '00010001000200090000')
GO

