

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/cf_surveyKBLink.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: cf_surveyKBLink'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_surveyKBLink]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cf_surveyKBLink]
  delete from GXDBVersions where name = 'cf_surveyKBLink' and type = 5
END
GO

    CREATE FUNCTION cf_surveyKBLink ( @spaceSeparatedErrorCodes  NVARCHAR(MAX))
    RETURNS NVARCHAR(MAX)
    AS
    BEGIN

    DECLARE @inputErrorCodes NVARCHAR(MAX) = @spaceSeparatedErrorCodes
    DECLARE @tblErrorCodes TABLE (errorCode NVARCHAR(52), htmlTag NVARCHAR(MAX))

    WHILE (CHARINDEX(' ',@spaceSeparatedErrorCodes)>0)
    BEGIN
	    INSERT INTO @tblErrorCodes (errorCode)
        SELECT LTRIM(RTRIM(SUBSTRING(@spaceSeparatedErrorCodes,1,CHARINDEX(' ',@spaceSeparatedErrorCodes)-1)))
        SET @spaceSeparatedErrorCodes = SUBSTRING(@spaceSeparatedErrorCodes,CHARINDEX(' ',@spaceSeparatedErrorCodes)+1,LEN(@spaceSeparatedErrorCodes))
    END

    IF(@spaceSeparatedErrorCodes IS NOT NULL AND LEN(@spaceSeparatedErrorCodes) > 0)
        INSERT INTO @tblErrorCodes (errorCode)
        SELECT LTRIM(RTRIM(@spaceSeparatedErrorCodes))

    DECLARE @baseKBLink nvarchar(MAX)
    DECLARE @result nvarchar(MAX) = ''
    DECLARE @QuoteVal  nvarchar(5)
    SET @QuoteVal = '%22'
    SET @baseKBLink = (select value from cf_SurveyConfig where Name = 'CVKnowledgeBaseLink')
    IF  @baseKBLink IS NOT NULL
    BEGIN
		UPDATE @tblErrorCodes
		SET htmlTag = '<a class="linkClass" target="_blank" href="'
                    + @baseKBLink
                    + '?q='
                    + @QuoteVal
                    + errorCode
                    + @QuoteVal + '">'
                    + errorCode
                    + '</a>'
                    + '</a>'

		SELECT @result =  COALESCE(@result + ' ', '') + htmlTag FROM @tblErrorCodes
    END
    ELSE
        SET @result = @inputErrorCodes
    return LTRIM(RTRIM(@result))
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cf_surveyKBLink]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cf_surveyKBLink' AND revision = '')

  insert into GXDBVersions values(5, 'cf_surveyKBLink',  '', 'cf_surveyKBLink', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
