

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/cf_SurveyResultFuncV1.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: cf_SurveyResultFuncV1'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_SurveyResultFuncV1]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cf_SurveyResultFuncV1]
  delete from GXDBVersions where name = 'cf_SurveyResultFuncV1' and type = 5
END
GO

	CREATE FUNCTION [dbo].[cf_SurveyResultFuncV1] (
		@i_QueryId		INT,
		@i_CSUniqueId	INT = 0,
		@i_LatestOnly	INT = 1,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEnd	DATETIME = NULL,
        @i_UserId       INT = NULL,
        @i_GroupId      INT = -1
	 )
	 RETURNS @Results TABLE (
	 	CommServUniqueId INT,
		CommCellID       VARCHAR(32),
		CommServIP       VARCHAR(256),
		CommServGUID     VARCHAR(256),
		CustomerName     NVARCHAR(256),
		CommServName     NVARCHAR(256),
		DisplayName      NVARCHAR(256),
		CommServHostName NVARCHAR(510),
		CommServTimeZone VARCHAR(256),
		CommServVersion  VARCHAR(256),
		CommServEdition	 VARCHAR(256),
		SurverResultId   BIGINT,
		SurveyID         INT,
		LogDate          DATETIME,
		LogDateUTC       DATETIME,
		RunningTime      INT,
		SureyResultFlags INT
	 )
	 AS
	 BEGIN
	 	DECLARE @UserCapability INT = -1
	 	DECLARE @UserProp xml

	 	DECLARE @IncludeDisabled INT = 0
	 	SET @IncludeDisabled = (@i_LatestOnly & 2)/2
	 	SET @i_LatestOnly = @i_LatestOnly & 1

	 	DECLARE @i_CommCellID	INT

	 	IF @i_CSUniqueId > 0
	 	BEGIN
	 		SELECT	@i_CommCellID = CommCellID
	 		FROM	cf_CommcellIdNameMap WITH (NOLOCK)
	 		WHERE	ID = @i_CSUniqueId AND (Flags & 1) <= @IncludeDisabled

	 		IF @i_CommCellID IS NULL
	 			RETURN
	 	END

		DECLARE @isPrivate INT = 0
		SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'isPrivate'

	 	DECLARE @CommcellTbl TABLE (
	 		 	ID				 INT,
	 			CommCellID       VARCHAR(32),
	 			CommServIP       VARCHAR(256),
	 			CommServGUID     VARCHAR(256),
	 			CustomerName     NVARCHAR(256),
	 			CommServName     NVARCHAR(256),
				DisplayName      NVARCHAR(256),
	 			CommServTZ		 VARCHAR(256),
	 			CommServVersion  VARCHAR(256),
	 			CommServEdition  VARCHAR(256),
	 			CommServHostName NVARCHAR(510)
	 		)

	 	IF @i_UserId > 0
	 	 	SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)

	 	IF @i_CSUniqueId = 0 AND ISNULL(@i_GroupId, 0) <= 0 AND (@i_UserId = -1 OR @UserCapability = 1)
		BEGIN
			IF @i_LatestOnly = 1
	 			INSERT INTO @Results
				SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 					CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
						cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
						result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
				FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON result.CommcellIdNameMap_ID = cc.ID
						AND result.QueryId = @i_QueryId
						AND result.Flags = 1
	 	   		WHERE	(cc.Flags & 1) <= @IncludeDisabled
			ELSE
			IF	@i_LogDateStart IS NOT NULL AND @i_LogDateEND IS NOT NULL
				INSERT INTO @Results
				SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 					CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
						cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
						result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
				FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON result.CommcellIdNameMap_ID = cc.ID
						AND result.QueryId = @i_QueryId
						AND result.LogDateUTC BETWEEN @i_LogDateStart AND @i_LogDateEnd
	 	   		WHERE	(cc.Flags & 1) <= @IncludeDisabled
			ELSE
	 			INSERT INTO @Results
				SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 					CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
						cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
						result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
				FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON result.CommcellIdNameMap_ID = cc.ID
						AND result.QueryId = @i_QueryId
	 	   		WHERE	(cc.Flags & 1) <= @IncludeDisabled

			RETURN
		END

		DECLARE @groupName NVARCHAR(1024) = ''
		IF (ISNULL(@i_GroupId, 0) > 0)
			SELECT @groupName = name FROM cf_CommcellGroup WHERE id = @i_GroupId

	 	IF @i_CSUniqueId > 0 AND (@i_UserId = -1 OR @UserCapability = 1)
		BEGIN
			IF ISNULL(@groupName, '') <> ''
	 		AND (@groupName = 'Permanent CommCells' AND @i_CommCellID < 655360
	 		  OR @groupName = 'Eval CommCells' AND @i_CommCellID <> -1
	 	      OR @groupName = 'NFR CommCells' AND (@i_CommCellID <= 0 OR @i_CommCellID >= 655360))
			BEGIN
				RETURN
			END
			ELSE
			IF ISNULL(@i_GroupId, 0) > 0 AND NOT EXISTS (
	 			SELECT  1
	 			FROM    cf_CommcellGroupAssoc cga WITH (NOLOCK)
						INNER JOIN cf_CommcellGroup cg WITH (NOLOCK)
							ON cg.id = cga.CommCellGroupId AND cg.id = @i_GroupId
	 			WHERE	cga.CommcellIdNameMap_ID = @i_CSUniqueId)
			BEGIN
				RETURN
			END

			IF @i_LatestOnly = 1
	 			INSERT INTO @Results
				SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 					CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
						cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
						result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
				FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON result.CommcellIdNameMap_ID = cc.ID
						AND result.QueryId = @i_QueryId
						AND result.Flags = 1
	 	   		WHERE	cc.ID = @i_CSUniqueId
			ELSE
			IF	@i_LogDateStart IS NOT NULL AND @i_LogDateEND IS NOT NULL
				INSERT INTO @Results
				SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 					CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
						cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
						result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
				FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON result.CommcellIdNameMap_ID = cc.ID
						AND result.QueryId = @i_QueryId
						AND result.LogDateUTC BETWEEN @i_LogDateStart AND @i_LogDateEnd
	 	   		WHERE	cc.ID = @i_CSUniqueId
			ELSE
	 			INSERT INTO @Results
				SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 					CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
						cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
						result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
				FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON result.CommcellIdNameMap_ID = cc.ID
						AND result.QueryId = @i_QueryId
	 	   		WHERE	cc.ID = @i_CSUniqueId

			RETURN
		END

	 	IF @i_UserId = -1
	 		SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = 1)
	 	ELSE
	 		SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)

	 	IF (@i_UserId = -1 OR @UserCapability = 1)
		BEGIN
			IF (@groupName = 'Permanent CommCells')
	 			INSERT INTO @CommcellTbl
	 			SELECT  ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.DisplayName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition, ccMap.CommServHostName
	 			FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 			WHERE	(Flags & 1) <= @IncludeDisabled AND ccMap.CommCellID >= 655360
			ELSE IF (@groupName = 'Eval CommCells')
	 			INSERT INTO @CommcellTbl
	 			SELECT  ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.DisplayName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition, ccMap.CommServHostName
	 			FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 			WHERE	(Flags & 1) <= @IncludeDisabled AND ccMap.CommCellID = -1
			ELSE IF (@groupName = 'NFR CommCells')
				INSERT INTO @CommcellTbl
				SELECT  ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.DisplayName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition, ccMap.CommServHostName
				FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
		 		WHERE	(Flags & 1) <= @IncludeDisabled AND ccMap.CommCellID > 0 AND ccMap.CommCellID < 655360
			ELSE
			BEGIN
	 			INSERT INTO @CommcellTbl
	 			SELECT  DISTINCT ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.DisplayName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition, ccMap.CommServHostName
	 			FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 					INNER JOIN cf_CommcellGroupAssoc cga WITH (NOLOCK)
	 						ON cga.CommcellIdNameMap_ID = ccMap.ID
						INNER JOIN cf_CommcellGroup cg WITH (NOLOCK)
							ON cg.id = cga.CommCellGroupId
							AND cg.id = @i_GroupId
	 			WHERE	(Flags & 1) <= @IncludeDisabled
			END
	 	END
	 	ELSE IF (ISNULL(@i_GroupId, 0) > 0 AND @i_CSUniqueId <= 0)
	 	BEGIN
	 		;WITH VisibleGroups (groupId) AS
	 		(
	 			SELECT  clientGroup.value('@clientGroupId', 'INT')
	 			FROM    @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
	 					CROSS APPLY resp.nodes('commcellGroups') AS clientGroup(clientGroup)
	 			WHERE clientGroup.value('@clientGroupId', 'INT') = @i_GroupId
				UNION
				SELECT CG.id
				FROM (
						SELECT
							ccg.value('@userGroupId', 'INT') companyId
						From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
							CROSS apply resp.nodes('companies/company') AS ccg(ccg)
					) UG
					INNER JOIN cf_CustomerGroup G WITH(NOLOCK)
						ON G.id = UG.companyId
						AND G.clientGroupId = @i_GroupId
					INNER JOIN cf_CommcellGroup CG WITH(NOLOCK)
						ON CG.id = G.clientGroupId
						AND CG.status & 32 <> 0
	 		)
	 		INSERT INTO @CommcellTbl
	 		SELECT  DISTINCT ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.DisplayName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition, ccMap.CommServHostName
	 		FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 			INNER JOIN cf_CommcellGroupAssoc cga WITH (NOLOCK)
	 				ON cga.CommcellIdNameMap_ID = ccMap.ID
	 			INNER JOIN VisibleGroups vcg
	 				ON 	cga.commcellGroupId = vcg.groupId
	 				AND vcg.groupId = @i_GroupId
	 		WHERE   (Flags & 1) <= @IncludeDisabled
		END
	 	ELSE
	 	IF @i_CSUniqueId > 0
	 	BEGIN
	 		;WITH VisibleCommcells (CommCellID, CommServGUID) AS
	 		(
	 			SELECT  commcells.value('@commCellId', '[NVARCHAR](MAX)'), commcells.value('@csGUID', '[NVARCHAR](MAX)')
	 			FROM    @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
	 					CROSS APPLY resp.nodes('commcells') AS commcells(commcells)
	 		)
	 		INSERT INTO @CommcellTbl
	 		SELECT  DISTINCT ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.DisplayName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition, ccMap.CommServHostName
	 		FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 				INNER JOIN VisibleCommcells  vcc ON vcc.CommServGUID = ccMap.CommServGUID
	 		WHERE   ID = @i_CSUniqueId
		END
	 	ELSE
	 	BEGIN
	 		;WITH VisibleCommcells (CommCellID, CommServGUID) AS
	 		(
	 			SELECT  commcells.value('@commCellId', '[NVARCHAR](MAX)'), commcells.value('@csGUID', '[NVARCHAR](MAX)')
	 			FROM    @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
	 					CROSS APPLY resp.nodes('commcells') AS commcells(commcells)
	 		)
	 		INSERT INTO @CommcellTbl
	 		SELECT  DISTINCT ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.DisplayName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition, ccMap.CommServHostName
	 		FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 				INNER JOIN VisibleCommcells  vcc ON vcc.CommServGUID = ccMap.CommServGUID
	 		WHERE   (Flags & 1) <= @IncludeDisabled
		END

		IF @i_LatestOnly = 1
	 		INSERT INTO @Results
			SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 				CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
					cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
					result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
			FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
				INNER JOIN @CommcellTbl AS cc
					ON result.CommcellIdNameMap_ID = cc.ID
					AND result.QueryId = @i_QueryId
					AND result.Flags = 1
		ELSE
		IF	@i_LogDateStart IS NOT NULL AND @i_LogDateEND IS NOT NULL
			INSERT INTO @Results
			SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 				CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
					cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
					result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
			FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
				INNER JOIN @CommcellTbl AS cc
					ON result.CommcellIdNameMap_ID = cc.ID
					AND result.QueryId = @i_QueryId
					AND result.LogDateUTC BETWEEN @i_LogDateStart AND @i_LogDateEnd
		ELSE
	 		INSERT INTO @Results
			SELECT	cc.ID, cc.CommCellID, cc.CommServIP, cc.CommServGUID, cc.CustomerName, cc.CommServName,
	 				CASE WHEN ISNULL(cc.DisplayName, '') <> '' THEN cc.DisplayName WHEN @isPrivate = 1 THEN cc.CommServName WHEN cc.CustomerName <> '' THEN cc.CustomerName + ' - ' + cc.CommServName ELSE cc.CommServName END,
					cc.CommServHostName, cc.CommServTZ, cc.CommServVersion, cc.CommServEdition, result.CommservSurveyResults_ID,
					result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
			FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
				INNER JOIN @CommcellTbl AS cc
					ON result.CommcellIdNameMap_ID = cc.ID
					AND result.QueryId = @i_QueryId

	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cf_SurveyResultFuncV1]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cf_SurveyResultFuncV1' AND revision = '1.6.2.10.4.1')

  insert into GXDBVersions values(5, 'cf_SurveyResultFuncV1',  '1.6.2.10.4.1', 'cf_SurveyResultFuncV1', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
