

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptMetricsThresholdInfo.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: RptMetricsThresholdInfo'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptMetricsThresholdInfo]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptMetricsThresholdInfo]
  delete from GXDBVersions where name = 'RptMetricsThresholdInfo' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptMetricsThresholdInfo]
	(
		@i_CommServUniqueId INT = 0,
		@i_QueryId INT = 0
	)
	RETURNS @TblSurveyResult TABLE
	(
		Parameter	 NVARCHAR(256) ,
		Threshold	 NVARCHAR(256) ,
		GoodText	 NVARCHAR(1024) ,
		WarnText	 NVARCHAR(1024),
		CriticalText NVARCHAR(1024),
		Warning		 INT ,
		Critical	 INT ,
		tmin		 INT ,
		tmax	 INT
	)
	AS
	BEGIN
	INSERT INTO @TblSurveyResult SELECT QueryName AS 'Parameter', ThresholdName AS 'Threshold',GoodThresholdText AS 'GoodText',WarningThresholdText AS 'WarnText', CriticalThresholdText AS 'CriticalText', WarningThreshold AS Warning, CriticalThreshold AS Critical, ThresholdMin AS tmin, ThresholdMax AS tmax FROM cf_ReportParameterView WHERE QueryId = @i_QueryId

	IF (( @i_CommServUniqueId != 0) AND (@i_QueryId  IN (65,156,144)))
	BEGIN
		DECLARE @commCellWarning INT=0
	    DECLARE @commCellCritical INT =0

					IF (@i_QueryId = 144)
					BEGIN
						DECLARE @CommServVersion INT
						SELECT  @CommServVersion =CASE WHEN LEFT(CommServVersion,2) LIKE '11%' THEN 11
	                                                                                WHEN LEFT(CommServVersion,2) LIKE '9.%' THEN 9
 	                                                                                WHEN LEFT(CommServVersion,2) LIKE '10%' THEN 10
 	                                                                                ELSE 0 END
												FROM cf_CommcellIdNameMap  WHERE CommCellSurveyServices & 1 = 1 AND  id =@i_CommServUniqueId
					 IF @CommServVersion<11
							UPDATE @TblSurveyResult
								 SET	 GoodText		=  'Over 50% of indexes are less than 30% fragmented.',
									     WarnText		=  'Over 25% of indexes are 30% to 50% fragmented.',
									     CriticalText   =  'Over 25% of indexes are more than 50% fragmented.'

					 IF @CommServVersion>=11
							UPDATE @TblSurveyResult
						SET	 GoodText	='Indexes are less than 30% fragmented or the most recent DB maintenance activity occurred fewer than 7 days ago.',
							 WarnText= 'Indexes are more than 30% fragmented and the most recent DB maintenance activity occurred more than 7 days ago.',
							CriticalText='Indexes are more than 30% fragmented and the most recent DB maintenance activity occurred more than 30 days ago.'

				END


			IF (@i_QueryId = 65)
			BEGIN
			SET @commCellWarning =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 and attrName ='AvgQITimeWarningLimit' AND CommServUniqueId=@i_CommServUniqueId AND attrtype =10),(SELECT Warning FROM @TblSurveyResult))

			SET @commCellCritical  =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 and attrName ='AvgQITimeCriticalLimit' AND CommServUniqueId=@i_CommServUniqueId AND attrtype =10),(SELECT Critical FROM @TblSurveyResult))

			 UPDATE @TblSurveyResult
			 SET	 GoodText		=  REPLACE(GoodText, 'CommCell Q&I Time Minimum Threshold',cast(@commCellWarning as nvarchar(max) ) +' &mu;s'),
					 WarnText		=  REPLACE(WarnText, 'Between minimum and maximum Threshold of CommCell Q&I Time',cast(@commCellWarning as nvarchar(max)) +'-'+ cast(@commCellCritical as nvarchar(max)) +' &mu;s'),
					 CriticalText   =  REPLACE(CriticalText, 'CommCell Q&I Time Maximum Threshold',cast(@commCellCritical as nvarchar(max) )+' &mu;s')

			END
			ELSE IF (@i_QueryId =156)
			BEGIN
				SET @commCellWarning =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId=@i_CommServUniqueId AND attrName ='DDBPendingDeleteWarningLimit' and attrtype =10),5000)
				SET @commCellCritical =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId=@i_CommServUniqueId AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),10000)
				UPDATE  @TblSurveyResult
				SET 	 GoodText		=  REPLACE(GoodText, 'CommCell SIDB Pending Record Minimum Threshold',cast(@commCellWarning as nvarchar(max))),
						 WarnText		=  REPLACE(WarnText, 'Between minimum and maximum Threshold of CommCell SIDB Pending Record',cast(@commCellWarning as nvarchar(max))  +'-'+  cast(@commCellCritical as nvarchar(max) )),
						 CriticalText   =  REPLACE(CriticalText, 'CommCell SIDB Pending Record Maximum Threshold', cast(@commCellCritical as nvarchar(max) ))

			END
	END
	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptMetricsThresholdInfo]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptMetricsThresholdInfo' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'RptMetricsThresholdInfo',  '1.1.2.5', 'RptMetricsThresholdInfo', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
