

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetSurveyResultsFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetSurveyResultsFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetSurveyResultsFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetSurveyResultsFunc]
  delete from GXDBVersions where name = 'RptGetSurveyResultsFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetSurveyResultsFunc]
	(
		@i_QueryId INT = 0,
		@i_CommServUniqueId INT = 0,
		@b_Latest INT = 1,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEND DATETIME = NULL,
		@i_UserId  		INT = NULL
	)
	RETURNS @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID VARCHAR(32) NOT NULL,
		CommServIP VARCHAR(256) NOT NULL,
		CommServGUID VARCHAR(256) NOT NULL,
		CustomerName NVARCHAR(256) NOT NULL,
		CommServName NVARCHAR(256),
		LogDate DATETIME NOT NULL,
		LogDateUTC DATETIME NOT NULL,
		RunningTime INT NOT NULL,
		CommServTZ VARCHAR(256) NOT NULL,
		CSVersion VARCHAR(256),
		surveyxml XML
	)
	AS
	BEGIN
		--DECLARE @defaultLogDateStart DATETIME = (SELECT MIN(LogDate) FROM cf_CommservSurveyResults WITH (NOLOCK, READUNCOMMITTED) WHERE QueryId = @i_QueryId)
		--DECLARE @defaultLogDateEND DATETIME = (SELECT MAX(LogDate) FROM cf_CommservSurveyResults WITH (NOLOCK, READUNCOMMITTED) WHERE QueryId = @i_QueryId)
		DECLARE @defaultLogDateStart DATETIME = DATEADD(MONTH, -3, GETUTCDATE())
		DECLARE @defaultLogDateEND DATETIME = GETUTCDATE()

		IF (@i_QueryId IS NULL)
			SET @i_QueryId = 0
		IF (@i_CommServUniqueId IS NULL)
			SET @i_CommServUniqueId = 0
		IF (@i_LogDateStart IS NULL)
			SET @i_LogDateStart =@defaultLogDateStart
		IF (@i_LogDateEND IS NULL)
			SET @i_LogDateEND = @defaultLogDateEND

	DECLARE @UserCapability INT = -1
	DECLARE @UserProp xml
	DECLARE @CommcellTbl TABLE (ccid			NVARCHAR(100),	csGUID			NVARCHAR(100))
	 SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId =@i_UserId)
	 IF (@i_UserId=-1 or @UserCapability =1)
	 BEGIN
			 INSERT INTO @CommcellTbl (ccid,csGUID)
			--SELECT CommCellID,CommServGUID FROM cf_CommcellIdNameMap WITH (NOLOCK) WHERE (Flags & 1) <> 1
  				SELECT '' ,''
	END
	ELSE IF  (@i_UserId IS NOT NULL)
	BEGIN
		 SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId =@i_UserId)
		 INSERT INTO @CommcellTbl (ccid,csGUID)
			SELECT commcells.value('@commCellId'			, '[NVARCHAR](MAX)'),
				   commcells.value('@csGUID'				, '[NVARCHAR](MAX)')
			From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
			CROSS apply resp.nodes('commcells') AS commcells(commcells)

	END
	ELSE
	BEGIN
		RETURN
	 END


		IF(@b_Latest = 0)
		IF @i_CommServUniqueId = 0
		INSERT INTO @TblSurveyResult
			SELECT
				result.CommServUniqueId,
				result.CommCellID,
				result.CommServIP,
				result.CommServGUID,
				result.CustomerName,
				result.CommServName,
				result.LogDate,
				result.LogDateUTC,
				result.RunningTime,
				result.CommServTimeZone,
				result.CommServVersion,
				result.CollectedResults
			FROM cf_SurveyResultView AS result WITH (NOLOCK, READUNCOMMITTED)
				INNER JOIN @CommcellTbl tbl ON
				(tbl.ccid='' OR
				 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
				 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))
				 AND --((result.CommServUniqueId = @i_CommServUniqueId) OR (@i_CommServUniqueId = 0)) AND
				(result.LogDateUTC BETWEEN @i_LogDateStart AND  @i_LogDateEND)
				AND result.SurveyID = @i_QueryId
		ELSE
		INSERT INTO @TblSurveyResult
			SELECT
				result.CommServUniqueId,
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				result.LogDate,
				result.LogDateUTC,
				result.RunningTime,
				result.CommServTimeZone,
				result.CommServVersion,
				result.CollectedResults
			FROM cf_SurveyResultView AS result WITH (NOLOCK, READUNCOMMITTED)
				INNER JOIN @CommcellTbl tbl ON
				 (tbl.ccid='' OR
				 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
				 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))
				AND (result.CommServUniqueId = @i_CommServUniqueId)
				AND (result.LogDateUTC BETWEEN @i_LogDateStart AND  @i_LogDateEND)
				AND result.SurveyID = @i_QueryId
		ELSE
		IF @i_CommServUniqueId = 0
		INSERT INTO @TblSurveyResult
			SELECT
				Sub2.CommServUniqueId,
				Sub2.CommCellID,
				Sub2.CommServIP,
				Sub2.CommServGUID,
				Sub2.CustomerName,
				Sub2.CommServName,
				Sub2.LogDate,
				Sub2.LogDateUTC,
				Sub2.RunningTime,
				Sub2.CommServTimeZone,
				Sub2.CommServVersion,
				Sub2.CollectedResults
			FROM
			(
					(SELECT
						CommServUniqueId,
						SurveyID,
						SurverResultId,
						LogDate,
						LogDateUTC,
						ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, SurveyID ORDER BY CommServUniqueId, LogDateUTC DESC) AS RowId
					FROM cf_SurveyResultView result WITH (NOLOCK, READUNCOMMITTED)
						INNER JOIN @CommcellTbl tbl ON
					 (tbl.ccid='' OR
					 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
					 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))) AS Sub1
					INNER JOIN cf_SurveyResultView AS Sub2 WITH (NOLOCK, READUNCOMMITTED)
						ON Sub1.RowId = 1
						AND Sub1.CommServUniqueId = Sub2.CommServUniqueId
						AND Sub1.SurverResultId = Sub2.SurverResultId
						AND Sub1.SurveyID = Sub2.SurveyID
						--AND ((Sub2.CommServUniqueId = @i_CommServUniqueId) OR (@i_CommServUniqueId = 0))
						AND Sub2.SurveyID = @i_QueryId
			)
		 ELSE
		 INSERT INTO @TblSurveyResult
			SELECT
				Sub2.CommServUniqueId,
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				Sub2.LogDate,
				Sub2.LogDateUTC,
				Sub2.RunningTime,
				Sub2.CommServTimeZone,
				Sub2.CommServVersion,
				Sub2.CollectedResults
			FROM
			(
					(SELECT
						CommServUniqueId,
						SurveyID,
						SurverResultId,
						LogDate,
						LogDateUTC,
						ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, SurveyID ORDER BY CommServUniqueId, LogDateUTC DESC) AS RowId
					FROM cf_SurveyResultView result WITH (NOLOCK, READUNCOMMITTED)
						INNER JOIN @CommcellTbl tbl ON
					 (tbl.ccid='' OR
					 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
					 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))) AS Sub1
					INNER JOIN cf_SurveyResultView AS Sub2 WITH (NOLOCK, READUNCOMMITTED)
						ON Sub1.RowId = 1
						AND Sub1.CommServUniqueId = Sub2.CommServUniqueId
						AND Sub1.SurverResultId = Sub2.SurverResultId
						AND Sub1.SurveyID = Sub2.SurveyID
						AND Sub2.CommServUniqueId = @i_CommServUniqueId
						AND Sub2.SurveyID = @i_QueryId
			)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetSurveyResultsFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetSurveyResultsFunc' AND revision = '1.5')

  insert into GXDBVersions values(5, 'RptGetSurveyResultsFunc',  '1.5', 'RptGetSurveyResultsFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
