

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetServerHealthFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: RptGetServerHealthFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetServerHealthFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetServerHealthFunc]
  delete from GXDBVersions where name = 'RptGetServerHealthFunc' and type = 5
END
GO

    SET QUOTED_IDENTIFIER ON
    GO
	CREATE FUNCTION [dbo].[RptGetServerHealthFunc]
	(
		@i_CommServUniqueId INT = 0,
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL,
		@i_IsLocal INT = 0
	)
	RETURNS @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		GroupId INTEGER NOT NULL,
		GroupName NVARCHAR(MAX) NOT NULL,
		MonitorId INTEGER NOT NULL,
		Monitor NVARCHAR(MAX) NOT NULL,
		Status VARCHAR(10) NOT NULL,
		LogDate DATETIME,
		Result NVARCHAR(MAX),
		ExpectedResult NVARCHAR(MAX),
		Recommendation NVARCHAR(MAX),
		GroupSortOrder INT,
		MonitorSortOrder INT,
		ParamId INT
	)
	AS
	BEGIN

		DECLARE @strGood		VARCHAR(10) = '1_Good'
		DECLARE @strInfo		VARCHAR(10) = '2_Info'
		DECLARE @strwarning		VARCHAR(10) = '3_Warning'
		DECLARE @strCritical	VARCHAR(10) = '4_Critical'
		DECLARE @strUnknown		VARCHAR(10) = '0_Unknown'
		DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
		DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1

		--Set Deafult to Backup Job Statistics
		DECLARE @queryId			INT = 16
		DECLARE @parameterName		NVARCHAR(256)
		DECLARE @warningThreshold	INT
		DECLARE @criticalThreshold	INT
		DECLARE @infoMessage		NVARCHAR(MAX)
		DECLARE @goodMessage		NVARCHAR(MAX)
		DECLARE @warningMessage		NVARCHAR(MAX)
		DECLARE @criticalMessage	NVARCHAR(MAX)

		DECLARE @showHiddenLibraries INT = 0
		IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
			SET @showHiddenLibraries = 1

		IF (@i_CommServUniqueId IS NULL OR @i_CommServUniqueId = 0)
			RETURN
		IF NOT EXISTS (SELECT * FROM dbo.cf_SurveyResultFuncV1(16, @i_CommServUniqueId, 1, NULL, NULL,@i_UserId,@i_GroupId) )
			RETURN

		DECLARE @CommServVersion VARCHAR(256) = ''
		SELECT  @CommServVersion = ISNULL(CommServVersion, '') FROM cf_CommCellIdNameMap WITH (NOLOCK) WHERE ID = @i_CommServUniqueId

		INSERT INTO @TblSurveyResult
				SELECT	@i_CommServUniqueId, sGroup.SurveyGroupId, sGroup.Name, survey.QueryId, CASE WHEN LEN(map.ParameterName) > 0 THEN map.ParameterName ELSE survey.Name END, @strUnknown, '', '', '', '' , sGroup.SortOrder, map.SurveySortOrder, 0
		FROM	cf_CommservSurveyQueries AS survey
				INNER JOIN dbo.RptGetMetricsQueryFlags(0) qflags ON survey.QueryId = qFlags.QueryId
				INNER JOIN cf_CommservSurveyGroupMap AS map
					ON map.SurveyId = survey.QueryId
					AND qflags.QueryFlags & 4 = 4
					AND (map.GroupId <> 15 OR (map.GroupId = 15 AND map.SurveyId = 171)) --Pick up only one row for value assessment
				INNER JOIN cf_CommservSurveyGroups as sGroup
					ON sGroup.SurveyGroupId = map.GroupId
		WHERE	survey.QueryId NOT IN (211,212) OR @CommServVersion NOT LIKE '9%' AND @CommServVersion NOT IN ('10', '10 SP1', '10 SP2', '10 SP3', '10 SP4', '10 SP5', '10 SP6')

		IF @i_IsLocal <> 0
			DELETE FROM @TblSurveyResult where MonitorId in (12, 31) -- Skip Comcell version and DR tiles for local commcell

		DECLARE @TblLatestResult TABLE (QueryId INT, SurveyResultId INT, LogDate DATETIME, LogDateUTC DATETIME)

		INSERT	INTO @TblLatestResult
		SELECT	DISTINCT R.QueryId, R.CommservSurveyResults_ID, R.LogDate, R.LogDateUTC
		FROM	cf_CommservSurveyResults R WITH (NOLOCK)
				INNER JOIN @TblSurveyResult S ON R.QueryId = S.MonitorId
		WHERE	R.CommcellIdNameMap_ID = @i_CommServUniqueId AND R.Flags = 1

		--If NO health check done - return
		IF NOT EXISTS (SELECT * FROM @TblLatestResult WHERE QueryID = @queryId)
		BEGIN
			DELETE FROM @TblSurveyResult
			RETURN
		END

		DECLARE @param_isPrivate INT = 0
		SELECT  @param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'

		IF (@param_isPrivate = 1) OR (@CommServVersion LIKE '9%') OR (@CommServVersion LIKE '10%') --Proactive Support status is not supported
			DELETE FROM @TblSurveyResult WHERE MonitorId = 2


		DECLARE @tmpStatus VARCHAR(10) = @strInfo
		DECLARE @tmpLogDate VARCHAR(20)
		DECLARE @tmpResult NVARCHAR(MAX) = ''
		DECLARE @tmpRecommendation NVARCHAR(MAX) = ''

		--Set LogDate by deafult to Backup Job Statistics date
		SELECT	@tmpLogDate = csInfo.LogDate
		FROM	cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = @queryId


		DECLARE @jobCount INTEGER = 0
		DECLARE @totSCs INT = 0
		DECLARE @SCsWithLongJobs INT = 0
		DECLARE @SCsWithLongJobsPercent DECIMAL(32,2) = 0
		DECLARE	HealthQueryCur CURSOR FOR
		SELECT	QueryId,
				ParameterName,
				WarningThreshold,
				CriticalThreshold,
				InfoMessage,
				GoodMessage,
				WarningMessage,
				CriticalMessage
		FROM	cf_ReportParameterView where ParamId < 700	-- Excluding scale statistics sub params from 700 to 714
			AND	(QueryId NOT IN (211,212) OR @CommServVersion NOT LIKE '9%' AND @CommServVersion NOT IN ('10', '10 SP1', '10 SP2', '10 SP3', '10 SP4', '10 SP5', '10 SP6'))

		OPEN HealthQueryCur

		FETCH NEXT FROM HealthQueryCur
		INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

		WHILE @@FETCH_STATUS <> -1
		BEGIN
			SET @tmpStatus = @strInfo
			SET @tmpResult = ''
			SET @tmpRecommendation = @infoMessage

			--Proactive Support
			IF @queryId = 2 AND @param_isPrivate = 0 --Only for public
			BEGIN
				DECLARE @apssSupport INT = 0
				SELECT @apssSupport = CASE WHEN CommCellSurveyServices & 128 = 128 THEN 1 ELSE 0 END FROM cf_CommcellIdNameMap WITH (NOLOCK) WHERE ID = @i_CommServUniqueId

				IF @apssSupport = 1
				BEGIN
					SET @tmpResult = 'CommCell is subscribed for Proactive Support.'
				END
				ELSE
				BEGIN
					SET @tmpResult = 'CommCell is not subscribed for Proactive Support.'
				END
			END

      --Simpana Service Pack Stats
      IF @queryId = 12 AND @i_IsLocal = 0
      BEGIN
		DECLARE @warningSPForServers INT = @warningThreshold, @criticalSPForServers INT = @criticalThreshold
		DECLARE @warningSPForMA INT = 1, @criticalSPForMA INT = 2
		DECLARE @warningUPThreshold INT = 6, @criticalUPThreshold INT = 12

		DECLARE @CSVersionStr NVARCHAR(20), @CSVersion INT, @CSServicePack INT
		SELECT @CSVersionStr = C.ServicePack FROM cf_SurveyClient C WHERE C.CommServUniqueId = @i_CommServUniqueId AND C.ClientId = 2
		DECLARE @CSNeedUpdate INT = 0, @ServerNeedUpdate INT = 0, @LaptopNeedUpdate INT = 0, @MANeedUpdate INT = 0, @TotalClientNeedsUpdate INT = 0

		-- SP6 and below do not upload data to query 239 due to missing stored procedure
		IF EXISTS(SELECT * FROM cf_SurveyVersionAndServicePack WHERE CommServUniqueId = @i_CommServUniqueId AND ClientType = 1)
		BEGIN
			DECLARE @VersionAndServicePackTable TABLE(ClientId INT, CType INT, VersionInt INT, ServicePack INT, LatestServicePack INT, UPNumber INT, LatestUPNumber INT, StatusInt INT DEFAULT 2)

			INSERT INTO @VersionAndServicePackTable(ClientId, CType, VersionInt, ServicePack, LatestServicePack, UPNumber, LatestUPNumber)
			SELECT T.ClientId, T.ClientType, T.Version, T.ServicePack,
				(CASE
					WHEN T.Version = 11 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '11_0_LatestSPMajorNo' )
					WHEN T.Version = 10 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '10_0_LatestSPMajorNo' )
					WHEN T.Version = 9 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '9_0_LatestSPMajorNo' )
					ELSE 0
				END),
				ISNULL(C.UPNumber, 0),
				ISNULL(R.LatestAvailableUPNumber, 0)
			FROM cf_SurveyVersionAndServicePack T
			INNER JOIN cf_SurveyClient C
				ON C.CommServUniqueId = T.CommServUniqueId
				AND C.ClientId = T.ClientId
			LEFT OUTER JOIN cf_ReleaseUpdatePackInfo R
				ON (R.ReleaseId - 5) = T.Version
				AND R.ServicePack = T.ServicePack
			WHERE T.CommservUniqueId = @i_CommServUniqueId AND C.UninstallTime IS NULL

			SELECT @CSVersion = VersionInt, @CSServicePack = ServicePack FROM @VersionAndServicePackTable T WHERE T.CType = 1

			--CS
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < 11)
					THEN 4 --Release is not supported. Critical
				WHEN (LatestServicePack - A.ServicePack) > @criticalSPForServers
					THEN 4	--SP is not supported. Critical
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - A.UPNumber > @criticalUPThreshold))
					THEN 4	--V11 SP14 and above - Hotfix Pack not supported. Critical
				WHEN ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND LEN(B.MissingUpdates) > 0)
					THEN 4	--V11 SP13 and below. Missing updates. Critical
				WHEN (LatestServicePack - A.ServicePack) >= @warningSPForServers AND (LatestServicePack - A.ServicePack) <= @criticalSPForServers
					THEN 3  --Little bit older SP. Warning
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - A.UPNumber > @warningUPThreshold) AND (LatestUPNumber - A.UPNumber <= @criticalUPThreshold))
					THEN 3	--V11 SP14 and above - Little bit older Hotfix Pack. Warning
				ELSE 2  --All good
			END)
			FROM @VersionAndServicePackTable A INNER JOIN cf_SurveyVersionAndServicePack B ON B.CommServUniqueId = @i_CommServUniqueId AND B.ClientId = A.ClientId
			WHERE CType = 1

			--Server
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < @CSVersion)
					THEN 4 --Release is not supported. Critical
				WHEN (@CSServicePack - A.ServicePack) > @criticalSPForServers
					THEN 4	--SP is not supported. Critical
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - A.UPNumber > @criticalUPThreshold))
					THEN 4	--V11 SP14 and above - Hotfix Pack not supported. Critical
				WHEN ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND LEN(MissingUpdates) > 0)
					THEN 4	--V11 SP13 and below. Missing updates. Critical
				WHEN (@CSServicePack - A.ServicePack) >= @warningSPForServers AND (@CSServicePack - A.ServicePack) <= @criticalSPForServers
					THEN 3  --Little bit older SP. Warning
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - A.UPNumber > @warningUPThreshold) AND (LatestUPNumber - A.UPNumber <= @criticalUPThreshold))
					THEN 3	--V11 SP14 and above - Little bit older Hotfix Pack. Warning
				ELSE 2  --All good
			END)
			FROM @VersionAndServicePackTable A INNER JOIN cf_SurveyVersionAndServicePack B ON B.CommServUniqueId = @i_CommServUniqueId AND B.ClientId = A.ClientId
			WHERE CType = 4

			--MA
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < @CSVersion)
					THEN 4 --Release is not supported. Critical
				WHEN (@CSServicePack - A.ServicePack) > @criticalSPForMA
					THEN 4	--SP is not supported. Critical
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - A.UPNumber > @criticalUPThreshold))
					THEN 4	--V11 SP14 and above - Hotfix Pack not supported. Critical
				WHEN ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND LEN(MissingUpdates) > 0)
					THEN 4	--V11 SP13 and below. Missing updates. Critical
				WHEN (@CSServicePack - A.ServicePack) >= @warningSPForMA AND (@CSServicePack - A.ServicePack) <= @criticalSPForMA
					THEN 3  --Little bit older SP. Warning
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - A.UPNumber > @warningUPThreshold) AND (LatestUPNumber - A.UPNumber <= @criticalUPThreshold))
					THEN 3	--V11 SP14 and above - Little bit older Hotfix Pack. Warning
				ELSE 2 --All good
			END)
			FROM @VersionAndServicePackTable A INNER JOIN cf_SurveyVersionAndServicePack B ON B.CommServUniqueId = @i_CommServUniqueId AND B.ClientId = A.ClientId
			WHERE CType = 3

			--Laptops critical when 4 service packs behind CS
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < @CSVersion AND ServicePack < LatestServicePack)
					THEN 4 --SP is not supported. Critical
				WHEN VersionInt = @CSVersion AND (@CSServicePack - ServicePack) > @criticalSPForServers
					THEN 4	--SP is not supported. Critical
				ELSE 2 --All good
			END)
			FROM @VersionAndServicePackTable A
			WHERE CType = 2

			SELECT
				@CSNeedUpdate = SUM(CASE WHEN CType = 1 THEN 1 ELSE 0 END),
				@LaptopNeedUpdate = SUM(CASE WHEN CType = 2 THEN 1 ELSE 0 END),
				@MANeedUpdate = SUM(CASE WHEN CType = 3 THEN 1 ELSE 0 END),
				@ServerNeedUpdate = SUM(CASE WHEN CType = 4 THEN 1 ELSE 0 END)
			FROM @VersionAndServicePackTable V WHERE V.StatusInt IN (3, 4)
			SET @TotalClientNeedsUpdate = @CSNeedUpdate + @ServerNeedUpdate + @LaptopNeedUpdate + @MANeedUpdate

			SELECT @tmpStatus = CASE MAX(StatusInt) WHEN 4 THEN @strCritical WHEN 3 THEN @strwarning ELSE @strGood END FROM @VersionAndServicePackTable

			SET @tmpRecommendation = CASE WHEN @tmpStatus IN (@strCritical, @strwarning) THEN 'View detailed report and install necessary updates.<BR/>' ELSE @goodMessage END
			SET @tmpRecommendation = @tmpRecommendation + '<VDL><VDL_CR>VersionAndServicePackMetrics&input.CommservUniqueId='+ CAST(@i_CommservUniqueId AS NVARCHAR(10)) + '</VDL_CR>'

		END
		ELSE --Simpana Service Pack Stats Old Code
		BEGIN
			DECLARE @CSVersionStrTmp NVARCHAR(20), @LatestSP  INT

			SELECT @CSNeedUpdate = Total FROM cf_SurveyUpdateStatus AS csInfo WITH(NOLOCK) INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId AND result.QueryID = @queryId AND ClientTypeId = 0
			SELECT @ServerNeedUpdate = Total FROM cf_SurveyUpdateStatus AS csInfo WITH(NOLOCK) INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId AND result.QueryID = @queryId AND ClientTypeId = 1
			SELECT @LaptopNeedUpdate = Total FROM cf_SurveyUpdateStatus AS csInfo WITH(NOLOCK) INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId AND result.QueryID = @queryId AND ClientTypeId = 2
			SELECT @MANeedUpdate = Total FROM cf_SurveyUpdateStatus AS csInfo WITH(NOLOCK) INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId AND result.QueryID = @queryId AND ClientTypeId = 4
			SET @TotalClientNeedsUpdate = @CSNeedUpdate + @ServerNeedUpdate + @LaptopNeedUpdate + @MANeedUpdate

			--Strip down Version and SP from @CSVersionStr
			SET @CSVersionStrTmp = REPLACE(LTRIM(@CSVersionStr), '.', ' ')		--Change 9.0 to 9 0	ans save in temp variable
			SET @CSVersionStrTmp = REPLACE(@CSVersionStrTmp, '-', '')			--Remove - from V11 SP14-
			SET @CSVersionStrTmp = REPLACE(@CSVersionStrTmp, '+', '')			--Remove + from V11 SP14+
			IF CHARINDEX('HPK', @CSVersionStrTmp) > 0							--Remove HPK* from V11 SP14 HPK2
				SET @CSVersionStrTmp = LEFT(@CSVersionStrTmp, CHARINDEX('HPK', @CSVersionStrTmp)-1)
			IF CHARINDEX(' ', @CSVersionStrTmp) > 0								--Get CS Version
				SET @CSVersion = LEFT(@CSVersionStrTmp, CHARINDEX(' ', @CSVersionStrTmp) - 1)
			ELSE
				SET @CSVersion = @CSVersionStrTmp
			IF CHARINDEX('SP', @CSVersionStrTmp) > 0							--Get CS SP
				SET @CSVersionStrTmp = SUBSTRING(@CSVersionStrTmp, CHARINDEX('SP', @CSVersionStrTmp)+2, LEN(@CSVersionStrTmp))
			ELSE
				SET @CSVersionStrTmp = '0'
			IF ISNUMERIC(RIGHT(@CSVersionStrTmp, 1)) = 1						--Check if 9.0 SP10a. remove minor sp letter
				SET @CSServicePack = @CSVersionStrTmp
			ELSE
				SET @CSServicePack = SUBSTRING(@CSVersionStrTmp, 1, LEN(@CSVersionStrTmp)-1)

			IF @CSVersion = 9
				SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '9_0_LatestSPMajorNo'
			ELSE IF @CSVersion = 10
				SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '10_0_LatestSPMajorNo'
			ELSE IF @CSVersion = 11
				SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '11_0_LatestSPMajorNo'

			SET @tmpStatus =
			CASE
				WHEN (@LatestSP - @CSServicePack) > @criticalSPForServers or @TotalClientNeedsUpdate > 0 THEN @strCritical
				WHEN (@LatestSP - @CSServicePack) >= @warningSPForServers AND (@LatestSP - @CSServicePack) <= @criticalSPForServers THEN @strWarning
				ELSE @strGood
			END

			SET @tmpRecommendation =
			CASE
				WHEN (@LatestSP - @CSServicePack) > @criticalSPForServers THEN 'Lags behind by <b>' + CAST((@LatestSP - @CSServicePack) AS VARCHAR(2)) + '</b> Feature Releases. ' + @warningMessage
				WHEN @TotalClientNeedsUpdate > 0 THEN @criticalMessage
				WHEN ((@LatestSP - @CSServicePack) >= @warningSPForServers) AND (@LatestSP - @CSServicePack) <= @criticalSPForServers THEN 'Lags behind by <b>' + CAST((@LatestSP - @CSServicePack) AS VARCHAR(2)) + '</b> Feature Releases. ' + @warningMessage
				ELSE @goodMessage
			END
		END

		SET	@tmpResult = 'CommServe is currently on <b>V' + @CSVersionStr + '</b>.<DELIM>'
		IF (@TotalClientNeedsUpdate > 0)
		BEGIN
			SET	@tmpResult += 'Entities that need updates : '
			IF (@CSNeedUpdate > 0)
				SET	@tmpResult += 'CommServe, '
			SET	@tmpResult += 'Servers <b>' + CAST(@ServerNeedUpdate AS VARCHAR(10)) + '</b>, '
			SET	@tmpResult += 'Laptops <b>' + CAST(@LaptopNeedUpdate AS VARCHAR(10)) + '</b>, '
			SET	@tmpResult += 'MediaAgents <b>' + CAST(@MANeedUpdate AS VARCHAR(10)) + '</b>'
		END

		SELECT	@tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
		FROM	cf_SurveyUpdateInfo AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = @queryId
      END
			--DeDup Store Config for Media Agent
			ELSE IF @queryId = 61
			BEGIN
				declare @totalMANum int = 0
				declare @MAStoreConfigResults table
				(
					MediaAgentId int,
					LogDate dateTime,
					ValidSIDBCount int,
					Status int
				)
				INSERT INTO @MAStoreConfigResults
				SELECT
					sub.MediaAgentId,
					sub.LogDate,
					SUM(sub.IsValid),
					CASE
						WHEN SUM(sub.IsValid) > @criticalThreshold THEN 3
						WHEN SUM(sub.IsValid) >= @warningThreshold and SUM(sub.IsValid) <= @criticalThreshold THEN 2
						ELSE 1
					END
				FROM
				(
				SELECT
					csInfo.MediaAgentId,
					csInfo.LogDate,
					CASE
						WHEN csInfo.SealedStatus = 'Active' OR (csInfo.SIDBStoreStatus <> 1 AND csInfo.TotalRecords >= 100000000) THEN 1
						ELSE 0
					END AS 'IsValid'
				FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND	csInfo.MediaAgentId > 1
				) AS sub
				GROUP BY sub.MediaAgentId, sub.LogDate
				select @totalMANum = ISNULL(COUNT(*), 0) from @MAStoreConfigResults
				select @tmpLogDate = ISNULL(MAX(LogDate), @tmpLogDate) from @MAStoreConfigResults
				SET @tmpStatus = @strInfo
				IF (@totalMANum > 0)
					BEGIN
						SET @tmpResult = 'MediaAgent(s) with DDB Partitions: <b>'+ CAST(@totalMANum AS NVARCHAR(5)) + '</b>'
						SET @tmpRecommendation = @goodMessage
					END
				ELSE
				BEGIN
					SET @tmpResult =  'There are no MediaAgents hosting Deduplication Database.<DELIM>'
					SET @tmpRecommendation = @infoMessage
				END
			END
			--BkpJobStatistics
			ELSE IF @queryId = 16
			BEGIN
				SELECT
					@tmpStatus =
						CASE
							WHEN sub.TotalJobs = 0 OR sub.SuccessRatePercent >= @warningThreshold THEN @strGood
							WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @strwarning
							ELSE @strCritical
						END,
					@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
					@tmpResult = 'Success Rate : <b>' + CASE WHEN sub.TotalJobs = 0 THEN 'N/A' ELSE CAST(sub.SuccessRatePercent AS NVARCHAR(MAX)) + ' %' END
						+ ' </b><DELIM>Total : <b>' + CAST(sub.TotalJobs AS NVARCHAR(100))
						+ '</b>, Successful : <b>' + CAST(sub.SuccessfulJobs AS NVARCHAR(100))
                        			+ '</b>, Failed : <b>' + CAST(sub.FailedJobs AS NVARCHAR(100))
                        			+ '</b>, Killed : <b>' + CAST(sub.KilledJobs AS NVARCHAR(100))
						+ '</b><DELIM>Completed with Errors : <b>' + CAST(sub.CompletedWithErrorJobs AS NVARCHAR(20))
						+ '</b>, Completed with Warning : <b>' + CAST(sub.CompletedWithWarningJobs AS NVARCHAR(20)) + '</b><DELIM>',
					@tmpRecommendation =
						CASE
							WHEN sub.TotalJobs = 0 OR sub.SuccessRatePercent >= @warningThreshold THEN @goodMessage
							WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @warningMessage
							ELSE @criticalMessage
						END
				FROM
				(
					SELECT
						csInfo.CommServUniqueId,
						csInfo.LogDate,
						csInfo.ClientGroups,
						csInfo.TotalJobs,
						csInfo.SuccessfulJobs,
						ISNULL(csInfo.CompletedWithErrorJobs, 0) AS CompletedWithErrorJobs,
						ISNULL(csInfo.CompletedWithWarningJobs, 0) AS CompletedWithWarningJobs,
						ISNULL(csInfo.FailedJobs, 0) FailedJobs,
						ISNULL(csInfo.KilledJobs, 0) AS KilledJobs,
						CASE
                            			WHEN csInfo.TotalJobs - ISNULL(csInfo.KilledJobs, 0) = 0 THEN 0
                            			ELSE CAST(((ISNULL(csInfo.CompletedWithErrorJobs, 0) + ISNULL(csInfo.CompletedWithWarningJobs, 0)+ ISNULL(csInfo.SuccessfulJobs, 0)) * 100.0)/(csInfo.TotalJobs - ISNULL(csInfo.KilledJobs, 0)) AS DECIMAL(7, 0))
						END AS SuccessRatePercent
					FROM cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				) AS sub
			END
			--Fallen Behind Storage policy copies
			ELSE IF @queryId = 64
			BEGIN
				declare @criticalCopyNum int = 0
				declare @warningCopyNum int = 0
				declare @totalCopyNum int = 0

				declare @dashCoppySummary table
				(
					spName nvarchar(255),
					copyName nvarchar(255),
					FallenBehindDays int,
					ToBeCopiedAppSizeGB bigint,
					AuxCopyAlertDays int,
					AuxCopyAlertGB bigint
				)

				INSERT INTO @dashCoppySummary
				SELECT 	C.PolicyName,
						C.CopyName,
						csInfo.FallenBehindDays,
						ISNULL(csInfo.TotalToBeCopiedJobsApplicationSizeGB, 0),
						ISNULL(csInfo.AuxCopyAlertDays, -1),
						ISNULL(csInfo.AuxCopyAlertGB, -1)
				FROM	cf_SurveyFallenBehindCopies AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
						INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK)
							ON C.CommServUniqueId = @i_CommServUniqueId AND C.CopyId = csInfo.CopyId

				SET @warningCopyNum = (SELECT COUNT(copyName) FROM @dashCoppySummary
					WHERE	(AuxCopyAlertGB <= 0 OR ToBeCopiedAppSizeGB <= AuxCopyAlertGB)
						AND (AuxCopyAlertDays <= 0 OR FallenBehindDays <= AuxCopyAlertDays)
						AND FallenBehindDays >= @warningThreshold AND FallenBehindDays <= @criticalThreshold)
				SET @criticalCopyNum =(SELECT COUNT(copyName) FROM @dashCoppySummary
					WHERE	AuxCopyAlertGB > 0 AND ToBeCopiedAppSizeGB > AuxCopyAlertGB
						 OR AuxCopyAlertDays > 0 AND FallenBehindDays > AuxCopyAlertDays
						 OR AuxCopyAlertDays < 0 AND FallenBehindDays > @criticalThreshold)
				SET @totalCopyNum = (SELECT COUNT(copyName) FROM @dashCoppySummary)

				SET @tmpStatus =
					CASE
						WHEN @criticalCopyNum > 0 THEN @strCritical
						WHEN @warningCopyNum > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalCopyNum > 0)
					BEGIN
						SET @tmpResult = 'Secondary Copies: <DELIM>'
						SET @tmpResult += 'Total: <B>'+ CAST(@totalCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good: <B>' + CAST((@totalCopyNum-@warningCopyNum-@criticalCopyNum) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning: <B>' + CAST(@warningCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical: <B>' + CAST(@criticalCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'There are no Fallen Behind Secondary Copies.<DELIM>'

				SET @tmpRecommendation =
					CASE
						WHEN @totalCopyNum = 0 THEN @infoMessage
						WHEN @totalCopyNum > 0 AND @criticalCopyNum = 0 AND @warningCopyNum = 0 THEN  @goodMessage
						ELSE @warningMessage
					END
			END
			--DDB Performance
			ELSE IF @queryId = 65
			BEGIN
				declare @criticalNum int = 0
				declare @warningNum int = 0
				declare @goodNum int = 0
				declare @totalNum int = 0

				declare @qiTime table
				(
					SidbStoreId int,
					AvgQITime	bigint,
					PrimaryRecords	bigint
				)

				INSERT INTO @qiTime
				SELECT	csInfo.SidbStoreId,
						csInfo.AvgQITime,
						csInfo.PrimaryRecords
				FROM	cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @criticalThreshold =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 and attrName ='AvgQITimeCriticalLimit' AND CommServUniqueId=@i_CommServUniqueId AND attrtype =10),@criticalThreshold)
				SET @warningThreshold =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 and attrName ='AvgQITimeWarningLimit' AND CommServUniqueId=@i_CommServUniqueId AND attrtype =10),@warningThreshold)
				SET @goodNum    = (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime < @warningThreshold  OR  PrimaryRecords < 100000000)
				SET @criticalNum= (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime > @criticalThreshold AND PrimaryRecords > 400000000)
				SET @totalNum	= (SELECT COUNT(SidbStoreId) FROM @qiTime)
				SET @warningNum	= (@totalNum - @goodNum - @criticalNum)

				SET @tmpStatus = CASE
					WHEN @totalNum = 0 THEN @strInfo
					WHEN @criticalNum > 0 THEN @strCritical
					WHEN @warningNum > 0 THEN @strwarning
					ELSE @strGood END

				IF (@totalNum > 0)
				BEGIN
					SET @tmpResult = 'DDBs: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@totalNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST(@goodNum  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>'  + CAST(@warningNum  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@criticalNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
					SET @tmpResult =  'There are no Media Agents hosting DDB store.<DELIM>'

				SET @tmpRecommendation = CASE
					WHEN @totalNum = 0 THEN @infoMessage
					WHEN @totalNum > 0 AND @criticalNum = 0 AND @warningNum = 0 THEN @goodMessage
					ELSE @warningMessage END
			END
			--Low Disk Space
			ELSE IF @queryId = 70
			BEGIN
				declare @criticalCopies int = 0
				declare @warningCopies int = 0
				declare @totalNCopies int = 0

				declare @copiesSize table
				(
					copyId int,
					percentFree decimal(10,2)
				)

				INSERT INTO @copiesSize
				SELECT	csInfo.CopyId,
						case when csInfo.CapacityMB > 0 THEN cast ((csInfo.FreeSpaceMB *100.0 / csInfo.CapacityMB ) AS decimal(10,2)) else '0' END AS percentFree
				FROM	cf_SurveyCopyFreeSpace AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @warningCopies	= (select COUNT(CopyId) FROM @copiesSize where percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
				SET @criticalCopies = (select COUNT(CopyId) FROM @copiesSize where percentFree < @criticalThreshold)
				SET @totalNCopies	= (select COUNT(CopyId) FROM @copiesSize)

				SET @tmpStatus = CASE
					WHEN @criticalCopies > 0 THEN @strCritical
					WHEN @warningCopies > 0 THEN @strwarning
					ELSE @strGood END

				IF (@totalNCopies > 0)
				BEGIN
					SET @tmpResult = 'Storage Policy Copies: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@totalNCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST((@totalNCopies-@warningCopies-@criticalCopies) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>' + CAST(@warningCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@criticalCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
					SET @tmpResult =  'All Copies have sufficient space.<DELIM>'

				SET @tmpRecommendation = CASE
					WHEN @totalNCopies = 0 THEN @infoMessage
					WHEN @totalNCopies > 0 AND @criticalCopies = 0 AND @warningCopies = 0 THEN @goodMessage
					ELSE @warningMessage END
			END
			--RestoreStatistics
			ELSE IF @queryId = 17
			BEGIN
				SELECT 	@tmpStatus =
							CASE
								WHEN sub.TotalRestoreClients = 0 OR sub.TotalSuccPct > @warningThreshold THEN @strGood --No Restores Jobs or All Restore Jobs success
								WHEN sub.TotalSuccPct >= @criticalThreshold THEN @strwarning
								ELSE @strCritical
							END,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = 'Client Count with Restore jobs : '
							+ CASE WHEN sub.TotalRestoreClients = 0 THEN 'None' ELSE '<DELIM>Successful : <b>'
							+ CAST(SuccessfulClients AS VARCHAR(7)) + '(' + CAST(sub.SuccessPct AS VARCHAR(7))
							+ '%)</b>, Successful after failed jobs : <b>'
							+ CAST(sub.SuccAfterFailClients AS VARCHAR(7)) + '(' + CAST(sub.SuccAfterFailPct AS VARCHAR(7))
							+ '%)</b>, <DELIM>Failed or Killed : <b>'
							+ CAST(sub.FailedClients AS VARCHAR(7)) + '(' + CAST(sub.FailurePct AS VARCHAR(7)) + '%)</b>' END,
						@tmpRecommendation =
							CASE WHEN sub.TotalRestoreClients = 0 THEN @infoMessage + '<VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
								WHEN sub.TotalSuccPct >= @warningThreshold THEN @goodMessage + '<VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
								WHEN sub.TotalSuccPct >= @criticalThreshold THEN @warningMessage + '<VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
								ELSE @criticalMessage + ' <VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
							END
				FROM	(SELECT
											 TotalRestoreClients,
											SuccessfulClients,
											CASE WHEN TotalRestoreClients>0
											THEN (100*SuccessfulClients)/TotalRestoreClients ELSE 0 END AS SuccessPct,
											SuccAfterFailClients,
											CASE WHEN TotalRestoreClients>0
											THEN (100*SuccAfterFailClients)/TotalRestoreClients ELSE 0 END AS SuccAfterFailPct,
											CASE WHEN TotalRestoreClients>0
											THEN 100*(SuccessfulClients + SuccAfterFailClients)/TotalRestoreClients ELSE 0 END AS TotalSuccPct,
											FailedClients,
											CASE WHEN TotalRestoreClients>0
											THEN (100*FailedClients)/TotalRestoreClients ELSE 0 END  AS FailurePct,
											LogDate
										FROM
										(
											SELECT (SuccessfulClients + SuccAfterFailClients + FailedClients) AS TotalRestoreClients,
											SuccessfulClients,
											SuccAfterFailClients,
											FailedClients,
											LogDate
											FROM cf_SurveyRestoreClientStats AS csInfo WITH (NOLOCK)
											INNER JOIN @TblLatestResult AS result
											ON result.SurveyResultId = csInfo.SurveyResultId
											AND result.QueryID = @queryId
										) SUB
						) AS sub

			END
			--Unsupported Clients
			ELSE IF @queryId = 18
			BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'None<DELIM>'
				SET @tmpRecommendation = @infoMessage

				SELECT 	@tmpStatus = CASE WHEN sub.ClientCount <= @warningThreshold THEN @strGood ELSE @strCritical END,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = 'There are <b>' + CAST(sub.ClientCount AS NVARCHAR(100)) + '</b> older clients.<DELIM>',
						@tmpRecommendation = CASE WHEN sub.ClientCount <= @warningThreshold THEN @goodMessage ELSE @criticalMessage END
				FROM	(SELECT csInfo.CommServUniqueId,
								csInfo.LogDate,
								COUNT(csInfo.ClientId) AS ClientCount
						FROM	cf_SurveyUnsupportedClientInfo AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
						) AS sub
			END
			--ClientsWithoutStoragePolicy
			ELSE IF @queryId = 20
			BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'None<DELIM>'
				SET @tmpRecommendation = @infoMessage

				SELECT 	@tmpStatus = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN @strWarning ELSE @strGood END,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = CASE
							WHEN sub.ClientsWithoutSP > 0 THEN '<b>' +
								CAST(sub.SubclientCount AS NVARCHAR(100)) + '</b> Subclient(s) from <b>'
								+ CAST(sub.ClientsWithoutSP AS NVARCHAR(100)) + '</b> Client(s) ' +
								+ ' <b>(' + CAST(sub.ClientsWithoutSPPercent AS NVARCHAR(100)) + '%)</b> are not associated with Storage Policy.'
							ELSE 'All Subclients are associated with Storage Policy.<DELIM>' END,
						@tmpRecommendation = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN @warningMessage ELSE @goodMessage END
				FROM	(SELECT TOP 1
								csInfo.CommServUniqueId,
								csInfo.LogDate,
								csInfo.ClientGroups,
								csInfo.ClientsWithoutSP,
								csInfo.ClientsWithoutSPPercent,
								csInfo.TotalClients,
								COUNT(csInfo.Subclient) AS 'SubclientCount'
						FROM	cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId,
								csInfo.LogDate,
								csInfo.ClientGroups,
								csInfo.ClientsWithoutSP,
								csInfo.ClientsWithoutSPPercent,
								csInfo.TotalClients
						) AS sub
			END
			--DeDup Backup Configuration
			ELSE IF @queryId = 66
			BEGIN
				DECLARE @TotalDDBs int
				declare @WarningDDBs int
				declare @CriticalDDBs int
				DECLARE @criticalValForTrasDDB int = 240	--10 Days
				DECLARE @warningValTrasDDB int = 168		--7 Days
				SELECT 	@totalDDBs = COUNT(csInfo.SidbStoreName),
				@CriticalDDBs = SUM(CASE
									WHEN csInfo.LastDDBBackupJobId =0 THEN 1
									WHEN ISNULL(csInfo.HoursSinceNoBackup,-1) = -1 THEN 1
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalThreshold THEN 1
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalValForTrasDDB THEN 1
											ELSE 0
									END),
				@WarningDDBs = SUM(CASE
									WHEN csInfo.LastDDBBackupJobId = 0 THEN 0
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <= @criticalThreshold AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningThreshold THEN 1
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <= @criticalValForTrasDDB AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningValTrasDDB THEN 1
									ELSE 0
								END)
				FROM	cf_SurveyDDBProtection AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				SET @tmpStatus = CASE WHEN @CriticalDDBs > 0 THEN @strCritical
									  WHEN @WarningDDBs >0 THEN @strWarning
									  ELSE @strGood END

				IF ( @TotalDDBs >0 )
				BEGIN
					set @tmpResult = ' DDB Partitions: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@TotalDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST((@TotalDDBs-@WarningDDBs-@CriticalDDBs) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>' + CAST(@WarningDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@CriticalDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
				BEGIN
					SET @tmpResult =  'There are no Media Agents hosting DDB store.<DELIM>'
				END
				SET @tmpRecommendation = CASE WHEN @TotalDDBs = 0 THEN @infoMessage
										      WHEN @CriticalDDBs > 0 or @WarningDDBs > 0 THEN @warningMessage ELSE @goodMessage END
			END
			--Schedule Policy Usage Statistics
			ELSE IF @queryId = 22
			BEGIN
				SET @tmpStatus = @strGood

				DECLARE @totalSchCount INT = 0
				DECLARE @unusedSchCount INT = 0

				DECLARE @tmpSchPolicy TABLE(IsUsed INT, SPCount INT)

				INSERT INTO @tmpSchPolicy
				SELECT 	csInfo.IsUsed, COUNT(*)
				FROM	cf_SurveySchedulePolicyUsage AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.IsUsed

				SELECT @totalSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy
				SELECT @unusedSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy WHERE IsUsed = 0

				IF @unusedSchCount > 0
				BEGIN
					SET @tmpResult = '<b>' + CAST(@unusedSchCount AS NVARCHAR(100)) + '</b> out of <b>'
						+ CAST(@totalSchCount AS NVARCHAR(100))
						+ '</b> Schedule Policies are not used.<DELIM>'
					SET @tmpStatus = @strwarning
					SET @tmpRecommendation = @warningMessage
				END
				ELSE
				BEGIN
					SET @tmpResult =
						CASE
							WHEN @totalSchCount = 0 THEN 'There is no Schedule Policy.<DELIM>'
							WHEN @totalSchCount > 0 THEN 'All <b>' + CAST(@totalSchCount AS NVARCHAR(100)) + '</b> Schedule Policies are in use.<DELIM>'
						END
					SET @tmpStatus = @strGood
					SET @tmpRecommendation = CASE WHEN @totalSchCount > 0 THEN @goodMessage ELSE '' END
				END
			END
			--Largest Clients by backup Size
			ELSE IF @queryId = 23
			BEGIN
				SET @tmpStatus = @strInfo
				SET @tmpResult = 'There may not be any backup jobs in last 30 days.'

				SELECT 	@tmpStatus = @strInfo,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = '<b>' + CAST(sub.ClientCount AS NVARCHAR(MAX)) + '</b> client(s) contribute(s) <b>'
							+ CAST(CAST(sub.SharePercent AS DECIMAL(6,2)) AS NVARCHAR(MAX)) + ' %</b> of the total application size <b>'
							+ dbo.FormatBytes(sub.TotalSize, 'GB') + '</b>  (last full backups).<DELIM>',
						@tmpRecommendation = CASE WHEN ISNULL(sub.ClientCount, 0) = 0 THEN '' ELSE '<VDL>' END
				FROM	(SELECT csInfo.CommServUniqueId,
								csInfo.LogDate,
								csInfo.ClientGroups,
								COUNT(DISTINCT csInfo.ClientId) AS ClientCount,
								MAX(csInfo.TotalSizeGB) AS TotalSize,
								CASE
									WHEN SUM(csInfo.ShareOfTotal) > 100 THEN 100
									ELSE SUM(csInfo.ShareOfTotal)
								END AS SharePercent
						FROM	cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.ClientGroups
						) AS sub
			END
			--Slowest Clients by long running jobs
			ELSE IF @queryId = 24
			BEGIN

				SELECT	TOP 1 @jobCount = csInfo.LongRunningJobs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @tmpStatus = CASE WHEN @jobCount > 0 THEN @strwarning ELSE @strGood	END
				SET @tmpResult = CASE
					WHEN @jobCount > 0 THEN '<b>' + CAST(@jobCount AS VARCHAR(MAX)) + '</b> jobs were found running longer than <b>12 hours</b>.<DELIM>'
					ELSE 'No jobs were found running longer than <b>12 hours</b>.<DELIM>' END
				SET @tmpRecommendation = CASE WHEN @jobCount > 0 THEN 'View top 25 backup jobs running for more than 12 hours.<VDL>' ELSE '' END
			END
			--Continuous Failed Clients
			ELSE IF @queryId = 25
			BEGIN

				DECLARE @totalClients INT =0
				DECLARE @totalClientsWithStrike INT =0
				DECLARE @tmpStrikeTable TABLE(StrikeCount INT, scCount INT, clientCount INT)

				INSERT INTO @tmpStrikeTable
				SELECT	CASE WHEN StrikeCounts > 3 THEN 3 ELSE StrikeCounts END AS 'StrikeCount', COUNT (*) AS 'SubclientCount', COUNT (DISTINCT ClientId) AS 'ClientCount'
				FROM	cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
							AND csInfo.StrikeCounts <> -1
				GROUP BY CASE WHEN StrikeCounts > 3 THEN 3 ELSE StrikeCounts END
				ORDER BY CASE WHEN StrikeCounts > 3 THEN 3 ELSE StrikeCounts END DESC

				SELECT	@totalClientsWithStrike = COUNT(DISTINCT csInfo.ClientId)
				FROM	cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
							AND csInfo.StrikeCounts <> -1

				SET @totalClients = ISNULL((SELECT ISNULL(TotalClients,0) FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
									INNER JOIN cf_CommservSurveyResults G WITH (NOLOCK)
									ON csInfo.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1),0)

				DECLARE @strike3Count VARCHAR(MAX) = ''
				DECLARE @strike2Count VARCHAR(MAX) = ''
				DECLARE @strike1Count VARCHAR(MAX) = ''

				SELECT	@strike3Count = 'Strike 3 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
				FROM	@tmpStrikeTable WHERE StrikeCount = 3

				SELECT 	@strike2Count = 'Strike 2 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
				FROM	@tmpStrikeTable WHERE StrikeCount = 2

				SELECT 	@strike1Count = 'Strike 1 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
				FROM	@tmpStrikeTable WHERE StrikeCount = 1

				IF @totalClientsWithStrike <> 0 AND @totalClients = 0
					SET @tmpStatus = @strCritical
				ELSE IF @totalClients = 0 OR @totalClientsWithStrike = 0 OR ((@totalClientsWithStrike*100.0)/@totalClients) < @warningThreshold
					SET @tmpStatus	    = @strGood
				ELSE IF ((@totalClientsWithStrike*100.0)/@totalClients) <= @criticalThreshold AND ((@totalClientsWithStrike*100.0)/@totalClients) >= @warningThreshold
					SET @tmpStatus	    = @strWarning
				ELSE
					SET @tmpStatus = @strCritical


				IF @totalClientsWithStrike = 0
				BEGIN
					SET @tmpRecommendation = '<DELIM>'
					SET @tmpResult = 'There are no clients having any consecutive failed/killed jobs hence there is no strike.<DELIM>'
				END
				ELSE
				BEGIN
					SET	@tmpResult = @strike3Count + '<DELIM>' + @strike2Count + '<DELIM>' + @strike1Count + '<DELIM>'
					SET @tmpRecommendation = '<VDL>'
				END
			END

			--Dedupe Ratio by Storage Policy Copy
			ELSE IF @queryId = 26
			BEGIN
				DECLARE @TotalCopies INT = 0

				DECLARE @DeDupRatioSPCount TABLE(Copy NVARCHAR(256), DeDupRatio DECIMAL(20, 2))

				INSERT INTO @DeDupRatioSPCount
				SELECT 	csInfo.Copy, csInfo.DedupeRatio
				FROM	cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				AND csInfo.Jobs > 0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
				AND csInfo.DedupeRatio > -1

				SELECT @TotalCopies = COUNT(*) FROM @DeDupRatioSPCount

				DECLARE @DDBappSize DECIMAL(20,2) = 0
				DECLARE @DDBSizeOnMedia DECIMAL(20,2) = 0
				DECLARE @DDBRatio VARCHAR(MAX) = ''
				SELECT
					@DDBappSize = CAST(SUM(csInfo.appSizeGB)/1024.0 AS Decimal(20,2)),
					@DDBSizeOnMedia = CAST(SUM(csInfo.SizeOnMediaGB)/1024.0 AS Decimal(20,2)),
					@DDBRatio =
					CASE
						WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
						ELSE CAST(CAST((100.0*(SUM(csInfo.appSizeGB)-SUM(csInfo.SizeOnMediaGB))/SUM(csInfo.appSizeGB))AS Decimal(20,2)) AS VARCHAR(MAX))
					END
				FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
					AND csInfo.DedupeRatio>-1

				SET	@tmpStatus = @strInfo

				SET @tmpRecommendation = @infoMessage

				IF (@TotalCopies > 0)
				BEGIN
					SET @tmpResult = 'Deduplication Copies: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@TotalCopies AS NVARCHAR(5)) + '</B>'
					SET @tmpResult += ', Application Size: <B>'+ CAST(@DDBappSize AS NVARCHAR(20)) + ' TB</B>'
					SET @tmpResult += ', Size on Media: <B>'+ CAST(@DDBSizeOnMedia AS NVARCHAR(20)) + ' TB</B>'
					SET @tmpResult += ', Deduplication Ratio: <B>'+ @DDBRatio + '</B>'
					SET @tmpRecommendation += '<VDL>'
				END
				ELSE
					SET @tmpResult =  'There are no storage policy copies with Deduplication enabled.<DELIM>'

			END
			--Unprotected Clients
			ELSE IF @queryId = 27
			BEGIN

				DECLARE @slaPercent FLOAT = -1
				DECLARE @MetSLA INT, @MissedSLA INT

				SELECT	@slaPercent = CASE
						WHEN (sub.NotProtectedClients+sub.ProtectedClients)>0
						THEN sub.ProtectedClients*100.0/(sub.NotProtectedClients+sub.ProtectedClients)
						ELSE -1 END,
						@MetSLA = sub.ProtectedClients,
						@MissedSLA = sub.NotProtectedClients
				FROM	(SELECT TOP 1
								csInfo.ProtectedClients,
								csInfo.NotProtectedClients
						FROM	cf_SurveySLASummary AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId AND (csInfo.Days = 30 OR csInfo.Days < 0)
						) AS sub

				IF @slaPercent < 0
				BEGIN
					SELECT	@slaPercent = CASE
							WHEN (NotProtectedClients+ProtectedClients)>0
							THEN ProtectedClients*100.0/(NotProtectedClients+ProtectedClients)
							ELSE -1 END,
							@MetSLA = ProtectedClients,
							@MissedSLA = NotProtectedClients
					FROM	cf_CommcellSummary WITH (NOLOCK)
					WHERE	SurveyResultId IN (
							SELECT CommservSurveyResults_ID FROM cf_CommservSurveyResults WITH (NOLOCK)
							WHERE QueryId = 146 and CommcellIdNameMap_ID = @i_CommServUniqueId AND Flags = 1)
				END

				IF @slaPercent < 0
				BEGIN
					SET @tmpResult = 'No data available<DELIM>'
					SET	@tmpStatus = @strInfo
					SET	@tmpRecommendation = @infoMessage
				END
				ELSE
				BEGIN
					SET @slaPercent = CAST(@slaPercent AS INT)
					SET @tmpResult = 'SLA is <b>'+ CAST (@slaPercent AS NVARCHAR(6)) + ' %.</b><DELIM>'
					SET @tmpResult += 'Met SLA : <b>' + CAST (@MetSLA AS NVARCHAR(10)) + '</b>, Missed SLA : <b>' + CAST (@MissedSLA AS NVARCHAR(10)) + '</b>'
					SET	@tmpStatus = CASE
						WHEN @slaPercent < @criticalThreshold THEN @strCritical
						WHEN @slaPercent <= @warningThreshold THEN @strwarning
						ELSE @strGood END
					SET	@tmpRecommendation = CASE
						WHEN @slaPercent < @criticalThreshold THEN @criticalMessage
						WHEN @slaPercent <= @warningThreshold THEN @warningMessage
						WHEN @slaPercent = 100 THEN @goodMessage END
				END
			END
			--Incremental Backup Change Rate
			ELSE IF @queryId = 28
			BEGIN
				DECLARE @WeeklySizeChange TABLE
				(
					LogDate DATE,
					BkpSize FLOAT,
					TotalJobs BIGINT
				)

				INSERT INTO @WeeklySizeChange
				SELECT 	CAST (DATEADD(SS,csInfo.UxDate,'1970-01-01')AS DATE),
						SUM(csInfo.BackupSize) AS BkpSize, --AS '',
						SUM(csInfo.TotalJobs)  AS TotalJobs --AS 'Number of Incremental Backups'
				FROM	cf_SurveyIncrBkpChangeRate AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				GROUP BY CAST (DATEADD(SS,csInfo.UxDate,'1970-01-01')AS DATE)

				DECLARE @LastTotalBkpSize FLOAT, @FirstTotalBkpSize FLOAT, @WeekBkpSizeChg FLOAT = 0, @WeekBkpSizeChgPercent FLOAT, @increased INT = 0
				SELECT	@LastTotalBkpSize =ISNULL(BkpSize,0)  FROM @WeeklySizeChange
				WHERE	LogDate = (SELECT MAX(LogDate)  FROM @WeeklySizeChange)

				SELECT	@FirstTotalBkpSize =ISNULL(BkpSize,0)  FROM @WeeklySizeChange
				WHERE	LogDate = (SELECT MIN(LogDate)  FROM @WeeklySizeChange)

				DECLARE @WeekBkpSizeChgStr VARCHAR(MAX)='NOT APPLICABLE' , @WeekBkpSizeChgPercentStr VARCHAR(MAX)='NOT APPLICABLE' , @WeekStr VARCHAR(MAX)=''

				IF @FirstTotalBkpSize <>0
				BEGIN
					SET @WeekBkpSizeChg				= (@LastTotalBkpSize - @FirstTotalBkpSize)
					SET @increased					= CASE WHEN @WeekBkpSizeChg > 0 THEN 1 WHEN @WeekBkpSizeChg < 0 THEN -1 ELSE 0 END
					IF  @WeekBkpSizeChg < 0 SET @WeekBkpSizeChg = -@WeekBkpSizeChg
					SET @WeekBkpSizeChgPercent		= @WeekBkpSizeChg*100.0/@FirstTotalBkpSize
					SET @WeekBkpSizeChgStr			= dbo.formatBytes(@WeekBkpSizeChg ,'GB')
					SET @WeekBkpSizeChgPercentStr	= CAST(CAST (@WeekBkpSizeChgPercent AS DECIMAL (16,2)) AS VARCHAR(MAX))
					SET	@tmpStatus					= @strInfo
					SET	@tmpRecommendation			= '<VDL>'
					SET	@WeekStr					=' ( <b>' + @WeekBkpSizeChgPercentStr + '</b> %)'
				END
				ELSE
				BEGIN
					SET	@tmpStatus					= @strInfo
					SET	@tmpRecommendation			= ''
				END

				SET @tmpResult = CASE @increased
									WHEN 1 THEN 'Total data size increased by <b>' + @WeekBkpSizeChgStr + '</b>' + @WeekStr + '<DELIM>'
									WHEN -1 THEN 'Total data size decreased by <b>' + @WeekBkpSizeChgStr + '</b>' + @WeekStr + '<DELIM>'
									ELSE 'Total data size remained unchanged' END
			END
			--Most Frequent Errors
			ELSE IF @queryId = 30
			BEGIN
				DECLARE @errorList TABLE(ErrorCode NVARCHAR(512), JobsAffected INT)

				INSERT INTO @errorList
				SELECT TOP 5 sub.ErrorCode, sub.NumberOfJobsAffected FROM
				(
				SELECT csInfo.ErrorCode, SUM(csInfo.NumberOfJobsAffected) AS NumberOfJobsAffected
				FROM	cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
						GROUP BY csInfo.ErrorCode
				) AS sub
				ORDER BY sub.NumberOfJobsAffected DESC

				DECLARE @totalErrors INT = 0
				SELECT @totalErrors = ISNULL(SUM(JobsAffected), 0) FROM @errorList

				IF (@totalErrors <= 0)
				BEGIN
					SET @tmpStatus = @strGood
					SET @tmpResult = 'No errors are found.<DELIM>'
					SET @tmpRecommendation = ''
				END
				ELSE
				BEGIN
					SET @tmpStatus = @strwarning
					SELECT @tmpResult = STUFF((SELECT ', ' + dbo.cf_surveyKBLink(ErrorCode) + ' (' + CAST(JobsAffected AS VARCHAR(50)) + ')' AS Error FROM @errorList FOR XML PATH(''), TYPE).value('.[1]', 'nvarchar(max)'), 1, 2, '') FROM @errorList AS x
					SELECT @tmpResult = 'Top 5 Error Code (Jobs Affected) <DELIM>' + @tmpResult
					SET @tmpRecommendation = '<VDL>'
				END
			END
			--DR Backup Configuration
			ELSE IF @queryId = 31 AND @i_IsLocal = 0
			BEGIN
				SET @tmpStatus = @strCritical
				SET @tmpResult = ''
				SET @tmpRecommendation = @criticalMessage
				DECLARE @DRTABLE TABLE (LogDate	datetime NOT NULL, FullJobsToRetain int NULL, IsUingNetworkPath NVARCHAR(20), LastSuccessfulDRTime INT DEFAULT 0, LastFailedDRTime INT DEFAULT 0, LastCweDRTime INT DEFAULT 0)
				INSERT INTO @DRTABLE
					SELECT 	0, csInfo.FullJobsToRetain, csInfo.IsUingNetworkPath, 0, 0, 0
								FROM	cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = @queryId

				UPDATE @DRTABLE SET LogDate = csInfo.LogDate, LastSuccessfulDRTime = csInfo.LastSuccessfulDRTime, LastFailedDRTime = csInfo.LastFailedDRTime, LastCweDRTime = ISNULL(csInfo.LastCweDRTime, 0)
				FROM cf_SurveyDRStats AS csInfo WITH (NOLOCK)
					INNER JOIN cf_CommservSurveyResults R WITH (NOLOCK)
						ON R.QueryID = 19 --User Query id 19(BR Backup Statistics)
						AND csInfo.SurveyResultId = R.CommservSurveyResults_ID
						AND R.CommcellIdNameMap_ID = @i_CommServUniqueId
						AND R.Flags = 1

				DECLARE @ISUNC NVARCHAR(20) = NULL
				DECLARE @FullJobsToRetain int =  NULL
				DECLARE @LastDRBkpTime int = 0
				DECLARE @LastFailedDRBkpTime int = 0
				DECLARE @LastCweDRBkpTime int = 0
				DECLARE @LastDRCollTime datetime = NULL
				SELECT 	@ISUNC = MAX(IsUingNetworkPath), @FullJobsToRetain = MAX(FullJobsToRetain), @LastDRBkpTime = MAX(LastSuccessfulDRTime), @LastFailedDRBkpTime = MAX(LastFailedDRTime), @LastCweDRBkpTime = MAX(LastCweDRTime), @LastDRCollTime = MAX(LogDate) FROM @DRTABLE

				IF EXISTS(SELECT * FROM @DRTABLE WHERE @ISUNC = 'false'
				OR @FullJobsToRetain = 0 OR ISNULL(@LastDRBkpTime, 0) = 0
				OR DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) > @criticalThreshold
				OR @LastFailedDRBkpTime > @LastDRBkpTime)
				BEGIN
					SET @tmpStatus = @strCritical
					SET @tmpRecommendation = @criticalMessage
				END
				ELSE IF EXISTS(SELECT * FROM @DRTABLE WHERE (@FullJobsToRetain = 1) OR DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) > @warningThreshold)
				BEGIN
					SET @tmpStatus = @strwarning
					SET @tmpRecommendation = @warningMessage
				END
				ELSE IF EXISTS(SELECT * FROM @DRTABLE WHERE @ISUNC = 'true' AND @FullJobsToRetain >= 2 AND DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) <= @warningThreshold)
				BEGIN
					SET @tmpStatus = @strGood
					SET @tmpRecommendation = @goodMessage
				END

				SET @tmpLogDate = CONVERT(VARCHAR(20), @LastDRCollTime, 100)

				SET @tmpResult =
				CASE
					WHEN ISNULL(@LastDRBkpTime, 0) = 0 THEN 'There is no successful DR job so far.<DELIM>'
					WHEN @LastFailedDRBkpTime > @LastDRBkpTime AND @LastFailedDRBkpTime > @LastCweDRBkpTime THEN 'DR Backup job failed on <b>'  + CONVERT(VARCHAR(12), DATEADD(second, @LastFailedDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
					WHEN @LastCweDRBkpTime > @LastDRBkpTime THEN 'DR Backup job completed with errors on <b>'  + CONVERT(VARCHAR(12), DATEADD(second, @LastCweDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
					ELSE 'Last successful DR backup ran on <b>' + CONVERT(VARCHAR(12), DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
				END
				IF (@ISUNC = 'true')
					SET @tmpResult = @tmpResult + 'DR Backup is scheduled to run with <b>UNC path</b> as destination.<DELIM>' + 'It is currently configured to retain <b>' + CAST(@FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<DELIM>'
				ELSE IF (@ISUNC = 'false')
					SET @tmpResult = @tmpResult + 'DR Backup is scheduled to run with <b>local path</b> as destination.<DELIM>' + 'It is currently configured to retain <b>' + CAST(@FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<DELIM>'
			END
			--Clients completing with error
			ELSE IF @queryId = 37
			BEGIN
				SET @totalClients =0
				SET @tmpStatus = @strGood
				SET @tmpResult = 'There are no clients with Jobs completed with errors.<DELIM>'

				SET @totalClients = (SELECT ISNULL(TotalClients,0) FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
									INNER JOIN cf_CommservSurveyResults G
									ON csInfo.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1)

				SELECT	@tmpStatus = (CASE WHEN @totalClients = 0 AND ISNULL(sub.ClientCount, 0) <> 0
												THEN @strCritical
										   WHEN @totalClients = 0 OR ISNULL(sub.ClientCount, 0) = 0 OR ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) < @warningThreshold
												THEN @strGood
										   WHEN ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) <= @criticalThreshold AND ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) >= @warningThreshold
												THEN @strWarning
										   ELSE @strCritical
									 END),
						@tmpResult = '<b>' + CAST(sub.ClientCount AS VARCHAR(10)) + '</b> client(s) with one or more jobs completed with error.<DELIM>',
						@tmpRecommendation = (CASE WHEN ISNULL(sub.ClientCount, 0) = 0 OR (@totalClients = 0 AND ISNULL(sub.ClientCount, 0) = 0) OR ((ISNULL(sub.ClientCount, 0)*100.0)/@totalClients)<= @warningThreshold
													THEN ''
												  ELSE '<VDL>'
												  END)
				FROM	(SELECT csInfo.CommServUniqueId, csInfo.LogDate, COUNT(csInfo.ClientName) AS ClientCount
						FROM	cf_SurveyClientJobsCompletingWithError AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
						) AS sub
			END
			--Index Cache location
			ELSE IF @queryId = 39 AND @parameterName = 'Index Cache Location'
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @localIdxCount INT = 0
				DECLARE @networkIdxCount INT = 0

				SELECT @localIdxCount = COUNT(csInfo.MAId)
				FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND csInfo.IsUNC = 0 AND csInfo.IndexAccessPathEnabled = 1

				SELECT @networkIdxCount = COUNT(csInfo.MAId)
				FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND csInfo.IsUNC = 1 AND csInfo.IndexAccessPathEnabled = 1

				SELECT
					@tmpStatus =
					CASE
						WHEN (@localIdxCount + @networkIdxCount = 0) THEN @strInfo
						WHEN @networkIdxCount >= @warningThreshold THEN @strWarning
						ELSE @strGood
					END,
					@tmpResult =
					CASE
						WHEN @localIdxCount+@networkIdxCount = 0 THEN @infoMessage
						ELSE 'Index cache distribution by location: <DELIM>'
						+ 'Total : <b>' + CAST((@localIdxCount+@networkIdxCount) AS VARCHAR(10))
						+ '</b>&nbsp&nbspLocal Disk : <b>' + CAST(@localIdxCount AS VARCHAR(10))
						+ '</b>&nbsp&nbspNetwork Share : <b>' + CAST(@networkIdxCount AS VARCHAR(10))
						+ '</b>'
					END,
					@tmpRecommendation =
					CASE
						WHEN (@localIdxCount + @networkIdxCount = 0) THEN @infoMessage
						WHEN @networkIdxCount >= @warningThreshold THEN @warningMessage
						ELSE @goodMessage
					END
			END
			--Index Cache Space
			ELSE IF @queryId = 105 AND @parameterName = 'Index Cache Space Utilization'
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalIdxCache int = 0
				DECLARE @warningIdxCache int = 0
				DECLARE @criticalIdxCache int = 0
				DECLARE @unknownIdxCache int = 0

				--Disk space free: good:   > 25%   warning: 10  25%, critical < 10%
				DECLARE @idxCacheSize TABLE
				(
					MAId INT,
					percentFree DECIMAL(10,2),
					FreeDiskSpaceMB BIGINT,
					warningSpaceMB	BIGINT,
					criticalSpaceMB	BIGINT,
					Days bigint
				)

				DECLARE @LatestThreshold TABLE  (
				CommServUniqueId INT,
				clientId INT,
				warningSpaceMB BIGINT,  criticalSpaceMB BIGINT)
				INSERT INTO @LatestThreshold
				SELECT  CommServUniqueId ,entityId  AS clientId,

				CASE ISNUMERIC([warningSpaceMB]) WHEN 1 THEN CAST(CAST([warningSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END AS warningSpaceMB,
				CASE ISNUMERIC([criticalSpaceMB]) WHEN 1 THEN CAST(CAST([criticalSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END  AS criticalSpaceMB

				FROM    (SELECT csInfo.CommServUniqueId,entityId, attrName ,attrVal
							FROM cf_SurveyCommcellThresholdInfo csInfo (NOLOCK)
									 where csInfo.CommServUniqueId =@i_CommServUniqueId
									and attrName IN ( 'warningSpaceMB', 'criticalSpaceMB')
				     	 ) AS clients

				PIVOT
				(
					MAX(attrVal) FOR attrName IN ( warningSpaceMB, [criticalSpaceMB])
				) AS P

				DECLARE @IdxCriticalDays  bigINT =30
				DECLARE @IdxWarningDays  bigINT= 90
				declare @IdxSrcTbl SrcTblType
				insert into @IdxSrcTbl
				select
					cast(MAId as varchar(max)),
					IndexCachePath,
					csInfo.CommServUniqueId,
					csInfo.LogDateUTC,
					csInfo.LogDate,
					TotalCapacityMB,
					DiskUsageMB,
					FreeDiskSpaceMB
					from cf_SurveyIndexCacheUsage AS csInfo
					INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 39	AND csInfo.TotalCapacityMB > 0 AND csInfo.IndexAccessPathEnabled = 1

				declare @IdxPeakSizeTbl PeakSizeTblType
				insert into @IdxPeakSizeTbl
				select
					cast(MAId as varchar(max)),
					IndexCachePath,
					CommServUniqueId,
					WeekStart,
					DiskUsageMB,
					FreeDiskSpaceMB
					from cf_SurveyIndexCacheUsagePeakSize
					where CommServUniqueId = @i_CommServUniqueId

				DECLARE @IdxLeastSquareFit TABLE (
					CommServUniqueId int,
					MAId int,
					IndexCachePath varchar(max),
					Slope float,
					Days bigint
				)
				insert into @IdxLeastSquareFit (CommServUniqueId,MAId,IndexCachePath,Slope,Days)
				select CommServUniqueId, cast(KeyCol1 as int), cast(KeyCol2 as varchar(max)), Slope, DaysToBeFull
				from dbo.PredictDateToBeFullFunc(
					@IdxSrcTbl,
					@IdxPeakSizeTbl,
					@i_CommServUniqueId
					)

				INSERT INTO @idxCacheSize (MAId,percentFree,FreeDiskSpaceMB,warningSpaceMB,criticalSpaceMB, Days)
				SELECT
				csInfo.MAId,
				CASE
					WHEN csInfo.TotalCapacityMB <= 0 THEN -1
					ELSE CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(10,2))
				END AS percentFree,
				CASE WHEN csInfo.TotalCapacityMB <= 0 THEN -1 ELSE csInfo.FreeDiskSpaceMB END,
				CASE WHEN T.clientId IS NOT NULL THEN T.warningSpaceMB ELSE csInfo.TotalCapacityMB*@warningThreshold/100 END,
				CASE WHEN T.clientId IS NOT NULL THEN T.criticalSpaceMB ELSE csInfo.TotalCapacityMB*@criticalThreshold/100 END,
				LSF.Days
				FROM
				cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = 39	AND csInfo.TotalCapacityMB > 0 AND csInfo.IndexAccessPathEnabled = 1
				LEFT OUTER JOIN @LatestThreshold T
				ON T.CommServUniqueId =csInfo.CommServUniqueId AND csInfo.MAId =T.clientId
				LEFT OUTER JOIN @IdxLeastSquareFit LSF
				ON LSF.MAId = csInfo.MAId

				SET @totalIdxCache = (SELECT COUNT(MAId) FROM @idxCacheSize)
				SET @unknownIdxCache = (select COUNT(MAId) FROM @idxCacheSize where percentFree = -1 )
				SET @criticalIdxCache = (select COUNT(MAId) FROM @idxCacheSize where ( FreeDiskSpaceMB<criticalSpaceMB ) or  ( Days != @NA and Days != @Never and Days<@IdxCriticalDays ))
				SET @warningIdxCache = (SELECT COUNT(MAId) FROM @idxCacheSize as A where ((FreeDiskSpaceMB>=criticalSpaceMB AND FreeDiskSpaceMB<=warningSpaceMB ) or ( Days != @NA and Days != @Never and Days>=@IdxCriticalDays and Days <= @IdxWarningDays )) and A.MAId not in (
					(select distinct(MAId) FROM @idxCacheSize where ( FreeDiskSpaceMB<criticalSpaceMB ) or ( Days != @NA and Days != @Never and Days<@IdxCriticalDays ))
					union all
					(select distinct MAId FROM @idxCacheSize where percentFree = -1 )
				)
				)

				SELECT
					@tmpStatus =
					CASE
						WHEN @totalIdxCache = 0 THEN @strInfo
						WHEN @criticalIdxCache > 0 THEN @strCritical
						WHEN @warningIdxCache > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalIdxCache > 0)
					BEGIN
						SET @tmpResult = 'Index cache distribution by available space: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST((@totalIdxCache-@warningIdxCache-@criticalIdxCache-@unknownIdxCache) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += '<DELIM>Excluded : <B>' + CAST(@unknownIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'There is no index cache configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalIdxCache = 0 THEN @infoMessage
					WHEN @totalIdxCache > 0 AND @criticalIdxCache = 0 AND @warningIdxCache = 0 THEN @goodMessage
					ELSE @warningMessage
				END
			END
			--Index BACKUP
			ELSE IF @queryId = 200 AND @parameterName = 'Index Backup'
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalIdx int = 0
				DECLARE @warningIdx int = 0
				DECLARE @criticalIdx int = 0


				--LAST BACKUP : good:   < 30 DAYS    critical > 30 DAYS
				DECLARE @idxLastBackupTime TABLE
				(
					ClientId INT,
					LastBackupTime BIGINT,
					lastTimeDbUptodate BIGINT
				)
				declare @last1month BIGINT= DBO.GetUnixTimeBig(GETDATE()-30)
				declare @warningdays BIGINT= DBO.GetUnixTimeBig(GETDATE()-@warningThreshold)
				declare @criticaldays BIGINT= DBO.GetUnixTimeBig(GETDATE()-@criticalThreshold)

				INSERT INTO @idxLastBackupTime
				SELECT
					csInfo.ClientId,
					csInfo.LastBackupTime,
					csInfo.lastTimeDbUptodate
					FROM cf_SurveyIndexBackupStatus AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId


				SET @totalIdx = (SELECT COUNT(ClientId) FROM @idxLastBackupTime)

				SET @warningIdx = (SELECT COUNT(ClientId) FROM @idxLastBackupTime where LastBackupTime >= @criticaldays and LastBackupTime <= @warningdays)
				SET @criticalIdx = (select COUNT(ClientId) FROM @idxLastBackupTime where LastBackupTime < @criticaldays AND ( lastTimeDbUptodate!=-1 AND LastBackupTime!=-1 ) )

				SELECT
					@tmpStatus =
					CASE
						WHEN @totalIdx = 0 THEN @strInfo
						WHEN @criticalIdx > 0 THEN @strCritical
						WHEN @warningIdx > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalIdx > 0)
					BEGIN
						SET @tmpResult = 'Index Backup Status: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalIdx AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST((@totalIdx-@warningIdx-@criticalIdx) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningIdx AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalIdx AS NVARCHAR(5)) + '</B>&nbsp&nbsp'

					END
				ELSE
					SET @tmpResult =  'There is no index backup status.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalIdx = 0 THEN @infoMessage
					WHEN @totalIdx > 0 AND @criticalIdx = 0 AND @warningIdx = 0 THEN @goodMessage
					ELSE @warningMessage
				END
			END
			--Index State
			ELSE IF @queryId = 201 AND @parameterName = 'Index State'
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalIdxState int = 0
				DECLARE @goodIdxState int = 0
				DECLARE @criticalIdxState int = 0
				DECLARE @warningIdxState int = 0

				--Index State : critical errorLevel BETWEEN 1 AND 5 THEN warning errorLevel> 5 OR csInfo.dbuptodate=0
				DECLARE @idxStateStatus TABLE
				(
					ClientId INT,
					errorLevel INT,
					dbuptodate INT
				)

				INSERT INTO @idxStateStatus
				SELECT
					csInfo.ClientId,
					csInfo.errorLevel,
					csInfo.dbuptodate
					FROM cf_SurveyIndexBackupStatus AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId


				SET @totalIdxState = (SELECT COUNT(ClientId) FROM @idxStateStatus )

				SET @goodIdxState = (SELECT COUNT(ClientId) FROM @idxStateStatus WHERE  dbuptodate=1 and errorLevel not BETWEEN 1 AND 5)
				SET @criticalIdxState = (select COUNT(ClientId) FROM @idxStateStatus WHERE errorLevel BETWEEN 1 AND 5 )
				SET @warningIdxState = @totalIdxState-@goodIdxState-@criticalIdxState
				SELECT
					@tmpStatus =
					CASE
						WHEN @totalIdxState = 0 THEN @strInfo
						WHEN @criticalIdxState > 0 THEN @strCritical
						WHEN @warningIdxState > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalIdxState > 0)
					BEGIN
						SET @tmpResult = 'Index Status: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalIdxState AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST(@goodIdxState AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST((@warningIdxState) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalIdxState AS NVARCHAR(5)) + '</B>&nbsp&nbsp'

					END
				ELSE
					SET @tmpResult =  'There is no index status.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalIdxState = 0 THEN @infoMessage
					WHEN @totalIdxState > 0 AND @criticalIdxState = 0 AND @warningIdxState = 0 THEN @goodMessage
					ELSE @warningMessage
				END
			END
			--Index Cache Space
			ELSE IF @queryId = 161
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalSearchEngine		int = 0
				DECLARE @warningSearchEngine	int = 0
				DECLARE @criticalSearchEngine	int = 0
				DECLARE @goodSearchEngine		int = 0
				--DECLARE @infoSearchEngine		int = 0

				DECLARE @segCountCritical INT  =512
				DECLARE @segCountWarning INT  = 256
                DECLARE @tiiFileSizeLimit INT  = 600
                DECLARE @successfulObjectCritical INT  = 40
                DECLARE @successfulObjectWarning INT  = 20
				DECLARE @driveFreeSpaceCritical INT  = 35
				DECLARE @driveFreeSpaceWarning INT  = 50
				DECLARE @isSearchOnly INT  = 1
				--Disk space free: good:   > 25%   warning: 10 – 25%, critical < 10%
				DECLARE @SearchEngineHealthNodeStatus TABLE
				(
				   status NVARCHAR(MAX)
				)

				INSERT INTO @SearchEngineHealthNodeStatus
				SELECT
					CASE WHEN (	ISNULL(csInfo.isSearchOnly, 0)  = @isSearchOnly
				   				)
						THEN @strGood
						WHEN (	 csInfo.SegmentCount							 >	 @segCountCritical
                                 OR  (csInfo.TermIndexFileSizeMB             >   @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) > @successfulObjectCritical )
								 OR  (csInfo.IndexSizeMB*@driveFreeSpaceCritical)/100.0    >	 csInfo.FreeSpaceMB
								 OR  csInfo.FreeSpaceMB = 0
							 )
						THEN @strCritical
						 WHEN (	 csInfo.SegmentCount								 >=	 @segCountWarning
                                 OR  (csInfo.TermIndexFileSizeMB                     >=  @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) >= @successfulObjectWarning)
								 OR  (csInfo.IndexSizeMB*@driveFreeSpaceWarning)/100.0    >	csInfo.FreeSpaceMB
							 )
						THEN @strwarning
					ELSE @strGood
					END
				FROM
					cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @totalSearchEngine = (SELECT COUNT(*) FROM @SearchEngineHealthNodeStatus)
				SET @criticalSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strCritical)
				SET @warningSearchEngine = (SELECT COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strwarning)
				SET @goodSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strGood)
				--SET @infoSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strInfo)

				SELECT
					@tmpStatus =
					CASE
					--	WHEN @totalSearchEngine = 0 OR @totalSearchEngine =@infoSearchEngine THEN @strInfo
						WHEN @criticalSearchEngine > 0 THEN @strCritical
						WHEN @warningSearchEngine > 0 THEN @strwarning
						ELSE @strGood
					END

				--IF (@totalSearchEngine > 0 AND @totalSearchEngine>@infoSearchEngine)
				IF (@totalSearchEngine > 0 )
					BEGIN
						SET @tmpResult = 'Search Clouds: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST(@goodSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'No Search Clouds are configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @criticalSearchEngine > 0 THEN @criticalMessage
					WHEN @warningSearchEngine  > 0 THEN @warningMessage
				--	WHEN @totalSearchEngine = 0 OR @totalSearchEngine =@infoSearchEngine  THEN @infoMessage
					WHEN @totalSearchEngine = 0 THEN @infoMessage
					ELSE @goodMessage
				END
			END
			ELSE IF @queryId = 95
			BEGIN
				SET @tmpStatus = @strInfo
				SET @tmpResult = ''

				DECLARE @totalMountPaths     int = 0

				--Disk space free: good:   > 25%   warning: 10  25%, critical < 10%
				DECLARE @MountPathsSize TABLE
				(
					MountPathName NVARCHAR(256),
					percentFree DECIMAL(20,2)
				)

				INSERT INTO @MountPathsSize
				SELECT
					csInfo.MountPathName,
					csInfo.FreeSpacePerc
				FROM
					cf_Survey95MountPathDetails AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
						INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON csinfo.CommServUniqueId = LP.CommservUniqueId AND csInfo.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
				GROUP BY csInfo.LibraryId, csInfo.MountPathId, csInfo.MountPathName, csInfo.Device, csInfo.FreeSpacePerc

				SET @totalMountPaths     = (SELECT COUNT(MountPathName) FROM @MountPathsSize)


				IF (@totalMountPaths > 0)
					BEGIN
						SET @tmpResult = 'Total configured Mount Paths: '
						SET @tmpResult += '<B>'+ CAST(@totalMountPaths AS NVARCHAR(5)) + '</B><BR/>'
					END
				ELSE
					SET @tmpResult =  'There is no mount path configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalMountPaths = 0 THEN @infoMessage
					ELSE @goodMessage
				END
			END
			ELSE IF @queryId = 96
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalDiskLib     int = 0
				DECLARE @goodDiskLib      int = 0
				DECLARE @warningDiskLib   int = 0
				DECLARE @criticalDiskLib  int = 0
                DECLARE @unknownDiskLib   int = 0
				DECLARE @InfoDiskLib      int = 0

				--Disk space free: good:   > 25%   warning: 10  25%, critical < 10%
				DECLARE @DiskLibDays TABLE
				(
					DiskLibId BIGINT,
					MonthlyGrowthMB	FLOAT,
					DaysToBeFull BIGINT,
                    totalFreeSpaceGB FLOAT,
                    totalReserveSpaceGB FLOAT,
                    totalSpaceGB            FLOAT,
                    LogDateUTC					DATETIME
				)

				INSERT INTO @DiskLibDays
				SELECT
					csInfo.LibraryId, 0,
					-1,
                     ISNULL(csInfo.totalFreeSpaceGB, -2), -- here -1 is Used for Cloud Library
                     ISNULL(1.0*csInfo.totalReserveSpaceMB/1024, -2),
                     ISNULL(csInfo.totalSpaceGB, -2),
                     csInfo.LogDateUTC
				FROM
					cf_Survey96DiskLibDetails AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
						INNER JOIN cf_SurveyLibrary AS L WITH (NOLOCK)
							ON csInfo.CommservUniqueId = L.CommServUniqueId AND csInfo.LibraryId = L.LibraryId AND L.LibraryTypeId = 3 AND (@showHiddenLibraries = 1 OR L.Hidden = 0) AND L.Enabled = 1

				DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
				DECLARE	@MaxNumOfMonthsforGrowthRate INT = 6
				DECLARE @FirstMonth DATE = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)

				DECLARE @TblLeastSquareData TABLE (LibraryId INT, X INT, Y FLOAT)

				INSERT INTO @TblLeastSquareData
				SELECT	S.LibraryId, DATEDIFF(MONTH, S.MonthStart, @CurrMonth), ISNULL(S.UsedSpaceMB, -1)
				FROM	cf_SurveyDiskLibraryPeakSize S
						INNER JOIN @DiskLibDays T ON S.CommservUniqueId = @i_CommServUniqueId AND S.LibraryId = T.DiskLibId
				WHERE	S.MonthStart >= @FirstMonth AND ISNULL(S.UsedSpaceMB, -1) > 0 AND T.totalSpaceGB > 0

				DELETE	@TblLeastSquareData
				FROM	@TblLeastSquareData T INNER JOIN
						(SELECT	LibraryId, Max(X) AS MaxX, COUNT(*) AS NumOfPrevData
						FROM	@TblLeastSquareData
						GROUP BY LibraryId
						) S ON T.LibraryId = S.LibraryId
				WHERE	X = MaxX AND NumOfPrevData > 2 OR NumOfPrevData < 2

				DELETE	@TblLeastSquareData
				FROM	@TblLeastSquareData T INNER JOIN
						(SELECT	LibraryId, COUNT(*) AS NumOfPrevData
						FROM	@TblLeastSquareData
						GROUP BY LibraryId
						) S ON T.LibraryId = S.LibraryId
				WHERE	X = 0 AND NumOfPrevData > 2

				;WITH LeastSquareAvg(LibraryId, AvgX, AvgY) AS
				(
					SELECT	LibraryId, AVG(X), AVG(Y)
					FROM	@TblLeastSquareData
					GROUP BY LibraryId
				)
				,LeastSquareFit(LibraryId, Slope) AS
				(
					SELECT	A.LibraryId, SUM((X - AvgX)*(Y - AvgY))/SUM((X - AvgX)*(X - AvgX))
					FROM	LeastSquareAvg A INNER JOIN @TblLeastSquareData D ON A.LibraryId = D.LibraryId
					GROUP BY A.LibraryId
					HAVING SUM((X - AvgX)*(X - AvgX)) > 0
				)
				UPDATE	@DiskLibDays SET MonthlyGrowthMB = -Slope
				FROM	@DiskLibDays D INNER JOIN LeastSquareFit F ON D.DiskLibId = F.LibraryId

				UPDATE	@DiskLibDays
				SET		DaysToBeFull = 30.0*1024.0*totalFreeSpaceGB/MonthlyGrowthMB - DATEDIFF(DAY, LogDateUTC, GETUTCDATE())
				WHERE	ABS(ISNULL(MonthlyGrowthMB, 0)) > 0.001 AND (totalFreeSpaceGB - totalReserveSpaceGB) > 0

				UPDATE	@DiskLibDays SET DaysToBeFull = 0
				WHERE	(totalFreeSpaceGB - totalReserveSpaceGB) <= 0 AND totalFreeSpaceGB >= 0

				SET @totalDiskLib    = (SELECT COUNT(DiskLibId) FROM @DiskLibDays)
				SET @warningDiskLib	 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB > 0 AND DaysToBeFull BETWEEN @criticalThreshold AND @warningThreshold)
				SET @criticalDiskLib = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB > 0 AND DaysToBeFull < @criticalThreshold AND DaysToBeFull >= 0)
				SET @InfoDiskLib	 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB = -1 AND totalFreeSpaceGB = -1)
				SET @unknownDiskLib  = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB <= 0 AND totalFreeSpaceGB <> -1)
				SET @goodDiskLib	 = @totalDiskLib - @warningDiskLib - @criticalDiskLib - @InfoDiskLib - @unknownDiskLib

				SELECT
					@tmpStatus =
					CASE
						WHEN @totalDiskLib = 0 THEN @strInfo
						WHEN @totalDiskLib = @InfoDiskLib THEN @strInfo
						WHEN @totalDiskLib = @unknownDiskLib THEN @strUnknown
						WHEN @criticalDiskLib > 0 THEN @strCritical
						WHEN @warningDiskLib > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalDiskLib > 0)
					BEGIN
						SET @tmpResult = 'Disk Library distribution by estimated days to be full: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST(@goodDiskLib  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += '<DELIM>Info : <B>' + CAST(@InfoDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Unknown : <B>' + CAST(@unknownDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'

					END
				ELSE
					SET @tmpResult =  'There is no disk library configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalDiskLib = 0 THEN @infoMessage
					WHEN @totalDiskLib > 0 AND @totalDiskLib = @unknownDiskLib THEN @infoMessage+'<VDL>'
					WHEN @totalDiskLib > 0 AND @criticalDiskLib = 0 AND @warningDiskLib = 0 THEN @goodMessage
					ELSE @warningMessage
				END

			END

			ELSE IF @queryId = 196
			BEGIN
				SET @tmpStatus = @strInfo
				SET @tmpResult = ''

				DECLARE @totalCloudLib INT = 0
				DECLARE @usedCloudLib  INT = 0

				DECLARE @CloudLib TABLE
				(
					LibraryId INT,
                    totalDataWrittenGB FLOAT
				)

				INSERT INTO @CloudLib
				SELECT
					csInfo.LibraryId,
                    ISNULL(csInfo.totalDataWrittenGB, 0)
				FROM
					cf_Survey96DiskLibDetails AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 96
						INNER JOIN cf_SurveyLibrary AS L WITH (NOLOCK)
							ON csInfo.CommservUniqueId = L.CommServUniqueId AND csInfo.LibraryId = L.LibraryId AND L.LibraryTypeId = -3 AND (@showHiddenLibraries = 1 OR L.Hidden = 0)

				SET @totalCloudLib   = (SELECT COUNT(LibraryId) FROM @CloudLib)
				SET @usedCloudLib	 = (SELECT COUNT(LibraryId) FROM @CloudLib WHERE totalDataWrittenGB > 0)

				IF (@totalCloudLib > 0)
				BEGIN
					SET @tmpResult = 'Configured cloud Libraries: <DELIM>'
					SET @tmpResult += 'Total : <B>'+ CAST(@totalCloudLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Used  : <B>' + CAST(@usedCloudLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'

					SET @tmpRecommendation = @goodMessage
				END
				ELSE
				BEGIN
					SET @tmpResult =  'There is no cloud library configured.<DELIM>'

					SET @tmpRecommendation = @infoMessage
				END

			END

			--Capacity License Usage
			ELSE IF @queryId = 1 AND @parameterName = 'Capacity License Usage'
			BEGIN
				DECLARE @TotalBackupSize BIGINT = -1
				DECLARE @TotalLoanedBkpSize BIGINT = -1
				DECLARE @UsedBackupSize BIGINT = 0
				DECLARE @TotalArchiveSize BIGINT = -1
				DECLARE @TotalLoanedArcSize BIGINT = -1
				DECLARE @UsedArchiveSize BIGINT = 0
				SELECT
					@TotalBackupSize = ISNULL(csInfo.TotalBackupSize, -1),
					@TotalLoanedBkpSize = ISNULL(csInfo.EvalBackupSizeMB, 0),
					@UsedBackupSize  = ISNULL(csInfo.BackupSize, 0),
					@TotalArchiveSize = ISNULL(csInfo.TotalArchiveSize, -1),
					@TotalLoanedArcSize = ISNULL(csInfo.EvalArchiveSizeMB, 0),
					@UsedArchiveSize = ISNULL(csInfo.ArchiveSize, 0)
				FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = 'Purchased Backup Size: <b>' + CAST(CAST(@TotalBackupSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b>, '
					+ 'Loaned Backup Size : <b>' + CAST(CAST(@TotalLoanedBkpSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					+ 'Used Backup Size : <b>' + CAST(CAST(@UsedBackupSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					+ 'Purchased Archive Size : <b>' + CAST(CAST(@TotalArchiveSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20)) + ' TB</b>, '
					+ 'Loaned Archive Size : <b>' + CAST(CAST(@TotalLoanedArcSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					+ 'Used Archive Size : <b>' + CAST(CAST(@UsedArchiveSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20)) + ' TB</b><DELIM>',
					@tmpRecommendation = @infoMessage
			END
			ELSE IF @queryId = 1 AND @parameterName = 'License Usage'
			BEGIN
				DECLARE @VMSockets BIGINT = 0
				DECLARE @ProtectedVMs BIGINT = 0
				DECLARE @ArchivedMailBox BIGINT = 0
				DECLARE @EndpointUsers BIGINT = 0
				DECLARE @SharingUsers BIGINT = 0
				DECLARE @eDiscoveryUsers BIGINT = 0
				SELECT
					@VMSockets = ISNULL(csInfo.VMSockets, 0),
					@ProtectedVMs = ISNULL(csInfo.ProtectedVMs, 0),
					@ArchivedMailBox = ISNULL(csInfo.ArchivedMailBoxes, 0),
					@EndpointUsers = ISNULL(csInfo.EndpointUsers, 0),
					@SharingUsers = ISNULL(csInfo.SharingUsers, 0),
					@eDiscoveryUsers = ISNULL(csInfo.eDiscoveryUsers, 0)
				FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = 'VM Sockets : <b>' + CAST(@VMSockets AS VARCHAR(20)) + '</b>'
						+ ', VMs : <b>' + CAST(@ProtectedVMs AS VARCHAR(20)) + '</b>'
						+ ', Archived MailBoxes : <b>' + CAST(@ArchivedMailBox AS VARCHAR(20)) + '</b><DELIM>'
						+ 'Users : <b>' + CAST(@EndpointUsers AS VARCHAR(20)) + '</b>'
						+ ', Sharing Users : <b>' + CAST(@SharingUsers AS VARCHAR(20)) + '</b>'
						+ ', eDiscovery Users : <b>' + CAST(@eDiscoveryUsers AS VARCHAR(20)) + '</b>',
					@tmpRecommendation = @infoMessage
			END
			--Snapshot Engine Usage
			ELSE IF @queryId = 4
			BEGIN
				DECLARE @snapEnginesUsed NVARCHAR(MAX)
				DECLARE	 @tbl TABLE (name nvarchar(max))
				INSERT INTO @tbl
				SELECT distinct csInfo.snapEngineName
				FROM cf_Survey4SnapInfo AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				SELECT	@snapEnginesUsed = COALESCE(@snapEnginesUsed + ', ', '') + name FROM  @tbl
				IF ISNULL(@snapEnginesUsed, '') = ''
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = 'Snap Engines are not used',
					@tmpRecommendation = @criticalMessage
				ELSE
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = '<b>Below Snap Engines are used</b><DELIM>' + @snapEnginesUsed,
					@tmpRecommendation = @infoMessage
			END
			-- Value Assessment
			ELSE IF @queryId = 171
			BEGIN
				SELECT @tmpStatus = @strInfo
				SET @tmpResult = @infoMessage
				SET @tmpRecommendation = '<VDL>'
			END
			--Sealed DDBs
			ELSE IF @queryId = 121
			BEGIN
					DECLARE @SealedDDBCount INT = 0
					SELECT @SealedDDBCount = COUNT(DISTINCT csInfo.SIDBStoreId)
						FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 61
							AND	csInfo.MediaAgentId > 1
							AND csInfo.SealedStatus = 'Sealed'
					SET @tmpStatus = @strInfo
					SET @tmpResult = 'Found <b>' +  CAST(@SealedDDBCount AS VARCHAR(10)) + '</b> Sealed DDB(s)'
					SET @tmpRecommendation = CASE WHEN @SealedDDBCount > 0 THEN @infoMessage ELSE @goodMessage END
			END
			--High-Risk Settings - Prune All Database Agent Logs Only By Days Retention Rule
			ELSE IF @queryId = 124
			BEGIN
				DECLARE @settingValue INT = 0
				DECLARE @settingValueString NVARCHAR(MAX) = ''
				SELECT @settingValue = csInfo.Value, @settingValueString = 'Prune all database agent logs only by days retention rule'
					FROM cf_surveyHighRiskSettings AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
							AND	csInfo.Name = 'Prune All Database Agent Logs Only By Days Retention Rule'
				SET @tmpStatus = CASE WHEN @settingValue = 0 THEN @strGood ELSE @strCritical END
				SET @tmpResult =
					CASE
						WHEN @settingValue = 0 THEN 'Prune all database agent logs only by days retention rule option: Disabled'
						ELSE 'Prune all database agent logs only by days retention rule option: Enabled'
					END
				SET @tmpRecommendation = CASE WHEN @settingValue = 0 THEN @goodMessage ELSE @CriticalMessage END
			END
			-- scale statistics
			ELSE IF @queryId = 7
			BEGIN
				IF ( NOT EXISTS ( SELECT top 1 csInfo.SurveyResultId from cf_SurveyScaleReportInfo csInfo INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId  ))
				BEGIN
					DELETE FROM @TblSurveyResult where MonitorId = 7
				END
				ELSE
				BEGIN
				            DECLARE @outputParam TABLE
	                        (
									status		  varchar(20),
	                        		outcome		varchar(1024),
								   	statusINT	INT
	                        )
				            INSERT INTO @outputParam
				            SELECT DISTINCT STATUS, outcome, statusINT
				            FROM dbo.RptGetScaleHealthFunc(@i_UserId,@i_GroupId ,1,1,@i_CommServUniqueId,null,null,'',1)


				            set @tmpResult =  NULL
							SELECT @tmpStatus =ISNULL(STATUS,@strInfo),
								   @tmpResult = (case WHEN statusINT =3 then COALESCE(@tmpResult + '<DELIM> ', '') +outcome
													  WHEN statusINT =2 then COALESCE(@tmpResult + '<DELIM> ', '') +outcome
													  ELSE outcome
													  end) ,
							@tmpRecommendation =(case WHEN statusINT =3 then @criticalMessage
													  WHEN statusINT =2 then @warningMessage
													  WHEN statusINT =1 then @goodMessage
													  else @goodMessage
													 end	)
							from @outputParam

				END
			END
			--Database Index Fragmentation
			ELSE IF @queryId = 144
			BEGIN
				DECLARE @TblFragmentation TABLE (DatabaseName VARCHAR(32), OperationalIndexCount INT, WarningIndexCount INT, CriticalIndexCount INT)
				INSERT INTO @TblFragmentation
				SELECT  csInfo.DatabaseName,
					SUM(CASE WHEN csInfo.FragmentationPct = 102 THEN IndexCount ELSE 0 END), --102: Total operational indices
					SUM(CASE WHEN csInfo.FragmentationPct >= @warningThreshold AND csInfo.FragmentationPct < @criticalThreshold THEN IndexCount ELSE 0 END),
					SUM(CASE WHEN csInfo.FragmentationPct >= @criticalThreshold AND csInfo.FragmentationPct < 100 THEN IndexCount ELSE 0 END)
				FROM    cf_SurveyIndexFragmentation AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
				GROUP BY DatabaseName
				IF EXISTS (SELECT * FROM @TblFragmentation WHERE CriticalIndexCount > 0.25*OperationalIndexCount)
				BEGIN
					SET @tmpStatus = @strCritical
					SET @tmpRecommendation = @criticalMessage
				END
				ELSE IF EXISTS (SELECT * FROM @TblFragmentation WHERE WarningIndexCount > 0.25*OperationalIndexCount)
				BEGIN
					SET @tmpStatus = @strWarning
					SET @tmpRecommendation = @warningMessage
				END
				ELSE
				BEGIN
					SET @tmpStatus = @strGood
					SET @tmpRecommendation = @goodMessage
				END
				IF EXISTS (SELECT * FROM @TblFragmentation)
					SELECT @tmpResult = 'Operational Indices: <B>' + CAST(SUM(OperationalIndexCount) AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp Good: <B>' + CAST(SUM(OperationalIndexCount - WarningIndexCount - CriticalIndexCount) AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp Warning: <B>' + CAST(SUM(WarningIndexCount) AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp Critical: <B>' + CAST(SUM(CriticalIndexCount) AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp'
					FROM   @TblFragmentation
				ELSE
				BEGIN
					SET @tmpStatus = @strUnknown
					SET @tmpResult = 'No data available'
					SET @tmpRecommendation = ''
				END
			END

			--Disk Pruning
			ELSE IF @queryId = 156
			BEGIN

				declare @criticalNo int = 0
				declare @warningNo int = 0
				declare @totalNo int = 0

				declare @DDBTable table
				(
					PrimaryRecords bigint,
					ZeroRefCount	bigint,
					SevenDaysOldMMDeletedAFtable bigint
				)

				DECLARE @criticalAFVal int = 0
				DECLARE @warningAFVal int  = 0
				SET @criticalAFVal =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId=@i_CommServUniqueId AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),10000)
				SET @warningAFVal =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId=@i_CommServUniqueId AND attrName ='DDBPendingDeleteWarningLimit' and attrtype =10),5000)
				INSERT INTO @DDBTable
				SELECT PrimaryRecords, ZeroRefCount, AF.SevenDaysOldMMDeletedAFtable FROM cf_SurveyDDBPerformance csInfo INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 65 AND ISNULL(PrimaryRecords,-1) > -1 AND ISNULL(ZeroRefCount,-1) > -1
							INNER JOIN (SELECT DD.SIDBStoreId,DD.SevenDaysOldMMDeletedAFtable  FROM cf_SurveyDeDupDeletedAFCount AS DD WITH (NOLOCK)
										INNER JOIN cf_CommservSurveyResults G
										ON DD.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1) AS AF
										ON csInfo.SidbStoreId = AF.SIDBStoreId

				SET @totalNo = (SELECT COUNT(*) FROM @DDBTable)
				SET @warningNo = (SELECT COUNT(*) FROM @DDBTable WHERE PrimaryRecords > 0 AND ZeroRefCount >= (@warningThreshold * (ZeroRefCount + PrimaryRecords) /100.0) AND ZeroRefCount < (@criticalThreshold * (ZeroRefCount + PrimaryRecords) /100.0) OR SevenDaysOldMMDeletedAFtable BETWEEN @warningAFVal AND @criticalAFVal)
				SET @criticalNo =(SELECT COUNT(*) FROM @DDBTable WHERE PrimaryRecords > 0 AND ZeroRefCount >= (@criticalThreshold * (ZeroRefCount + PrimaryRecords) /100.0) OR SevenDaysOldMMDeletedAFtable > @criticalAFVal )

				SET @tmpStatus = CASE
					WHEN @totalNo = 0 THEN @strInfo
					WHEN @criticalNo > 0 THEN @strCritical
					WHEN @warningNo > 0 THEN @strwarning
					ELSE @strGood END

				IF (@totalNo > 0)
				BEGIN
					SET @tmpResult = 'Dedupe Stores: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@totalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST((@totalNo-@warningNo-@criticalNo) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>' + CAST(@warningNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@criticalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
					SET @tmpResult =  'There are no Media Agents hosting DDB store.<DELIM>'

				SET @tmpRecommendation = CASE
					WHEN @totalNo = 0 THEN @infoMessage
					WHEN @totalNo > 0 AND @criticalNo = 0 AND @warningNo = 0 THEN @goodMessage
					ELSE @warningMessage END
			END

			--Live Sync
			ELSE IF @queryId = 181
			BEGIN
				DECLARE @totVms INT = 0
				DECLARE @WarningVms INT = 0
				DECLARE @CriticalVms INT = 0
				DECLARE @GoodVms INT = 0

				declare @liveSyncVmDetails table
				(
					SourceVMClientName          NVARCHAR(256),
					Status						INT
				)

				INSERT INTO @liveSyncVmDetails
				SELECT vmInfo.SourceVMClientName,
                CASE
                    WHEN (vmInfo.Status = 5 OR DATEDIFF(d, dbo.GetDateTime(vmInfo.LastRestoreTime), SYSDATETIME()) > 7) THEN  4
                    WHEN vmInfo.Status = 6 THEN 3
                    ELSE 1
                END
				FROM cf_SurveyLiveSyncVMDetails AS vmInfo with (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = vmInfo.SurveyResultId AND result.QueryID = @queryId

				--get total number of vms being synced.
				SELECT @totVms = COUNT(*) from @liveSyncVmDetails

				--get number of good VMs
				SELECT @GoodVms = COUNT(*) from @liveSyncVmDetails where Status = 1

				--get number of warning VMs
				SELECT @WarningVms = COUNT(*) from @liveSyncVmDetails where Status = 3

				--get number of sync failures
				SELECT @CriticalVms = COUNT(*) from @liveSyncVmDetails where Status = 4

				SET @tmpResult = 'Total VM(s): <B>'+ CAST(@totVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpResult += 'Good: <B>' + CAST((@GoodVms) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpResult += 'Warning: <B>' + CAST(@WarningVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpResult += 'Critical: <B>' + CAST(@CriticalVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'

				IF @CriticalVms > 0
				BEGIN
					SET @tmpStatus = @strCritical
					SET @tmpRecommendation = @criticalMessage
				END
				ELSE IF @WarningVms > 0
				BEGIN
					SET @tmpStatus = @strwarning
					SET @tmpRecommendation = @warningMessage
				END
				ELSE
				BEGIN
					SET @tmpStatus = @strGood
					SET @tmpRecommendation = @goodMessage
				END
			END

			-- Tape Library Growth
			ELSE IF @queryId = 186
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalTapeLib     int = 0
				DECLARE @goodTapeLib      int = 0
				DECLARE @warningTapeLib   int = 0
				DECLARE @criticalTapeLib  int = 0
				DECLARE @InfoTapeLib      int = 0

				DECLARE @LibraryInfo TABLE
				(
					LibraryId		INT,
					MonthlyGrowth	FLOAT,
					DaysToBeFull	BIGINT,
                    UsedTapeCount	FLOAT,
                    SpareTapeCount	FLOAT,
                    TotalTapeCount	FLOAT,
                    LogDateUTC		DATETIME
				)

				INSERT INTO @LibraryInfo
				SELECT	L.LibraryId, 0, -1, L.UsedTapeCount, L.SpareTapeCount, (L.UsedTapeCount + L.SpareTapeCount), R.LogDateUTC
				FROM	cf_SurveyTapeUsageByLibrary AS L WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS R ON R.SurveyResultId = L.SurveyResultId AND R.QueryID = @queryId
						INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON @i_CommServUniqueId = LP.CommservUniqueId AND L.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)

				SET @CurrMonth = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
				SET	@MaxNumOfMonthsforGrowthRate = 6
				SET @FirstMonth = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)

				INSERT INTO @TblLeastSquareData
				SELECT	S.LibraryId, DATEDIFF(MONTH, S.MonthStart, @CurrMonth), S.UsedTapeCount
				FROM	cf_SurveyMonthlyTapeUsageByLibrary S
						INNER JOIN @LibraryInfo T ON S.CommservUniqueId = @i_CommServUniqueId AND S.LibraryId = T.LibraryId
				WHERE	S.MonthStart >= @FirstMonth AND S.UsedTapeCount > 0 AND T.TotalTapeCount > 0

				DELETE	@TblLeastSquareData
				FROM	@TblLeastSquareData T INNER JOIN
						(SELECT	LibraryId, Max(X) AS MaxX, COUNT(*) AS NumOfPrevData
						FROM	@TblLeastSquareData
						GROUP BY LibraryId
						) S ON T.LibraryId = S.LibraryId
				WHERE	X = MaxX AND NumOfPrevData > 2 OR NumOfPrevData < 2

				DELETE	@TblLeastSquareData
				FROM	@TblLeastSquareData T INNER JOIN
						(SELECT	LibraryId, COUNT(*) AS NumOfPrevData
						FROM	@TblLeastSquareData
						GROUP BY LibraryId
						) S ON T.LibraryId = S.LibraryId
				WHERE	X = 0 AND NumOfPrevData > 2

				;WITH LeastSquareAvg(LibraryId, AvgX, AvgY) AS
				(
					SELECT	LibraryId, AVG(X), AVG(Y)
					FROM	@TblLeastSquareData
					GROUP BY LibraryId
				)
				,LeastSquareFit(LibraryId, Slope) AS
				(
					SELECT	A.LibraryId, SUM((X - AvgX)*(Y - AvgY))/SUM((X - AvgX)*(X - AvgX))
					FROM	LeastSquareAvg A INNER JOIN @TblLeastSquareData D ON A.LibraryId = D.LibraryId
					GROUP BY A.LibraryId
					HAVING SUM((X - AvgX)*(X - AvgX)) > 0
				)
				UPDATE	@LibraryInfo SET MonthlyGrowth = -Slope
				FROM	@LibraryInfo L INNER JOIN LeastSquareFit F ON L.LibraryId = F.LibraryId

				UPDATE	@LibraryInfo
				SET		DaysToBeFull = 30.0*SpareTapeCount/MonthlyGrowth - DATEDIFF(DAY, LogDateUTC, GETUTCDATE())
				WHERE	ISNULL(MonthlyGrowth, -1) > 0.001 AND SpareTapeCount > 0

				SET @totalTapeLib    = (SELECT COUNT(LibraryId) FROM @LibraryInfo)
				SET @InfoTapeLib	 = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount <= 0)
				SET @warningTapeLib	 = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount > 0 AND DaysToBeFull BETWEEN @criticalThreshold AND @warningThreshold)
				SET @criticalTapeLib = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount > 0 AND DaysToBeFull < @criticalThreshold AND DaysToBeFull >= 0)
				SET @goodTapeLib	 = @totalTapeLib - @InfoTapeLib - @warningTapeLib - @criticalTapeLib

				SELECT
					@tmpStatus =
					CASE
						WHEN @totalTapeLib = 0 THEN @strInfo
						WHEN @totalTapeLib = @InfoTapeLib THEN @strInfo
						WHEN @criticalTapeLib > 0 THEN @strCritical
						WHEN @warningTapeLib > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalTapeLib > 0)
					BEGIN
						SET @tmpResult = 'Tape Library distribution by estimated days to be full: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST(@goodTapeLib  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += '<DELIM>Info : <B>' + CAST(@InfoTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'There is no tape library configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalTapeLib = 0 THEN @infoMessage
					WHEN @totalTapeLib > 0 AND @criticalTapeLib = 0 AND @warningTapeLib = 0 THEN @goodMessage
					ELSE @warningMessage
				END

			END

			--Top 25 growing clients by application Size
			ELSE IF @queryId = 204
			BEGIN
				DECLARE @nDays             INT = 7
				DECLARE @nTotalClients     INT = 0
				DECLARE @nGrowingClients   INT = 0
				DECLARE @nShrinkingClients INT = 0

				SELECT	@nTotalClients     = ISNULL(SUM(nClients), 0),
						@nGrowingClients   = ISNULL(SUM(CASE WHEN fromMB >= 100 THEN nClients ELSE 0 END), 0),
						@nShrinkingClients = ISNULL(SUM(CASE WHEN fromMB < -100 THEN nClients ELSE 0 END), 0)
				FROM	cf_SurveyClientGrowthBucket G
						INNER JOIN @TblLatestResult AS R ON G.SurveyResultId = R.SurveyResultId
				WHERE	G.nDaysAgo = @nDays

				DECLARE @TotalAppSizeGB BIGINT = 0
				DECLARE @NetGrowthGB    BIGINT = 0
				DECLARE @NetGrowthPct   BIGINT = 0
				DECLARE @SizeChangeStr  VARCHAR(MAX) = 'NOT APPLICABLE'

				SELECT	@TotalAppSizeGB = ISNULL(SUM(appSizeMB), 0)/1024, @NetGrowthGB = ISNULL(SUM(growthMB), 0)/1024
				FROM	cf_SurveyAgentGrowth G
						INNER JOIN @TblLatestResult AS R ON G.SurveyResultId = R.SurveyResultId
				WHERE	G.nDaysAgo = @nDays

				IF @TotalAppSizeGB > 0
					SET @NetGrowthPct = CAST(100.0*@NetGrowthGB/@TotalAppSizeGB AS DECIMAL(20,2))

				DECLARE @nTopGrowingClients  INT = 0
				DECLARE @TopClientsAppSizeGB DECIMAL(20,2) = 0
				DECLARE @TopClientsGrowthGB  DECIMAL(20,2) = 0
				DECLARE @TopClientsGrowthPct DECIMAL(20,2) = 0

				SELECT	@nTopGrowingClients = ISNULL(COUNT(DISTINCT clientId), 0), @TopClientsAppSizeGB = ISNULL(SUM(appSizeMB), 0)/1024.0, @TopClientsGrowthGB = ISNULL(SUM(growthMB), 0)/1024.0
				FROM	cf_SurveyGrowingClients G
						INNER JOIN @TblLatestResult AS R ON G.SurveyResultId = R.SurveyResultId
				WHERE	G.nDaysAgo = @nDays

				IF @TopClientsAppSizeGB > 0
					SET @TopClientsGrowthPct = CAST(100.0*@TopClientsGrowthGB/@TopClientsAppSizeGB AS DECIMAL(20,2))

				SET	@tmpStatus = @strInfo
				SET @tmpResult = ''
				SET	@tmpRecommendation = ''

				IF @nTotalClients > 0
				BEGIN
					SET @SizeChangeStr = 'Total application size ' + CASE
						WHEN @NetGrowthGB > 0 THEN 'increased <B>' + dbo.FormatBytes (@NetGrowthGB, 'GB') + ' (' +  CAST(@NetGrowthPct AS NVARCHAR(20))  + '</B>%)'
						WHEN @NetGrowthGB < 0 THEN 'decreased <B>' + dbo.FormatBytes(-@NetGrowthGB, 'GB') + ' (' +  CAST(-@NetGrowthPct AS NVARCHAR(20)) + '</B>%)'
						ELSE 'remains unchanged' END + ' from <B>' + dbo.FormatBytes(@TotalAppSizeGB, 'GB') + '</B>'
					SET @tmpResult += 'In last 7 days, application size increased for <B>'+ CAST(@nGrowingClients AS NVARCHAR(10)) + '</B> client(s), decreased for <B>'+ CAST(@nShrinkingClients AS NVARCHAR(10)) + '</B> client(s).<DELIM>'
					SET @tmpResult += @SizeChangeStr + '.<DELIM>'
					SET @tmpResult += CAST(@nTopGrowingClients AS NVARCHAR(10)) + ' client(s) contribute(s) <B>' + dbo.FormatBytes(@TopClientsGrowthGB, 'GB') + ' (' + CAST(@TopClientsGrowthPct AS NVARCHAR(20)) + '%)</B> growth of application size.<DELIM>'
					IF	@nTopGrowingClients > 0
						SET	@tmpRecommendation = '<VDL>'
				END
				ELSE
					SET @tmpResult =  'There is no change of backup size for any client.<DELIM>'
			END

			--DDB Disk Space Utilization
			ELSE IF @queryId = 206 AND @parameterName = 'DDB Disk Space Utilization'
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalDDBPath int = 0
				DECLARE @warningDDBPath int = 0
				DECLARE @criticalDDBPath int = 0
				DECLARE @unknownDDBPath int = 0

				--Disk space free: good:   > 25%   warning: 10  25%, critical < 10%
				DECLARE @DDBPathUsage TABLE
				(
					idxAccessPathId INT,
					percentFree DECIMAL(20,2),
					Days BIGINT
				)

				DECLARE @DDBCriticalDays  bigINT =30
				DECLARE @DDBWarningDays  bigINT= 90
				declare @DDBSrcTbl SrcTblType
				insert into @DDBSrcTbl
				select
					cast(SIDBStoreId as varchar(max)),
					cast(SubstoreId as varchar(max)),
					csInfo.CommServUniqueId,
					csInfo.LogDateUTC,
					csInfo.LogDate,
					DDBDiskTotalSpaceMB,
					DDBUsedDiskSpaceMB,
					DDBDiskFreeSpaceMB
					FROM cf_SurveyDeDupStoreConfig AS csInfo
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 61

				declare @DDBPeakSizeTbl PeakSizeTblType
				insert into @DDBPeakSizeTbl
				select
					cast(SIDBStoreId as varchar(max)),
					cast(SubstoreId as varchar(max)),
					CommServUniqueId as '@CommServUniqueId',
					WeekStart as '@WeekStart',
					DDBUsedDiskSpaceMB as '@DiskUsageMB',
					DDBDiskFreeSpaceMB as '@FreeDiskSpaceMB'
					from cf_SurveyDeDupStoreConfigPeakSize
					where CommServUniqueId = @i_CommServUniqueId

				DECLARE @DDBLeastSquareFit TABLE (
					CommServUniqueId int,
					SIDBStoreId int,
					SubstoreId int,
					Slope float,
					Days bigint
				)
				insert into @DDBLeastSquareFit (CommServUniqueId,SIDBStoreId,SubstoreId,Slope,Days)
				SELECT
					CommServUniqueId,
					cast(KeyCol1 as int),
					cast(KeyCol2 as int),
					Slope,
					DaysToBeFull
				from dbo.PredictDateToBeFullFunc(
					@DDBSrcTbl,
					@DDBPeakSizeTbl,
					@i_CommServUniqueId
					)

				INSERT INTO @DDBPathUsage
				SELECT
					csInfo.idxAccessPathId,
					CASE
						WHEN csInfo.DDBDiskTotalSpaceMB <= 0 THEN -1
						ELSE CAST((CASE WHEN ISNULL(csInfo.DDBUsedDiskSpaceMB, 0) <= 0 THEN 0 ELSE (1.0*csInfo.DDBDiskFreeSpaceMB)/(0.01*csInfo.DDBUsedDiskSpaceMB) END) AS DECIMAL(20,2))
					END AS percentFree,
					LSF.Days
				FROM
					cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 61
				LEFT OUTER JOIN @DDBLeastSquareFit LSF
				ON LSF.SIDBStoreId = csInfo.SIDBStoreId and LSF.SubstoreId = csInfo.SubstoreId

				SET @totalDDBPath = (SELECT COUNT(DISTINCT idxAccessPathId) FROM @DDBPathUsage)
				SET @unknownDDBPath = (select COUNT(DISTINCT idxAccessPathId) FROM @DDBPathUsage where percentFree = -1)
				SET @criticalDDBPath = (select COUNT(DISTINCT idxAccessPathId) FROM @DDBPathUsage where (percentFree >= 0 and percentFree < @criticalThreshold) or ( Days != @NA and Days != @Never and Days<@DDBCriticalDays ))
				SET @warningDDBPath = (
					SELECT COUNT(DISTINCT idxAccessPathId)
					FROM @DDBPathUsage as A
					where (
							(percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
							or
							( Days != @NA and Days != @Never and Days>=@DDBCriticalDays and Days <= @DDBWarningDays )
						)
						and A.idxAccessPathId not in (
							(select DISTINCT idxAccessPathId FROM @DDBPathUsage where (percentFree >= 0 and percentFree < @criticalThreshold) or ( Days != @NA and Days != @Never and Days<@DDBCriticalDays ))
							union all
							(select DISTINCT idxAccessPathId FROM @DDBPathUsage where percentFree = -1)
						)
				)





				SELECT
					@tmpStatus =
					CASE
						WHEN @totalDDBPath = 0 THEN @strInfo
						WHEN @criticalDDBPath > 0 THEN @strCritical
						WHEN @warningDDBPath > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalDDBPath > 0)
					BEGIN
						SET @tmpResult = 'DDB path distribution by available space: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST((@totalDDBPath-@warningDDBPath-@criticalDDBPath-@unknownDDBPath) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += '<DELIM>Excluded : <B>' + CAST(@unknownDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'There is no DDB path configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalDDBPath = 0 THEN @infoMessage
					WHEN @totalDDBPath > 0 AND @criticalDDBPath = 0 AND @warningDDBPath = 0 THEN @goodMessage
					ELSE @warningMessage
				END
			END

			--Subclients not having full backup in 60 days
			ELSE IF @queryId = 207
			BEGIN
				DECLARE @nSubclients       INT = 0
				DECLARE @nSubclients40Incr INT = 0
				DECLARE @nSubclientsNoIncr INT = 0
				DECLARE @NumOfIncrJobs     INT = 0
				DECLARE @IncrJobsAppSizeGB BIGINT = 0

				SELECT	@nSubclients       = ISNULL(COUNT(S.AppId), 0),
						@nSubclients40Incr = ISNULL(SUM(CASE WHEN NumOfIncrJobs >= 40 THEN 1 ELSE 0 END), 0),
						@nSubclientsNoIncr = ISNULL(SUM(CASE WHEN NumOfIncrJobs <= 0  THEN 1 ELSE 0 END), 0),
						@NumOfIncrJobs     = ISNULL(SUM(NumOfIncrJobs), 0),
						@IncrJobsAppSizeGB = ISNULL(SUM(IncrJobsAppSize)/1024/1024/1024, 0)
				FROM	cf_SurveySubclientsNoRecentFull S
				INNER JOIN @TblLatestResult AS R ON S.SurveyResultId = R.SurveyResultId
				INNER JOIN cf_SurveySubclientAssociation T ON T.CommservUniqueId = @i_CommServUniqueId AND T.AppId = S.AppId AND T.Deleted = 0 AND T.BackupDisabled =0
				INNER JOIN cf_SurveyCopyBasicRetention C ON T.CommservUniqueId  = C.CommservUniqueId AND S.ArchGrpId = C.PolicyId

						AND C.IsDefaultCopy = 1 AND C.IsSnapCopy = 0 AND C.Deleted = 0
								INNER JOIN cf_SurveyAgentType AT ON T.AppTypeId = AT.id

				SET	@tmpStatus = @strInfo
				SET @tmpResult = ''
				SET	@tmpRecommendation = ''

				IF @nTotalClients > 0
				BEGIN
					SET @tmpResult += '<B>'+ CAST(@nSubclients AS NVARCHAR(10)) + '</B> subclient(s) have no full backup jobs in 60 days.<DELIM>'
					SET @tmpResult += 'Total application size of jobs since the last full backup jobs is <B>' + dbo.FormatBytes(@IncrJobsAppSizeGB, 'GB') + '</B>.<DELIM>'
					SET @tmpResult += '<B>'+ CAST(@nSubclients40Incr AS NVARCHAR(10)) + '</B> subclient(s) have 40 or more backup jobs since the last full backup jobs.<DELIM>'
					SET @tmpResult += '<B>'+ CAST(@nSubclientsNoIncr AS NVARCHAR(10)) + '</B> subclient(s) have no jobs since the last full backup jobs.<DELIM>'
					IF	@nSubclients > 0
						SET	@tmpRecommendation = '<VDL>'
				END
				ELSE
					SET @tmpResult =  'There is no subclient not having full backup jobs in 60 days.<DELIM>'
			END

			--Fallen Behind Backup Copies
			ELSE IF @queryId = 209
			BEGIN
				declare @criticalBkpCopyNum int = 0
				declare @warningBkpCopyNum int = 0
				declare @totalBkpCopyNum int = 0

				DECLARE @utcTimeNow BIGINT = (SELECT dbo.getUnixTimeBig(GETUTCDATE()))

				SELECT
					@totalBkpCopyNum = COUNT(*),
					@warningBkpCopyNum = SUM (CASE WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) >= @warningThreshold AND ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) <= @criticalThreshold THEN 1 ELSE 0 END),
					@criticalBkpCopyNum = SUM (CASE WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) > @criticalThreshold THEN 1 ELSE 0 END)
				FROM cf_SurveyFallenBehindBackupCopies AS csInfo WITH (NOLOCK)
				WHERE CommservUniqueId = @i_CommServUniqueId

				SET @tmpStatus =
					CASE
						WHEN @criticalBkpCopyNum > 0 THEN @strCritical
						WHEN @warningBkpCopyNum > 0 THEN @strwarning
						WHEN @totalBkpCopyNum > 0 THEN @strGood
						ELSE @strInfo
					END

				IF (@totalBkpCopyNum > 0)
					BEGIN
						SET @tmpResult = 'Backup Copies: <DELIM>'
						SET @tmpResult += 'Total: <B>'+ CAST(@totalBkpCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good: <B>' + CAST((@totalBkpCopyNum-@warningBkpCopyNum-@criticalBkpCopyNum) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning: <B>' + CAST(@warningBkpCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical: <B>' + CAST(@criticalBkpCopyNum AS NVARCHAR(5)) + '</B>'
					END
				ELSE
					SET @tmpResult =  'There are no Fallen Behind Backup Copies.<DELIM>'

				SET @tmpRecommendation =
					CASE
						WHEN @totalBkpCopyNum = 0 THEN @infoMessage
						WHEN @criticalBkpCopyNum = 0 AND @warningCopyNum = 0 THEN  @goodMessage
						WHEN @criticalBkpCopyNum = 0 THEN @warningMessage
						ELSE @criticalMessage
					END
			END

			--Recoverability SLA
			ELSE IF @queryId = 211
			BEGIN
				DECLARE @nClientsTotal     INT = 0
				DECLARE @nClientsMet       INT = 0
				DECLARE @nClientsNotMet    INT = 0
				DECLARE @RecoverabilityPct INT = 0

				SELECT	@nClientsTotal = COUNT(DISTINCT S.ClientId)
				FROM	cf_SurveyRecoverabilitySLA S
						INNER JOIN @TblLatestResult AS R ON S.SurveyResultId = R.SurveyResultId
						LEFT OUTER JOIN (
							SELECT	DISTINCT ClientId
							FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
									INNER JOIN dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R
										ON R.SurverResultId = S.SurveyResultId AND (S.Days = 30 OR S.Days < 0)
						) C ON S.ClientId = C.ClientId
				WHERE	LastJobId > 0 OR C.ClientId IS NOT NULL

				SELECT	@nClientsMet = COUNT(DISTINCT S.ClientId)
				FROM	cf_SurveyRecoverabilitySLA S
						INNER JOIN @TblLatestResult AS R ON S.SurveyResultId = R.SurveyResultId
						LEFT OUTER JOIN (
							SELECT	DISTINCT ClientId
							FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
									INNER JOIN dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R
										ON R.SurverResultId = S.SurveyResultId AND (S.Days = 30 OR S.Days < 0)
						) C ON S.ClientId = C.ClientId
				WHERE	LastJobId > 0 AND RTAMinutes >= 0 AND RTAMinutes <= RTOMinutes AND C.ClientId IS NULL

				SET @nClientsNotMet = (@nClientsTotal - @nClientsMet)
				SET	@RecoverabilityPct = CAST((CASE WHEN @nClientsTotal > 0 THEN @nClientsMet*100.0/@nClientsTotal ELSE 0 END) AS INT)

				SET	@tmpStatus = @strInfo
				SET @tmpResult = ''
				SET	@tmpRecommendation = ''

				IF @nClientsTotal > 0
				BEGIN
					SET @tmpResult = 'SLA is <b>'+ CAST (@RecoverabilityPct AS NVARCHAR(6)) + ' %.</b><DELIM>'
					SET @tmpResult += 'Met SLA : <b>' + CAST (@nClientsMet AS NVARCHAR(10)) + '</b>, Missed SLA : <b>' + CAST (@nClientsNotMet AS NVARCHAR(10)) + '</b>'
					SET	@tmpRecommendation = '<VDL>'
				END
				ELSE
					SET @tmpResult = 'No data available.<DELIM>'
			END

			--Copy Redundancy SLA
			ELSE IF @queryId = 212
			BEGIN
				SET @nClientsTotal  = 0
				SET @nClientsMet    = 0
				SET @nClientsNotMet = 0
				DECLARE @RedundancyPct INT = 0

				SELECT	@nClientsTotal = COUNT(DISTINCT S.ClientId)
				FROM	cf_SurveyRecoverabilitySLA S
						INNER JOIN @TblLatestResult AS R ON S.SurveyResultId = R.SurveyResultId
						LEFT OUTER JOIN (
							SELECT	DISTINCT ClientId
							FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
									INNER JOIN dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R
										ON R.SurverResultId = S.SurveyResultId AND (S.Days = 30 OR S.Days < 0)
						) C ON S.ClientId = C.ClientId
				WHERE	LastJobId > 0 OR C.ClientId IS NOT NULL

				SELECT	@nClientsMet = COUNT(DISTINCT S.ClientId)
				FROM	cf_SurveyRecoverabilitySLA S
						INNER JOIN @TblLatestResult AS R ON S.SurveyResultId = R.SurveyResultId
						LEFT OUTER JOIN (
							SELECT	DISTINCT ClientId
							FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
									INNER JOIN dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R
										ON R.SurverResultId = S.SurveyResultId AND (S.Days = 30 OR S.Days < 0)
						) C ON S.ClientId = C.ClientId
				WHERE	LastJobId > 0 AND C.ClientId IS NULL AND MinRedundancy >= CopyRedundancy AND MaxBehindDays <= CopyBehindDays

				SET @nClientsNotMet = (@nClientsTotal - @nClientsMet)
				SET	@RedundancyPct  = CAST((CASE WHEN @nClientsTotal > 0 THEN @nClientsMet*100.0/@nClientsTotal ELSE 0 END) AS INT)

				SET	@tmpStatus = @strInfo
				SET @tmpResult = ''
				SET	@tmpRecommendation = ''

				IF @nClientsTotal > 0
				BEGIN
					SET @tmpResult = 'SLA is <b>'+ CAST (@RedundancyPct AS NVARCHAR(6)) + ' %.</b><DELIM>'
					SET @tmpResult += 'Met SLA : <b>' + CAST (@nClientsMet AS NVARCHAR(10)) + '</b>, Missed SLA : <b>' + CAST (@nClientsNotMet AS NVARCHAR(10)) + '</b>'
					SET	@tmpRecommendation = '<VDL>'
				END
				ELSE
					SET @tmpResult = 'No data available.<DELIM>'
			END
			ELSE IF @queryId = 214
				BEGIN
					DECLARE @CGCount INT = 0 ,
					@CCount INT = 0,
					@SCCount INT = 0,
					@MACount INT = 0,
					@ArrayCount INT = 0,
					@AlertCount INT = 0,
					@UserGroupCount  INT = 0,
					@UserCount  INT = 0,
					@policyCount INT = 0,
					@SPCount INT = 0,
					@LibCount INT = 0

					SET @CGCount = (SELECT count(CG.ClientGroupId )
					FROM cf_SurveyClientGroup CG WITH(NOLOCK)
					LEFT OUTER JOIN cf_SurveyClientGroupAssociation CGA WITH(NOLOCK) ON CG.CommservUniqueId = CGA.CommservUniqueId AND CGA.clientGroupId = CG.clientGroupId
					WHERE	CGA.clientId IS NULL AND  CG.CommservUniqueId = @i_CommServUniqueID AND CG.DeletedDate IS NULL)

					DECLARE  @SurveyResultId_215  INT = (select SurverResultId from  dbo.cf_SurveyResultFuncV1(215,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1))
					DECLARE  @SurveyResultId_214  INT = (select SurverResultId from  dbo.cf_SurveyResultFuncV1(214,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1))
					DECLARE  @SurveyResultId_217  INT = (select SurverResultId from  dbo.cf_SurveyResultFuncV1(217,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1))

				SET @CCount = ( select COUNT(DISTINCT clientId) from cf_surveycleanupClient csInfo where
				csInfo.SurveyResultId = @SurveyResultId_217)


				SET @SCCount = (select count(DISTINCT AppId)  from cf_surveySubclientAssociation CS1
				where BackupDisabled = 1 AND CS1.CommServUniqueId = @i_CommServUniqueID AND (CS1.deleted = 0 OR CS1.SubclientStatus & 4 = 0))

				SET @MACount = (select COUNT(DISTINCT csInfo.MAID)  from cf_SurveyMANotUsed csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_215)

				DECLARE @tempArray TABLE (ArrayId INT)

				INSERT INTO @tempArray
				select csInfo.ArrayId from cf_SurveyArrayWithoutClient csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_215

				INSERT INTO @tempArray
				select csInfo.ArrayId from cf_SurveyArrayWithOrphanSnap csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_215

				INSERT INTO @tempArray
				select csInfo.ArrayId from cf_SurveyDeleteFailSnapArray csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_215


				SET @ArrayCount = ( select COUNT(DISTINCT ArrayId) from @tempArray)


				SET @AlertCount = (select COUNT(csInfo.AlertId)  from cf_SurveyAlertsWithoutUsers csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_214)


				SET @UserCount = (select count(csInfo.UserId)  from cf_SurveyUserNotLoggedIn csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_214)


				SET @UserGroupCount = (select count(csInfo.UserGroupId)  from cf_SurveyCleanupUserGroup csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_214)



				SET @policyCount =( select count(DISTINCT C.PolicyId)  from cf_SurveySchedulePolicyUsage C
				INNER JOIN dbo.cf_SurveyResultFuncV1(22,0,1,NULL,NULL,@i_UserId,-1) AS resultView ON
				resultView.SurverResultId = C.SurveyResultId AND resultview.CommServUniqueId = @i_CommServUniqueID
				where Disable = 1)


				SET @LibCount = (select COUNT(LibraryId)  from cf_SurveyCleanupLibrary csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_215)

				SET @SPCount = (select COUNT(DISTINCT SPID)  from cf_SurveyCleanupPolicy csInfo
				where
				csInfo.SurveyResultId = @SurveyResultId_215)

				SET	@tmpStatus = @strInfo

				SET @tmpResult = ''
				IF (@CCount > 0)
				SET @tmpResult += '<div>Clients : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Clients&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(@CCount AS VARCHAR(128))+'</a>, '
				ELSE
				SET @tmpResult += 'Client : None, '
				IF (@CGCount > 0)
				SET @tmpResult += 'Client Groups : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Clients&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(@CGCount AS VARCHAR(128))+'</a>, '
				ELSE
				SET @tmpResult += 'Client Group : None, '
				IF (@MACount > 0)
				SET @tmpResult += 'MediaAgents : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Media&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(@MACount AS VARCHAR(128))+'</a>, '
		        ELSE
				SET @tmpResult += 'MediaAgent : None, '
				IF (@ArrayCount> 0)
				SET @tmpResult += ' Arrays : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Media&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(@ArrayCount AS VARCHAR(128))+'</a>, '
				ELSE
				SET @tmpResult += 'Array : None, '
				IF (@AlertCount > 0)
				SET @tmpResult += 'Alerts : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Alerts&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(@AlertCount AS VARCHAR(128))+' </a>, '
				ELSE
				SET @tmpResult += 'Alert : None, '
				IF (@SCCount > 0)
				SET @tmpResult += 'Subclients : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=SubClients&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(@SCCount AS VARCHAR(128))+'</a>, '
				ELSE
				SET @tmpResult += 'Subclient : None, '
				IF (@policyCount > 0)
				SET @tmpResult += 'Policies : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Policies&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(@policyCount AS VARCHAR(128))+' </a>, '
				ELSE
				SET @tmpResult += 'Policies : None, '
				IF (@UserGroupCount   > 0)
				SET @tmpResult += 'UserGroups :  <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Security&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(@UserGroupCount AS VARCHAR(128))+'</a>, '
				ELSE
				SET @tmpResult += 'UserGroup : None, '
				IF (@UserCount   > 0)
				SET @tmpResult += 'Users : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Security&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(@UserCount AS VARCHAR(128))+'</a>, '
				ELSE
				SET @tmpResult += 'User : None, '
				IF (@LibCount  > 0)
				SET @tmpResult += 'Libraries : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Storage&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(@LibCount AS VARCHAR(128))+' </a>, '
				ELSE
				SET @tmpResult += 'Libraries : None, '
				IF (@SPCount > 0)
				SET @tmpResult += 'Storage Policies : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Storage&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(@SPCount AS VARCHAR(128))+' </a></div>'
				ELSE
				SET @tmpResult += 'Storage Policies : None  </div><b>'



					IF (@CGCount + @CCount + @SCCount+@MACount+@ArrayCount+@AlertCount +@UserGroupCount+@UserCount  +@policyCount +@SPCount +@LibCount <= 0 )
					BEGIN
					SET @tmpResult = 'No items to clean up.'
					SET	@tmpRecommendation = 'Everything is looking good. No need to Cleanup.'
					END
					ELSE
					SET	@tmpRecommendation = ' View the items in the list above to clean up your CommCell environment.<VDL><VDL_CR>MetricsCleanupReport&pageName=Details&input.CommCell='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'

			END

			UPDATE	@TblSurveyResult
			SET		Status = ISNULL(@tmpStatus, @strUnknown),
					LogDate = @tmpLogDate,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation
			WHERE	MonitorId = @queryId AND (@parameterName = '' OR Monitor = @parameterName)

			FETCH NEXT FROM HealthQueryCur
			INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage
		END

		UPDATE @TblSurveyResult
		SET		ParamId = H.ParamId
		FROM	@TblSurveyResult T, cf_SurveyHealthParam H
		WHERE	T.Monitor = H.ParameterName

		CLOSE HealthQueryCur
		DEALLOCATE HealthQueryCur

	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetServerHealthFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetServerHealthFunc' AND revision = '1.74.2.101')

  insert into GXDBVersions values(5, 'RptGetServerHealthFunc',  '1.74.2.101', 'RptGetServerHealthFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
