

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetMetricsQueryFlags.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetMetricsQueryFlags'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetMetricsQueryFlags]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetMetricsQueryFlags]
  delete from GXDBVersions where name = 'RptGetMetricsQueryFlags' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetMetricsQueryFlags]
	(
		@i_queryId INT = 0	--QueryId = 0 returns all queries. Pass a queryId to get the results for that query
	)
	RETURNS @Results TABLE
	(
		QueryId INTEGER NOT NULL,
		QueryFlags VARCHAR(32) NOT NULL,
		QueryEnabled INTEGER NOT NULL,
		DataRetentionDays INTEGER NOT NULL
	)
	AS
	BEGIN

	DECLARE @QueryFlags TABLE(QueryId int, DefaultFlags int, ReportStatus int, Retention int)

	INSERT INTO @QueryFlags
	SELECT
		Q.QueryId,
		Q.Flags AS DefaultFlag,
		MAX(
		CASE
			WHEN u.props.value('@status','int') IS NULL
			THEN R.Status
			ELSE u.props.value('@status','int')
		END) AS ReportStatus,
		CASE WHEN MAX(ISNULL(u.props.value('@retention', 'int'),0)) = 0 THEN Q.DataRetentionDays
			 ELSE MAX(ISNULL(u.props.value('@retention', 'int'),0))
		END
	FROM cf_CommservSurveyQueries Q WITH(NOLOCK)
		LEFT OUTER JOIN cf_WebConsoleReportQueryMap M WITH(NOLOCK) ON Q.QueryId = M.QueryId
		LEFT OUTER JOIN cf_WebConsoleReports R WITH(NOLOCK) ON R.ReportId = M.ReportId AND ISNULL(R.ReportId,0) < 1000	--Special reports need not be considered
		OUTER APPLY R.userModifiedProps.nodes('/userModifiedProps') AS u(props)
	WHERE (@i_QueryId = 0 OR Q.QueryId = @i_QueryId)
	GROUP BY Q.QueryId, Q.Flags, Q.DataRetentionDays

	INSERT INTO @Results
	SELECT Q.QueryId,
		CASE
			WHEN ISNULL(Q.ReportStatus, 1) = 1 THEN Q.DefaultFlags
			ELSE Q.ReportStatus --0
		END,
		CASE
			WHEN Q.ReportStatus IS NULL THEN (Q.DefaultFlags & 2)/2  --1 or 0
			ELSE Q.ReportStatus --0
		END,
		Retention
	FROM @QueryFlags Q

	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetMetricsQueryFlags]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetMetricsQueryFlags' AND revision = '1.1.2.6')

  insert into GXDBVersions values(5, 'RptGetMetricsQueryFlags',  '1.1.2.6', 'RptGetMetricsQueryFlags', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
