

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetServicePackSortRank.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetServicePackSortRank'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetServicePackSortRank]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetServicePackSortRank]
  delete from GXDBVersions where name = 'GetServicePackSortRank' and type = 5
END
GO

 CREATE FUNCTION GetServicePackSortRank ( @Version nvarchar(32) )
 RETURNS INT
 WITH ENCRYPTION
 AS
 BEGIN
	IF  ISNULL(@Version, '') = '' RETURN 0
	SET @Version = LTRIM(@Version)
	IF  ISNUMERIC(LEFT(@Version, 1)) = 0 RETURN 0
	SET @Version = RTRIM(@Version)
	IF  RIGHT(@Version, 1) IN ('-', '+') SET @Version = LEFT(@Version, LEN(@Version)-1)

	DECLARE @posSP  INT = 0
	DECLARE @posHPK INT = 0
	DECLARE @relNo  INT = 0
	DECLARE @spNo   INT = 0
	DECLARE @hpkNo  INT = 0
	DECLARE @posSPEnd INT = 0
	DECLARE @spStr	nvarchar(32)

 	IF(CHARINDEX('SP', @Version) > 0)
 	BEGIN
 		SET @posSP = CHARINDEX('SP', @Version)
 		SET @relNo = CAST(SUBSTRING(@Version, 0, @posSP) AS FLOAT)
 		SET @Version = SUBSTRING(@Version, @posSP, LEN(@Version))
 		SET @posSP = CHARINDEX('SP', @Version)

 		IF(CHARINDEX('HPK',@Version, @posSP) > 0)
 		BEGIN
 			SET @posSPEnd = CHARINDEX('HPK',@Version)
 			SET @posHPK = @posSPEnd + 3
 		END
 		ELSE IF(CHARINDEX('.',@Version) > 0)
 		BEGIN
 			SET @posSPEnd = CHARINDEX('.',@Version)
 			SET @posHPK = @posSPEnd + 1
 		END

 		IF  ASCII(RIGHT(@Version, 1)) >= 97
 		BEGIN
 			SET @hpkNo = ASCII(RIGHT(@Version, 1)) - 96
 			SET @Version = LEFT(@Version, LEN(@Version)-1)
 		END

 		SET @spStr = RTRIM(SUBSTRING(@Version, @posSP+2, CASE WHEN @posSPEnd > 0 THEN @posSPEnd-@posSP-2 ELSE LEN(@Version) END))
 		IF  RIGHT(@spStr, 1) IN ('-', '+') SET @spStr = LEFT(@spStr, LEN(@spStr)-1)
 		SET @spNo = CAST(@spStr AS FLOAT)
 		SET @hpkNo = CASE WHEN @posHPK > 0 THEN CAST(SUBSTRING(@Version, @posHPK, LEN(@Version)) AS FLOAT) ELSE @hpkNo END
 	END
 	ELSE IF(CHARINDEX('.', @Version) > 0)
 	BEGIN
 		SET @posSP = CHARINDEX('.', @Version)
 		SET @relNo = CAST(SUBSTRING(@Version, 0, @posSP) AS FLOAT)
 		SET @posHPK = CHARINDEX('.', @Version, @posSP+1)
 		SET @spNo = CAST(SUBSTRING(@Version, @posSP+1, CASE WHEN @posHPK > 0 THEN @posHPK ELSE LEN(@Version) END) AS FLOAT)
 		SET @hpkNo = CASE WHEN @posHPK > 0 THEN CAST(SUBSTRING(@Version, @posHPK+1, LEN(@Version)) AS FLOAT) ELSE 0 END
 	END
 	ELSE
 	BEGIN
 		SET @relNo = CAST(RTRIM(@Version) AS FLOAT)
 	END

	RETURN (@relNo*100000 + @spNo*1000 + @hpkNo)
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetServicePackSortRank]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetServicePackSortRank' AND revision = '1.5.44.4')

  insert into GXDBVersions values(5, 'GetServicePackSortRank',  '1.5.44.4', 'GetServicePackSortRank', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
