

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetRenderedValue.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetRenderedValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetRenderedValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetRenderedValue]
  delete from GXDBVersions where name = 'GetRenderedValue' and type = 5
END
GO

	CREATE FUNCTION [dbo].[GetRenderedValue]
	(
	   @inputValue		NVARCHAR(MAX),
	   @renderer		NVARCHAR(128),
	   @dataType		NVARCHAR(128)
	)
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
		DECLARE @output NVARCHAR(MAX)

		IF ISNULL(@renderer, '') = ''
			SET @output = @inputValue
		ELSE IF ISNULL(@renderer, '') = 'booleanRenderer'
		BEGIN
			IF (@inputValue = 'true' OR @inputValue = 'yes')
				SET @output = 'Yes'
			ELSE
				SET @output = 'No'
		END
		ELSE IF ISNULL(@renderer, '') = 'dateTimeRenderer'
			SET @output = CAST (dbo.GetDateTime(@inputValue) AS NVARCHAR(MAX))
		ELSE IF ISNULL(@renderer, '') = 'MMMYYYY' AND ISNULL(@dataType,'') like '%varchar'
			SET @output = (SELECT convert(CHAR(3), CAST (@inputValue AS DATE), 0) + ' ' + DATENAME(YEAR, @inputValue))
		ELSE IF ISNULL(@renderer, '') = 'MMMYYYY' AND ISNULL(@dataType,'') like '%int'
			SET @output = (SELECT convert(CHAR(3), CAST (dbo.GetDateTime(@inputValue) AS DATE), 0) + ' ' + DATENAME(YEAR, dbo.GetDateTime(@inputValue)))
		ELSE IF ISNULL(@renderer, '') = 'HEALTH_STATUS'
		BEGIN
			IF @inputValue = '0_Unknown'
				SET @output = 'Unknown'
			IF @inputValue = '1_Good'
				SET @output = 'Good'
			IF @inputValue = '2_Info'
				SET @output = 'Info'
			IF @inputValue = '3_Warning'
				SET @output = 'Warning'
			IF @inputValue = '4_Critical'
				SET @output = 'Critical'
		END
		ELSE IF ISNULL(@renderer, '') like 'Number%'
		BEGIN
			IF ISNULL(@renderer, '') = 'NumberNA' AND CAST(@inputValue AS DECIMAL(38,7)) < 0
				SET @output = 'N/A'
			ELSE IF ISNULL(@renderer, '') = 'NumberUnlimitedNA' AND CAST(@inputValue AS DECIMAL(38,7)) = -1.0
				SET @output = 'Unlimited'
			ELSE IF ISNULL(@renderer, '') = 'NumberUnlimitedNA' AND CAST(@inputValue AS DECIMAL(38,7)) = -2.0
				SET @output = 'N/A'
			ELSE
				SET @output = CAST(@inputValue AS NVARCHAR(MAX))
		END
		ELSE IF ISNULL(@renderer, '') = 'capacityMB' OR ISNULL(@renderer, '') = 'sizeMB'
		BEGIN
			IF CAST(@inputValue AS DECIMAL(38,7)) < 0
				SET @output = 'N/A'
			ELSE
				SET @output = CAST( dbo.FormatBytes ( CAST(@inputValue AS DECIMAL(38,7)), 'MB') AS NVARCHAR(MAX) )
		END
		ELSE IF ISNULL(@renderer, '') = 'MMMDDYYYY' OR ISNULL(@renderer, '') = 'MMMDDYYYYHrMinAM' OR ISNULL(@renderer, '') = 'HHMMSS' OR ISNULL(@renderer, '') = 'DWDDMMM'
		BEGIN
			IF @inputValue >= 0 AND @renderer = 'MMMDDYYYY'
				SET @output = CONVERT(VARCHAR(20),dbo.GetDateTime(@inputValue),107)
			ELSE IF @inputValue >= 0 AND @renderer = 'MMMDDYYYYHrMinAM'
				SET @output = CONVERT(VARCHAR(30),dbo.GetDateTime(@inputValue),100)
			ELSE IF @inputValue >= 0 AND @renderer = 'HHMMSS'
				SET @output = CONVERT(VARCHAR(20),dbo.GetDateTime(@inputValue),108)
			ELSE IF @inputValue >= 0 AND @renderer = 'DWDDMMM'
				SET @output = DATENAME(DW, dbo.GetDateTime(@inputValue)) + ' (' + CAST(DATEPART(DAY, dbo.GetDateTime(@inputValue)) as nvarchar(10))
							+ ' ' + CAST(DATENAME(MONTH, dbo.GetDateTime(@inputValue)) as nvarchar(3)) + ')'
			ELSE IF @inputValue >= 0 AND @renderer = 'DATETIME'
				SET @output = CONVERT(VARCHAR(20),dbo.GetDateTime(@inputValue),100)
			ELSE IF @inputValue = -2
				SET @output = 'Nothing to Copy'
			ELSE IF @inputValue = -3
				SET @output = 'Never'
			ELSE IF @inputValue = -4
				SET @output = 'History unavailable to estimate time'
			ELSE IF @inputValue = -5
				SET @output = 'Jan 1, 2038'
			ELSE IF @inputValue = -50
				SET @output = 'N/A'
			ELSE IF @inputValue = -100
				SET @output = ''
			ELSE
				SET @output = 'N/A'
		END
		ELSE
			SET @output = @inputValue



	   -- Return the result of the function
	   RETURN REPLACE(@output,'''','''''')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetRenderedValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetRenderedValue' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetRenderedValue',  '1.4', 'GetRenderedValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
