

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetLatestSurvey.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: GetLatestSurvey'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLatestSurvey]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLatestSurvey]
  delete from GXDBVersions where name = 'GetLatestSurvey' and type = 5
END
GO

	CREATE FUNCTION [dbo].[GetLatestSurvey]
	(
		@i_CommServUniqueId INT = 0,
		@i_QueryId INT
	)
	RETURNS @TblLatestSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		LogDateUTC DATETIME NOT NULL,
		SurveyResultId BIGINT NOT NULL
	)
	AS
	BEGIN
		INSERT INTO @TblLatestSurveyResult
		SELECT
			sub1.CommServUniqueId,
			sub1.LogDateUTC,
			sub1.SurverResultId
		FROM
		(
			(SELECT
				CommServUniqueId,
				SurveyID,
				LogDateUTC,
				SurverResultId,
				ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, SurveyID ORDER BY CommServUniqueId, LogDateUTC DESC) AS RowId
			FROM cf_SurveyResultView WITH (NOLOCK, READUNCOMMITTED)) AS Sub1
			INNER JOIN cf_SurveyResultView AS Sub2 WITH (NOLOCK, READUNCOMMITTED)
				ON Sub1.RowId = 1
				AND Sub1.CommServUniqueId = Sub2.CommServUniqueId
				AND Sub1.SurverResultId = Sub2.SurverResultId
				AND Sub1.SurveyID = Sub2.SurveyID
				AND ((Sub2.CommServUniqueId = @i_CommServUniqueId) OR (@i_CommServUniqueId = 0))
				AND Sub2.SurveyID = @i_QueryId
		)
	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLatestSurvey]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLatestSurvey' AND revision = '1.1.90.1')

  insert into GXDBVersions values(5, 'GetLatestSurvey',  '1.1.90.1', 'GetLatestSurvey', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
