

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetDateTimeBig.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTimeBig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTimeBig]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTimeBig]
  delete from GXDBVersions where name = 'GetDateTimeBig' and type = 5
END
GO

	CREATE FUNCTION GetDateTimeBig (@UnixTimeArg bigint)
	RETURNS DATETIME
	-- WITH ENCRYPTION
	AS
	BEGIN
	declare @l_MAXINT int = 2147483647
	/*DateAdd function doesn't take bigint - so split the input into a number of max ints
	and call DateAdd for each*/
	if(@UnixTimeArg > @l_MAXINT)
	begin
		declare @iterations bigint
		declare @reminder int
		declare @dateVar datetime = '01/01/1970'
		SET @iterations = @UnixTimeArg/@l_MAXINT
		SET @reminder = @UnixTimeArg%@l_MAXINT
		WHILE(@iterations > 0)
		begin
			select @dateVar = dateadd(second,@l_MAXINT,@dateVar)
			SET @iterations = @iterations - 1
		end
		IF @reminder > 0
			select @dateVar = dateadd(second,@reminder,@dateVar)
		return @dateVar
	end
	return dateadd(second, @UnixTimeArg, '01/01/1970')
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTimeBig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTimeBig' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'GetDateTimeBig',  '1.1.2.1', 'GetDateTimeBig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
