SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/utf8_2_ucs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: utf8_2_ucs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[utf8_2_ucs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[utf8_2_ucs]
  delete from GXDBVersions where name = 'utf8_2_ucs' and type = 5
END
GO

	CREATE FUNCTION utf8_2_ucs( @inValue varchar(2048) )
		RETURNS nvarchar(2048)
		AS
		BEGIN
		DECLARE @binValue varbinary(4096)
		DECLARE @outValue nvarchar(2048)

		exec master.dbo.xp_utf8_2_ucs @inValue, @binValue OUTPUT
		set @outValue = @binValue

		RETURN 	@outValue
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [utf8_2_ucs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'utf8_2_ucs' AND revision = '1.2')

  insert into GXDBVersions values(5, 'utf8_2_ucs',  '1.2', 'utf8_2_ucs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/FormatBytes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: FormatBytes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[FormatBytes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[FormatBytes]
  delete from GXDBVersions where name = 'FormatBytes' and type = 5
END
GO

	CREATE FUNCTION [dbo].[FormatBytes]
	(
	   @InputNumber   DECIMAL(38,7),
	   @InputUOM      VARCHAR(5) = 'Bytes'
	)
	RETURNS VARCHAR(20)
	WITH SCHEMABINDING
	AS
	BEGIN
	   -- Declare the return variable here
	   DECLARE @Output VARCHAR(48)
	   DECLARE @Prefix MONEY
	   DECLARE @Suffix VARCHAR(6)
	   DECLARE @Multiplier DECIMAL(38,2)
	   DECLARE @Bytes  DECIMAL(38,2)

	   SELECT @Multiplier =
	      CASE @InputUOM
	         WHEN 'Bytes'         THEN 1
	         WHEN 'Byte'          THEN 1
	         WHEN 'B'             THEN 1
	         WHEN 'Kilobytes'     THEN 1024
	         WHEN 'Kilobyte'      THEN 1024
	         WHEN 'KB'            THEN 1024
	         WHEN 'Megabytes'     THEN 1048576
	         WHEN 'Megabyte'      THEN 1048576
	         WHEN 'MB'            THEN 1048576
	         WHEN 'Gigabytes'     THEN 1073741824
	         WHEN 'Gigabyte'      THEN 1073741824
	         WHEN 'GB'            THEN 1073741824
	         WHEN 'Terabytes'     THEN 1099511627776
	         WHEN 'Terabyte'      THEN 1099511627776
	         WHEN 'TB'            THEN 1099511627776
	         WHEN 'Petabytes'     THEN 1125899906842624
	         WHEN 'Petabyte'      THEN 1125899906842624
	         WHEN 'PB'            THEN 1125899906842624
	         WHEN 'Exabytes'      THEN 1152921504606846976
	         WHEN 'Exabyte'       THEN 1152921504606846976
	         WHEN 'EB'            THEN 1152921504606846976
	         WHEN 'Zettabytes'    THEN 1180591620717411303424
	         WHEN 'Zettabyte'     THEN 1180591620717411303424
	         WHEN 'ZB'            THEN 1180591620717411303424
	         WHEN 'Yottabytes'    THEN 1208925819614629174706176
	         WHEN 'Yottabyte'     THEN 1208925819614629174706176
	         WHEN 'YB'            THEN 1208925819614629174706176
	         WHEN 'Brontobytes'   THEN 1237940039285380274899124224
	         WHEN 'Brontobyte'    THEN 1237940039285380274899124224
	         WHEN 'BB'            THEN 1237940039285380274899124224
	         WHEN 'Geopbytes'     THEN 1267650600228229401496703205376
	         WHEN 'Geopbyte'      THEN 1267650600228229401496703205376
	      END

	   SELECT @Bytes = @InputNumber*@Multiplier

	   SELECT @Prefix =
	      CASE
	         WHEN ABS(@Bytes) < 1024 THEN @Bytes --bytes
	         WHEN ABS(@Bytes) < 1048576 THEN (@Bytes/1024) --kb
	         WHEN ABS(@Bytes) < 1073741824 THEN (@Bytes/1048576) --mb
	         WHEN ABS(@Bytes) < 1099511627776 THEN (@Bytes/1073741824) --gb
	         WHEN ABS(@Bytes) < 1125899906842624 THEN (@Bytes/1099511627776) --tb
	         WHEN ABS(@Bytes) < 1152921504606846976 THEN (@Bytes/1125899906842624) --pb
	         WHEN ABS(@Bytes) < 1180591620717411303424 THEN (@Bytes/1152921504606846976) --eb
	         WHEN ABS(@Bytes) < 1208925819614629174706176 THEN (@Bytes/1180591620717411303424) --zb
	         WHEN ABS(@Bytes) < 1237940039285380274899124224 THEN (@Bytes/1208925819614629174706176) --yb
	         WHEN ABS(@Bytes) < 1267650600228229401496703205376 THEN (@Bytes/1237940039285380274899124224) --bb
	         ELSE (@Bytes/1267650600228229401496703205376) --geopbytes
	      END,
	          @Suffix =
	     CASE
	         WHEN ABS(@Bytes) < 1024 THEN ' Bytes'
	         WHEN ABS(@Bytes) < 1048576 THEN ' KB'
	         WHEN ABS(@Bytes) < 1073741824 THEN ' MB'
	         WHEN ABS(@Bytes) < 1099511627776 THEN ' GB'
	         WHEN ABS(@Bytes) < 1125899906842624 THEN ' TB'
	         WHEN ABS(@Bytes) < 1152921504606846976 THEN ' PB'
	         WHEN ABS(@Bytes) < 1180591620717411303424 THEN ' EB'
	         WHEN ABS(@Bytes) < 1208925819614629174706176 THEN ' ZB'
	         WHEN ABS(@Bytes) < 1237940039285380274899124224 THEN ' YB'
	         WHEN ABS(@Bytes) < 1267650600228229401496703205376 THEN ' BB'
	         ELSE ' Geopbytes'
	      END

	   -- Return the result of the function
	   SELECT @Output = CAST(@Prefix AS VARCHAR(39)) + @Suffix
	   RETURN @Output
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [FormatBytes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'FormatBytes' AND revision = '1.2')

  insert into GXDBVersions values(5, 'FormatBytes',  '1.2', 'FormatBytes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/cf_SurveyResultFuncV1.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: cf_SurveyResultFuncV1'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_SurveyResultFuncV1]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cf_SurveyResultFuncV1]
  delete from GXDBVersions where name = 'cf_SurveyResultFuncV1' and type = 5
END
GO

	CREATE FUNCTION [dbo].[cf_SurveyResultFuncV1] (
		@i_QueryId		INT,
		@i_CSUniqueId	INT = 0,
		@i_LatestOnly	INT = 1,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEnd	DATETIME = NULL,
        @i_UserId       INT = NULL,
        @i_GroupId      INT = -1
	 )
	 RETURNS @Results TABLE (
	 	CommServUniqueId INT,
		CommCellID       VARCHAR(32),
		CommServIP       VARCHAR(256),
		CommServGUID     VARCHAR(256),
		CustomerName     NVARCHAR(256),
		CommServName     NVARCHAR(256),
		CommServTimeZone VARCHAR(256),
		CommServVersion  VARCHAR(256),
		CommServEdition	 VARCHAR(256),
		SurverResultId   INT,
		SurveyID         INT,
		LogDate          DATETIME,
		LogDateUTC       DATETIME,
		RunningTime      INT,
		SureyResultFlags INT
	 )
	 AS
	 BEGIN
	 	DECLARE @UserCapability INT = -1
	 	DECLARE @UserProp xml

	 	DECLARE @IncludeDisabled INT = 0
	 	SET @IncludeDisabled = @i_LatestOnly & 2
	 	SET @i_LatestOnly = @i_LatestOnly & 1

	 	DECLARE @CommcellTbl TABLE (
	 		 	ID				 INT,
	 			CommCellID       VARCHAR(32),
	 			CommServIP       VARCHAR(256),
	 			CommServGUID     VARCHAR(256),
	 			CustomerName     NVARCHAR(256),
	 			CommServName     NVARCHAR(256),
	 			CommServTZ		 VARCHAR(256),
	 			CommServVersion  VARCHAR(256),
	 			CommServEdition  VARCHAR(256)
	 		)

	 	SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)
	 	IF @i_UserId = -1
	 		SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = 1)
	 	ELSE
	 		SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)

	 	IF (@i_UserId = -1 OR @UserCapability = 1)
		BEGIN
	 		IF (ISNULL(@i_GroupId, 0) <= 0) --Group Id is not provided. Take all accessible commcells
	 	 		INSERT INTO @CommcellTbl
	 	 		SELECT	ID, CommCellID, CommServIP, CommServGUID, CustomerName, CommServName, CommServTZ, CommServVersion, CommServEdition
	 	 			FROM	cf_CommcellIdNameMap WITH (NOLOCK)
	 	   		WHERE	(ID = @i_CSUniqueId) OR (@i_CSUniqueId = 0 AND (@IncludeDisabled > 0  OR (Flags & 1) <> 1))
	 		ELSE --Group id is provided take the commcells in that group
	 		BEGIN
	 			;WITH VisibleGroups (groupId) AS
	 			(
	 				SELECT  clientGroup.value('@clientGroupId', 'INT')
	 				FROM    @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
	 						CROSS APPLY resp.nodes('commcellGroups') AS clientGroup(clientGroup)
	 				WHERE   clientGroup.value('@clientGroupId', 'INT') = @i_GroupId
	 			)
	 			INSERT INTO @CommcellTbl
	 			SELECT  ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition
	 			FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 					INNER JOIN cf_CommcellGroupAssoc cga WITH (NOLOCK)
	 						ON cga.CommcellIdNameMap_ID = ccMap.ID
	 					INNER JOIN VisibleGroups vcg
	 						ON 	cga.commcellGroupId = vcg.groupId
	 			WHERE	(ID = @i_CSUniqueId) OR (@i_CSUniqueId = 0 AND (@IncludeDisabled > 0 OR (Flags & 1) <> 1))
	 		END
	 	END
	 	ELSE IF (ISNULL(@i_GroupId, 0) > 0)
	 	BEGIN
	 		;WITH VisibleGroups (groupId) AS
	 		(
	 			SELECT  clientGroup.value('@clientGroupId', 'INT')
	 			FROM    @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
	 					CROSS APPLY resp.nodes('commcellGroups') AS clientGroup(clientGroup)
	 			WHERE   @i_GroupId IS NULL OR @i_GroupId = -1 OR clientGroup.value('@clientGroupId', 'INT') = @i_GroupId
	 		)
	 		INSERT INTO @CommcellTbl
	 		SELECT  ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition
	 		FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 			INNER JOIN cf_CommcellGroupAssoc cga WITH (NOLOCK)
	 				ON cga.CommcellIdNameMap_ID = ccMap.ID
	 			INNER JOIN VisibleGroups vcg
	 				ON 	cga.commcellGroupId = vcg.groupId
	 		WHERE   (ID = @i_CSUniqueId) OR (@i_CSUniqueId = 0 AND (@IncludeDisabled > 0 OR (Flags & 1) <> 1))
		END
	 	ELSE
	 	BEGIN
	 		;WITH VisibleCommcells (CommCellID, CommServGUID) AS
	 		(
	 			SELECT  commcells.value('@commCellId', '[NVARCHAR](MAX)'), commcells.value('@csGUID', '[NVARCHAR](MAX)')
	 			FROM    @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
	 					CROSS APPLY resp.nodes('commcells') AS commcells(commcells)
	 		)
	 		INSERT INTO @CommcellTbl
	 		SELECT  ccMap.ID, ccMap.CommCellID, ccMap.CommServIP, ccMap.CommServGUID, ccMap.CustomerName, ccMap.CommServName, ccMap.CommServTZ, ccMap.CommServVersion, ccMap.CommServEdition
	 		FROM    cf_CommcellIdNameMap ccMap WITH (NOLOCK)
	 				INNER JOIN VisibleCommcells  vcc ON vcc.CommServGUID = ccMap.CommServGUID
	 		WHERE   ((ID = @i_CSUniqueId) OR (@i_CSUniqueId = 0 AND (@IncludeDisabled > 0  OR (Flags & 1) <> 1)))
		END

		IF @i_LatestOnly = 1
	 		INSERT INTO @Results
			SELECT	ccNameMap.ID, ccNameMap.CommCellID, ccNameMap.CommServIP, ccNameMap.CommServGUID, ccNameMap.CustomerName, ccNameMap.CommServName,
					ccNameMap.CommServTZ, ccNameMap.CommServVersion, ccNameMap.CommServEdition, result.CommservSurveyResults_ID,
					result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
			FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
				INNER JOIN @CommcellTbl AS ccNameMap
					ON result.CommcellIdNameMap_ID = ccNameMap.ID
					AND result.QueryId = @i_QueryId
					AND result.Flags = 1
		ELSE
		IF	@i_LogDateStart IS NOT NULL AND @i_LogDateEND IS NOT NULL
			INSERT INTO @Results
			SELECT	ccNameMap.ID, ccNameMap.CommCellID, ccNameMap.CommServIP, ccNameMap.CommServGUID, ccNameMap.CustomerName, ccNameMap.CommServName,
					ccNameMap.CommServTZ, ccNameMap.CommServVersion, ccNameMap.CommServEdition, result.CommservSurveyResults_ID,
					result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
			FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
				INNER JOIN @CommcellTbl AS ccNameMap
					ON result.CommcellIdNameMap_ID = ccNameMap.ID
					AND result.QueryId = @i_QueryId
					AND result.LogDateUTC BETWEEN @i_LogDateStart AND @i_LogDateEnd
		ELSE
	 		INSERT INTO @Results
			SELECT	ccNameMap.ID, ccNameMap.CommCellID, ccNameMap.CommServIP, ccNameMap.CommServGUID, ccNameMap.CustomerName, ccNameMap.CommServName,
					ccNameMap.CommServTZ, ccNameMap.CommServVersion, ccNameMap.CommServEdition, result.CommservSurveyResults_ID,
					result.QueryId, result.LogDate, result.LogDateUTC, result.RunningTime, result.Flags
			FROM	dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
				INNER JOIN @CommcellTbl AS ccNameMap
					ON result.CommcellIdNameMap_ID = ccNameMap.ID
					AND result.QueryId = @i_QueryId

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cf_SurveyResultFuncV1]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cf_SurveyResultFuncV1' AND revision = '1.6')

  insert into GXDBVersions values(5, 'cf_SurveyResultFuncV1',  '1.6', 'cf_SurveyResultFuncV1', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/cf_SurveyResultFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: cf_SurveyResultFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_SurveyResultFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cf_SurveyResultFunc]
  delete from GXDBVersions where name = 'cf_SurveyResultFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[cf_SurveyResultFunc] (
		@i_QueryId		INT,
		@i_CSUniqueId	INT = 0,
		@i_LatestOnly	INT = 1,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEnd	DATETIME = NULL,
		@i_UserId  		INT = NULL
	 )
	 RETURNS @Results TABLE (
	 	CommServUniqueId INT,
		CommCellID       VARCHAR(32),
		CommServIP       VARCHAR(256),
		CommServGUID     VARCHAR(256),
		CustomerName     NVARCHAR(256),
		CommServName     NVARCHAR(256),
		CommServTimeZone VARCHAR(256),
		CommServVersion  VARCHAR(256),
		CommServEdition	 VARCHAR(256),
		SurverResultId   INT,
		SurveyID         INT,
		LogDate          DATETIME,
		LogDateUTC       DATETIME,
		RunningTime      INT,
		SureyResultFlags INT
	 )
	 AS
	 BEGIN
	 		DECLARE @i_GroupId INT
	 		SET @i_GroupId = -1
	 		INSERT INTO @Results
			SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, CustomerName, CommServName,
					CommServTimeZone, CommServVersion, CommServEdition, SurverResultId,
					SurveyID, LogDate, LogDateUTC, RunningTime, SureyResultFlags
			FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CSUniqueId, @i_LatestOnly, @i_LogDateStart, @i_LogDateEnd, @i_UserId, @i_GroupId) AS result

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cf_SurveyResultFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cf_SurveyResultFunc' AND revision = '1.8')

  insert into GXDBVersions values(5, 'cf_SurveyResultFunc',  '1.8', 'cf_SurveyResultFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/cf_surveyKBLink.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: cf_surveyKBLink'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_surveyKBLink]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cf_surveyKBLink]
  delete from GXDBVersions where name = 'cf_surveyKBLink' and type = 5
END
GO

    CREATE FUNCTION cf_surveyKBLink ( @errorCode  NVARCHAR(52))
    RETURNS NVARCHAR(256)
    AS
    BEGIN
    DECLARE @baseKBLink nvarchar(100)
    DECLARE @result nvarchar(256)
    DECLARE @QuoteVal  nvarchar(5)
    SET @QuoteVal = '%22'
    SET @baseKBLink = (select value from cf_SurveyConfig where Name = 'CVKnowledgeBaseLink')
    IF  @baseKBLink IS NOT NULL
    SELECT @result =  '<a class="linkClass" target="_blank" href="'
                    + @baseKBLink
                    + '?q='
                    + @QuoteVal
                    + @errorCode
                    + @QuoteVal + '">'
                    + @errorCode
                    + '</a>'
                    + '</a>'
    ELSE
        SET @result = @errorCode
    return @result
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cf_surveyKBLink]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cf_surveyKBLink' AND revision = '')

  insert into GXDBVersions values(5, 'cf_surveyKBLink',  '', 'cf_surveyKBLink', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/ConvertBigIntToHexStr.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ConvertBigIntToHexStr'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ConvertBigIntToHexStr]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ConvertBigIntToHexStr]
  delete from GXDBVersions where name = 'ConvertBigIntToHexStr' and type = 5
END
GO

	CREATE FUNCTION ConvertBigIntToHexStr ( @Num BIGINT )
	RETURNS NVARCHAR(16)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @Str	NVARCHAR(16)
		DECLARE @Index	INTEGER

	SET @Str = ''

		WHILE @NUM > 0
		BEGIN
			SET @Index = @Num & 0xF
			SET @Num = @Num/16
			SET @Str = SUBSTRING('0123456789ABCDEF', @Index+1, 1)+@Str
		END
		RETURN @Str
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ConvertBigIntToHexStr]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ConvertBigIntToHexStr' AND revision = '1.2')

  insert into GXDBVersions values(5, 'ConvertBigIntToHexStr',  '1.2', 'ConvertBigIntToHexStr', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/ConvertHexToInt.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ConvertHexToInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ConvertHexToInt]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ConvertHexToInt]
  delete from GXDBVersions where name = 'ConvertHexToInt' and type = 5
END
GO

	CREATE FUNCTION ConvertHexToInt ( @hexnum  varchar(128))
	RETURNS INT
	AS
	BEGIN
   DECLARE @i                 int;
   DECLARE @digits            int;
   DECLARE @Xdigits           int;
   DECLARE @result            int ;
   DECLARE @current_digit     char(1);
   DECLARE @current_digit_dec int;

   set @digits = Len(@hexnum);
   set @Xdigits = CHARINDEX( 'x', @hexnum, 1)
   set @digits = @digits - @Xdigits
   SET @hexnum = UPPER(RIGHT(@hexnum, @digits))
   --Trim the hex values

   SET @result = 0
   SET @i = 1
   WHILE ( @i <= @digits)
   BEGIN
     SET @current_digit = SUBSTRING(@hexnum, @i, 1);
      IF  (@current_digit in ('A','B','C','D','E','F'))
        SET  @current_digit_dec = ascii(@current_digit) - ascii('A') + 10;
      ELSE
      IF  (@current_digit NOT IN ('0','1','2','3','4','5','6','7','8','9'))
        RETURN NULL
      ELSE
 	   SET @current_digit_dec = CAST(@current_digit AS int);
      SET @result = (@result * 16) + @current_digit_dec;
      SET @i = @i + 1
   END
  return @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ConvertHexToInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ConvertHexToInt' AND revision = '1.3')

  insert into GXDBVersions values(5, 'ConvertHexToInt',  '1.3', 'ConvertHexToInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetLatestSurvey.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLatestSurvey'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLatestSurvey]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLatestSurvey]
  delete from GXDBVersions where name = 'GetLatestSurvey' and type = 5
END
GO

	CREATE FUNCTION [dbo].[GetLatestSurvey]
	(
		@i_CommServUniqueId INT = 0,
		@i_QueryId INT
	)
	RETURNS @TblLatestSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		LogDateUTC DATETIME NOT NULL,
		SurveyResultId INT NOT NULL
	)
	AS
	BEGIN
		INSERT INTO @TblLatestSurveyResult
		SELECT
			sub1.CommServUniqueId,
			sub1.LogDateUTC,
			sub1.SurverResultId
		FROM
		(
			(SELECT
				CommServUniqueId,
				SurveyID,
				LogDateUTC,
				SurverResultId,
				ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, SurveyID ORDER BY CommServUniqueId, LogDateUTC DESC) AS RowId
			FROM cf_SurveyResultView WITH (NOLOCK, READUNCOMMITTED)) AS Sub1
			INNER JOIN cf_SurveyResultView AS Sub2 WITH (NOLOCK, READUNCOMMITTED)
				ON Sub1.RowId = 1
				AND Sub1.CommServUniqueId = Sub2.CommServUniqueId
				AND Sub1.SurverResultId = Sub2.SurverResultId
				AND Sub1.SurveyID = Sub2.SurveyID
				AND ((Sub2.CommServUniqueId = @i_CommServUniqueId) OR (@i_CommServUniqueId = 0))
				AND Sub2.SurveyID = @i_QueryId
		)
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLatestSurvey]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLatestSurvey' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetLatestSurvey',  '1.1', 'GetLatestSurvey', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetServerHealthFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: RptGetServerHealthFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetServerHealthFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetServerHealthFunc]
  delete from GXDBVersions where name = 'RptGetServerHealthFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetServerHealthFunc]
	(
		@i_CommServUniqueId INT = 0,
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL
	)
	RETURNS @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		GroupId INTEGER NOT NULL,
		GroupName NVARCHAR(MAX) NOT NULL,
		MonitorId INTEGER NOT NULL,
		Monitor NVARCHAR(MAX) NOT NULL,
		Status VARCHAR(10) NOT NULL,
		LogDate DATETIME,
		Result NVARCHAR(MAX),
		ExpectedResult NVARCHAR(MAX),
		Recommendation NVARCHAR(MAX),
		GroupSortOrder INT,
		MonitorSortOrder INT,
		ParamId INT
	)
	AS
	BEGIN

		DECLARE @strGood		VARCHAR(10) = '1_Good'
		DECLARE @strInfo		VARCHAR(10) = '2_Info'
		DECLARE @strwarning		VARCHAR(10) = '3_Warning'
		DECLARE @strCritical	VARCHAR(10) = '4_Critical'
		DECLARE @strUnknown		VARCHAR(10) = '0_Unknown'

		--Set Deafult to Backup Job Statistics
		DECLARE @queryId			INT = 16
		DECLARE @parameterName		NVARCHAR(256)
		DECLARE @warningThreshold	INT
		DECLARE @criticalThreshold	INT
		DECLARE @infoMessage		NVARCHAR(MAX)
		DECLARE @goodMessage		NVARCHAR(MAX)
		DECLARE @warningMessage		NVARCHAR(MAX)
		DECLARE @criticalMessage	NVARCHAR(MAX)

		IF (@i_CommServUniqueId IS NULL OR @i_CommServUniqueId = 0)
			RETURN
		IF NOT EXISTS (SELECT * FROM dbo.cf_SurveyResultFuncV1(16, @i_CommServUniqueId, 1, NULL, NULL,@i_UserId,@i_GroupId) )
			RETURN

		INSERT INTO @TblSurveyResult
				SELECT	@i_CommServUniqueId, sGroup.SurveyGroupId, sGroup.Name, survey.QueryId, CASE WHEN LEN(map.ParameterName) > 0 THEN map.ParameterName ELSE survey.Name END, @strUnknown, '', '', '', '' , map.GroupSortOrder, map.SurveySortOrder, 0
		FROM	cf_CommservSurveyQueries AS survey
				INNER JOIN cf_CommservSurveyGroupMap AS map
					ON map.SurveyId = survey.QueryId
					AND Flags & 4 = 4
					AND (map.GroupId <> 15 OR (map.GroupId = 15 AND map.SurveyId = 171)) --Pick up only one row for value assessment
				INNER JOIN cf_CommservSurveyGroups as sGroup
					ON sGroup.SurveyGroupId = map.GroupId

		DECLARE @TblLatestResult TABLE (QueryId INT, SurveyResultId INT, LogDate DATETIME)

		INSERT	INTO @TblLatestResult
		SELECT	DISTINCT R.QueryId, R.CommservSurveyResults_ID, R.LogDate
		FROM	cf_CommservSurveyResults R WITH (NOLOCK)
				INNER JOIN @TblSurveyResult S ON R.QueryId = S.MonitorId
		WHERE	R.CommcellIdNameMap_ID = @i_CommServUniqueId AND R.Flags = 1

		--If NO health check done - return
		IF NOT EXISTS (SELECT * FROM @TblLatestResult WHERE QueryID = @queryId)
		BEGIN
			DELETE FROM @TblSurveyResult
			RETURN
		END

		DECLARE @tmpStatus VARCHAR(10) = @strInfo
		DECLARE @tmpLogDate VARCHAR(20)
		DECLARE @tmpResult NVARCHAR(MAX) = ''
		DECLARE @tmpRecommendation NVARCHAR(MAX) = ''

		--Set LogDate by deafult to Backup Job Statistics date
		SELECT	@tmpLogDate = csInfo.LogDate
		FROM	cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = @queryId


		DECLARE @jobCount INTEGER = 0
		DECLARE @totSCs INT = 0
		DECLARE @SCsWithLongJobs INT = 0
		DECLARE @SCsWithLongJobsPercent DECIMAL(32,2) = 0
		DECLARE	HealthQueryCur CURSOR FOR
		SELECT	QueryId,
				ParameterName,
				WarningThreshold,
				CriticalThreshold,
				InfoMessage,
				GoodMessage,
				WarningMessage,
				CriticalMessage
		FROM	cf_ReportParameterView where ParamId < 700	-- Excluding scale statistics sub params from 700 to 714

		OPEN HealthQueryCur

		FETCH NEXT FROM HealthQueryCur
		INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

		WHILE @@FETCH_STATUS <> -1
		BEGIN
			SET @tmpStatus = @strUnknown
			SET @tmpResult = ''
			SET @tmpRecommendation = @infoMessage

			--Simpana Service Pack Stats
			IF @queryId = 12
			BEGIN
				DECLARE @CSVersion VARCHAR(128) = ''
				DECLARE @ReleaseNo INT
				DECLARE @SPMajorNo INT
				DECLARE @SPMinorNo VARCHAR(1) = ''
				DECLARE @LatestSP  INT

				SELECT	@CSVersion = CASE
							WHEN CommServVersion IS NULL THEN 'Unknown'
							WHEN CommServVersion = 'Not Found' THEN 'Unknown'
							ELSE SUBSTRING(CommServVersion, 0, CHARINDEX('(', CommServVersion)) + ' ' + SUBSTRING(CommServVersion, CHARINDEX(')', CommServVersion)+1, LEN(CommServVersion))
						END
				FROM	cf_CommCellIdNameMap WITH (NOLOCK)
				WHERE	ID = @i_CommServUniqueId

				IF @CSVersion <> 'Unknown' AND ISNULL(@CSVersion, '') <> ''
				BEGIN
				SET	@tmpResult = 'Currently on <b>Version ' + @CSVersion + '</b>.<DELIM>'

					SET @CSVersion = REPLACE(LTRIM(@CSVersion), '.', ' ')
					IF CHARINDEX(' ', @CSVersion) > 0
						SET @ReleaseNo = LEFT(@CSVersion, CHARINDEX(' ', @CSVersion) - 1)
					ELSE
						SET @ReleaseNo = @CSVersion

					SET @CSVersion = SUBSTRING(@CSVersion, CHARINDEX('SP', @CSVersion)+2, LEN(@CSVersion))

					IF ISNUMERIC(RIGHT(@CSVersion, 1)) = 1
						SET @SPMajorNo = @CSVersion
					ELSE
					BEGIN
						SET @SPMajorNo = SUBSTRING(@CSVersion, 1, LEN(@CSVersion)-1)
						SET @SPMinorNo = SUBSTRING(@CSVersion, LEN(@CSVersion)-1, LEN(@CSVersion))
					END

					IF @ReleaseNo = 9
						SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '9_0_LatestSPMajorNo'
					ELSE IF @ReleaseNo = 10
						SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '10_0_LatestSPMajorNo'

					SET @tmpStatus =
					CASE
						WHEN (@LatestSP - @SPMajorNo) >= @criticalThreshold THEN @strCritical
						WHEN (@SPMinorNo <> '') OR ((@LatestSP - @SPMajorNo) >= @warningThreshold) THEN @strWarning
						ELSE @strGood
				END

					SET @tmpRecommendation =
					CASE
						WHEN (@LatestSP - @SPMajorNo) >= @criticalThreshold THEN 'Lags behind by <b>' + CAST((@LatestSP - @SPMajorNo) AS VARCHAR(2)) + '</b> service packs. ' + @criticalMessage
						WHEN (@SPMinorNo <> '') THEN @infoMessage
						WHEN ((@LatestSP - @SPMajorNo) >= @warningThreshold) THEN 'Lags behind by <b>' + CAST((@LatestSP - @SPMajorNo) AS VARCHAR(2)) + '</b> service packs. ' + @warningMessage
						ELSE @goodMessage
				END
				END

				SELECT	@tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyUpdateInfo AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
			END
			--DeDup Store Config for Media Agent
			ELSE IF @queryId = 61
			BEGIN
				declare @totalMANum int = 0
				declare @MAStoreConfigResults table
				(
					MediaAgentId int,
					LogDate dateTime,
					ValidSIDBCount int,
					Status int
				)
				INSERT INTO @MAStoreConfigResults
				SELECT
					sub.MediaAgentId,
					sub.LogDate,
					SUM(sub.IsValid),
					CASE
						WHEN SUM(sub.IsValid) > @criticalThreshold THEN 3
						WHEN SUM(sub.IsValid) >= @warningThreshold and SUM(sub.IsValid) <= @criticalThreshold THEN 2
						ELSE 1
					END
				FROM
				(
				SELECT
					csInfo.MediaAgentId,
					csInfo.LogDate,
					CASE
						WHEN csInfo.SealedStatus = 'Active' OR (csInfo.SIDBStoreStatus <> 1 AND csInfo.TotalRecords >= 100000000) THEN 1
						ELSE 0
					END AS 'IsValid'
				FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND	csInfo.MediaAgentId > 1
				) AS sub
				GROUP BY sub.MediaAgentId, sub.LogDate
				select @totalMANum = ISNULL(COUNT(*), 0) from @MAStoreConfigResults
				select @tmpLogDate = ISNULL(MAX(LogDate), @tmpLogDate) from @MAStoreConfigResults
				SET @tmpStatus = @strInfo
				IF (@totalMANum > 0)
					BEGIN
						SET @tmpResult = 'Media Agent(s) with DDB Partitions: <b>'+ CAST(@totalMANum AS NVARCHAR(5)) + '</b>'
						SET @tmpRecommendation = @goodMessage
					END
				ELSE
				BEGIN
					SET @tmpResult =  'There are no MediaAgents hosting Deduplication Database.<DELIM>'
					SET @tmpRecommendation = @infoMessage
				END
			END
			--BkpJobStatistics
			ELSE IF @queryId = 16
			BEGIN
				SELECT
					@tmpStatus =
						CASE
							WHEN sub.SuccessRatePercent >= @warningThreshold THEN @strGood
							WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @strwarning
							ELSE @strCritical
						END,
					@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
					@tmpResult = 'Success Rate : <b>' + CAST(sub.SuccessRatePercent AS NVARCHAR(MAX))
						+ ' %</b><DELIM>Total : <b>' + CAST(sub.TotalJobs AS NVARCHAR(100))
						+ '</b>, Successful : <b>' + CAST(sub.SuccessfulJobs AS NVARCHAR(100))
						+ '</b>, Failed or Killed : <b>' + CAST(sub.FailedJobs AS NVARCHAR(100))
						+ '</b><DELIM>Completed with Errors : <b>' + CAST(sub.CompletedWithErrorJobs AS NVARCHAR(20))
						+ '</b>, Completed with Warning : <b>' + CAST(sub.CompletedWithWarningJobs AS NVARCHAR(20)) + '</b><DELIM>',
					@tmpRecommendation =
						CASE
							WHEN sub.SuccessRatePercent >= @warningThreshold THEN @goodMessage
							WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @warningMessage
							ELSE @criticalMessage
						END
				FROM
				(
					SELECT
						csInfo.CommServUniqueId,
						csInfo.LogDate,
						csInfo.ClientGroups,
						csInfo.TotalJobs,
						csInfo.SuccessfulJobs,
						ISNULL(csInfo.CompletedWithErrorJobs, 0) AS CompletedWithErrorJobs,
						ISNULL(csInfo.CompletedWithWarningJobs, 0) AS CompletedWithWarningJobs,
						ISNULL(csInfo.FailedJobs, 0) FailedJobs,
						CASE
							WHEN csInfo.TotalJobs = 0 THEN 0
							ELSE CAST(((ISNULL(csInfo.CompletedWithErrorJobs, 0) + ISNULL(csInfo.CompletedWithWarningJobs, 0)+ ISNULL(csInfo.SuccessfulJobs, 0)) * 100.0)/csInfo.TotalJobs AS DECIMAL(7, 0))
						END AS SuccessRatePercent
					FROM cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				) AS sub
			END
			--Fallen Behind Storage policy copies
			ELSE IF @queryId = 64
			BEGIN
				declare @criticalCopyNum int = 0
				declare @warningCopyNum int = 0
				declare @totalCopyNum int = 0

				declare @dashCoppySummary table
				(
					spName nvarchar(255),
					copyName nvarchar(255),
					FallenBehindDays int
				)

				INSERT INTO @dashCoppySummary
				SELECT 	csInfo.storagePolicyName,
						csInfo.StoragePolicyCopyName,
						csInfo.FallenBehindDays
				FROM	cf_SurveyFallenBehindCopies AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				set @warningCopyNum = (select COUNT( copyName) FROM @dashCoppySummary where FallenBehindDays >= @warningThreshold and FallenBehindDays <= @criticalThreshold)
				set @criticalCopyNum =( select COUNT( copyName) FROM @dashCoppySummary where FallenBehindDays > @criticalThreshold)
				set @totalCopyNum = (select COUNT( copyName) FROM 	@dashCoppySummary)

				SET @tmpStatus =
					CASE
						WHEN @criticalCopyNum > 0 THEN @strCritical
						WHEN @warningCopyNum > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalCopyNum > 0)
					BEGIN
						SET @tmpResult = 'Secondary Copies: <DELIM>'
						SET @tmpResult += 'Total: <B>'+ CAST(@totalCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good: <B>' + CAST((@totalCopyNum-@warningCopyNum-@criticalCopyNum) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning: <B>' + CAST(@warningCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical: <B>' + CAST(@criticalCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'There are no Fallen Behind Secondary Copies.<DELIM>'

				SET @tmpRecommendation =
					CASE
						WHEN @totalCopyNum = 0 THEN @infoMessage
						WHEN @totalCopyNum > 0 AND @criticalCopyNum = 0 AND @warningCopyNum = 0 THEN  @goodMessage
						ELSE @warningMessage
					END
			END
			--DDB Performance
			ELSE IF @queryId = 65
			BEGIN
				declare @criticalNum int = 0
				declare @warningNum int = 0
				declare @goodNum int = 0
				declare @totalNum int = 0

				declare @qiTime table
				(
					SidbStoreId int,
					AvgQITime	bigint,
					PrimaryRecords	bigint
				)

				INSERT INTO @qiTime
				SELECT	csInfo.SidbStoreId,
						csInfo.AvgQITime,
						csInfo.PrimaryRecords
				FROM	cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @goodNum    = (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime < @warningThreshold  OR  PrimaryRecords < 100000000)
				SET @criticalNum= (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime > @criticalThreshold AND PrimaryRecords > 200000000)
				SET @totalNum	= (SELECT COUNT(SidbStoreId) FROM @qiTime)
				SET @warningNum	= (@totalNum - @goodNum - @criticalNum)

				SET @tmpStatus = CASE
					WHEN @totalNum = 0 THEN @strInfo
					WHEN @criticalNum > 0 THEN @strCritical
					WHEN @warningNum > 0 THEN @strwarning
					ELSE @strGood END

				IF (@totalNum > 0)
				BEGIN
					SET @tmpResult = 'DDBs: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@totalNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST(@goodNum  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>'  + CAST(@warningNum  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@criticalNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
					SET @tmpResult =  'There are no Media Agents hosting DDB store.<DELIM>'

				SET @tmpRecommendation = CASE
					WHEN @totalNum = 0 THEN @infoMessage
					WHEN @totalNum > 0 AND @criticalNum = 0 AND @warningNum = 0 THEN @goodMessage
					ELSE @warningMessage END
			END
			--Low Disk Space
			ELSE IF @queryId = 70
			BEGIN
				declare @criticalCopies int = 0
				declare @warningCopies int = 0
				declare @totalNCopies int = 0

				declare @copiesSize table
				(
					copyId int,
					percentFree decimal(10,2)
				)

				INSERT INTO @copiesSize
				SELECT	csInfo.CopyId,
						case when csInfo.CapacityMB > 0 THEN cast ((csInfo.FreeSpaceMB *100.0 / csInfo.CapacityMB ) AS decimal(10,2)) else '0' END AS percentFree
				FROM	cf_SurveyCopyFreeSpace AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @warningCopies	= (select COUNT(CopyId) FROM @copiesSize where percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
				SET @criticalCopies = (select COUNT(CopyId) FROM @copiesSize where percentFree < @criticalThreshold)
				SET @totalNCopies	= (select COUNT(CopyId) FROM @copiesSize)

				SET @tmpStatus = CASE
					WHEN @criticalCopies > 0 THEN @strCritical
					WHEN @warningCopies > 0 THEN @strwarning
					ELSE @strGood END

				IF (@totalNCopies > 0)
				BEGIN
					SET @tmpResult = 'Storage Policy Copies: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@totalNCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST((@totalNCopies-@warningCopies-@criticalCopies) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>' + CAST(@warningCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@criticalCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
					SET @tmpResult =  'All Copies have sufficient space.<DELIM>'

				SET @tmpRecommendation = CASE
					WHEN @totalNCopies = 0 THEN @infoMessage
					WHEN @totalNCopies > 0 AND @criticalCopies = 0 AND @warningCopies = 0 THEN @goodMessage
					ELSE @warningMessage END
			END
			--RestoreStatistics
			ELSE IF @queryId = 17
			BEGIN
				SELECT 	@tmpStatus =
							CASE
								WHEN sub.TotalRestoreClients = 0 OR sub.TotalSuccPct > @warningThreshold THEN @strGood --No Restores Jobs or All Restore Jobs success
								WHEN sub.TotalSuccPct >= @criticalThreshold THEN @strwarning
								ELSE @strCritical
							END,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = 'Clients with Restore jobs : '
							+ CASE WHEN sub.TotalRestoreClients = 0 THEN 'None' ELSE '<DELIM>Successful : <b>'
							+ CAST(SuccessfulClients AS VARCHAR(7)) + '(' + CAST(sub.SuccessPct AS VARCHAR(7))
							+ '%)</b>, Successful after failed jobs : <b>'
							+ CAST(sub.SuccAfterFailClients AS VARCHAR(7)) + '(' + CAST(sub.SuccAfterFailPct AS VARCHAR(7))
							+ '%)</b>, <DELIM>Failed or Killed : <b>'
							+ CAST(sub.FailedClients AS VARCHAR(7)) + '(' + CAST(sub.FailurePct AS VARCHAR(7)) + '%)</b>' END,
						@tmpRecommendation =
							CASE WHEN sub.TotalRestoreClients = 0 THEN @infoMessage
								WHEN sub.TotalSuccPct >= @warningThreshold THEN @goodMessage
								WHEN sub.TotalSuccPct >= @criticalThreshold THEN @warningMessage
								ELSE @criticalMessage
							END
				FROM	(SELECT	(SuccessfulClients + SuccAfterFailClients + FailedClients) AS TotalRestoreClients,
								SuccessfulClients,
								100*SuccessfulClients/(SuccessfulClients + SuccAfterFailClients + FailedClients) AS SuccessPct,
								SuccAfterFailClients,
								100*SuccAfterFailClients/(SuccessfulClients + SuccAfterFailClients + FailedClients) AS SuccAfterFailPct,
								100*(SuccessfulClients + SuccAfterFailClients)/(SuccessfulClients + SuccAfterFailClients + FailedClients) AS TotalSuccPct,
								FailedClients,
								100*FailedClients/(SuccessfulClients + SuccAfterFailClients + FailedClients) AS FailurePct,
								result.LogDate
						FROM	cf_SurveyRestoreClientStats AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						) AS sub

			END
			--Unsupported Clients
			ELSE IF @queryId = 18
			BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'None<DELIM>'
				SET @tmpRecommendation = @infoMessage

				SELECT 	@tmpStatus = CASE WHEN sub.ClientCount <= @warningThreshold THEN @strGood ELSE @strCritical END,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = 'There are <b>' + CAST(sub.ClientCount AS NVARCHAR(100)) + '</b> older clients.<DELIM>',
						@tmpRecommendation = CASE WHEN sub.ClientCount <= @warningThreshold THEN @goodMessage ELSE @criticalMessage END
				FROM	(SELECT csInfo.CommServUniqueId,
								csInfo.LogDate,
								COUNT(csInfo.ClientId) AS ClientCount
						FROM	cf_SurveyUnsupportedClientInfo AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
						) AS sub
			END
			--ClientsWithoutStoragePolicy
			ELSE IF @queryId = 20
			BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'None<DELIM>'
				SET @tmpRecommendation = @infoMessage

				SELECT 	@tmpStatus = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN @strWarning ELSE @strGood END,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = CASE
							WHEN sub.ClientsWithoutSP > 0 THEN '<b>' +
								CAST(sub.SubclientCount AS NVARCHAR(100)) + '</b> Subclient(s) from <b>'
								+ CAST(sub.ClientsWithoutSP AS NVARCHAR(100)) + '</b> Client(s) ' +
								+ ' <b>(' + CAST(sub.ClientsWithoutSPPercent AS NVARCHAR(100)) + '%)</b> are not associated with Storage Policy.'
							ELSE 'All Subclients are associated with Storage Policy.<DELIM>' END,
						@tmpRecommendation = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN @warningMessage ELSE @goodMessage END
				FROM	(SELECT TOP 1
								csInfo.CommServUniqueId,
								csInfo.LogDate,
								csInfo.ClientGroups,
								csInfo.ClientsWithoutSP,
								csInfo.ClientsWithoutSPPercent,
								csInfo.TotalClients,
								COUNT(csInfo.Subclient) AS 'SubclientCount'
						FROM	cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId,
								csInfo.LogDate,
								csInfo.ClientGroups,
								csInfo.ClientsWithoutSP,
								csInfo.ClientsWithoutSPPercent,
								csInfo.TotalClients
						) AS sub
			END
			--DeDup Backup Configuration
			ELSE IF @queryId = 66
			BEGIN
				DECLARE @TotalDDBs int
				declare @WarningDDBs int
				declare @CriticalDDBs int

				SELECT 	@totalDDBs = COUNT(csInfo.SidbStoreName),
						@CriticalDDBs = SUM( case when csInfo.LastDDBBackupJobId =0 THEN 1
													ELSE case when ISNULL(csInfo.HoursSinceNoBackup,-1) <> -1  AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalThreshold THEN 1
															ELSE 0
														 END
												END),

						@WarningDDBs = SUM( 	case when (csInfo.LastDDBBackupJobId  >0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) = -1)
														  OR (csInfo.LastDDBBackupJobId  >0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <> -1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) < @criticalThreshold
															AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningThreshold)
													  THEN 1
													ELSE 0
												END
												)









				FROM	cf_SurveyDDBProtection AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId



				SET @tmpStatus = CASE WHEN @CriticalDDBs > 0 THEN @strCritical
									  WHEN @WarningDDBs >0 THEN @strWarning
									  ELSE @strGood END

				IF ( @TotalDDBs >0 )
				BEGIN
					set @tmpResult = ' DDB Partitions: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@TotalDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST((@TotalDDBs-@WarningDDBs-@CriticalDDBs) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>' + CAST(@WarningDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@CriticalDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
				BEGIN
					SET @tmpResult =  'There are no Media Agents hosting DDB store.<DELIM>'
				END










				SET @tmpRecommendation = CASE WHEN @TotalDDBs = 0 THEN @infoMessage
										      WHEN @CriticalDDBs > 0 or @WarningDDBs > 0 THEN @warningMessage ELSE @goodMessage END
			END
			--Schedule Policy Usage Statistics
			ELSE IF @queryId = 22
			BEGIN
				SET @tmpStatus = @strGood

				DECLARE @totalSchCount INT = 0
				DECLARE @unusedSchCount INT = 0

				DECLARE @tmpSchPolicy TABLE(IsUsed INT, SPCount INT)

				INSERT INTO @tmpSchPolicy
				SELECT 	csInfo.IsUsed, COUNT(*)
				FROM	cf_SurveySchedulePolicyUsage AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.IsUsed

				SELECT @totalSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy
				SELECT @unusedSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy WHERE IsUsed = 0

				IF @unusedSchCount > 0
				BEGIN
					SET @tmpResult = '<b>' + CAST(@unusedSchCount AS NVARCHAR(100)) + '</b> out of <b>'
						+ CAST(@totalSchCount AS NVARCHAR(100))
						+ '</b> Schedule Policies are not used.<DELIM>'
					SET @tmpStatus = @strwarning
					SET @tmpRecommendation = @warningMessage
				END
				ELSE
				BEGIN
					SET @tmpResult =
						CASE
							WHEN @totalSchCount = 0 THEN 'There is no Schedule Policy.<DELIM>'
							WHEN @totalSchCount > 0 THEN 'All <b>' + CAST(@totalSchCount AS NVARCHAR(100)) + '</b> Schedule Policies are in use.<DELIM>'
						END
					SET @tmpStatus = @strGood
					SET @tmpRecommendation = CASE WHEN @totalSchCount > 0 THEN @goodMessage ELSE '' END
				END
			END
			--Largest Clients by backup Size
			ELSE IF @queryId = 23
			BEGIN
				SET @tmpStatus = @strInfo
				SET @tmpResult = 'There may not be any backup jobs in last 30 days.'

				SELECT 	@tmpStatus = @strInfo,
						@tmpLogDate = CONVERT(VARCHAR(20), sub.LogDate, 100),
						@tmpResult = '<b>' + CAST(sub.ClientCount AS NVARCHAR(MAX)) + '</b> client(s) contribute(s) <b>'
							+ CAST(CAST(sub.SharePercent AS DECIMAL(6,2)) AS NVARCHAR(MAX)) + ' %</b> of the total application size <b>'
							+ dbo.FormatBytes(sub.TotalSize, 'GB') + '</b>  (last full backups).<DELIM>',
						@tmpRecommendation = CASE WHEN ISNULL(sub.ClientCount, 0) = 0 THEN '' ELSE '<VDL>' END
				FROM	(SELECT csInfo.CommServUniqueId,
								csInfo.LogDate,
								csInfo.ClientGroups,
								COUNT(csInfo.ClientId) AS ClientCount,
								MAX(csInfo.TotalSizeGB) AS TotalSize,
								CASE
									WHEN SUM(csInfo.ShareOfTotal) > 100 THEN 100
									ELSE SUM(csInfo.ShareOfTotal)
								END AS SharePercent
						FROM	cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.ClientGroups
						) AS sub
			END
			--Slowest Clients by long running jobs
			ELSE IF @queryId = 24
			BEGIN

				SELECT	TOP 1 @jobCount = csInfo.LongRunningJobs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @tmpStatus = CASE WHEN @jobCount > 0 THEN @strwarning ELSE @strGood	END
				SET @tmpResult = CASE
					WHEN @jobCount > 0 THEN '<b>' + CAST(@jobCount AS VARCHAR(MAX)) + '</b> jobs were found running longer than <b>12 hours</b>.<DELIM>'
					ELSE 'No jobs were found running longer than <b>12 hours</b>.<DELIM>' END
				SET @tmpRecommendation = CASE WHEN @jobCount > 0 THEN '<VDL>' ELSE '' END
			END
			--Continuous Failed Clients
			ELSE IF @queryId = 25
			BEGIN

				DECLARE @totalClients INT =0
				DECLARE @totalClientsWithStrike INT =0
				DECLARE @tmpStrikeTable TABLE(StrikeCount INT, scCount INT, clientCount INT)

				INSERT INTO @tmpStrikeTable
				SELECT	sub.StrikeCounts AS 'StrikeCount', COUNT (*) AS 'SubclientCount', COUNT (DISTINCT sub.ClientName) AS 'ClientCount'
				FROM	(SELECT DISTINCT
								csInfo.CommServUniqueId,
								csInfo.LogDate,
								csInfo.ClientGroups,
								csInfo.ClientName,
								csInfo.AgentName,
								csInfo.InstanceName,
								csInfo.BackupSet,
								csInfo.Subclient,
								csInfo.StrikeCounts
						FROM	cf_SurveyFailingClients AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
									AND csInfo.StrikeCounts <> -1
						) AS sub
				GROUP BY StrikeCounts
				ORDER BY StrikeCounts DESC

				SET @totalClientsWithStrike=ISNULL((SELECT COUNT(DISTINCT csInfo.ClientId)
													FROM cf_SurveyFailingClients AS csInfo WITH (NOLOCK)
														INNER JOIN @TblLatestResult AS result
														ON result.SurveyResultId = csInfo.SurveyResultId
														AND result.QueryID = @queryId
														AND csInfo.StrikeCounts <> -1),0)

				SET @totalClients = ISNULL((SELECT ISNULL(TotalClients,0) FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
									INNER JOIN cf_CommservSurveyResults G WITH (NOLOCK)
									ON csInfo.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1),0)

				DECLARE @strike3Count VARCHAR(MAX) = ''
				DECLARE @strike2Count VARCHAR(MAX) = ''
				DECLARE @strike1Count VARCHAR(MAX) = ''

				SELECT	@strike3Count = 'Strike 3 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
				FROM	@tmpStrikeTable WHERE StrikeCount = 3

				SELECT 	@strike2Count = 'Strike 2 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
				FROM	@tmpStrikeTable WHERE StrikeCount = 2

				SELECT 	@strike1Count = 'Strike 1 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
				FROM	@tmpStrikeTable WHERE StrikeCount = 1

				IF @totalClientsWithStrike <> 0 AND @totalClients = 0
					SET @tmpStatus = @strCritical
				ELSE IF @totalClients = 0 OR @totalClientsWithStrike = 0 OR ((@totalClientsWithStrike*100.0)/@totalClients) < @warningThreshold
					SET @tmpStatus	    = @strGood
				ELSE IF ((@totalClientsWithStrike*100.0)/@totalClients) <= @criticalThreshold AND ((@totalClientsWithStrike*100.0)/@totalClients) >= @warningThreshold
					SET @tmpStatus	    = @strWarning
				ELSE
					SET @tmpStatus = @strCritical


				IF @totalClientsWithStrike = 0
				BEGIN
					SET @tmpRecommendation = '<DELIM>'
					SET @tmpResult = 'There are no clients having any consecutive failed/killed jobs hence there is no strike.<DELIM>'
				END
				ELSE
				BEGIN
					SET	@tmpResult = @strike3Count + '<DELIM>' + @strike2Count + '<DELIM>' + @strike1Count + '<DELIM>'
					SET @tmpRecommendation = '<VDL>'
				END
			END

			--Dedupe Ratio by Storage Policy Copy
			ELSE IF @queryId = 26
			BEGIN
				DECLARE @TotalCopies INT = 0

				DECLARE @DeDupRatioSPCount TABLE(Copy NVARCHAR(256), DeDupRatio DECIMAL(20, 2))

				INSERT INTO @DeDupRatioSPCount
				SELECT 	csInfo.Copy, csInfo.DedupeRatio
				FROM	cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				AND csInfo.Jobs > 0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
				AND csInfo.DedupeRatio > -1

				SELECT @TotalCopies = COUNT(*) FROM @DeDupRatioSPCount

				SET	@tmpStatus = @strInfo

				SET @tmpRecommendation = @infoMessage

				IF (@TotalCopies > 0)
				BEGIN
					SET @tmpResult = 'Dedup Copies: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@TotalCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpRecommendation += '<VDL>'
				END
				ELSE
					SET @tmpResult =  'There are no storage policy copies with DeDup Ratio.<DELIM>'

			END
			--Unprotected Clients
			ELSE IF @queryId = 27
			BEGIN

				DECLARE @slaPercent FLOAT =100

				SELECT	@slaPercent = CASE
						WHEN (sub.NotProtectedSubclients+sub.ProtectedSubclients)>0
						THEN sub.ProtectedSubclients*100.0/(sub.NotProtectedSubclients+sub.ProtectedSubclients)
						ELSE 0 END
				FROM	(SELECT TOP 1
								csInfo.CommServUniqueId,
								csInfo.ProtectedSubclients,
								csInfo.NotProtectedSubclients
						FROM	cf_SurveyUnprotectedClients AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId AND csInfo.Days = 30
						) AS sub
				SET @slaPercent = CAST (@slaPercent AS INT)
				SET @tmpResult = 'SLA is <b>'+ CAST (@slaPercent AS NVARCHAR(6)) + ' %.</b><DELIM>'
				SET	@tmpStatus = CASE
					WHEN @slaPercent < @criticalThreshold THEN @strCritical
					WHEN @slaPercent <= @warningThreshold THEN @strwarning
					ELSE @strGood END
				SET	@tmpRecommendation = CASE
					WHEN @slaPercent < @criticalThreshold THEN @criticalMessage
					WHEN @slaPercent <= @warningThreshold THEN @warningMessage
					WHEN @slaPercent = 100 THEN @goodMessage
				END
			END
			--Incremental Backup Change Rate
			ELSE IF @queryId = 28
			BEGIN
				DECLARE @WeeklySizeChange TABLE
				(
					LogDate DATE,
					BkpSize FLOAT,
					TotalJobs BIGINT
				)

				INSERT INTO @WeeklySizeChange
				SELECT 	CAST (DATEADD(SS,csInfo.UxDate,'1970-01-01')AS DATE),
						SUM(csInfo.BackupSize) AS BkpSize, --AS '',
						SUM(csInfo.TotalJobs)  AS TotalJobs --AS 'Number of Incremental Backups'
				FROM	cf_SurveyIncrBkpChangeRate AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				GROUP BY CAST (DATEADD(SS,csInfo.UxDate,'1970-01-01')AS DATE)

				DECLARE @LastTotalBkpSize FLOAT, @FirstTotalBkpSize FLOAT, @WeekBkpSizeChg FLOAT = 0, @WeekBkpSizeChgPercent FLOAT, @increased INT = 0
				SELECT	@LastTotalBkpSize =ISNULL(BkpSize,0)  FROM @WeeklySizeChange
				WHERE	LogDate = (SELECT MAX(LogDate)  FROM @WeeklySizeChange)

				SELECT	@FirstTotalBkpSize =ISNULL(BkpSize,0)  FROM @WeeklySizeChange
				WHERE	LogDate = (SELECT MIN(LogDate)  FROM @WeeklySizeChange)

				DECLARE @WeekBkpSizeChgStr VARCHAR(MAX)='NOT APPLICABLE' , @WeekBkpSizeChgPercentStr VARCHAR(MAX)='NOT APPLICABLE' , @WeekStr VARCHAR(MAX)=''

				IF @FirstTotalBkpSize <>0
				BEGIN
					SET @WeekBkpSizeChg				= (@LastTotalBkpSize - @FirstTotalBkpSize)
					SET @increased					= CASE WHEN @WeekBkpSizeChg > 0 THEN 1 WHEN @WeekBkpSizeChg < 0 THEN -1 ELSE 0 END
					IF  @WeekBkpSizeChg < 0 SET @WeekBkpSizeChg = -@WeekBkpSizeChg
					SET @WeekBkpSizeChgPercent		= @WeekBkpSizeChg*100.0/@FirstTotalBkpSize
					SET @WeekBkpSizeChgStr			= dbo.formatBytes(@WeekBkpSizeChg ,'GB')
					SET @WeekBkpSizeChgPercentStr	= CAST(CAST (@WeekBkpSizeChgPercent AS DECIMAL (16,2)) AS VARCHAR(MAX))
					SET	@tmpStatus					= @strInfo
					SET	@tmpRecommendation			= '<VDL>'
					SET	@WeekStr					=' ( <b>' + @WeekBkpSizeChgPercentStr + '</b> %)'
				END
				ELSE
				BEGIN
					SET	@tmpStatus					= @strInfo
					SET	@tmpRecommendation			= ''
				END

				SET @tmpResult = CASE @increased
									WHEN 1 THEN 'Total data size increased by <b>' + @WeekBkpSizeChgStr + '</b>' + @WeekStr + '<DELIM>'
									WHEN -1 THEN 'Total data size decreased by <b>' + @WeekBkpSizeChgStr + '</b>' + @WeekStr + '<DELIM>'
									ELSE 'Total data size remained unchanged' END
			END
			--Most Frequent Errors
			ELSE IF @queryId = 30
			BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'No errors are found.<DELIM>'

				SELECT	@tmpStatus = CASE WHEN ISNULL(sub.TotalErrors, 0) = 0 THEN @strGood ELSE @strwarning END,
						@tmpResult = CASE WHEN ISNULL(sub.TotalErrors, 0) = 0 THEN 'No errors are found.<DELIM>' ELSE 'Top 10 errors in last 1 day.<DELIM>' END,
						@tmpRecommendation = CASE WHEN ISNULL(sub.TotalErrors, 0) = 0 THEN '' ELSE '<VDL>' END
				FROM	(SELECT csInfo.CommServUniqueId, csInfo.LogDate, COUNT(csInfo.NumberOfJobsAffected) AS TotalErrors
						FROM	cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
						) AS sub
			END
			--DR Backup Configuration
			ELSE IF @queryId = 31
			BEGIN
				SET @tmpStatus = @strCritical
				SET @tmpResult = ''
				SET @tmpRecommendation = @criticalMessage
				DECLARE @DRTABLE TABLE (LogDate	datetime NOT NULL, FullJobsToRetain int NULL, IsUingNetworkPath NVARCHAR(20), LastSuccessfulDRTime INT DEFAULT 0)
				INSERT INTO @DRTABLE
					SELECT 	0, csInfo.FullJobsToRetain, csInfo.IsUingNetworkPath, 0
								FROM	cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = @queryId

				UPDATE @DRTABLE SET LogDate = csInfo.LogDateUTC, LastSuccessfulDRTime = csInfo.LastSuccessfulDRTime
				FROM cf_SurveyDRStats AS csInfo WITH (NOLOCK)
					INNER JOIN cf_CommservSurveyResults R WITH (NOLOCK)
						ON R.QueryID = 19 --User Query id 19(BR Backup Statistics)
						AND csInfo.SurveyResultId = R.CommservSurveyResults_ID
						AND R.CommcellIdNameMap_ID = @i_CommServUniqueId
						AND R.Flags = 1

				DECLARE @ISUNC NVARCHAR(20) = NULL
				DECLARE @FullJobsToRetain int =  NULL
				DECLARE @LastDRBkpTime int = 0
				DECLARE @LastDRCollTime datetime = NULL
				SELECT 	@ISUNC = MAX(IsUingNetworkPath), @FullJobsToRetain = MAX(FullJobsToRetain), @LastDRBkpTime = MAX(LastSuccessfulDRTime), @LastDRCollTime = MAX(LogDate) FROM @DRTABLE

				IF EXISTS(SELECT * FROM @DRTABLE WHERE @ISUNC = 'false' OR @FullJobsToRetain = 0 OR ISNULL(@LastDRBkpTime, 0) = 0 OR DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) > @criticalThreshold)
				BEGIN
					SET @tmpStatus = @strCritical
					SET @tmpRecommendation = @criticalMessage
				END
				ELSE IF EXISTS(SELECT * FROM @DRTABLE WHERE (@FullJobsToRetain > 0 AND @FullJobsToRetain < 5) OR DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) > @warningThreshold)
				BEGIN
					SET @tmpStatus = @strwarning
					SET @tmpRecommendation = @warningMessage
				END
				ELSE IF EXISTS(SELECT * FROM @DRTABLE WHERE @ISUNC = 'true' AND @FullJobsToRetain >= 5 AND DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) <= @warningThreshold)
				BEGIN
					SET @tmpStatus = @strGood
					SET @tmpRecommendation = @goodMessage
				END

				SET @tmpLogDate = CONVERT(VARCHAR(20), @LastDRCollTime, 100)

				SET @tmpResult =
				CASE
					WHEN ISNULL(@LastDRBkpTime, 0) = 0 THEN 'There is no successful DR job so far.<DELIM>'
					ELSE 'Last successful DR backup ran on <b>' + CONVERT(VARCHAR(12), DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
				END
				IF (@ISUNC = 'true')
					SET @tmpResult = @tmpResult + 'DR Backup is scheduled to run with <b>UNC path</b> as destination.<DELIM>' + 'It is currently configured to retain <b>' + CAST(@FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<DELIM>'
				ELSE IF (@ISUNC = 'false')
					SET @tmpResult = @tmpResult + 'DR Backup is scheduled to run with <b>local path</b> as destination.<DELIM>' + 'It is currently configured to retain <b>' + CAST(@FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<DELIM>'
			END
			--Clients completing with error
			ELSE IF @queryId = 37
			BEGIN
				SET @totalClients =0
				SET @tmpStatus = @strGood
				SET @tmpResult = 'There are no clients with Jobs completed with errors.<DELIM>'

				SET @totalClients = (SELECT ISNULL(TotalClients,0) FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
									INNER JOIN cf_CommservSurveyResults G
									ON csInfo.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1)

				SELECT	@tmpStatus = (CASE WHEN @totalClients = 0 AND ISNULL(sub.ClientCount, 0) <> 0
												THEN @strCritical
										   WHEN @totalClients = 0 OR ISNULL(sub.ClientCount, 0) = 0 OR ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) < @warningThreshold
												THEN @strGood
										   WHEN ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) <= @criticalThreshold AND ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) >= @warningThreshold
												THEN @strWarning
										   ELSE @strCritical
									 END),
						@tmpResult = '<b>' + CAST(sub.ClientCount AS VARCHAR(10)) + '</b> client(s) with one or more jobs completed with error.<DELIM>',
						@tmpRecommendation = (CASE WHEN ISNULL(sub.ClientCount, 0) = 0 OR (@totalClients = 0 AND ISNULL(sub.ClientCount, 0) = 0) OR ((ISNULL(sub.ClientCount, 0)*100.0)/@totalClients)<= @warningThreshold
													THEN ''
												  ELSE '<VDL>'
												  END)
				FROM	(SELECT csInfo.CommServUniqueId, csInfo.LogDate, COUNT(csInfo.ClientName) AS ClientCount
						FROM	cf_SurveyClientJobsCompletingWithError AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = csInfo.SurveyResultId
									AND result.QueryID = @queryId
						GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
						) AS sub
			END
			--Index Cache location
			ELSE IF @queryId = 39 AND @parameterName = 'Index Cache Location'
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @localIdxCount INT = 0
				DECLARE @networkIdxCount INT = 0
				DECLARE @intermediateIdxCount INT = 0

				SELECT @localIdxCount = COUNT(csInfo.MAId)
				FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND csInfo.IsUNC = 0

				SELECT @networkIdxCount = COUNT(csInfo.MAId)
				FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND csInfo.IsUNC = 1

				SELECT @intermediateIdxCount = COUNT(csInfo.MAId)
				FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND LEN(csInfo.IntermediateCachePath) > 0 AND csInfo.IntermediateCachePath <> 'N/A'

				SELECT
					@tmpStatus =
					CASE
						WHEN (@localIdxCount + @networkIdxCount = 0) THEN @strInfo
						WHEN @networkIdxCount >= @warningThreshold THEN @strWarning
						ELSE @strGood
					END,
					@tmpResult =
					CASE
						WHEN @localIdxCount+@networkIdxCount = 0 THEN @infoMessage
						ELSE 'Index cache distribution by location: <DELIM>'
						+ 'Total : <b>' + CAST((@localIdxCount+@networkIdxCount) AS VARCHAR(10))
						+ '</b>&nbsp&nbspLocal Disk : <b>' + CAST(@localIdxCount AS VARCHAR(10))
						+ '</b>&nbsp&nbspNetwork Share : <b>' + CAST(@networkIdxCount AS VARCHAR(10))
						+ '</b><DELIM>Intermediate Cache : <b>' + CAST(@intermediateIdxCount AS VARCHAR(10)) + '</b><DELIM>'
					END,
					@tmpRecommendation =
					CASE
						WHEN (@localIdxCount + @networkIdxCount = 0) THEN @infoMessage
						WHEN @networkIdxCount >= @warningThreshold OR @intermediateIdxCount >= @warningThreshold THEN @warningMessage
						ELSE @goodMessage
					END
			END
			--Index Cache Space
			ELSE IF @queryId = 105 AND @parameterName = 'Index Cache Space Utilization'
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalIdxCache int = 0
				DECLARE @warningIdxCache int = 0
				DECLARE @criticalIdxCache int = 0
				DECLARE @unknownIdxCache int = 0

				--Disk space free: good:   > 25%   warning: 10 – 25%, critical < 10%
				DECLARE @idxCacheSize TABLE
				(
					MAId INT,
					percentFree DECIMAL(10,2)
				)

				INSERT INTO @idxCacheSize
				SELECT
					csInfo.MAId,
					CASE
						WHEN csInfo.TotalCapacityMB <= 0 THEN -1
						ELSE CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(10,2))
					END AS percentFree
				FROM
					cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 39

				SET @totalIdxCache = (SELECT COUNT(MAId) FROM @idxCacheSize)
				SET @unknownIdxCache = (select COUNT(MAId) FROM @idxCacheSize where percentFree = -1)
				SET @warningIdxCache = (SELECT COUNT(MAId) FROM @idxCacheSize where percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
				SET @criticalIdxCache = (select COUNT(MAId) FROM @idxCacheSize where percentFree >= 0 and percentFree < @criticalThreshold)

				SELECT
					@tmpStatus =
					CASE
						WHEN @totalIdxCache = 0 THEN @strInfo
						WHEN @criticalIdxCache > 0 THEN @strCritical
						WHEN @warningIdxCache > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalIdxCache > 0)
					BEGIN
						SET @tmpResult = 'Index cache distribution by available space: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST((@totalIdxCache-@warningIdxCache-@criticalIdxCache-@unknownIdxCache) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += '<DELIM>Excluded : <B>' + CAST(@unknownIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'There is no index cache configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalIdxCache = 0 THEN @infoMessage
					WHEN @totalIdxCache > 0 AND @criticalIdxCache = 0 AND @warningIdxCache = 0 THEN @goodMessage
					ELSE @warningMessage
				END
			END
			--Index Cache Space
			ELSE IF @queryId = 161
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalSearchEngine		int = 0
				DECLARE @warningSearchEngine	int = 0
				DECLARE @criticalSearchEngine	int = 0
				DECLARE @goodSearchEngine		int = 0
				--DECLARE @infoSearchEngine		int = 0

				DECLARE @segCountCritical INT  =75
				DECLARE @segCountWarning INT  = 50
				DECLARE @tiiFileSizeCritical INT  = 600
				DECLARE @tiiFileSizeWarning INT  = 500
				DECLARE @docCountCritical INT  = 30000000
				DECLARE @docCountWarning  INT  = 20000000
				DECLARE @driveFreeSpaceCritical INT  = 50
				DECLARE @driveFreeSpaceWarning INT  = 35
				--Disk space free: good:   > 25%   warning: 10 – 25%, critical < 10%
				DECLARE @SearchEngineHealthNodeStatus TABLE
				(
				   status NVARCHAR(MAX)
				)

				INSERT INTO @SearchEngineHealthNodeStatus
				SELECT
					CASE WHEN (	 csInfo.SegmentCount							 >	 @segCountCritical
							     OR	 csInfo.TermIndexFileSizeMB					     >	 @tiiFileSizeCritical
								 OR  csInfo.DocumentCount					    	 >	 ISNULL(csInfo.DocMaxCriticalLimit,@docCountCritical)
								 OR  (csInfo.IndexSizeMB*@driveFreeSpaceCritical)/100.0    >	 csInfo.FreeSpaceMB
							 )
						THEN @strCritical
						 WHEN (	 csInfo.SegmentCount								 >=	 @segCountWarning
							     OR	 csInfo.TermIndexFileSizeMB					     >=	 @tiiFileSizeWarning
								 OR  csInfo.DocumentCount					    	 >=	 ISNULL(csInfo.DocMaxWarningLimit,@docCountWarning)
								 OR  (csInfo.IndexSizeMB*@driveFreeSpaceWarning)/100.0    >	csInfo.FreeSpaceMB
							 )
						THEN @strwarning
					ELSE @strGood
					END
				FROM
					cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @totalSearchEngine = (SELECT COUNT(*) FROM @SearchEngineHealthNodeStatus)
				SET @criticalSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strCritical)
				SET @warningSearchEngine = (SELECT COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strwarning)
				SET @goodSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strGood)
				--SET @infoSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strInfo)

				SELECT
					@tmpStatus =
					CASE
					--	WHEN @totalSearchEngine = 0 OR @totalSearchEngine =@infoSearchEngine THEN @strInfo
						WHEN @criticalSearchEngine > 0 THEN @strCritical
						WHEN @warningSearchEngine > 0 THEN @strwarning
						ELSE @strGood
					END

				--IF (@totalSearchEngine > 0 AND @totalSearchEngine>@infoSearchEngine)
				IF (@totalSearchEngine > 0 )
					BEGIN
						SET @tmpResult = 'Search Clouds: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST(@goodSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'No Search Clouds are configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @criticalSearchEngine > 0 THEN @criticalMessage
					WHEN @warningSearchEngine  > 0 THEN @warningMessage
				--	WHEN @totalSearchEngine = 0 OR @totalSearchEngine =@infoSearchEngine  THEN @infoMessage
					WHEN @totalSearchEngine = 0 THEN @infoMessage
					ELSE @goodMessage
				END
			END
			ELSE IF @queryId = 95
			BEGIN
				SET @tmpStatus = @strInfo
				SET @tmpResult = ''

				DECLARE @totalMountPaths     int = 0

				--Disk space free: good:   > 25%   warning: 10 – 25%, critical < 10%
				DECLARE @MountPathsSize TABLE
				(
					MountPathName NVARCHAR(256),
					percentFree DECIMAL(20,2)
				)

				INSERT INTO @MountPathsSize
				SELECT
					csInfo.MountPathName,
					csInfo.FreeSpacePerc
				FROM
					cf_Survey95MountPathDetails AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @totalMountPaths     = (SELECT COUNT(MountPathName) FROM @MountPathsSize)


				IF (@totalMountPaths > 0)
					BEGIN
						SET @tmpResult = 'Total configured Mounpaths: '
						SET @tmpResult += '<B>'+ CAST(@totalMountPaths AS NVARCHAR(5)) + '</B><BR/>'
					END
				ELSE
					SET @tmpResult =  'There is no mount path configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalMountPaths = 0 THEN @infoMessage
					ELSE @goodMessage
				END
			END
			ELSE IF @queryId = 96
			BEGIN
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''

				DECLARE @totalDiskLib     int = 0
				DECLARE @goodDiskLib      int = 0
				DECLARE @warningDiskLib   int = 0
				DECLARE @criticalDiskLib  int = 0
                DECLARE @excludedDiskLib  int = 0

				--Disk space free: good:   > 25%   warning: 10 – 25%, critical < 10%
				DECLARE @DiskLibDays TABLE
				(
					DiskLibId BIGINT,
					estimatedSpaceRunoutDays BIGINT,
                    totalSpaceGB            FLOAT,
                    LogDateUTC					DATETIME
				)

				INSERT INTO @DiskLibDays
				SELECT
					csInfo.LibraryId,
					csInfo.estimatedSpaceRunoutDays,
                     csInfo.totalSpaceGB,
                     csInfo.LogDateUTC
				FROM
					cf_Survey96DiskLibDetails AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId

				SET @totalDiskLib     = (SELECT COUNT(DiskLibId) FROM @DiskLibDays)
				SET @goodDiskLib		 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays where (((estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) >= @warningThreshold) OR (estimatedSpaceRunoutDays IS NULL) OR (estimatedSpaceRunoutDays < 0)) AND totalSpaceGB IS NOT NULL)
				SET @warningDiskLib	 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays where (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) >= @criticalThreshold and (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) <= @warningThreshold  AND totalSpaceGB IS NOT NULL)
				SET @criticalDiskLib	 = (select COUNT(DiskLibId) FROM @DiskLibDays where estimatedSpaceRunoutDays > -1 and (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) < @criticalThreshold AND totalSpaceGB IS NOT NULL)
				SET @excludedDiskLib     = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB IS NULL)

				SELECT
					@tmpStatus =
					CASE
						WHEN @totalDiskLib = 0 OR @totalDiskLib =@excludedDiskLib THEN @strInfo
						WHEN @criticalDiskLib > 0 THEN @strCritical
						WHEN @warningDiskLib > 0 THEN @strwarning
						ELSE @strGood
					END

				IF (@totalDiskLib > 0)
					BEGIN
						SET @tmpResult = 'Disk Library distribution by estimated days to be full: <DELIM>'
						SET @tmpResult += 'Total : <B>'+ CAST(@totalDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Good : <B>' + CAST(@goodDiskLib  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Warning : <B>' + CAST(@warningDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += 'Critical : <B>' + CAST(@criticalDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						SET @tmpResult += '<DELIM>Excluded : <B>' + CAST(@excludedDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					END
				ELSE
					SET @tmpResult =  'There is no disk library configured.<DELIM>'

				SELECT @tmpRecommendation =
				CASE
					WHEN @totalDiskLib = 0 THEN @infoMessage
					WHEN @totalDiskLib > 0 AND @totalDiskLib = @excludedDiskLib THEN @infoMessage+'<VDL>'
					WHEN @totalDiskLib > 0 AND @criticalDiskLib = 0 AND @warningDiskLib = 0 THEN @goodMessage
					ELSE @warningMessage
				END

			END

			--Capacity License Usage
			ELSE IF @queryId = 1 AND @parameterName = 'Capacity License Usage'
			BEGIN
				DECLARE @UsedBackupSize BIGINT = 0
				DECLARE @UsedArchiveSize BIGINT = 0
				SELECT
					@UsedBackupSize  = ISNULL(csInfo.BackupSize, 0),
					@UsedArchiveSize = ISNULL(csInfo.ArchiveSize, 0)
				FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = 'Backup Size : <b>' + dbo.formatBytes(@UsedBackupSize, 'MB')  + '</b>'
						+ ', Archive Size : <b>' + dbo.formatBytes(@UsedArchiveSize, 'MB') + '</b><DELIM>',
					@tmpRecommendation = @infoMessage
			END
			ELSE IF @queryId = 1 AND @parameterName = 'License Usage'
			BEGIN
				DECLARE @VMSockets BIGINT = 0
				DECLARE @ProtectedVMs BIGINT = 0
				DECLARE @ArchivedMailBox BIGINT = 0
				DECLARE @EndpointUsers BIGINT = 0
				DECLARE @SharingUsers BIGINT = 0
				DECLARE @eDiscoveryUsers BIGINT = 0
				SELECT
					@VMSockets = ISNULL(csInfo.VMSockets, 0),
					@ProtectedVMs = ISNULL(csInfo.ProtectedVMs, 0),
					@ArchivedMailBox = ISNULL(csInfo.ArchivedMailBoxes, 0),
					@EndpointUsers = ISNULL(csInfo.EndpointUsers, 0),
					@SharingUsers = ISNULL(csInfo.SharingUsers, 0),
					@eDiscoveryUsers = ISNULL(csInfo.eDiscoveryUsers, 0)
				FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = 'VM Sockets : <b>' + CAST(@VMSockets AS VARCHAR(20)) + '</b>'
						+ ', VMs : <b>' + CAST(@ProtectedVMs AS VARCHAR(20)) + '</b>'
						+ ', Archived MailBoxes : <b>' + CAST(@ArchivedMailBox AS VARCHAR(20)) + '</b><DELIM>'
						+ 'Users : <b>' + CAST(@EndpointUsers AS VARCHAR(20)) + '</b>'
						+ ', Sharing Users : <b>' + CAST(@SharingUsers AS VARCHAR(20)) + '</b>'
						+ ', eDiscovery Users : <b>' + CAST(@eDiscoveryUsers AS VARCHAR(20)) + '</b>',
					@tmpRecommendation = @infoMessage
			END
			--Client Counts
			ELSE IF @queryId = 8
			BEGIN
				DECLARE @TotalClientCount INTEGER = 0
				DECLARE @activeClientCount INTEGER = 0
				DECLARE @laptopClients INTEGER = 0
				SELECT
					@TotalClientCount = ISNULL(SUM(csInfo.TotalClients), 0),
					@activeClientCount = ISNULL(SUM(csInfo.TotalActiveClients), 0),
					@laptopClients = ISNULL(SUM(csInfo.TotalLaptops), 0)
				FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = 'Total : <b>' + CAST(@TotalClientCount AS NVARCHAR(10)) + '</b>'
						+ ', Active : <b>' + CAST(@activeClientCount AS NVARCHAR(10)) + '</b>'
						+ ', Laptops : <b>' + CAST(@laptopClients AS NVARCHAR(10)) + '</b>',
					@tmpRecommendation = @infoMessage
			END
			--Snapshot Engine Usage
			ELSE IF @queryId = 4
			BEGIN
				DECLARE @snapEnginesUsed NVARCHAR(MAX)
				DECLARE	 @tbl TABLE (name nvarchar(max))
				INSERT INTO @tbl
				SELECT distinct csInfo.snapEngineName
				FROM cf_Survey4SnapInfo AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				SELECT	@snapEnginesUsed = COALESCE(@snapEnginesUsed + ', ', '') + name FROM  @tbl
				IF ISNULL(@snapEnginesUsed, '') = ''
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = 'Snap Engines are not used',
					@tmpRecommendation = @criticalMessage
				ELSE
				SELECT
					@tmpStatus = @strInfo,
					@tmpResult = '<b>Below Snap Engines are used</b><DELIM>' + @snapEnginesUsed,
					@tmpRecommendation = @infoMessage
			END
			-- Value Assessment
			ELSE IF @queryId = 171
			BEGIN
				SELECT @tmpStatus =
					CASE
						WHEN MAX(Status) = '2_Info' THEN MIN(Status)
						ELSE MAX(Status)
					END
				FROM RptGetValueAssessmentFunc(@i_CommServUniqueId, @i_UserId, @i_GroupId)
				SET @tmpResult =
				(case
					WHEN @tmpStatus = @strCritical THEN @criticalMessage
					WHEN @tmpStatus = @strwarning THEN @warningMessage
					ELSE @goodMessage
				end)
				SET @tmpRecommendation = '<VDL>'
			END
			--Sealed DDBs
			ELSE IF @queryId = 121
			BEGIN
					DECLARE @SealedDDBCount INT = 0
					SELECT @SealedDDBCount = COUNT(DISTINCT csInfo.SIDBStoreId)
						FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 61
							AND	csInfo.MediaAgentId > 1
							AND csInfo.SealedStatus = 'Sealed'
					SET @tmpStatus = @strInfo
					SET @tmpResult = 'Found <b>' +  CAST(@SealedDDBCount AS VARCHAR(10)) + '</b> Sealed DDB(s)'
					SET @tmpRecommendation = CASE WHEN @SealedDDBCount > 0 THEN @infoMessage ELSE @goodMessage END
			END
			--High-Risk Settings - Prune All Database Agent Logs Only By Days Retention Rule
			ELSE IF @queryId = 124
			BEGIN
				DECLARE @settingValue INT = 0
				DECLARE @settingValueString NVARCHAR(MAX) = ''
				SELECT @settingValue = csInfo.Value, @settingValueString = 'Prune all database agent logs only by days retention rule'
					FROM cf_surveyHighRiskSettings AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
							AND	csInfo.Name = 'Prune All Database Agent Logs Only By Days Retention Rule'
				SET @tmpStatus = CASE WHEN @settingValue = 0 THEN @strGood ELSE @strCritical END
				SET @tmpResult = @settingValueString
				SET @tmpRecommendation = CASE WHEN @settingValue = 0 THEN @goodMessage ELSE @CriticalMessage END
			END
			-- scale statistics
			ELSE IF @queryId = 7
			BEGIN
				IF ( NOT EXISTS ( SELECT top 1 csInfo.SurveyResultId from cf_SurveyScaleReportInfo csInfo INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId  ))
				BEGIN
					DELETE FROM @TblSurveyResult where MonitorId = 7
				END
				ELSE
				BEGIN
				            DECLARE @outputParam TABLE
	                        (
									status		  varchar(20),
	                        		outcome		varchar(1024),
								   	statusINT	INT
	                        )
				            INSERT INTO @outputParam
				            SELECT DISTINCT STATUS, outcome, statusINT
				            FROM dbo.RptGetScaleHealthFunc(@i_UserId,@i_GroupId ,1,1,@i_CommServUniqueId,null,null,'',1)


				            set @tmpResult =  NULL
							SELECT @tmpStatus =ISNULL(STATUS,@strInfo),
								   @tmpResult = (case WHEN statusINT =3 then COALESCE(@tmpResult + '<DELIM> ', '') +outcome
													  WHEN statusINT =2 then COALESCE(@tmpResult + '<DELIM> ', '') +outcome
													  ELSE outcome
													  end) ,
							@tmpRecommendation =(case WHEN statusINT =3 then @criticalMessage
													  WHEN statusINT =2 then @warningMessage
													  WHEN statusINT =1 then @goodMessage
													  else @goodMessage
													 end	)
							from @outputParam

				END
			END
			--Database Index Fragmentation
			ELSE IF @queryId = 144
			BEGIN
				DECLARE @TblFragmentation TABLE (DatabaseName VARCHAR(32), TotalIndexCount INT, IndexCount INT, Percentage INT)
				INSERT INTO @TblFragmentation
				SELECT  DatabaseName, SUM(IndexCount), SUM(CASE WHEN FragmentationPct > 30 THEN IndexCount ELSE 0 END), 0
				FROM    cf_SurveyIndexFragmentation AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
				GROUP BY DatabaseName
				UPDATE	@TblFragmentation SET Percentage = 100*IndexCount/TotalIndexCount
				SET @tmpStatus = @strInfo
				SET @tmpRecommendation = @infoMessage
				IF EXISTS (SELECT * FROM @TblFragmentation)
					SELECT @tmpResult += (DatabaseName + ': <b>' + CAST(Percentage AS VARCHAR(3)) + '% </b> indices are over 30% fragmented<DELIM>')
					FROM   @TblFragmentation
					ORDER BY DatabaseName
				ELSE
				BEGIN
					SET @tmpStatus = @strUnknown
					SET @tmpResult = 'No data available'
					SET @tmpRecommendation = ''
				END
			END

			--Disk Pruning
			ELSE IF @queryId = 156
			BEGIN

				declare @criticalNo int = 0
				declare @warningNo int = 0
				declare @totalNo int = 0

				declare @DDBTable table
				(
					PrimaryRecords bigint,
					ZeroRefCount	bigint,
					SevenDaysOldMMDeletedAFtable bigint
				)

				INSERT INTO @DDBTable
				SELECT PrimaryRecords, ZeroRefCount, AF.SevenDaysOldMMDeletedAFtable FROM cf_SurveyDDBPerformance csInfo INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 65 AND ISNULL(PrimaryRecords,-1) > -1 AND ISNULL(ZeroRefCount,-1) > -1
							INNER JOIN (SELECT DD.SIDBStoreId,DD.SevenDaysOldMMDeletedAFtable  FROM cf_SurveyDeDupDeletedAFCount AS DD WITH (NOLOCK)
										INNER JOIN cf_CommservSurveyResults G
										ON DD.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1) AS AF
										ON csInfo.SidbStoreId = AF.SIDBStoreId

				SET @totalNo = (SELECT COUNT(*) FROM @DDBTable)
				SET @warningNo = (SELECT COUNT(*) FROM @DDBTable WHERE ZeroRefCount >= (@warningThreshold * PrimaryRecords /100.0) AND ZeroRefCount < (@criticalThreshold * PrimaryRecords /100.0) OR SevenDaysOldMMDeletedAFtable BETWEEN 5000 AND 10000)
				SET @criticalNo = (SELECT COUNT(*) FROM @DDBTable WHERE ZeroRefCount >= (@criticalThreshold * PrimaryRecords /100.0) OR SevenDaysOldMMDeletedAFtable > 10000 )

				SET @tmpStatus = CASE
					WHEN @totalNo = 0 THEN @strInfo
					WHEN @criticalNo > 0 THEN @strCritical
					WHEN @warningNo > 0 THEN @strwarning
					ELSE @strGood END

				IF (@totalNo > 0)
				BEGIN
					SET @tmpResult = 'Dedupe Stores: <DELIM>'
					SET @tmpResult += 'Total: <B>'+ CAST(@totalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Good: <B>' + CAST((@totalNo-@warningNo-@criticalNo) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Warning: <B>' + CAST(@warningNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					SET @tmpResult += 'Critical: <B>' + CAST(@criticalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				END
				ELSE
					SET @tmpResult =  'There are no Media Agents hosting DDB store.<DELIM>'

				SET @tmpRecommendation = CASE
					WHEN @totalNo = 0 THEN @infoMessage
					WHEN @totalNo > 0 AND @criticalNo = 0 AND @warningNo = 0 THEN @goodMessage
					ELSE @warningMessage END
			END

			UPDATE	@TblSurveyResult
			SET		Status = ISNULL(@tmpStatus, @strUnknown),
					LogDate = @tmpLogDate,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation
			WHERE	MonitorId = @queryId AND (@parameterName = '' OR Monitor = @parameterName)

			FETCH NEXT FROM HealthQueryCur
			INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage
		END

		UPDATE @TblSurveyResult
		SET		ParamId = H.ParamId
		FROM	@TblSurveyResult T, cf_SurveyHealthParam H
		WHERE	T.Monitor = H.ParameterName

		CLOSE HealthQueryCur
		DEALLOCATE HealthQueryCur

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetServerHealthFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetServerHealthFunc' AND revision = '1.74')

  insert into GXDBVersions values(5, 'RptGetServerHealthFunc',  '1.74', 'RptGetServerHealthFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetSurveyResultsFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetSurveyResultsFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetSurveyResultsFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetSurveyResultsFunc]
  delete from GXDBVersions where name = 'RptGetSurveyResultsFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetSurveyResultsFunc]
	(
		@i_QueryId INT = 0,
		@i_CommServUniqueId INT = 0,
		@b_Latest INT = 1,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEND DATETIME = NULL,
		@i_UserId  		INT = NULL
	)
	RETURNS @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID VARCHAR(32) NOT NULL,
		CommServIP VARCHAR(256) NOT NULL,
		CommServGUID VARCHAR(256) NOT NULL,
		CustomerName NVARCHAR(256) NOT NULL,
		CommServName NVARCHAR(256),
		LogDate DATETIME NOT NULL,
		LogDateUTC DATETIME NOT NULL,
		RunningTime INT NOT NULL,
		CommServTZ VARCHAR(256) NOT NULL,
		CSVersion VARCHAR(256),
		surveyxml XML
	)
	AS
	BEGIN
		--DECLARE @defaultLogDateStart DATETIME = (SELECT MIN(LogDate) FROM cf_CommservSurveyResults WITH (NOLOCK, READUNCOMMITTED) WHERE QueryId = @i_QueryId)
		--DECLARE @defaultLogDateEND DATETIME = (SELECT MAX(LogDate) FROM cf_CommservSurveyResults WITH (NOLOCK, READUNCOMMITTED) WHERE QueryId = @i_QueryId)
		DECLARE @defaultLogDateStart DATETIME = DATEADD(MONTH, -3, GETUTCDATE())
		DECLARE @defaultLogDateEND DATETIME = GETUTCDATE()

		IF (@i_QueryId IS NULL)
			SET @i_QueryId = 0
		IF (@i_CommServUniqueId IS NULL)
			SET @i_CommServUniqueId = 0
		IF (@i_LogDateStart IS NULL)
			SET @i_LogDateStart =@defaultLogDateStart
		IF (@i_LogDateEND IS NULL)
			SET @i_LogDateEND = @defaultLogDateEND

	DECLARE @UserCapability INT = -1
	DECLARE @UserProp xml
	DECLARE @CommcellTbl TABLE (ccid			NVARCHAR(100),	csGUID			NVARCHAR(100))
	 SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId =@i_UserId)
	 IF (@i_UserId=-1 or @UserCapability =1)
	 BEGIN
			 INSERT INTO @CommcellTbl (ccid,csGUID)
			--SELECT CommCellID,CommServGUID FROM cf_CommcellIdNameMap WITH (NOLOCK) WHERE (Flags & 1) <> 1
  				SELECT '' ,''
	END
	ELSE IF  (@i_UserId IS NOT NULL)
	BEGIN
		 SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId =@i_UserId)
		 INSERT INTO @CommcellTbl (ccid,csGUID)
			SELECT commcells.value('@commCellId'			, '[NVARCHAR](MAX)'),
				   commcells.value('@csGUID'				, '[NVARCHAR](MAX)')
			From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
			CROSS apply resp.nodes('commcells') AS commcells(commcells)

	END
	ELSE
	BEGIN
		RETURN
	 END


		IF(@b_Latest = 0)
		IF @i_CommServUniqueId = 0
		INSERT INTO @TblSurveyResult
			SELECT
				result.CommServUniqueId,
				result.CommCellID,
				result.CommServIP,
				result.CommServGUID,
				result.CustomerName,
				result.CommServName,
				result.LogDate,
				result.LogDateUTC,
				result.RunningTime,
				result.CommServTimeZone,
				result.CommServVersion,
				result.CollectedResults
			FROM cf_SurveyResultView AS result WITH (NOLOCK, READUNCOMMITTED)
				INNER JOIN @CommcellTbl tbl ON
				(tbl.ccid='' OR
				 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
				 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))
				 AND --((result.CommServUniqueId = @i_CommServUniqueId) OR (@i_CommServUniqueId = 0)) AND
				(result.LogDateUTC BETWEEN @i_LogDateStart AND  @i_LogDateEND)
				AND result.SurveyID = @i_QueryId
		ELSE
		INSERT INTO @TblSurveyResult
			SELECT
				result.CommServUniqueId,
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				result.LogDate,
				result.LogDateUTC,
				result.RunningTime,
				result.CommServTimeZone,
				result.CommServVersion,
				result.CollectedResults
			FROM cf_SurveyResultView AS result WITH (NOLOCK, READUNCOMMITTED)
				INNER JOIN @CommcellTbl tbl ON
				 (tbl.ccid='' OR
				 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
				 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))
				AND (result.CommServUniqueId = @i_CommServUniqueId)
				AND (result.LogDateUTC BETWEEN @i_LogDateStart AND  @i_LogDateEND)
				AND result.SurveyID = @i_QueryId
		ELSE
		IF @i_CommServUniqueId = 0
		INSERT INTO @TblSurveyResult
			SELECT
				Sub2.CommServUniqueId,
				Sub2.CommCellID,
				Sub2.CommServIP,
				Sub2.CommServGUID,
				Sub2.CustomerName,
				Sub2.CommServName,
				Sub2.LogDate,
				Sub2.LogDateUTC,
				Sub2.RunningTime,
				Sub2.CommServTimeZone,
				Sub2.CommServVersion,
				Sub2.CollectedResults
			FROM
			(
					(SELECT
						CommServUniqueId,
						SurveyID,
						SurverResultId,
						LogDate,
						LogDateUTC,
						ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, SurveyID ORDER BY CommServUniqueId, LogDateUTC DESC) AS RowId
					FROM cf_SurveyResultView result WITH (NOLOCK, READUNCOMMITTED)
						INNER JOIN @CommcellTbl tbl ON
					 (tbl.ccid='' OR
					 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
					 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))) AS Sub1
					INNER JOIN cf_SurveyResultView AS Sub2 WITH (NOLOCK, READUNCOMMITTED)
						ON Sub1.RowId = 1
						AND Sub1.CommServUniqueId = Sub2.CommServUniqueId
						AND Sub1.SurverResultId = Sub2.SurverResultId
						AND Sub1.SurveyID = Sub2.SurveyID
						--AND ((Sub2.CommServUniqueId = @i_CommServUniqueId) OR (@i_CommServUniqueId = 0))
						AND Sub2.SurveyID = @i_QueryId
			)
		 ELSE
		 INSERT INTO @TblSurveyResult
			SELECT
				Sub2.CommServUniqueId,
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				Sub2.LogDate,
				Sub2.LogDateUTC,
				Sub2.RunningTime,
				Sub2.CommServTimeZone,
				Sub2.CommServVersion,
				Sub2.CollectedResults
			FROM
			(
					(SELECT
						CommServUniqueId,
						SurveyID,
						SurverResultId,
						LogDate,
						LogDateUTC,
						ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, SurveyID ORDER BY CommServUniqueId, LogDateUTC DESC) AS RowId
					FROM cf_SurveyResultView result WITH (NOLOCK, READUNCOMMITTED)
						INNER JOIN @CommcellTbl tbl ON
					 (tbl.ccid='' OR
					 (tbl.ccid =result.CommCellID AND result.CommCellID <>-1) OR
					 (result.CommCellID =-1 AND tbl.csGUID =result.CommServGUID ))) AS Sub1
					INNER JOIN cf_SurveyResultView AS Sub2 WITH (NOLOCK, READUNCOMMITTED)
						ON Sub1.RowId = 1
						AND Sub1.CommServUniqueId = Sub2.CommServUniqueId
						AND Sub1.SurverResultId = Sub2.SurverResultId
						AND Sub1.SurveyID = Sub2.SurveyID
						AND Sub2.CommServUniqueId = @i_CommServUniqueId
						AND Sub2.SurveyID = @i_QueryId
			)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetSurveyResultsFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetSurveyResultsFunc' AND revision = '1.5')

  insert into GXDBVersions values(5, 'RptGetSurveyResultsFunc',  '1.5', 'RptGetSurveyResultsFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/JobSelectionPatternFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JobSelectionPatternFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JobSelectionPatternFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JobSelectionPatternFunc]
  delete from GXDBVersions where name = 'JobSelectionPatternFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[JobSelectionPatternFunc] (
		@SelectionType INT, @SelectionFlags INT, @NumberPeriod INT, @DayNumber INT
		)
		RETURNS VARCHAR(1024)
	AS
	BEGIN
		DECLARE	@tempStr VARCHAR(1024)

		IF	@SelectionType = 0
			SET	@tempStr = 'All jobs'
		ELSE
		IF	@SelectionType = 1
			SET	@tempStr = 'All full jobs'
		ELSE
		IF	@SelectionType = 2
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'week' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' weeks' END
							+ ' starting from '
							+ CASE @DayNumber WHEN 1 THEN 'Monday' WHEN 2 THEN 'Tuesday' WHEN 3 THEN 'Wednesday'
								WHEN 4 THEN 'Thurday' WHEN 5 THEN 'Friday' WHEN 6 THEN 'Saturday' ELSE 'Sunday' END
		ELSE
		IF	@SelectionType = 3
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'day' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' days' END
		ELSE
		IF	@SelectionType = 4
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'month' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' months' END
							+ ' starting from '
							+ CASE @DayNumber WHEN 1 THEN '1st' WHEN 2 THEN '2nd' WHEN 3 THEN '3rd'
								ELSE CAST(@DayNumber AS VARCHAR(8)) + 'th' END + ' day'
		ELSE
		IF	@SelectionType = 8
			SET	@tempStr = 'Latest full jobs'
		ELSE
		IF	@SelectionType = 9
			SET	@tempStr = 'Manually selected full jobs'
		ELSE
		IF	@SelectionType = 10
			SET	@tempStr = CASE WHEN (@SelectionFlags & 4096) = 0 THEN 'First' ELSE 'Last' END
							+ ' full job every '
							+ CASE WHEN @NumberPeriod = 1 THEN 'hour' ELSE CAST(@NumberPeriod AS VARCHAR(8)) + ' hours' END

		RETURN @tempStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JobSelectionPatternFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JobSelectionPatternFunc' AND revision = '1.1')

  insert into GXDBVersions values(5, 'JobSelectionPatternFunc',  '1.1', 'JobSelectionPatternFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptMetricsCommCellDetails.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptMetricsCommCellDetails'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptMetricsCommCellDetails]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptMetricsCommCellDetails]
  delete from GXDBVersions where name = 'RptMetricsCommCellDetails' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptMetricsCommCellDetails]
	(
		@i_CSUniqueId INT = 0,
		@QueryId INT = 0,
		@i_UserId INT = 0,
		@i_OpType INT = 1
	)
	RETURNS @Results TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID VARCHAR(32) NOT NULL,
		CommServIP VARCHAR(256) NOT NULL,
		CommServGUID VARCHAR(256) NOT NULL,
		CommCellName NVARCHAR(256) NOT NULL,
		CustomerName NVARCHAR(256),
		CommServName NVARCHAR(256),
		CommServTZ VARCHAR(256),
		CommServVersion VARCHAR(256),
		CommServEdition VARCHAR(256),
		MonitoredClientGroup VARCHAR(MAX),
		LastCollectionTime DATETIME,
		IsHealthEnabled varchar(4),
		LastHealthCollectionTime DATETIME,
		IsUCEnabled varchar(4),
		LastUCCollectionTime DATETIME,
		IsUREnabled varchar(4),
		LastURCollectionTime DATETIME,
		IsActivityEnabled varchar(4),
		LastActivityCollectionTime DATETIME,
		IsChargeBackEnabled varchar(4),
		LastchargeBackTime DATETIME,
		IsAuditEnabled varchar(4),
		LastHeartbeatTime DATETIME,
		LastAuditTime DATETIME,
		LicExpirationDate VARCHAR(12)
	)
	AS
	BEGIN


	IF @QueryId <= 0
		SET @QueryId = 2
	ELSE IF @QueryId = 77
		SET @QueryId = 67
	ELSE IF @QueryId IN (99, 100, 112)
		SET @QueryId = 23
	ELSE IF @QueryId IN (98, 101, 102)
		SET @QueryId = 24
	ELSE IF @QueryId = 105
		SET @QueryId = 39
	ELSE IF @QueryId = 111
		SET @QueryId = 26

	INSERT INTO @Results
	SELECT
		cc.CommServUniqueId, cc.CommCellID, cc.CommServIP, cc.CommServGUID,
		CASE
			WHEN (SELECT COALESCE(SUM(CAST(Value AS INT)), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate') = 1 THEN cc.CommServName
			ELSE ISNULL(map.DisplayName,cc.CustomerName + ' - ' + cc.CommServName)
		END AS 'CommCellName',
		cc.CustomerName, cc.CommServName, cc.CommServTimeZone, cc.CommServVersion, cc.CommServEdition,  'N/A',
		dbo.UTCToLocalDateTimeConversion(map.ModifiedTime,cc.CommServTimeZone),'No', NULL, 'No', NULL, 'No', NULL, 'No', NULL, 'No', NULL,'No', NULL, NULL,
		CASE WHEN ISNULL(info.LicExpirationDate, 0) <= 0 THEN ''
			 ELSE CONVERT(NVARCHAR(12), dbo.UTCToLocalDateTimeConversion(dbo.GetDateTime(info.LicExpirationDate), cc.CommServTimeZone), 107)
		END
	FROM dbo.cf_SurveyResultFuncV1(2, @i_CSUniqueId, 1, NULL, NULL,@i_UserId,-1) as cc
		INNER JOIN cf_SurveyCSDetailsInfo as info ON info.SurveyResultId = cc.SurverResultId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId
	order by map.ModifiedTime desc

	--Update Monitored Client Group
	UPDATE @Results SET MonitoredClientGroup = bkpStat.ClientGroups
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(16, @i_CSUniqueId, 1, NULL, NULL,@i_UserId,-1) AS cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_SurveyBkpJobStats AS bkpStat WITH (NOLOCK)
			ON bkpStat.SurveyResultId = cc.SurverResultId


	--Update Health Check Status
	UPDATE @Results SET IsHealthEnabled = CASE WHEN (CommCellSurveyServices&1)=1 THEN 'Yes' ELSE 'NO' END , LastHealthCollectionTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(16, @i_CSUniqueId, 1, NULL, NULL,@i_UserId,-1) AS cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId



	--Update Upgrade Check Status
	UPDATE @Results	SET IsUCEnabled = CASE WHEN (CommCellSurveyServices&2)=2 THEN 'Yes' ELSE 'NO' END , LastUCCollectionTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(40, @i_CSUniqueId, 1, NULL, NULL,@i_UserId,-1) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId


	--Update Activity Status
	UPDATE @Results SET IsActivityEnabled = CASE WHEN (CommCellSurveyServices&4)=4 THEN 'Yes' ELSE 'NO' END , LastActivityCollectionTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(51, @i_CSUniqueId, 1, NULL, NULL,@i_UserId,-1) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId


	--Update Charge Back Status
	UPDATE @Results SET IsChargeBackEnabled = CASE WHEN (CommCellSurveyServices&32)=32 THEN 'Yes' ELSE 'NO' END , LastchargeBackTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(136, @i_CSUniqueId, 1, NULL, NULL,@i_UserId,-1) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId



	--Update Audit Status
	UPDATE @Results SET IsAuditEnabled = CASE WHEN (CommCellSurveyServices&16)=16 THEN'Yes' ELSE 'NO' END , LastAuditTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(63, @i_CSUniqueId, 1, NULL, NULL,@i_UserId,-1) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId

	--Update Heartbeat Time
	UPDATE @Results SET LastHeartbeatTime = cs.ModifiedTime
	FROM @Results as result
		INNER JOIN cf_CommcellIdNameMap as cs
			ON result.CommServUniqueId = cs.ID

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptMetricsCommCellDetails]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptMetricsCommCellDetails' AND revision = '1.18')

  insert into GXDBVersions values(5, 'RptMetricsCommCellDetails',  '1.18', 'RptMetricsCommCellDetails', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetCommcellCount.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetCommcellCount'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetCommcellCount]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetCommcellCount]
  delete from GXDBVersions where name = 'RptGetCommcellCount' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetCommcellCount]
	(
		@i_optype INT = 0,
		@i_UserId  INT = NULL,
		@i_GroupId INT = NULL,
		@i_IncludeDisabledCC INT = 0
	)
	RETURNS BIGINT
	AS
	BEGIN
	DECLARE @total BIGINT
	DECLARE @activityTotal BIGINT
	DECLARE @healthTotal BIGINT
	DECLARE @retVal BIGINT =0
	DECLARE @blLatestSurvey INT = 1
	IF @i_IncludeDisabledCC = 1
		SET @blLatestSurvey = 3

	SELECT  @activityTotal= sum(case when (csInfo.CommCellSurveyServices & 4) =4 then 1 else 0 end ) ,
			@healthTotal= sum(case when (csInfo.CommCellSurveyServices & 1) =1 then 1 else 0 end ) ,
			@total = count(*)
	FROM cf_SurveyResultFuncV1(146, 0, @blLatestSurvey, NULL, NULL, @i_UserId, @i_GroupId) as resultFn
		INNER JOIN cf_CommcellIdNameMap csinfo WITH (NOLOCK)
	ON resultFn.CommServUniqueId = csinfo.ID



	IF (@i_optype = 1)	-- THIS IS FOR ACTIVITY
	BEGIN
		SET @retVal = @activityTotal
	END
	ELSE IF(@i_optype = 0) -- THIS IS FOR general
	BEGIN
		SET @retVal = @total
	END
	ELSE IF(@i_optype = 2) -- THIS IS FOR health
	BEGIN
		SET @retVal = @healthTotal
	END
	RETURN @retVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetCommcellCount]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetCommcellCount' AND revision = '1.7')

  insert into GXDBVersions values(5, 'RptGetCommcellCount',  '1.7', 'RptGetCommcellCount', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetAvgBkpThroughput.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAvgBkpThroughput'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAvgBkpThroughput]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAvgBkpThroughput]
  delete from GXDBVersions where name = 'GetAvgBkpThroughput' and type = 5
END
GO

	CREATE FUNCTION [dbo].[GetAvgBkpThroughput]
	(
		@i_CommServUniqueId INT = 0,
		@i_lastNDays INT = 1,
		@i_Type INT = 0, --0-> Tape, 1 = DISK, 2->All
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL
	)
	RETURNS DECIMAL(32,2)
	AS
	BEGIN
	IF ( @i_lastNDays = 0) return 0
	DECLARE @AvgThroughput DECIMAL(32, 2) = 0
	DECLARE @iQueryId INT = 55
	DECLARE @iLatest INT = 1
	DECLARE	@LastDays INT = @i_lastNDays

	SELECT @AvgThroughput =
		   SUM(csInfo.AppSizeGB)/(@i_lastNDays*24)
	FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@iQueryId, @i_CommServUniqueId, @iLatest, NULL, NULL, @i_UserId, @i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND (csInfo.IsDisk = @i_Type OR @i_Type = 2) --Disk OR Tape OR Both
			AND DATEDIFF(day, jobsEndDate,resultView.Logdate) <= @i_lastNDays
	RETURN @AvgThroughput
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAvgBkpThroughput]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAvgBkpThroughput' AND revision = '1.6')

  insert into GXDBVersions values(5, 'GetAvgBkpThroughput',  '1.6', 'GetAvgBkpThroughput', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptCommCellSLAInfo.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptCommCellSLAInfo'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptCommCellSLAInfo]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptCommCellSLAInfo]
  delete from GXDBVersions where name = 'RptCommCellSLAInfo' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptCommCellSLAInfo] (
		@i_CommServUniqueId INT = 0,
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL
	 )
	RETURNS @TblCommCellSLAInfo TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID INTEGER NOT NULL,
		SLAPercent DECIMAL(6, 2) NOT NULL,
		SLAStatus VARCHAR(10) NOT NULL,
		SLAAsOf DATETIME NOT NULL,
		ProtectedSubclients INTEGER NOT NULL,
		NotProtectedSubclients INTEGER NOT NULL
	)
	 AS
	 BEGIN
	DECLARE @strGood		VARCHAR(10) = 'Good'
	DECLARE @strInfo		VARCHAR(10) = 'Info'
	DECLARE @strWarning		VARCHAR(10) = 'Warning'
	DECLARE @strCritical	VARCHAR(10) = 'Critical'
	DECLARE @strUnknown		VARCHAR(10) = 'Unknown'
	DECLARE @WarningThreshold INT, @CriticalThreshold INT
	SELECT @WarningThreshold = WarningThreshold, @CriticalThreshold= CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 27

	INSERT INTO @TblCommCellSLAInfo
	SELECT
		sub.CommServUniqueId,
		CAST(sub.CommCellID AS INT) AS CommCellID,
		CASE
			WHEN (sub.NotProtectedSubclients+sub.ProtectedSubclients) > 0 THEN CAST(sub.ProtectedSubclients*100.0/(sub.NotProtectedSubclients+sub.ProtectedSubclients) AS DECIMAL(6, 2))
			ELSE 0
		END,
		CASE
			WHEN (sub.NotProtectedSubclients+sub.ProtectedSubclients) = 0 THEN @strUnknown
			WHEN sub.ProtectedSubclients*100/(sub.NotProtectedSubclients+sub.ProtectedSubclients) < @criticalThreshold THEN @strCritical
			WHEN sub.ProtectedSubclients*100/(sub.NotProtectedSubclients+sub.ProtectedSubclients) < @warningThreshold THEN @strWarning
			ELSE @strGood
		END,
		sub.LogDate,
		ProtectedSubclients,
		NotProtectedSubclients
	FROM
		(SELECT DISTINCT
			resultView.CommServUniqueId,
			resultView.CommCellID,
			csInfo.ProtectedSubclients,
			csInfo.NotProtectedSubclients,
			csInfo.LogDate
		FROM
			cf_SurveyUnprotectedClients AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueId, 1, 0, 0, @i_UserId, @i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.Days = 30) AS sub
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptCommCellSLAInfo]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptCommCellSLAInfo' AND revision = '1.4')

  insert into GXDBVersions values(5, 'RptCommCellSLAInfo',  '1.4', 'RptCommCellSLAInfo', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/FormatTime.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: FormatTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[FormatTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[FormatTime]
  delete from GXDBVersions where name = 'FormatTime' and type = 5
END
GO

	CREATE FUNCTION [dbo].[FormatTime]
	(
		@i_timeinHrs FLOAT
	)
	RETURNS VARCHAR(MAX)
	AS
	BEGIN
	RETURN CONVERT(varchar(32), FLOOR(@i_timeinHrs)) + ':' + RIGHT('00' + CONVERT(varchar(32), FLOOR((@i_timeinHrs - FLOOR(@i_timeinHrs)) * 60)), 2)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [FormatTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'FormatTime' AND revision = '1.2')

  insert into GXDBVersions values(5, 'FormatTime',  '1.2', 'FormatTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetRenderedValue.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetRenderedValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetRenderedValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetRenderedValue]
  delete from GXDBVersions where name = 'GetRenderedValue' and type = 5
END
GO

	CREATE FUNCTION [dbo].[GetRenderedValue]
	(
	   @inputValue		NVARCHAR(MAX),
	   @renderer		NVARCHAR(128),
	   @dataType		NVARCHAR(128)
	)
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
		DECLARE @output NVARCHAR(MAX)

		IF ISNULL(@renderer, '') = ''
			SET @output = @inputValue
		ELSE IF ISNULL(@renderer, '') = 'booleanRenderer'
		BEGIN
			IF (@inputValue = 'true' OR @inputValue = 'yes')
				SET @output = 'Yes'
			ELSE
				SET @output = 'No'
		END
		ELSE IF ISNULL(@renderer, '') = 'dateTimeRenderer'
			SET @output = CAST (dbo.GetDateTime(@inputValue) AS NVARCHAR(MAX))
		ELSE IF ISNULL(@renderer, '') = 'MMMYYYY' AND ISNULL(@dataType,'') like '%varchar'
			SET @output = (SELECT convert(CHAR(3), CAST (@inputValue AS DATE), 0) + ' ' + DATENAME(YEAR, @inputValue))
		ELSE IF ISNULL(@renderer, '') = 'MMMYYYY' AND ISNULL(@dataType,'') like '%int'
			SET @output = (SELECT convert(CHAR(3), CAST (dbo.GetDateTime(@inputValue) AS DATE), 0) + ' ' + DATENAME(YEAR, dbo.GetDateTime(@inputValue)))
		ELSE IF ISNULL(@renderer, '') = 'HEALTH_STATUS'
		BEGIN
			IF @inputValue = '0_Unknown'
				SET @output = 'Unknown'
			IF @inputValue = '1_Good'
				SET @output = 'Good'
			IF @inputValue = '2_Info'
				SET @output = 'Info'
			IF @inputValue = '3_Warning'
				SET @output = 'Warning'
			IF @inputValue = '4_Critical'
				SET @output = 'Critical'
		END
		ELSE IF ISNULL(@renderer, '') like 'Number%'
		BEGIN
			IF ISNULL(@renderer, '') = 'NumberNA' AND CAST(@inputValue AS DECIMAL(38,7)) < 0
				SET @output = 'N/A'
			ELSE IF ISNULL(@renderer, '') = 'NumberUnlimitedNA' AND CAST(@inputValue AS DECIMAL(38,7)) = -1.0
				SET @output = 'Unlimited'
			ELSE IF ISNULL(@renderer, '') = 'NumberUnlimitedNA' AND CAST(@inputValue AS DECIMAL(38,7)) = -2.0
				SET @output = 'N/A'
			ELSE
				SET @output = CAST(@inputValue AS NVARCHAR(MAX))
		END
		ELSE IF ISNULL(@renderer, '') = 'capacityMB' OR ISNULL(@renderer, '') = 'sizeMB'
		BEGIN
			IF CAST(@inputValue AS DECIMAL(38,7)) < 0
				SET @output = 'N/A'
			ELSE
				SET @output = CAST( dbo.FormatBytes ( CAST(@inputValue AS DECIMAL(38,7)), 'MB') AS NVARCHAR(MAX) )
		END
		ELSE IF ISNULL(@renderer, '') = 'MMMDDYYYY' OR ISNULL(@renderer, '') = 'MMMDDYYYYHrMinAM' OR ISNULL(@renderer, '') = 'HHMMSS' OR ISNULL(@renderer, '') = 'DWDDMMM'
		BEGIN
			IF @inputValue >= 0 AND @renderer = 'MMMDDYYYY'
				SET @output = CONVERT(VARCHAR(20),dbo.GetDateTime(@inputValue),107)
			ELSE IF @inputValue >= 0 AND @renderer = 'MMMDDYYYYHrMinAM'
				SET @output = CONVERT(VARCHAR(30),dbo.GetDateTime(@inputValue),100)
			ELSE IF @inputValue >= 0 AND @renderer = 'HHMMSS'
				SET @output = CONVERT(VARCHAR(20),dbo.GetDateTime(@inputValue),108)
			ELSE IF @inputValue >= 0 AND @renderer = 'DWDDMMM'
				SET @output = DATENAME(DW, dbo.GetDateTime(@inputValue)) + ' (' + CAST(DATEPART(DAY, dbo.GetDateTime(@inputValue)) as nvarchar(10))
							+ ' ' + CAST(DATENAME(MONTH, dbo.GetDateTime(@inputValue)) as nvarchar(3)) + ')'
			ELSE IF @inputValue >= 0 AND @renderer = 'DATETIME'
				SET @output = CONVERT(VARCHAR(20),dbo.GetDateTime(@inputValue),100)
			ELSE IF @inputValue = -2
				SET @output = 'Nothing to Copy'
			ELSE IF @inputValue = -3
				SET @output = 'Never'
			ELSE IF @inputValue = -4
				SET @output = 'History unavailable to estimate time'
			ELSE IF @inputValue = -5
				SET @output = 'Jan 1, 2038'
			ELSE IF @inputValue = -50
				SET @output = 'N/A'
			ELSE IF @inputValue = -100
				SET @output = ''
			ELSE
				SET @output = 'N/A'
		END
		ELSE
			SET @output = @inputValue



	   -- Return the result of the function
	   RETURN REPLACE(@output,'''','''''')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetRenderedValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetRenderedValue' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetRenderedValue',  '1.4', 'GetRenderedValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetDateTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTime]
  delete from GXDBVersions where name = 'GetDateTime' and type = 5
END
GO

	CREATE FUNCTION GetDateTime (@UnixTimeArg integer)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
	 	return dateadd(second, @UnixTimeArg, '01/01/1970')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTime' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetDateTime',  '1.2', 'GetDateTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetUnixTimeBig.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUnixTimeBig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUnixTimeBig]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUnixTimeBig]
  delete from GXDBVersions where name = 'GetUnixTimeBig' and type = 5
END
GO

	CREATE FUNCTION GetUnixTimeBig (@DateTimeArg datetime)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @dateTimeBase DATETIME
    DECLARE @unixtime BIGINT
    SET @dateTimeBase = '01/01/1970'
	IF (@DateTimeArg < @dateTimeBase)
	  set @unixtime = 0
	ELSE
		SET @unixtime = (convert(bigint, datediff(day, @dateTimeBase, @DateTimeArg)) * 24 * 60 * 60) + (datediff(second, dateadd(day, datediff(day, 0, @DateTimeArg), 0), @DateTimeArg))
	return @unixtime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUnixTimeBig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUnixTimeBig' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetUnixTimeBig',  '1.2', 'GetUnixTimeBig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptMetricsTrend.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptMetricsTrend'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptMetricsTrend]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptMetricsTrend]
  delete from GXDBVersions where name = 'RptMetricsTrend' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptMetricsTrend]
	(
		@i_trend int = 0
	)
	RETURNS @Results TABLE
	(
		STARTDATE DATE,
		ENDDATE DATE
	)
	AS
	BEGIN
	DECLARE @CNT INT
	DECLARE @ENDDATE DATE=DATEADD(DAY,1,GETUTCDATE())
    DECLARE @STARTDATE DATE=DATEADD(DAY,-1,@ENDDATE)

	SELECT @CNT=(CASE
		WHEN @i_trend = 1 THEN 7
		WHEN @i_trend = 2 THEN DATEDIFF(DAY,GETDATE(),DATEADD(MONTH,1,GETDATE()))
		WHEN @i_trend = 3 THEN DATEDIFF(DAY,GETDATE(),DATEADD(MONTH,3,GETDATE()))
		WHEN @i_trend = 4 THEN DATEDIFF(DAY,GETDATE(),DATEADD(MONTH,6,GETDATE()))
		WHEN @i_trend = 5 THEN DATEDIFF(DAY,GETDATE(),DATEADD(YEAR,1,GETDATE()))
		END)
	WHILE @CNT >0
	BEGIN
		INSERT INTO @Results values(@STARTDATE,@ENDDATE)
		SET @ENDDATE = @STARTDATE
		SET @STARTDATE=DATEADD(DAY,-1,@ENDDATE)
		SET @CNT=@CNT-1
	END

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptMetricsTrend]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptMetricsTrend' AND revision = '1.3')

  insert into GXDBVersions values(5, 'RptMetricsTrend',  '1.3', 'RptMetricsTrend', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetServicePackSortRank.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetServicePackSortRank'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetServicePackSortRank]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetServicePackSortRank]
  delete from GXDBVersions where name = 'GetServicePackSortRank' and type = 5
END
GO

	CREATE FUNCTION GetServicePackSortRank ( @Version nvarchar(16) )
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN

		IF RIGHT(@Version, 1) IN ('-', '+') SET @Version = SUBSTRING(@Version, 0, LEN(@Version)-1)

		RETURN ( CAST ( SUBSTRING( @Version,0, CASE WHEN CHARINDEX('.',@Version) <> 0
													THEN CHARINDEX('.', @Version)
													ELSE ( CASE WHEN CHARINDEX(' ',@Version) <>0
																THEN CHARINDEX(' ', @Version)
																ELSE len(@Version)
																END )
												END) AS int)  ) * 1000
		+ CASE WHEN ASCII( SUBSTRING(@Version, len(@Version),1)) >=97
			   THEN ASCII( SUBSTRING(@Version, len(@Version),1)) -96 +
				    CAST( (CASE WHEN CHARINDEX('P', @Version) <>0
													THEN SUBSTRING(@Version, CHARINDEX('P', @Version) + 1, LEN(@Version) - charindex('P', @Version) -1)
													ELSE 0
													END ) AS int) *10
		  ELSE
		  		   CAST(SUBSTRING( @Version , CASE
											  WHEN CHARINDEX('P', @Version) <>0
											  THEN CHARINDEX('P', @Version)+1
											  ELSE LEN(@Version)
											  END, LEN(@Version) - charindex('P', @Version) ) as int)*10

		  END

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetServicePackSortRank]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetServicePackSortRank' AND revision = '1.5')

  insert into GXDBVersions values(5, 'GetServicePackSortRank',  '1.5', 'GetServicePackSortRank', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetScaleHealthFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetScaleHealthFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetScaleHealthFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetScaleHealthFunc]
  delete from GXDBVersions where name = 'RptGetScaleHealthFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetScaleHealthFunc]
	(
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL,
		@blaggregate INT = 0,
		@blLatestSurvey INT = 1,
		@i_CommServUniqueID INT = 0,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEND DATETIME = NUll,
		@i_GroupType VARCHAR(128) = 'HourlyFormat',
		@bneedHealthinfoonly INT= 0
	)
	RETURNS @outputParam TABLE
	(
		Id				INTEGER NOT NULL IDENTITY (1,1),
		GroupName  varchar(256),
		ParameterName  varchar(256),
		status		  varchar(20),
		LastHour		  float,
		Last24Hour	  float,
		unit			  varchar(10),
		dbParameterName  varchar(256),
		outcome		varchar(1024),
		remarks		varchar(256),
		statusINT	INT,
		ParamId		INT
	)
	AS
	BEGIN

		DECLARE @i_QueryId BIGINT = 7
		DECLARE @strGood		VARCHAR(10) = '1_Good'
		DECLARE @strInfo		VARCHAR(10) = '2_Info'
		DECLARE @strwarning		VARCHAR(10) = '3_Warning'
	    DECLARE @strCritical	VARCHAR(10) = '4_Critical'
	    DECLARE @ParamId			INT = 16
		DECLARE @parameterName		NVARCHAR(256)
		DECLARE @warningThreshold	INT
		DECLARE @criticalThreshold	INT
		DECLARE @infoMessage		NVARCHAR(MAX)
		DECLARE @goodMessage		NVARCHAR(MAX)
		DECLARE @warningMessage		NVARCHAR(MAX)
		DECLARE @criticalMessage	NVARCHAR(MAX)
	    DECLARE @surveyResultId int
	    set @surveyResultId =	(select SurverResultId from dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId ) )
		DECLARE	ScaleQueryCur CURSOR FOR
		SELECT	ParamId,
				ParameterName,
				WarningThreshold,
				CriticalThreshold,
				InfoMessage,
				GoodMessage,
				WarningMessage,
				CriticalMessage
		FROM	cf_ReportParameterView where ParamId >= 700 AND queryId = 7 order by ParamId

		OPEN ScaleQueryCur

		FETCH NEXT FROM ScaleQueryCur
		INTO @ParamId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

		WHILE @@FETCH_STATUS <> -1
		BEGIN

			IF @ParamId = 721 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, 'GB', @parameterName, NULL, '',0,@ParamId)

				update @outputParam
				set LastHour = csInfo.LastHour
				FROM @outputParam outParam
				INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
					ON  csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property = outParam.dbParameterName
					AND outParam.dbParameterName = @parameterName
				update @outputParam
				set status = ( case when LastHour > @criticalThreshold  then @strCritical
									when (LastHour >@warningThreshold and LastHour <= @criticalThreshold)  then @strwarning
									when LastHour <=@warningThreshold then @strGood
							   end
							  ),
					statusINT = ( case when LastHour > @criticalThreshold  then 3
									when (LastHour >@warningThreshold and LastHour <=@criticalThreshold)  then 2
									when LastHour <=@warningThreshold then 1
							   end
							  )
				where ParameterName = @parameterName
			END
			ELSE IF @ParamId = 722 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, 'GB', @parameterName, NULL, '',0,@ParamId)

				update @outputParam
				set LastHour = csInfo.LastHour
				FROM @outputParam outParam
				INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
					ON  csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property = outParam.dbParameterName
					AND outParam.dbParameterName = @parameterName
				update @outputParam
				set status = ( case when LastHour > @criticalThreshold  then @strCritical
									when (LastHour >@warningThreshold and LastHour <= @criticalThreshold)  then @strwarning
									when LastHour <=@warningThreshold then @strGood
							   end
							  ),
					statusINT = ( case when LastHour > @criticalThreshold  then 3
									when (LastHour >@warningThreshold and LastHour <=@criticalThreshold)  then 2
									when LastHour <=@warningThreshold then 1
							   end
							  )
				where ParameterName = @parameterName
			END
			ELSE IF @ParamId = 723 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, 'GB', @parameterName, NULL, '',0,@ParamId)

			END
			ELSE IF @ParamId = 724 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, '', '', 'Top 10 Largest Tables by Size', '<VDL>',0,@ParamId)

				declare @tableData4tblsize xml = (
				select cast(csInfo.Unit as XML)
				FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
						WHERE  csInfo.SurveyResultId = @surveyResultid
						and csInfo.Property = 'Largest Tables by Size'
				)

				DECLARE @tableDataInfo TABLE
				(
					TableName				varchar(100),
					DataSizeinMB			bigint
				)
				 insert into @tableDataInfo(TableName, DataSizeinMB)
					SELECT
					T.n.value('@TableName', 'varchar(100)') ,
					cast(T.n.value('@DataSizeinKB', 'bigint') /1024.0    as BIGINT)
					FROM @tableData4tblsize.nodes('/TableData') AS T(n)


				IF EXISTS(SELECT * FROM @tableDataInfo WHERE DataSizeinMB > @criticalThreshold)
					update @outputParam
					set status =   @strCritical, statusINT =3,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended size.'
					where ParameterName = @parameterName
				ELSE IF EXISTS(SELECT * FROM @tableDataInfo WHERE DataSizeinMB >= @WarningThreshold and DataSizeinMB <= @criticalThreshold)
					update @outputParam
					set status =   @strwarning, statusINT =2,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended size.'
					where ParameterName = @parameterName
				ELSE
					update @outputParam
					set status =   @strGood, statusINT =1,
						dbParameterName = 'All tables are within the recommended size limit.'
					where ParameterName = @parameterName
			END
			ELSE IF @ParamId = 725 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, '', '', 'Top 10 Largest Tables by Row Count', '<VDL>',0,@ParamId)
				declare @tableData4tblrows xml = (
				select cast(csInfo.Unit as XML)
				FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
						WHERE  csInfo.SurveyResultId = @surveyResultid
						and csInfo.Property = 'Largest Tables by Rows'
				)
				DECLARE @tableDataInfo2 TABLE
				(
					TableName				varchar(100),
					TotalRows				bigint

				)
				 insert into @tableDataInfo2(TableName, TotalRows)
					SELECT
					T.n.value('@TableName', 'varchar(100)') ,
					T.n.value('@TotalRows', 'bigint')
					FROM @tableData4tblrows.nodes('/TableData') AS T(n)


				IF EXISTS(SELECT * FROM @tableDataInfo2 WHERE TotalRows > @criticalThreshold)
					update @outputParam
					set status =   @strCritical, statusINT =3,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended row count.'
					where ParameterName = @parameterName

				ELSE IF EXISTS(SELECT * FROM @tableDataInfo2 WHERE TotalRows >= @WarningThreshold and TotalRows <= @criticalThreshold)
					update @outputParam
					set status =   @strwarning, statusINT =2,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended row count.'
					where ParameterName = @parameterName

				ELSE
					update @outputParam
					set status =   @strGood, statusINT =1,
						dbParameterName = 'All tables are within the recommended row count limit.'
					where ParameterName = @parameterName

			END
			ELSE IF @ParamId = 726 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Client', @parameterName, @strInfo, NULL, NULL, '', @parameterName, NULL, '',0,@ParamId)
				Declare @percentActiveClients INT = 0
				Declare @ScaleLimit INT = 0
				Declare @ActiveClient INT = ISNULL((select TotalActiveClients from cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK) where CommServUniqueId = @i_CommServUniqueID
				and SurveyResultId = (select max(SurveyResultId) from cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK) where CommServUniqueId = @i_CommServUniqueID )),0)

				set @ScaleLimit = ISNULL((select cast(csInfo.Unit as INT)
				FROM @outputParam outParam
				INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
					ON  csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property = outParam.dbParameterName AND outParam.ParamId = @ParamId ),4000)
                IF(@ScaleLimit>0)
    				SET @percentActiveClients =  @ActiveClient*100/@ScaleLimit
    			ELSE
					SET @percentActiveClients = 100
				update @outputParam
				set status = ( case when @percentActiveClients > @criticalThreshold  then @strCritical
									when (@percentActiveClients  >@warningThreshold and @percentActiveClients  <= @criticalThreshold)  then @strwarning
									when @percentActiveClients  <=@warningThreshold then @strGood
							   end
							  ),
					statusINT = ( case when @percentActiveClients  > @criticalThreshold  then 3
									when (@percentActiveClients  >@warningThreshold and @percentActiveClients  <=@criticalThreshold)  then 2
									when @percentActiveClients  <=@warningThreshold then 1
							   end
							  ),
				remarks		=( case when @percentActiveClients > @criticalThreshold  then @criticalMessage
									when (@percentActiveClients  >@warningThreshold and @percentActiveClients  <= @criticalThreshold)  then @warningMessage
								else ''
							 end)
				where ParamId = @ParamId
				DECLARE @outComeInfo table
				(
					dbParameterName varchar(256),
					name			varchar(1024),
					LastHour		float
				)
				insert into @outComeInfo (dbParameterName,name, LastHour)
				select 'Client Scale Limit', 'Client Scale Limit : ', @ScaleLimit
				insert into @outComeInfo (dbParameterName,name, LastHour)
				select 'Active Clients', 'Active Clients : ', @ActiveClient
				update @outputParam
				set outcome= (select (select ' ' + name + '  <b>' +CAST(lasthour as varchar(10)) +
							   case when name ='Client Scale Limit : ' then '</b> <DELIM>'
							   ELSE '</b>' end
							  from @outComeInfo
							  for XML path(''),root('valueStr'), TYPE).value('/valueStr[1]','varchar(1024)'))
				where ParamId = @ParamId
			END
			ELSE IF @ParamId = 701 AND (@i_GroupType = 'HourlyFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '', 'AVG NO. OF ATMPTS PER JOB',NULL,'',0,@ParamId)


				update @outputParam
							set LastHour = csInfo.LastHour,
								Last24Hour = csInfo.Last24Hours
							FROM @outputParam outParam
							INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
								ON  csInfo.SurveyResultId = @surveyResultid
								and csInfo.Property = outParam.dbParameterName
								AND outParam.dbParameterName = @parameterName

				update @outputParam
				set status = ( case when LastHour >=2 or Last24Hour >=2 then @strCritical
				                when LastHour >= 1.5 or Last24Hour >=1.5 then @strwarning
									else @strGood
							   end
							  ),
				    statusINT = ( case when LastHour >= 2 or Last24Hour >= 2 then 3
				                  when LastHour >= 1.5 or Last24Hour >= 1.5 then 2
									else 1
							   end
							  )
					where ParameterName =@parameterName

			END
			ELSE IF @ParamId = 702 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, 'GB/HR', 'AVG JOB THROUGHPUT',NULL,'',0,@ParamId)

			END
			ELSE IF @ParamId = 703 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '%', 'JOBS COMPLETED IN ONE ATMPT',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 704 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '', 'JOBS COMPLETED',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 705 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '', 'Job Load',NULL,'<VDL>',0,@ParamId)

				DECLARE @jobLoad table
				(
					dbParameterName varchar(256),
					name			varchar(1024),
					LastHour		float
				)
				insert into @jobLoad values
				('JOBS IN QUEUE(RUNNING)', 'Running : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(PENDING)', 'Pending : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(WAITING)', 'Waiting : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(QUEUED)', 'Queued : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(SUSPENDED)', 'Suspended : ', NULL)
				update @jobLoad
				set LastHour = csInfo.LastHour
				FROM @jobLoad outParam
				INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
					ON  csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property = outParam.dbParameterName

				insert into @jobLoad (dbParameterName,name, LastHour)
				select 'TOTAL JOBS', 'Total Jobs: ', SUM(LastHour) from @jobLoad
				update @outputParam
				set outcome= (select (select ' ' + name + '  <b>' +CAST(lasthour as varchar(10)) +
							   case when name ='Waiting : ' then '</b> <DELIM>'
							   ELSE '</b>' end
							  from @jobLoad
							  for XML path(''),root('valueStr'), TYPE).value('/valueStr[1]','varchar(1024)'))
				where dbParameterName ='Job Load'

			END
			ELSE IF @ParamId = 711 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL,' Chunks/Hr', 'CHUNKS CLOSED',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 712 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL,  'GB/HR', 'SIZE OF CHUNKS',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 713 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL, '', 'MAX NO. OF STRMS TRANSF. DATA',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 714 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL, '', 'AVG NO. OF STRMS TRANSF. DATA',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 715 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL, '', 'NO. OF RESERVATIONS',NULL,'',0,@ParamId)
			END

			FETCH NEXT FROM ScaleQueryCur
			INTO @ParamId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

		END
		CLOSE ScaleQueryCur
		DEALLOCATE ScaleQueryCur

		update @outputParam
		set LastHour = csInfo.LastHour,
			Last24Hour = csInfo.Last24Hours
		FROM @outputParam outParam
		INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
			ON  csInfo.SurveyResultId = @surveyResultid
			and csInfo.Property = outParam.dbParameterName and outparam.ParamId <> 726

		IF (@bneedHealthinfoonly = 1)
		BEGIN
			DECLARE @statusInt INT= (SELECT MAX(statusINT) FROM @outputParam)
			DELETE FROM @outputParam WHERE statusINT <> @statusInt
		--	DELETE FROM @outputParam WHERE Id <> (SELECT MIN(Id) FROM @outputParam)
			IF (@statusInt>1) -- update outcome with below message only for warning and critical case
				UPDATE @outputParam
				set outcome = CASE WHEN ParamId = 721 THEN 'The tempdb database size is too large.'
								   WHEN ParamId = 722 THEN 'The tempdb log size is too large.'
								   WHEN ParamId IN (724,725) THEN 'The CommServe database tables are too large.'
								   WHEN ParamId = 701 THEN 'The average attempts per job is too high.'
								   WHEN ParamId = 726 THEN 'Contact Support to increase the client scale limits.'
								   END
			ELSE 	-- update outcome with below message only for good case
				UPDATE @outputParam
				set outcome = 'Scale Statistics'
		END

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetScaleHealthFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetScaleHealthFunc' AND revision = '1.10')

  insert into GXDBVersions values(5, 'RptGetScaleHealthFunc',  '1.10', 'RptGetScaleHealthFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetValueAssessmentFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: RptGetValueAssessmentFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetValueAssessmentFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetValueAssessmentFunc]
  delete from GXDBVersions where name = 'RptGetValueAssessmentFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetValueAssessmentFunc]
	(
		@i_CommServUniqueId INT = 0,
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL
	)
	RETURNS @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		MonitorId INTEGER NOT NULL,
		Monitor NVARCHAR(MAX) NOT NULL,
		Status VARCHAR(10) NOT NULL,
		Result NVARCHAR(MAX),
		Recommendation NVARCHAR(MAX)
	)
	AS
	BEGIN
	DECLARE @strGood		VARCHAR(10) = '1_Good'
	DECLARE @strInfo		VARCHAR(10) = '2_Info'
	DECLARE @strwarning		VARCHAR(10) = '3_Warning'
	DECLARE @strCritical	VARCHAR(10) = '4_Critical'
	DECLARE @strUnknown		VARCHAR(10) = '0_Unknown'

	DECLARE @queryId			INT = 97
	DECLARE @parameterName		NVARCHAR(256)
	DECLARE @warningThreshold	INT
	DECLARE @criticalThreshold	INT
	DECLARE @infoMessage		NVARCHAR(MAX)
	DECLARE @goodMessage		NVARCHAR(MAX)
	DECLARE @warningMessage		NVARCHAR(MAX)
	DECLARE @criticalMessage	NVARCHAR(MAX)

	IF (@i_CommServUniqueId IS NULL OR @i_CommServUniqueId = 0)
		RETURN
	IF NOT EXISTS (SELECT * FROM dbo.cf_SurveyResultFuncV1(97, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId))
		RETURN

	INSERT INTO @TblSurveyResult
			SELECT	@i_CommServUniqueId, survey.QueryId, CASE WHEN LEN(map.ParameterName) > 0 THEN map.ParameterName ELSE survey.Name END, @strUnknown, '', ''
	FROM	cf_CommservSurveyQueries AS survey
			INNER JOIN cf_CommservSurveyGroupMap AS map
				ON map.SurveyId = survey.QueryId
				AND Flags & 4 = 4
				AND map.GroupId = 15
				AND map.SurveyId <> 171
			INNER JOIN cf_CommservSurveyGroups as sGroup
				ON sGroup.SurveyGroupId = map.GroupId

	DECLARE @TblLatestResult TABLE (QueryId INT, SurveyResultId INT, LogDate DATETIME)

	INSERT	INTO @TblLatestResult
	SELECT	DISTINCT R.QueryId, R.CommservSurveyResults_ID, R.LogDate
	FROM	cf_CommservSurveyResults R WITH (NOLOCK)
	INNER JOIN @TblSurveyResult S ON R.QueryId = S.MonitorId
	WHERE	R.CommcellIdNameMap_ID = @i_CommServUniqueId AND R.Flags = 1

	--If NO health check done - return
	IF NOT EXISTS (SELECT * FROM @TblLatestResult WHERE QueryID = @queryId)
	BEGIN
		DELETE FROM @TblSurveyResult
		RETURN
	END

	DECLARE @tmpStatus VARCHAR(10) = @strInfo
	DECLARE @tmpLogDate VARCHAR(20)
	DECLARE @tmpResult NVARCHAR(MAX) = ''
	DECLARE @tmpRecommendation NVARCHAR(MAX) = ''

	SELECT	@tmpLogDate = csInfo.LogDate
	FROM	cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
	INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = @queryId

	DECLARE @totSCs INT = 0
	DECLARE @SCsWithLongJobs INT = 0
	DECLARE @SCsWithLongJobsPercent DECIMAL(32,2) = 0
	DECLARE	HealthQueryCur CURSOR FOR
	SELECT	QueryId,
		ParameterName,
			WarningThreshold,
			CriticalThreshold,
			InfoMessage,
			GoodMessage,
			WarningMessage,
			CriticalMessage
	FROM	cf_ReportParameterView where ParamId IN (30, 31, 32, 33, 34, 35, 38, 39, 40, 41)

	OPEN HealthQueryCur

	FETCH NEXT FROM HealthQueryCur
	INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @tmpStatus = @strUnknown
		SET @tmpResult = ''
		SET @tmpRecommendation = @infoMessage

		--Network Efficiency
		IF @queryId = 97
		BEGIN
				DECLARE @NonMASubClients INT = 0
				DECLARE @NonMASCWithSourceDeDup INT = 0
				DECLARE @NonMASCWithSourceDeDupPercent DECIMAL(32,2) = 0
			DECLARE @AvgNetworkSavingsFrmDeDupe DECIMAL(32,2) = 0

			SELECT @NonMASubClients = csInfo.NonMASubClients, @NonMASCWithSourceDeDup = csInfo.NonMASCWithSourceDeDup,
					@AvgNetworkSavingsFrmDeDupe = csInfo.AvgDeDupSavings
			FROM	cf_SurveySourceDeDupEfficiency AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId

			SELECT @NonMASCWithSourceDeDupPercent = CASE WHEN @NonMASubClients = 0 THEN 0 ELSE (@NonMASCWithSourceDeDup*100.0)/@NonMASubClients END

			SET @tmpStatus =
			CASE
				WHEN @NonMASubClients = 0 THEN @strInfo
				WHEN @NonMASCWithSourceDeDupPercent >= @warningThreshold THEN @strGood
				WHEN @NonMASCWithSourceDeDupPercent > @criticalThreshold AND @NonMASCWithSourceDeDupPercent < @warningThreshold THEN @strWarning
				ELSE @strCritical
			END

			SET @tmpResult =
			CASE
				WHEN @NonMASubClients = 0 THEN 'No Subclients are found protected over the network (LAN) by deduplication storage policies.'
				ELSE '<b>' + CAST(@NonMASCWithSourceDeDup AS VARCHAR(MAX)) + ' (' + CAST(@NonMASCWithSourceDeDupPercent AS VARCHAR(MAX))
					+ '%)</b> out of <b>' + CAST(@NonMASubClients AS VARCHAR(MAX))
					+ '</b> Subclient(s) protected over the network (LAN) by deduplication storage policies have source side deduplication enabled.<BR>'
					+ 'Average networks savings from  '
					+ 'deduplication is <b>' + CAST(@AvgNetworkSavingsFrmDeDupe AS VARCHAR(14)) + '%</b>.<DELIM>'
			END

			SET @tmpRecommendation =
			CASE
				WHEN @NonMASubClients = 0 THEN @infoMessage
				WHEN @NonMASCWithSourceDeDupPercent = 100 THEN @goodMessage
				WHEN @NonMASCWithSourceDeDupPercent >= @warningThreshold THEN @goodMessage + '<VDL>'
				WHEN @NonMASCWithSourceDeDupPercent > @criticalThreshold AND @NonMASCWithSourceDeDupPercent < @warningThreshold THEN @warningMessage
				ELSE @criticalMessage
			END
		END
		--file system Backup Efficiency
		ELSE IF @queryId = 98
		BEGIN
			SET @totSCs = 0
			SET @SCsWithLongJobs = 0
			SELECT @totSCs = csInfo.TotalSCCount , @SCsWithLongJobs = csInfo.LongRunningSCs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyLongRunningFSFullJobs AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 24
						AND csInfo.JobId = 0
			SELECT @SCsWithLongJobsPercent = CASE WHEN @totSCs = 0 THEN 0 ELSE (@SCsWithLongJobs*100.0)/@totSCs END
			SET @tmpStatus =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @strCritical
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @SCsWithLongJobs > 0 THEN 'Found <b>' + CAST(@SCsWithLongJobs AS VARCHAR(MAX))
				+ ' (' + CAST(@SCsWithLongJobsPercent AS VARCHAR(MAX)) + '%)'
				+ '</b> out of <b>' + CAST(@totSCs AS VARCHAR(MAX))
				+ '</b> file system Subclient(s) with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
				ELSE 'No file system Subclients are found with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @criticalMessage
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--File Data Placement
		ELSE IF @queryId = 99
		BEGIN
				DECLARE @totFSC INT = 0
				DECLARE @totNoArcFSC INT = 0
				DECLARE @totNoArcFSCPercent DECIMAL(32,2) = 0
				SELECT @totFSC = csInfo.TotalClients, @totNoArcFSC = csInfo.TotalNoArchiveClients, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyLargestNoArchiveFSClients AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 23
							AND csInfo.ClientId = 0
				SELECT @totNoArcFSCPercent = CASE WHEN @totFSC = 0 THEN 0 ELSE (@totNoArcFSC*100.0)/@totFSC END
				SET @tmpStatus =
				CASE
					WHEN @totNoArcFSCPercent >= @criticalThreshold THEN @strCritical
					WHEN @totNoArcFSCPercent < @criticalThreshold AND @totNoArcFSCPercent > @warningThreshold THEN @strWarning
					ELSE @strGood
				END
				SET @tmpResult =
				CASE
					WHEN @totFSC > 0 THEN 'Found <b>' + CAST(@totNoArcFSC AS VARCHAR(MAX))
						+ ' (' + CAST(@totNoArcFSCPercent AS VARCHAR(MAX))
						+ '%) </b> out of <b>' + CAST(@totFSC AS VARCHAR(MAX)) +
						+ '</b> file system client(s) with <b>application size > 1 TB</b> that may be candidates for archiving in last 30 days  (last full backups).<DELIM>'
					ELSE 'No file system clients are found with application size > 1 TB that may be candidates for archiving in last 30 days  (last full backups).<DELIM>'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @totNoArcFSCPercent >= @criticalThreshold THEN @criticalMessage
					WHEN @totNoArcFSCPercent < @criticalThreshold AND @totNoArcFSCPercent > @warningThreshold THEN @warningMessage
					ELSE @goodMessage
				END
		END
		--Rapid Recovery Capability
		ELSE IF @queryId = 100
		BEGIN
			DECLARE @warningClientCount INT = 0
			DECLARE @totNoAppSnapC INT = 0
			DECLARE @avgRestoreThroughput DECIMAL(32, 2) = 0

			SELECT
				@totNoAppSnapC = ISNULL(MAX(sub.TotalNoSnapClients), 0),
				@avgRestoreThroughput = ISNULL(MAX(sub.avgThroughput), 0),
				@warningClientCount = COUNT(*),
				@tmpLogDate = CONVERT(VARCHAR(20), MAX(sub.LogDate), 100)
			FROM
			(SELECT
				csInfo.TotalNoSnapClients,
				CAST(csInfo.AvgRestoreThroughput AS DECIMAL(32,2)) AS avgThroughput,
				csInfo.LogDate
				FROM	cf_SurveyLargestNoSnapClients AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 23
						AND csInfo.ClientId <> 0
						AND csInfo.RestoreThroughput > 0
						AND (csInfo.ApplicationSizeTB*1024.0)/csInfo.RestoreThroughput > 8
			)AS sub
			SET @tmpStatus = CASE
				WHEN @warningClientCount > 0 THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @warningClientCount > 0
					THEN 'Found <b>' + CAST(@warningClientCount AS VARCHAR(MAX)) + '</b> application client(s) that may take longer than <b>8 hours</b> to restore (based on latest full backup jobs in the last 30 days).<DELIM>'
					+ 'Average Restore Throughput is <b>' + CAST(@avgRestoreThroughput AS VARCHAR(MAX)) + ' GB/HR</b>'
				ELSE 'No Application clients are found that may take longer than <b>8 hours</b> to restore (based on latest full backup jobs in the last 30 days).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @warningClientCount > 0 THEN @warningMessage
				WHEN @totNoAppSnapC > 0 THEN @infoMessage
				ELSE @goodMessage
			END
		END
		--VM Backup Efficiency
		ELSE IF @queryId = 101
		BEGIN
			SET @totSCs = 0
			SET @SCsWithLongJobs = 0
			SELECT @totSCs = csInfo.TotalSCCount, @SCsWithLongJobs = csInfo.LongRunningSCs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyLongRunningVSAFullJobs AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 24
						AND csInfo.JobId = 0
			SELECT @SCsWithLongJobsPercent = CASE WHEN @totSCs = 0 THEN 0 ELSE (@SCsWithLongJobs*100.0)/@totSCs END
			SET @tmpStatus =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @strCritical
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @SCsWithLongJobs > 0 THEN 'Found <b>' + CAST(@SCsWithLongJobs AS VARCHAR(MAX))
				+ ' (' + CAST(@SCsWithLongJobsPercent AS VARCHAR(MAX)) + '%)'
				+ '</b> out of <b>' + CAST(@totSCs AS VARCHAR(MAX))
				+ '</b> Subclient(s) with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
				ELSE 'No Subclients are found with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @criticalMessage
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--Application Backup Efficiency
		ELSE IF @queryId = 102
		BEGIN
			SET @totSCs = 0
			SET @SCsWithLongJobs = 0
			SELECT @totSCs = csInfo.TotalSCCount, @SCsWithLongJobs = csInfo.LongRunningSCs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyLongRunningFullJobs AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 24
						AND csInfo.JobId = 0
			SELECT @SCsWithLongJobsPercent = CASE WHEN @totSCs = 0 THEN 0 ELSE (@SCsWithLongJobs*100.0)/@totSCs END
			SET @tmpStatus =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @strCritical
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @SCsWithLongJobs > 0 THEN 'Found <b>' + CAST(@SCsWithLongJobs AS VARCHAR(MAX))
				+ ' (' + CAST(@SCsWithLongJobsPercent AS VARCHAR(MAX)) + '%)'
				+ '</b> out of <b>' + CAST(@totSCs AS VARCHAR(MAX))
				+ '</b> Subclient(s) with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
				ELSE 'No Subclients are found with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @criticalMessage
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--Disk Protection Tier Savings
		ELSE IF @queryId = 111
		BEGIN
			DECLARE @totPrimCopies INT = 0
			DECLARE @totDeDupPrimCopies INT = 0
			DECLARE @AppSizeGB FLOAT = 0
			DECLARE @TotSizeOnMediaGB FLOAT = 0
			DECLARE @DeDupRatio DECIMAL(20, 2) = 0
			DECLARE @DeDupPrimCopiesPercent DECIMAL(32,2) = 0
			SELECT TOP 1 @totPrimCopies = csInfo.PrimaryCopies, @totDeDupPrimCopies = csInfo.DeDupPrimaryCopies, @AppSizeGB = csInfo.TotalAppSize, @TotSizeOnMediaGB = csInfo.TotalSizeOnMedia, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 26
						AND csInfo.PrimaryCopies > 0
			SELECT @DeDupPrimCopiesPercent = CASE WHEN @totPrimCopies = 0 THEN 0 ELSE (@totDeDupPrimCopies*100.0)/@totPrimCopies END
			SELECT @DeDupRatio = CASE WHEN @AppSizeGB = 0 THEN 0 ELSE CAST((100.0*(@AppSizeGB-@TotSizeOnMediaGB)/@AppSizeGB) AS Decimal(20,2)) END
			SET @tmpStatus =
			CASE
				WHEN @totPrimCopies = 0 THEN @strInfo
				WHEN @DeDupPrimCopiesPercent < @criticalThreshold THEN @strCritical
				WHEN @DeDupPrimCopiesPercent >= @criticalThreshold AND @DeDupPrimCopiesPercent <= @warningThreshold THEN @strWarning
				ELSE @strGood
			END
			IF @totPrimCopies = 0
				SET @tmpResult = 'Primary Copies are not found.'
			ELSE
			BEGIN
				SET @tmpResult =
					'Found <b>' + CAST(@totDeDupPrimCopies AS VARCHAR(MAX))
						+ ' (' + CAST(@DeDupPrimCopiesPercent AS VARCHAR(MAX)) + '%)'
						+ '</b> out of <b>' + CAST(@totPrimCopies AS VARCHAR(MAX))
						+ '</b> Primary Copies with DeDuplication enabled in last 30 days.<DELIM>'
						+ 'Application Size of Protected Data (All Copies) : <b>' + dbo.FormatBytes(@AppSizeGB, 'GB') + ' </b><DELIM>'
						+ 'Media Size (All Copies) : <b>' + dbo.FormatBytes(@TotSizeOnMediaGB, 'GB') + '</b><DELIM>'
				IF @totDeDupPrimCopies > 0
					SET @tmpResult += 'Savings (All Copies) : <b>' + CAST(@DeDupRatio AS VARCHAR(MAX)) + '%</b>'
				ELSE
					SET @tmpResult += 'If Deduplication is used, estimated savings based on 85% reduction: <b>' + dbo.FormatBytes(@AppSizeGB*0.85, 'GB') + '</b>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @totPrimCopies = 0 THEN 'Primary Copies are not found.'
				WHEN @DeDupPrimCopiesPercent < @criticalThreshold THEN @criticalMessage
				WHEN @DeDupPrimCopiesPercent >= @criticalThreshold AND @DeDupPrimCopiesPercent <= @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--Email Data Placement
		ELSE IF @queryId = 112
		BEGIN
				DECLARE @totEmailClients INT = 0
				DECLARE @totNoArcEmailClients INT = 0
				DECLARE @totNoArcEmailCPercent DECIMAL(32,2) = 0
				SELECT @totEmailClients = csInfo.TotalClients, @totNoArcEmailClients = csInfo.TotalNoArchiveClients, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyLargestNoArcEmailClients AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 23
							AND csInfo.ClientId = 0
				SELECT @totNoArcEmailCPercent = CASE WHEN @totEmailClients = 0 THEN 0 ELSE (@totNoArcEmailClients*100.0)/@totEmailClients END
				SET @tmpStatus =
				CASE
					WHEN @totNoArcEmailCPercent >= @criticalThreshold THEN @strCritical
					WHEN @totNoArcEmailCPercent < @criticalThreshold AND @totNoArcEmailCPercent > @warningThreshold THEN @strWarning
					ELSE @strGood
				END
				SET @tmpResult =
				CASE
					WHEN @totEmailClients > 0 THEN 'Found <b>' + CAST(@totNoArcEmailClients AS VARCHAR(MAX))
						+ ' (' + CAST(@totNoArcEmailCPercent AS VARCHAR(MAX))
						+ '%) </b> out of <b>' + CAST(@totEmailClients AS VARCHAR(MAX)) +
						+ '</b> email client(s) with <b>application size > 1 TB</b> that may be candidates for archiving in last 30 days (last full backups).<DELIM>'
					ELSE 'No email clients are found with application size > 1 TB that may be candidates for archiving in last 30 days (last full backups).<DELIM>'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @totNoArcEmailCPercent >= @criticalThreshold THEN @criticalMessage
					WHEN @totNoArcEmailCPercent < @criticalThreshold AND @totNoArcEmailCPercent > @warningThreshold THEN @warningMessage
					ELSE @goodMessage
				END
		END
		--Tape Media Management
		ELSE IF @queryId = 113
		BEGIN
				DECLARE @TapeLibUsed INT = 0
				DECLARE @VTPolicyUsed INT = 0
				DECLARE @VTEntFeatureEnabled INT = 0
				SELECT
					@TapeLibUsed = ISNULL(csInfo.TapeLibUsed, 0),
					@VTPolicyUsed = ISNULL(csInfo.VTPolicyUsed, 0),
					@VTEntFeatureEnabled = ISNULL(csInfo.VTEntFeatureEnabled, 0), @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyTapeMediaMgmt AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				SET @tmpStatus =
				CASE
					WHEN @TapeLibUsed = 0  OR (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled > 0) THEN @strGood
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled = 0) THEN @strWarning
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed = 0) THEN @strCritical
					ELSE @strCritical
				END
				SET @tmpResult = ''
				IF @TapeLibUsed = 0
					SET @tmpResult = 'No Tape Libraries are in use.'
				ELSE
				BEGIN
					SET @tmpResult = 'Tape Libraries exist.<DELIM>'
					IF @VTPolicyUsed > 0
						SET @tmpResult += 'Vault Tracker Policies are configured.<DELIM>'
					ELSE
						SET @tmpResult += 'Vault Tracker Policies are not configured.<DELIM>'
					IF @VTEntFeatureEnabled > 0
						SET @tmpResult += 'Vault Tracker Enterprise Feature is in use.<DELIM>'
					ELSE
						SET @tmpResult += 'Vault Tracker Enterprise Feature is not in use.<DELIM>'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @TapeLibUsed = 0  OR (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled > 0) THEN @goodMessage
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled = 0) THEN @warningMessage
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed = 0) THEN @criticalMessage
					ELSE @criticalMessage
				END
		END
		--Self-Service
		ELSE IF @queryId = 114
		BEGIN
				DECLARE @WCClients INT = 0
				SELECT @WCClients = ISNULL(csInfo.ClientCounts, 0), @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveySelfServiceInfo AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
							AND csInfo.PackageId = 726
				SET @tmpStatus =
				CASE
					WHEN @WCClients > 0 THEN @strGood
					ELSE @strWarning
				END
				SET @tmpResult =
				CASE
					WHEN @WCClients > 0 THEN 'WebConsole is installed'
					ELSE 'WebConsole is not installed'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @WCClients > 0 THEN @goodMessage
					ELSE @warningMessage
				END
		END

		UPDATE	@TblSurveyResult
		SET		Status = ISNULL(@tmpStatus, @strUnknown),
				Result = @tmpResult,
				Recommendation = @tmpRecommendation
		WHERE	MonitorId = @queryId AND (@parameterName = '' OR Monitor = @parameterName)

		FETCH NEXT FROM HealthQueryCur
		INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage
	END

	CLOSE HealthQueryCur
	DEALLOCATE HealthQueryCur

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetValueAssessmentFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetValueAssessmentFunc' AND revision = '1.3')

  insert into GXDBVersions values(5, 'RptGetValueAssessmentFunc',  '1.3', 'RptGetValueAssessmentFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetCommCellGroups.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetCommCellGroups'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetCommCellGroups]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetCommCellGroups]
  delete from GXDBVersions where name = 'RptGetCommCellGroups' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetCommCellGroups]
	(
		@i_UserId INT = NULL
	)
	RETURNS @TblGroupResult TABLE
	(
		GroupId INTEGER NOT NULL,
		GroupName VARCHAR(512) NOT NULL,
		GroupDescription NVARCHAR(MAX) NULL,
		CommCellCount INTEGER NOT NULL,
		ActiveClients INTEGER NOT NULL,
		SLA INTEGER NOT NULL,
		GroupCreatedBy NVARCHAR(255) NULL,
		GroupModifiedBy NVARCHAR(255) NULL
	)
	AS
	BEGIN
	DECLARE @UserCapability INT = -1
	DECLARE @UserProp xml
	DECLARE @groupTbl TABLE (gId INT, gName NVARCHAR(512))
	DECLARE @ccTbl TABLE (gId INT, gName NVARCHAR(512), ccuId INT, ActiveClients INT, ProtectedClients INTEGER,	NotProtectedClients INTEGER)
	IF (@i_UserId = -1)
	BEGIN
		INSERT INTO @groupTbl(gId, gName) SELECT id, name FROM cf_CommcellGroup WITH (NOLOCK)
 	END
 	ELSE IF (@i_UserId IS NOT NULL)
	BEGIN
		SET @UserProp = (SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId =@i_UserId)
		INSERT INTO @groupTbl(gId, gName)
		SELECT
			ccg.value('@clientGroupId', 'INT'),
			ccg.value('@clientGroupName', '[NVARCHAR](512)')
		From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
			CROSS apply resp.nodes('commcellGroups') AS ccg(ccg)
	END
	ELSE
	BEGIN
		RETURN
	END
	INSERT INTO @ccTbl
		SELECT DISTINCT up.gId, up.gName, ga.CommcellIdNameMap_ID, 0, 0, 0
			FROM @groupTbl up
				INNER JOIN cf_CommcellGroupAssoc ga WITH (NOLOCK, READUNCOMMITTED)
					ON up.gId = ga.commCellGroupId
	UPDATE @ccTbl
		SET ActiveClients = ISNULL(csinfo.TotalActiveClients, 0)
	FROM	dbo.cf_SurveyResultFuncV1(8, 0, 3, NULL, NULL, @i_UserId, -1) AS resultView
			INNER JOIN cf_SurveyClientStatisticsInfo csinfo
				ON csinfo.SurveyResultId = resultView.SurverResultId
			INNER JOIN @ccTbl AS cc
				ON cc.ccuId = resultView.CommServUniqueId
	UPDATE @ccTbl
		SET	NotProtectedClients = ISNULL(csSummary.NotProtectedClients, 0), ProtectedClients = ISNULL(csSummary.ProtectedClients, 0)
	FROM	dbo.cf_SurveyResultFuncV1(146, 0, 3, NULL, NULL, @i_UserId, -1) AS resultView
			INNER JOIN cf_CommcellSummary  csSummary WITH (NOLOCK)
				ON csSummary.SurveyResultId = resultView.SurverResultId
			INNER JOIN @ccTbl AS cc
				ON cc.ccuId = resultView.CommServUniqueId
	INSERT INTO @TblGroupResult
	SELECT
		g.id,
		g.name,
		g.description,
		COUNT(result.ccuId),
		SUM(result.ActiveClients),
		CAST((CASE WHEN SUM(result.NotProtectedClients+result.ProtectedClients)>0 THEN SUM(result.ProtectedClients)*100.0/(SUM(result.NotProtectedClients+ProtectedClients)) ELSE 0 END) AS INT)
		,g.createdByUser
		,g.modifiedByUser
	FROM @ccTbl result
		INNER JOIN cf_commcellidnamemap ccMap WITH (NOLOCK, READUNCOMMITTED)
			ON ccMap.ID = result.ccuId
		INNER JOIN cf_CommCellGroup g WITH (NOLOCK)
			ON g.id = result.gId
	GROUP BY g.id, g.name, g.description,g.createdByUser,g.modifiedByUser
	ORDER BY g.name ASC
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetCommCellGroups]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetCommCellGroups' AND revision = '1.9')

  insert into GXDBVersions values(5, 'RptGetCommCellGroups',  '1.9', 'RptGetCommCellGroups', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetCommCellsInGroup.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetCommCellsInGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetCommCellsInGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetCommCellsInGroup]
  delete from GXDBVersions where name = 'RptGetCommCellsInGroup' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetCommCellsInGroup] (
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL,
		@i_IncludeDisabledCC INT = 0
		)
	RETURNS @ResultTable TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID VARCHAR(32) NOT NULL,
		CommServGUID VARCHAR(256) NOT NULL,
		DisplayName NVARCHAR(256) NOT NULL,
		CommCellName NVARCHAR(256) NOT NULL,
		CommServTZ VARCHAR(256),
		CommServVersion VARCHAR(256),
		IncludedInGroup INT
	)
	AS
	BEGIN
		DECLARE @blLatestSurvey INT = 1
		IF @i_IncludeDisabledCC = 1
			SET @blLatestSurvey = 3

		DECLARE @param_isPrivate INT = 0
		SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'

		INSERT INTO @ResultTable
		SELECT
	            csinfo.ID,
	            csinfo.CommCellID,
	            csinfo.CommServGUID,
	            CASE
					WHEN @param_isPrivate = 1 THEN ISNULL(csinfo.CommServName, '')
					ELSE ISNULL(csinfo.CustomerName,'')
	            END,
				CASE
					WHEN @param_isPrivate = 1 THEN ISNULL(csinfo.CommServName, '')
	                ELSE ISNULL(csinfo.CustomerName,'') + ' - ' + ISNULL(csinfo.CommServName, '')
	            END,
	            CommServTimeZone,
				csinfo.CommServVersion,
				0
		FROM
	            cf_CommcellIdNameMap csinfo WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(146, 0, @blLatestSurvey, NULL, NULL, @i_UserId, -1) AS resultView
	                    on resultView.CommServUniqueId = csinfo.ID

		UPDATE @ResultTable SET IncludedInGroup = 1
		FROM @ResultTable AS r
			INNER JOIN cf_CommCellGroupAssoc AS cga WITH (NOLOCK)
				ON cga.CommcellIdNameMap_ID = r.CommServUniqueId
				AND cga.CommCellGroupId = @i_GroupId

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetCommCellsInGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetCommCellsInGroup' AND revision = '1.4')

  insert into GXDBVersions values(5, 'RptGetCommCellsInGroup',  '1.4', 'RptGetCommCellsInGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/IsInputSafe.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsInputSafe'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsInputSafe]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsInputSafe]
  delete from GXDBVersions where name = 'IsInputSafe' and type = 5
END
GO

	CREATE FUNCTION IsInputSafe
	(
		@input  NVARCHAR(MAX) = 0
	)
	RETURNS INT
	AS
	BEGIN

	IF (CHARINDEX(';',@input) >0 OR CHARINDEX('--',@input) > 0 OR  CHARINDEX('xp_',@input) > 0)
		RETURN 0



	RETURN 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsInputSafe]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsInputSafe' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsInputSafe',  '1.2', 'IsInputSafe', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
