

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/DiskLibraryGrowth.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: DiskLibraryGrowth'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DiskLibraryGrowth]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DiskLibraryGrowth]
  delete from GXDBVersions where name = 'DiskLibraryGrowth' and type = 5
END
GO

  CREATE FUNCTION [dbo].[DiskLibraryGrowth]
  (
	@i_CommServUniqueID INT,
	@i_IntervalType VARCHAR(8) = 'Month'
  )
  RETURNS @Results TABLE (
	CommServUniqueId INT,
	LibraryId INT,
	GrowthInMB FLOAT,
	StdDevInMB FLOAT
  )
  AS
  BEGIN
	DECLARE @LeastSquareData TABLE (CommservUniqueId INT, LibraryId INT, X INT, Y FLOAT, SeqId INT)

	IF @i_IntervalType IN ('M', 'MM', 'Month')
	BEGIN
		DECLARE @CurrMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
		DECLARE @FirstMonth DATE = DATEADD(MONTH, -7, @CurrMonth)

		INSERT INTO @LeastSquareData
		SELECT	CommservUniqueId, LibraryId, DATEDIFF(MONTH, @CurrMonth, MonthStart), ISNULL(UsedSpaceMB, -1),
				ROW_NUMBER() OVER (PARTITION BY CommservUniqueId, LibraryId ORDER BY MonthStart)
		FROM	cf_SurveyDiskLibraryPeakSize S
		WHERE	(@i_CommServUniqueID = 0 OR CommservUniqueId = @i_CommServUniqueID) AND MonthStart >= @FirstMonth AND ISNULL(UsedSpaceMB, -1) > 0
	END
	ELSE
	IF @i_IntervalType IN ('W', 'WW', 'Week')
	BEGIN
		DECLARE @CurrWeek  DATE = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()), 0)
		DECLARE @FirstWeek DATE = DATEADD(WEEK, -13, @CurrWeek)

		INSERT INTO @LeastSquareData
		SELECT	CommservUniqueId, LibraryId, DATEDIFF(WEEK, @CurrWeek, WeekStart), ISNULL(UsedSpaceMB, -1),
				ROW_NUMBER() OVER (PARTITION BY CommservUniqueId, LibraryId ORDER BY WeekStart)
		FROM	cf_SurveyDiskLibraryWeeklyPeakSize S
		WHERE	(@i_CommServUniqueID = 0 OR CommservUniqueId = @i_CommServUniqueID) AND WeekStart >= @FirstWeek AND ISNULL(UsedSpaceMB, -1) > 0
	END

	DELETE	@LeastSquareData
	FROM	@LeastSquareData T INNER JOIN
			(SELECT	CommservUniqueId, LibraryId, MAX(SeqId) AS NumOfData
			FROM	@LeastSquareData
			GROUP BY CommservUniqueId, LibraryId
			) S ON T.CommservUniqueId = S.CommservUniqueId AND T.LibraryId = S.LibraryId
	WHERE	NumOfData < 2

	UPDATE	T SET Y = (T.Y - S.Y)/(T.X - S.X)
	FROM	@LeastSquareData T INNER JOIN
			(SELECT	CommservUniqueId, LibraryId, X, Y, (SeqId+1) AS SeqId
			FROM	@LeastSquareData
			) S ON T.CommservUniqueId = S.CommservUniqueId AND T.LibraryId = S.LibraryId AND T.SeqId = S.SeqId

	DELETE	@LeastSquareData WHERE SeqId = 1

	;WITH LeastSquareAvg(CommservUniqueId, LibraryId, AvgY, StDevY) AS
	(
		SELECT	CommservUniqueId, LibraryId, AVG(Y), ISNULL(STDEV(Y), 0)
		FROM	@LeastSquareData
		GROUP BY CommservUniqueId, LibraryId
	)
	DELETE	T
	FROM	@LeastSquareData T
			INNER JOIN LeastSquareAvg A ON T.CommservUniqueId = A.CommservUniqueId AND T.LibraryId = A.LibraryId
	WHERE	ABS(T.Y - AvgY) > StDevY

	INSERT INTO @Results
	SELECT	CommservUniqueId, LibraryId, AVG(Y), ISNULL(STDEV(Y), 0)
	FROM	@LeastSquareData
	GROUP BY CommservUniqueId, LibraryId

	RETURN
  END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DiskLibraryGrowth]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DiskLibraryGrowth' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'DiskLibraryGrowth',  '1.1.2.2', 'DiskLibraryGrowth', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
