

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/CalculateDaysToBeFull.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: CalculateDaysToBeFull'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CalculateDaysToBeFull]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CalculateDaysToBeFull]
  delete from GXDBVersions where name = 'CalculateDaysToBeFull' and type = 5
END
GO

	CREATE FUNCTION [dbo].[CalculateDaysToBeFull] (
		@FreeDiskSpaceMB BIGINT, @GrowthRate FLOAT, @LogDateUTC DATETIME
		)
		RETURNS bigint
	AS
	BEGIN
		DECLARE	@DaysToBeFull bigint
		DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
		DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1

		set @DaysToBeFull = (
	      	 case
	      	 when @FreeDiskSpaceMB is null
	      	 then
	             	 @NA
	      	 else
	             	 case
	             	 when @FreeDiskSpaceMB > 0
	             	 then
	                    	 case
	                    	 when @GrowthRate is null
	                    	 then
	                           	 @NA
	                    	 else
	                           	 case
	                           	 when (-@GrowthRate > 0)
	                           	 then
	                                  	 case
	                                  	 when @LogDateUTC is null
	                                  	 then
	                                         	 @NA
	                                  	 else
	                                         	 CASE
	                                         	 WHEN (@FreeDiskSpaceMB/(-@GrowthRate) - DATEDIFF(DAY, @LogDateUTC, GETUTCDATE())) <= 0 THEN 0
	                                         	 WHEN (@FreeDiskSpaceMB/(-@GrowthRate) - DATEDIFF(DAY, @LogDateUTC, GETUTCDATE())) > 9999 THEN @Never
	                                         	 ELSE (@FreeDiskSpaceMB/(-@GrowthRate) - DATEDIFF(DAY, @LogDateUTC, GETUTCDATE()))
	                                         	 END
	                                  	 END
	                           	 else
	                                  	 @Never
	                           	 end
	                    	 end
	             	 else
	                    	 0
	             	 end
	      	 end
		)

		RETURN @DaysToBeFull
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CalculateDaysToBeFull]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CalculateDaysToBeFull' AND revision = '1.1.2.1.54.1')

  insert into GXDBVersions values(5, 'CalculateDaysToBeFull',  '1.1.2.1.54.1', 'CalculateDaysToBeFull', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
