SET NOCOUNT ON
GO

CREATE TABLE #MonthlyResults (CommServUniqueId INT, MonthStart DATETIME, SurveyResultId INT)

BEGIN TRANSACTION

DECLARE	@errorCode	INTEGER = 0

INSERT	INTO cf_SurveyDiskLibraryPeakSize
SELECT	T.CommServUniqueId, T.MonthStart, S.LibraryId, S.LibraryName, 
		ISNULL((S.totalSpaceGB - S.totalFreeSpaceGB), 0)*1024, ISNULL(S.totalFreeSpaceGB, 0)*1024, 
		ISNULL(S.totalAppSizeGB, 0)*1024, ISNULL(S.totalDataWrittenGB, 0)*1024
FROM	(
		SELECT	CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, LogDate), 0) AS MonthStart, SurveyResultId, 
				ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, LogDate), 0) ORDER BY LogDate DESC) AS RowNo
		FROM	cf_Survey96DiskLibDetails WITH (NOLOCK)) T
		INNER JOIN cf_Survey96DiskLibDetails S WITH (NOLOCK) ON T.SurveyResultId = S.SurveyResultId
		LEFT OUTER JOIN cf_SurveyDiskLibraryPeakSize P WITH (NOLOCK) 
			ON T.CommServUniqueId = P.CommServUniqueId AND T.MonthStart = P.MonthStart
WHERE	P.MonthStart IS NULL AND RowNo = 1

SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH

INSERT	INTO #MonthlyResults
SELECT	CommServUniqueId, MonthStart, SurveyResultId
FROM	(
		SELECT	CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, StartDate), 0) AS MonthStart, SurveyResultId, 
				ROW_NUMBER() OVER (PARTITION BY CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, StartDate), 0) ORDER BY StartDate DESC) AS RowNo
		FROM	cf_SurveyMonthlyChargeback WITH (NOLOCK)
		WHERE StartDate IS NOT NULL) T
WHERE	RowNo = 1

SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH

INSERT	INTO cf_SurveyAgentPeakSize
SELECT	T.CommServUniqueId, T.MonthStart, 0, '', 
		SUM(CAST(S.TotalProtectedApp AS DECIMAL(38,0)))/1024/1024, SUM(CAST(S.TotalDataOnMedia AS DECIMAL(38,0)))/1024/1024, COUNT(DISTINCT S.ClientId)
FROM	#MonthlyResults T
		INNER JOIN cf_SurveyMonthlyChargeback S WITH (NOLOCK) ON T.SurveyResultId = S.SurveyResultId
		LEFT OUTER JOIN cf_SurveyAgentPeakSize P WITH (NOLOCK) 
			ON T.CommServUniqueId = P.CommServUniqueId AND T.MonthStart = P.MonthStart
WHERE	P.MonthStart IS NULL
GROUP BY T.CommServUniqueId, T.MonthStart

SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH

INSERT	INTO cf_SurveyAgentPeakSize
SELECT	T.CommServUniqueId, T.MonthStart, A.AppTypeId, A.AgentName, 
		SUM(CAST(S.TotalProtectedApp AS DECIMAL(38,0)))/1024/1024, SUM(CAST(S.TotalDataOnMedia AS DECIMAL(38,0)))/1024/1024, COUNT(DISTINCT S.ClientId)
FROM	#MonthlyResults T
		INNER JOIN cf_SurveyMonthlyChargeback S WITH (NOLOCK) ON T.SurveyResultId = S.SurveyResultId
		INNER JOIN cf_SurveySubclientAssociation A WITH (NOLOCK) ON S.CommservUniqueId = A.CommservUniqueId AND S.AppId = A.AppId
		LEFT OUTER JOIN cf_SurveyAgentPeakSize P WITH (NOLOCK) 
			ON T.CommServUniqueId = P.CommServUniqueId AND T.MonthStart = P.MonthStart
WHERE	P.MonthStart IS NULL
GROUP BY T.CommServUniqueId, T.MonthStart, A.AppTypeId, A.AgentName

SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH

INSERT	INTO cf_SurveyClientGroupPeakSize
SELECT	T.CommServUniqueId, T.MonthStart, CGA.ClientGroupId, 
		SUM(CAST(S.TotalProtectedApp AS DECIMAL(38,0)))/1024/1024, SUM(CAST(S.TotalDataOnMedia AS DECIMAL(38,0)))/1024/1024, COUNT(DISTINCT S.ClientId)
FROM	#MonthlyResults T
		INNER JOIN cf_SurveyMonthlyChargeback S WITH (NOLOCK) ON T.SurveyResultId = S.SurveyResultId
		INNER JOIN cf_SurveyClientGroupAssociation CGA WITH (NOLOCK) ON S.CommservUniqueId = CGA.CommservUniqueId AND S.ClientId = CGA.ClientId
		LEFT OUTER JOIN cf_SurveyClientGroupPeakSize P WITH (NOLOCK) 
			ON T.CommServUniqueId = P.CommServUniqueId AND T.MonthStart = P.MonthStart
WHERE	P.MonthStart IS NULL
GROUP BY T.CommServUniqueId, T.MonthStart, CGA.ClientGroupId

FINISH:
IF @errorCode <> 0
	ROLLBACK TRANSACTION
ELSE
	COMMIT TRANSACTION

DROP TABLE #MonthlyResults
	
RETURN
	
GO
