SET NOCOUNT ON

DECLARE @dllPath VARCHAR(2048) = ''
DECLARE @baseFolderPath VARCHAR(2048) = ''
DECLARE @retVal INT = 0

DECLARE @windows TINYINT = 1
DECLARE @linux TINYINT = 2
DECLARE @osType TINYINT = 0
DECLARE @nl VARCHAR(4) = ''
DECLARE @versionSQL NVARCHAR(MAX)

SET @baseFolderPath = '%s'

SET @versionSQL = @@VERSION
SET @osType = IIF((@versionSQL LIKE '%%Linux%%'), @linux, @windows) -- '%%Linux%%' is used so that it is not parsed as a format specifier in cpp.
SET @nl = IIF((@osType = @windows), (CHAR(13) + CHAR(10)), CHAR(10))	-- CRLF(Windows), LF(Linux newline)

IF (@osType = @windows)
BEGIN
    SELECT @dllPath = CASE WHEN RIGHT(@baseFolderPath, 1) = '\' THEN SUBSTRING( @baseFolderPath, 1, LEN(@baseFolderPath) - 1 ) ELSE @baseFolderPath END
	SET @dllPath = @dllPath + '\DBCLR.dll'
END
ELSE
BEGIN
    SELECT @dllPath = CASE WHEN RIGHT(@baseFolderPath, 1) = '/' THEN SUBSTRING( @baseFolderPath, 1, LEN(@baseFolderPath) - 1 ) ELSE @baseFolderPath END
END

EXEC @retVal = AppCreateCLRFunctions @dllPath

IF @@ERROR <> 0 OR @retVal <> 0 
    SELECT 1
ELSE
    SELECT 0
GO