

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cm_ReportToVolumeDiscountMap.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cm_ReportToVolumeDiscountMap.script,v $ $Id: cm_ReportToVolumeDiscountMap.script,v 1.1.2.1 2020/12/21 17:13:07 lgeorge Exp $";
-- TABLENAME cm_ReportToVolumeDiscountMap

print '... inserting Table: cm_ReportToVolumeDiscountMap'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cm_ReportToVolumeDiscountMap

IF NOT EXISTS (SELECT 1 FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'ResetPartnerDiscount' AND Value = '1')

BEGIN

	--transfer all partner discounts from single tiered model to tiered volume discount model

	IF OBJECT_ID('cm_ReportToVolumeDiscountMap') IS NOT NULL AND OBJECT_ID('cm_VolumeDiscount') IS NOT NULL

	BEGIN

		DECLARE @partnerId INT = 0

		DECLARE @contractId INT = 0

		DECLARE @discount INT = 0

		DECLARE @reportToVolumeDiscountMapId INT = 0

		DECLARE @currencyCode VARCHAR(5) = 'USD'

		DECLARE partnerCursor CURSOR FOR

		SELECT DISTINCT partnerId, contractId, discountPercentage FROM cm_PartnerToContractMap WITH (NOLOCK) WHERE discountPercentage>0 

		AND partnerId NOT IN (SELECT DISTINCT reportId FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=2)

		OPEN partnerCursor

		FETCH NEXT FROM partnerCursor INTO @partnerId, @contractId, @discount

		WHILE @@FETCH_STATUS = 0

		BEGIN

			SET @reportToVolumeDiscountMapId = 0

			SELECT @currencyCode=ISNULL(currencyCode,'USD') FROM cm_Contract WITH (NOLOCK) WHERE contractId=@contractId

			--add discount into tiered volume discounting
			INSERT INTO cm_ReportToVolumeDiscountMap VALUES (2, @partnerId, @currencyCode, 0, 0)


			SELECT @reportToVolumeDiscountMapId=SCOPE_IDENTITY()
			INSERT INTO cm_VolumeDiscount VALUES(@reportToVolumeDiscountMapId, 0, -1, @discount, 0, 0)


			FETCH NEXT FROM partnerCursor INTO @partnerId, @contractId, @discount					

		END

		CLOSE partnerCursor

		DEALLOCATE partnerCursor		

	END

	IF NOT EXISTS (SELECT 1 FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'ResetPartnerDiscount')
		INSERT INTO cf_SurveyConfig(Name, Value) VALUES('ResetPartnerDiscount', '1')


	ELSE

		UPDATE cf_SurveyConfig SET Value = '1' WHERE Name = 'ResetPartnerDiscount'

END
