

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_SurveyHealthParam.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_SurveyHealthParam.script,v $ $Id: cf_SurveyHealthParam.script,v 1.81.2.103.4.1 2021/04/07 20:01:23 dkraplanee Exp $";
-- TABLENAME cf_SurveyHealthParam

print '... inserting Table: cf_SurveyHealthParam'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_SurveyHealthParam

DECLARE @doclink NVARCHAR(256)

DECLARE @rel VARCHAR(10)

SET @rel = (SELECT TOP 1 release from simAllGalaxyRel order by id desc)

SELECT @doclink = 'http://documentation.commvault.com/commvault/v' + @rel + '/article'

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 12)
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (12, 'Software Version', '<a class="hc-cell-a" href="' + @doclink + '?p=2617.htm">Feature Release and Maintenance Release Guidelines</a>', 0, 100, 2, 4, 
		'Installed with supported Feature Release and Maintenance Release', 
		'CommServe computer Feature Release and Maintenance Release is retiring, and the support will expire soon $MULTICRIT$ MediaAgent and client computers are behind the CommServe computer version', 
		'Installed version is retired, and classified under deprecated support $MULTICRIT$ MediaAgent and client computers are far behind the CommServe computer version', 
		'Minor feature release installed instead of major feature release. Apply latest major feature release.<DELIM><VDL>', 
		'Up-to-Date.<DELIM><VDL>', 
		'Install latest Feature Release.<DELIM><VDL>', 
		'Install missing Maintenance Releases.<DELIM><VDL>',
		'Installed Feature Release is behind by ##val## or more Feature Release releases', 1)



ELSE

	UPDATE cf_SurveyHealthParam SET

		ParameterName = 'Software Version',

		ThresholdName = '<a class="hc-cell-a" href="' + @doclink + '?p=2617.htm">Feature Release and Maintenance Release Guidelines</a>',

		WarningThreshold = 2,

		CriticalThreshold = 4,

		GoodThresholdText = 'Installed with supported Feature Release and Maintenance Release',

		WarningThresholdText = 'CommServe computer Feature Release and Maintenance Release is retiring, and the support will expire soon $MULTICRIT$ MediaAgent and client computers are behind the CommServe computer version',

		CriticalThresholdText = 'Installed version is retired, and classified under deprecated support $MULTICRIT$ MediaAgent and client computers are far behind the CommServe computer version',

		GoodMessage = 'Up-to-Date.<DELIM><VDL>',

		WarningMessage = 'Install latest Feature Release.<DELIM><VDL>',

		CriticalMessage = 'Install missing Maintenance Releases.<DELIM><VDL>',

		DescriptionText = 'Installed Feature Release is behind by ##val## or more Feature Release releases'

	WHERE QueryId = 12

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 61) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (61, 'DDB Partition counts per MediaAgent', 'Information', -1, -1, -1, -1, 
		'', 
		'', 
		'', 
		'', 
		'It is recommended to have maximum of 2 DDB partitions on the same MediaAgent depending on your MediaAgent performance. See <a href="' + @doclink +	'?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a> for more information.<DELIM><VDL>', 
		'Separate DDBs should be housed on different MediaAgents.<DELIM><VDL>', 
		'Separate DDBs should be housed on different MediaAgents.<DELIM><VDL>', 
		'MediaAgents with more than ##val## DDB Partitions present', 2)


ELSE

	UPDATE cf_SurveyHealthParam  
		SET ParameterName = 'DDB Partition counts per MediaAgent', 
		ThresholdName = 'Information', 
		GoodMessage = 'It is recommended to have maximum of 2 DDB partitions on the same MediaAgent depending on your MediaAgent performance. See <a href="' + @doclink + '?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a> for more information.<DELIM><VDL>' 
	WHERE QueryId = 61


IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 16) 
	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 16


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 64) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (64, 'Fallen Behind Secondary Copies', 'Fallen behind days', 0, 1000, 3, 10, 
		'< #1 days', 
		'#1 - #2 days', 
		'> #2 days or Exceeds Copy Alert Thresholds', 
		'Up-To-Date.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Examine Network & Disk throughput. Check for the DDB performance in case of DASH copy. Contact Support for further information.<DELIM><VDL>', 
		'Examine Network & Disk throughput. Check for the DDB performance in case of DASH copy. Contact Support for further information.<DELIM><VDL>', 
		'Secondary copies have fallen behind by ##val## or more days', 4)


ELSE

    UPDATE cf_SurveyHealthParam 

		SET ParameterName = 'Fallen Behind Secondary Copies', 

		DescriptionText = 'Secondary copies have fallen behind by ##val## or more days',

		CriticalThresholdText = '> #2 days or Exceeds Copy Alert Thresholds'

    WHERE  QueryId = 64

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 65) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (65, 'DDB Performance and Status', 'Average Q&I Time and Primary Records', 0, 1000000, 1400, 1799, 

		'< CommCell Q&I Time Minimum Threshold Or Between minimum and maximum Threshold of CommCell Q&I Time and < 100 Million',

		'Between minimum and maximum Threshold of CommCell Q&I Time and >= 100 Million Or >= CommCell Q&I Time Maximum Threshold and < 200 Million Or DDB needs an upgrade.',

		'>= CommCell Q&I Time Maximum Threshold and >= 200 Million',

		'It is recommended to use DeDuplication feature for optimal data protection.<DELIM>', 

		'Meets Expectation.<DELIM><VDL>', 

		'Make sure each DDB is housed on SSD disk. If it is already on SSD, check Disk performance.  It may be time to start a new DDB store.  <a href="' + @doclink + '?p=features/deduplication/troubleshooting.htm#deduplication_database_qi">How to troubleshoot Q&I performance</a><DELIM><VDL>', 

		'Make sure each DDB is housed on SSD disk. If it is already on SSD, check Disk performance.  It may be time to start a new DDB store.  <a href="' + @doclink + '?p=features/deduplication/troubleshooting.htm#deduplication_database_qi">How to troubleshoot Q&I performance</a><DELIM><VDL>', 

		'Average Q&I time of DDB Stores is ##op## ##val## microseconds', 5)

ELSE 

	UPDATE cf_SurveyHealthParam 

	SET 

		GoodThresholdText    = '< CommCell Q&I Time Minimum Threshold Or Between minimum and maximum Threshold of CommCell Q&I Time and < 100 Million',

		WarningThresholdText = 'Between minimum and maximum Threshold of CommCell Q&I Time and >= 100 Million Or >= CommCell Q&I Time Maximum Threshold and < 200 Million Or DDB needs an upgrade.',

		CriticalThresholdText= '>= CommCell Q&I Time Maximum Threshold and >= 200 Million',

		ParameterName  = 'DDB Performance and Status', 

		ThresholdName  = 'Average Q&I Time and Primary Records', 

		WarningThreshold = 1400,

		CriticalThreshold = 1799,

		WarningMessage = 'Make sure each DDB is housed on SSD disk. If it is already on SSD, check Disk performance.  It may be time to start a new DDB store.  <a href="' + @doclink + '?p=features/deduplication/troubleshooting.htm#deduplication_database_qi">How to troubleshoot Q&I performance</a><DELIM><VDL>', 

		CriticalMessage= 'Make sure each DDB is housed on SSD disk. If it is already on SSD, check Disk performance.  It may be time to start a new DDB store.  <a href="' + @doclink + '?p=features/deduplication/troubleshooting.htm#deduplication_database_qi">How to troubleshoot Q&I performance</a><DELIM><VDL>' 

	WHERE QueryId = 65

IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 17) 
	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 17


IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 18) 
DELETE FROM cf_SurveyHealthParam WHERE QueryId = 18 


IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 19) 
	delete from cf_SurveyHealthParam where QueryId = 19


IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 20) 
DELETE FROM cf_SurveyHealthParam WHERE QueryId = 20


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 23) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (23, 'Largest 25 Clients', 'Information', -1, -1, -1, -1, '', '', '', '', '', '', '', '', 10)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 24) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (24, 'Long Running Backup Jobs for last 1 day', 'Long running jobs', -1, -1, -1, -1, 'None', 'At least one long runging job exists', 'Not Applicable', '', '', '', '', '', 11)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 25) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (25, 'Strike Count', '% of clients with strike', 0, 100, 5, 10, '<= #1%', '#1 - #2%', '> #2%', '', '', '', '', 'Percentage of clients with strike is ##op## ##val## %', 12)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 28) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (28, 'Incremental backup change rate for Last 7 days', 'Information', -1, -1, -1, -1, '', '', '', '', '', '', '', '', 13)


ELSE 

	UPDATE cf_SurveyHealthParam 

	SET ParameterName = 'Incremental backup change rate for Last 7 days'

	WHERE QueryId = 28

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 66) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (66, 'DDB backups', 'Time Since Last Backup', 0, 1000, 2, 3, 
		'<= #1 days or <= 8 days for Transactional DDBs', 
		'#1 - #2 days or 8 - 15 days for Transactional DDBs', 
		'> #2 days or > 15 days for Transactional DDBs', 
		'It is recommended to use DeDuplication feature for optimal data protection.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Configure DDB Subclients for each DDB MA and schedule backups. If this is already done, check if DDB backups are running successfully. <DELIM><VDL>', 
		'Configure DDB Subclients for each DDB MA and schedule backups. If this is already done, check if DDB backups are running successfully. <DELIM><VDL>', 
		'Any DDB is not protected in last ##val## days', 14)


ELSE

UPDATE cf_SurveyHealthParam SET

	ParameterName = 'DDB backups',

	ThresholdName = 'Time Since Last Backup',

	WarningThreshold = 2,

	CriticalThreshold = 3,

	GoodThresholdText = '<= #1 days or <= 8 days for Transactional DDBs',

	WarningThresholdText = '#1 - #2 days or 8 - 15 days for Transactional DDBs',

	CriticalThresholdText = '> #2 days or > 15 days for Transactional DDBs'

WHERE QueryId = 66

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 22) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (22, 'Unused Schedule Policies', '', -1, -1, -1, -1, 
		'All Schedule Policies are in use', 
		'At least one schedule policy exists without association', 
		'Not Applicable', 
		'', 
		'Meets Expectation.<DELIM>', 
		'Make use of unused Schedule Policies.<DELIM><VDL>', 
		'Make use of unused Schedule Policies.<DELIM><VDL>',


		'', 15)

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 26) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (26, 'Deduplication Ratio For The Last 30 Days', 'Information', -1, -1, -1, -1, '', '', '', 
'Visit the <a href="' + @doclink + '?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a>  to configure your subclients and storage policies to yield the optimum deduplication savings.', 


'Meets Expectation.<VDL>', 

'Visit the <a href="' + @doclink + '?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a>  to configure your subclients and storage policies to yield the optimum deduplication savings<VDL>', 

'Visit the <a href="' + @doclink + '?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a>  to configure your subclients and storage policies to yield the optimum deduplication savings<VDL>', 

'DeDuplication Ratio of Storage Policies is ##op## ##val## %', 16)

ELSE 

	UPDATE cf_SurveyHealthParam 

	SET ParameterName = 'Deduplication Ratio For The Last 30 Days', 

		ThresholdName  = 'Information',

		InfoMessage    = 'Visit the <a href="' + @doclink + '?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a>  to configure your subclients and storage policies to yield the optimum deduplication savings<VDL>', 

		WarningMessage = 'Visit the <a href="' + @doclink + '?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a>  to configure your subclients and storage policies to yield the optimum deduplication savings<VDL>', 

		CriticalMessage= 'Visit the <a href="' + @doclink + '?p=features/deduplication/deduplication_building_block.htm">Deduplication building block guide on BOL</a>  to configure your subclients and storage policies to yield the optimum deduplication savings<VDL>' 

	WHERE QueryId = 26

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 27) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (27, 'SLA', 'SLA - <a class="hc-cell-a" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA?</a>', 0, 100, 97, 90, 
		'#1 - 100%', 
		'#2 - #1%', 
		'< #2%', 
		'<a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>', 
		'Meets SLA<DELIM><a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>',  
		'<VDL><DELIM><a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>', 
		'<VDL><DELIM><a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>', 
		'SLA is ##op## ##val## %', 17)


ELSE

	UPDATE cf_SurveyHealthParam SET

	ParameterName = 'SLA',

	ThresholdName = 'SLA - <a class="hc-cell-a" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA?</a>',

	GoodThresholdText = '#1 - 100%',

	InfoMessage = '<a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>',

	GoodMessage = 'Meets SLA<DELIM><a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>',

	WarningMessage = '<VDL><DELIM><a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>',

	CriticalMessage = '<VDL><DELIM><a class="hc-cell-a" style="font-size: 10px; font-style: italic" href="' + @doclink + '?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA</a>',

	WarningThreshold = 97,

	DescriptionText = 'SLA is ##op## ##val## %'

	WHERE QueryId = 27

IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 30) 
	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 30


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 31) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (31, 'Disaster Recovery Backup', 'Hours since last DR Backup and DR Path', 0, 1000, 26, 26, 
        'Hours since the last DR Backup is < #1 hours and the latest DR should be a successful job $MULTICRIT$ Cloud or Network path is used $MULTICRIT$ Full job retention is >= 2', 
        'Hours since the last DR Backup is equal to #1 hours $MULTICRIT$ Full jobs retention is set to 1', 
        'Hours since the last DR Backup is > #2 hours or the latest DR job failed $MULTICRIT$ Local path is used $MULTICRIT$ Full job retention is set to 0', 
        '', 
        'Meets Expectation.<VDL>', 
        'It is recommended to run DR backup <b>every hours</b> and use <b>Cloud or UNC path</b> as destination with <b>2</b> metadata retentions.<DELIM><VDL>', 
        'It is strongly recommended to run DR backup <b>every hours</b> and use <b>Cloud or UNC path</b> as destination with <b>2</b> metadata retentions.<DELIM><VDL>',


        'Hours since last DR Backup is ##op## ##val## hours', 19)

ELSE 
UPDATE cf_SurveyHealthParam SET 
    ParameterName = 'Disaster Recovery Backup', 
    ThresholdName = 'Hours since last DR Backup and DR Path', 
    ThresholdMin = 0, 
    ThresholdMax = 1000, 
    WarningThreshold = 26, 
    CriticalThreshold = 26, 
    GoodThresholdText = 'Hours since the last DR Backup is < #1 hours and the latest DR should be a successful job $MULTICRIT$ Cloud or Network path is used $MULTICRIT$ Full job retention is >= 2', 
    WarningThresholdText = 'Hours since the last DR Backup is equal to #1 hours $MULTICRIT$ Full jobs retention is set to 1', 
    CriticalThresholdText = 'Hours since the last DR Backup is > #2 hours or the latest DR job failed $MULTICRIT$ Local path is used $MULTICRIT$ Full job retention is set to 0', 
    GoodMessage = 'Meets Expectation.<VDL>', 
    WarningMessage = 'It is recommended to run DR backup <b>every hours</b> and use <b>Cloud or UNC path</b> as destination with <b>2</b> metadata retentions.<DELIM><VDL>', 
    CriticalMessage = 'It is strongly recommended to run DR backup <b>every hours</b> and use <b>Cloud or UNC path</b> as destination with <b>2</b> metadata retentions.<DELIM><VDL>', 
    DescriptionText = 'Hours since last DR Backup is ##op## ##val## hours' 
WHERE QueryId = 31 AND ParamId = 19


IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 37) 
	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 37


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 70) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (70, 'Storage Policy Disk Usage', 'Free Disk Space', 0, 100, 20, 5, 
		'> #1%', 
		'#2 - #1%', 
		'< #2%', 
		'Up-To-Date.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Add more disk space to the Disk Libraries or revisit the Retention settings and Data Aging schedule.<DELIM><VDL>', 
		'Add more disk space to the Disk Libraries or revisit the Retention settings and Data Aging schedule.<DELIM><VDL>',


		'Free disk space of storage policy copies is ##op## ##val## %', 21)

ELSE

	UPDATE cf_SurveyHealthParam SET ParameterName = 'Storage Policy Disk Usage', WarningThreshold = 20, CriticalThreshold = 5, ThresholdName = 'Free Disk Space' WHERE QueryId = 70 and ParamId = 21

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 39 AND ParameterName = 'Index Cache Location') 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (39, 'Index Cache Location', 'Index Cache Location', 0, 100, 70, 90, 
		'No Index Cache in CommCell having critical or warning status', 
		'Any Index Cache in CommCell having warning status', 
		'Any Index Cache in CommCell having critical status', 
		'There is no index cache configured.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Check index cache retention and operational parameters, indidual indices states, and Media Agent''s operational state. If necessary, add more disk to Media Agent''s index cache volume.<DELIM><VDL>', 
		'Check index cache retention and operational parameters, indidual indices states, and Media Agent''s operational state. If necessary, add more disk to Media Agent''s index cache volume.<DELIM><VDL>', 
		'', 22) 
ELSE 
	update cf_SurveyHealthParam 


			SET ParameterName = 'Index Cache Location',

			ThresholdName = 'Index Cache Location',

			WarningThreshold = 70,

			CriticalThreshold = 90,

			GoodThresholdText    = 'No index cache in CommCell having critical or warning status',

			WarningThresholdText = 'Any Index Cache in CommCell having warning status',

			CriticalThresholdText= 'Any Index Cache in CommCell having critical status',

			GoodMessage = 'Meets Expectation.<DELIM><VDL>',

			WarningMessage = 'Check index cache retention and operational parameters, indidual indices states, and Media Agent''s operational state. If necessary, add more disk to Media Agent''s index cache volume.<DELIM><VDL>',

			CriticalMessage = 'Check index cache retention and operational parameters, indidual indices states, and Media Agent''s operational state. If necessary, add more disk to Media Agent''s index cache volume.<DELIM><VDL>',

			DescriptionText = ''

			where QueryId = 39 and ParamId = 22

IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 105 AND ParameterName = 'Index Cache Space Utilization') 
	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 105 AND ParameterName = 'Index Cache Space Utilization'


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 95) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (95, 'Mount Path', 'Information', -1, -1, -1, -1, 
		'', 
		'', 
		'', 
		'There is no mount path configured.<DELIM>', 
		'<VDL>', 
		'<VDL>', 
		'<VDL>', 
		'', 24)


ELSE 

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', GoodMessage ='<VDL>', WarningMessage = '<VDL>', CriticalMessage ='<VDL>', DescriptionText ='' WHERE QueryId =95		

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 1 AND ParameterName = 'Capacity License Usage') 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (1, 'Capacity License Usage', 'Information', -1, -1, -1, -1, 
		'', 
		'', 
		'', 
		'<VDL>', 
		'<VDL>', 
		'<VDL>', 
		'<VDL>', 
		'', 25)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 250 AND ParamId = 63) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold,GoodThresholdText, WarningThresholdText,CriticalThresholdText, InfoMessage, GoodMessage,WarningMessage, CriticalMessage,LogDateUTC, DescriptionText,ParamId) 
values  (250, 'Security Assessment', 'Security Assessment',-1,-1,-1,-1, 
		'No Security assessment parameter having critical or warning status','Any Security assessment parameter having warning status', 
		'Any Security assessment parameter having critical status','<VDL>','<VDL>', 
		'The CommServe has potential security issues <DELIM><VDL>','The CommServe has critical security issues that require immediate attention <DELIM><VDL>', 
		'','', 
		63)


ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'No Security assessment parameter having critical or warning status', WarningThresholdText = 'Any Security assessment parameter having warning status', CriticalThresholdText = 'Any Security assessment parameter having critical status', InfoMessage = '<VDL>', GoodMessage ='<VDL>', WarningMessage = 'The CommServe has potential security issues <DELIM><VDL>', CriticalMessage ='The CommServe has critical security issues that require immediate attention <DELIM><VDL>', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 63

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2501)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Two-factor authentication', 'Information',-1,-1,-1,-1,'','','','','','','','',2501)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Two-factor authentication' WHERE QueryId = 250	AND ParamId = 2501

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2502)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Single sign-on', 'Information',-1,-1,-1,-1,'','','','','','','','',2502)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Single sign-on' WHERE QueryId = 250	AND ParamId = 2502

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2503)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Password complexity level', 'Security Assessment',-1,-1,-1,-1,'Password complexity level is set to 2 or higher','Password complexity level is set to 1','Not applicable','','','','','',2503)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'Password complexity level is set to 2 or higher', WarningThresholdText = 'Password complexity level is set to 1', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Password complexity level' WHERE QueryId = 250	AND ParamId = 2503

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2504)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Failed log-on attempts limit', 'Security Assessment',-1,-1,-1,-1,'Failed log-on attempts limit is set','Not applicable','Failed log-on attempts limit is not set','','','','','',2504)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'Failed log-on attempts limit is set', WarningThresholdText = 'Not applicable', CriticalThresholdText = 'Failed log-on attempts limit is not set', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Failed log-on attempts limit' WHERE QueryId = 250	AND ParamId = 2504

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2505)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Account lock duration', 'Information',-1,-1,-1,-1,'','','','','','','','',2505)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Account lock duration' WHERE QueryId = 250	AND ParamId = 2505

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2506)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Command Center timeout period', 'Information',-1,-1,-1,-1,'','','','','','','','',2506)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Command Center timeout period' WHERE QueryId = 250	AND ParamId = 2506

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2507)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Commcell Console timeout period', 'Security Assessment',-1,-1,-1,-1,'A timeout period has been specified for Commcell Console','Commcell Console will not timeout','Not applicable','','','','','',2507)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'A timeout period has been specified for Commcell Console', WarningThresholdText = 'Commcell Console will not timeout', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Commcell Console timeout period' WHERE QueryId = 250	AND ParamId = 2507

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25081)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Critical priority audit trail retention', 'Retention period',-1,-1,-1,-1,'>= 1 year','< 1 year','Not applicable','','','','','',25081)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Retention period',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '>= 1 year', WarningThresholdText = '< 1 year', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25081

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25082)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'High priority audit trail retention', 'Retention period',-1,-1,-1,-1,'>= 1 year','< 1 year','Not applicable','','','','','',25082)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Retention period',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '>= 1 year', WarningThresholdText = '< 1 year', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25082

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25083)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Medium priority audit trail retention', 'Retention period',-1,-1,-1,-1,'>= 240 days','< 240 days','Not applicable','','','','','',25083)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Retention period',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '>= 240 days', WarningThresholdText = '< 240 days', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25083

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25084)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Low priority audit trail retention', 'Retention period',-1,-1,-1,-1,'>= 120 days','< 120 days','Not applicable','','','','','',25084)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Retention period',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '>= 120 days', WarningThresholdText = '< 120 days', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25084

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 2509)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Security Cleanup report', 'Information',-1,-1,-1,-1,'','','','','','','','',2509)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 2509

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25010)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'User and user group permissions report', 'Information',-1,-1,-1,-1,'','','','','','','','',25010)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25010

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25011)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Storage pools without encryption', 'Information',-1,-1,-1,-1,'','','','','','','','',25011)

ELSE

UPDATE cf_SurveyHealthParam

		SET ParameterName = 'Storage pools without encryption', ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25011

IF EXISTS (SELECT 1 FROM cf_SurveyHealthParam WHERE QueryId = 250 AND ParameterName = 'Storage pools without auxiliary copy encryption')

	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 250 AND ParameterName = 'Storage pools without auxiliary copy encryption'

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25013)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Ransomware protection', 'Security Assessment',-1,-1,-1,-1,'All mount paths secured against ransomware','Not applicable','Some mount paths are not secured against ransomware','','','','','',25013)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'All mount paths secured against ransomware', WarningThresholdText = 'Not applicable', CriticalThresholdText = 'Some mount paths are not secured against ransomware', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25013

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25014)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'File Activity Anomaly alert', 'Security Assessment',-1,-1,-1,-1,'File Activity Anomaly alert is enabled','Not applicable','File Activity Anomaly alert is disabled/deleted<br>&#9679; The alert is triggered by event code 7:211|7:212 given as regular expression.<br>&#9679; The alert should not have any criteria other than Error Code selected','','','','','',25014)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'File Activity Anomaly alert is enabled', WarningThresholdText = 'Not applicable', CriticalThresholdText = 'File Activity Anomaly alert is disabled/deleted<br>&#9679; The alert is triggered by event code 7:211|7:212 given as regular expression.<br>&#9679; The alert should not have any criteria other than Error Code selected', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'File Activity Anomaly alert' WHERE QueryId = 250	AND ParamId = 25014

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25015)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Privacy feature', 'Information',-1,-1,-1,-1,'','','','','','','','',25015)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Privacy feature' WHERE QueryId = 250	AND ParamId = 25015

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25016)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Client computer encryption', 'Information',-1,-1,-1,-1,'','','','','','','','',25016)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Client computer encryption' WHERE QueryId = 250	AND ParamId = 25016

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25017)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Passkey for restore feature', 'Information',-1,-1,-1,-1,'','','','','','','','',25017)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25017

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25018)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Users with master capabilities', 'Information',-1,-1,-1,-1,'','','','','','','','',25018)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25018

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25019)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Delete Jobs Authorization workflow', 'Information',-1,-1,-1,-1,'','','','','','','','',25019)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25019

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25020)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Delete BackupSet Authorization workflow', 'Information',-1,-1,-1,-1,'','','','','','','','',25020)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25020

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25021)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Delete Client Authorization workflow', 'Information',-1,-1,-1,-1,'','','','','','','','',25021)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25021

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25022)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Delete Library Mount Path Authorization workflow', 'Information',-1,-1,-1,-1,'','','','','','','','',25022)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25022

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25023)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Delete Storage Policy Authorization workflow', 'Information',-1,-1,-1,-1,'','','','','','','','',25023)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25023

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25024)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Get And Process Authorization workflow', 'Information',-1,-1,-1,-1,'','','','','','','','',25024)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25024

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25025)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Restore Request Authorization workflow', 'Information',-1,-1,-1,-1,'','','','','','','','',25025)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25025

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25026)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Requires user authentication for installing agents', 'Security Assessment',-1,-1,-1,-1,'Authentication is required for installing agents','Authentication is not required for installing agents','Not applicable','','','','','',25026)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'Authentication is required for installing agents', WarningThresholdText = 'Authentication is not required for installing agents', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Requires user authentication for installing agents' WHERE QueryId = 250	AND ParamId = 25026

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25027)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Key Management Servers', 'Information',-1,-1,-1,-1,'','','','','','','','',25027)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25027

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25028)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Data Loss Prevention', 'Information',-1,-1,-1,-1,'','','','','','','','',25028)

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='', ParameterName = 'Data Loss Prevention' WHERE QueryId = 250	AND ParamId = 25028

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25029)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Disaster Recovery Backup', 'Security Assessment',-1,-1,-1,-1,'DR backup is configured','DR backup is not configured to cloud or UNC path','Not applicable','','','','','',25029)

ELSE

BEGIN

UPDATE cf_SurveyHealthParam

		SET ParameterName = 'Disaster Recovery Backup', ThresholdName ='Security Assessment',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = 'DR backup is configured', WarningThresholdText = 'DR backup is not configured to cloud or UNC path', CriticalThresholdText = 'Not applicable', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25029

END

IF NOT EXISTS(SELECT 1 FROM cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=250 and ParamId = 25030)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

		(250, 'Key Management Server for Password Encryption', 'Information',-1,-1,-1,-1,'','','','','','','','',25030)

ELSE

UPDATE cf_SurveyHealthParam

		SET ParameterName = 'Key Management Server for Password Encryption', ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', InfoMessage = '', GoodMessage ='', WarningMessage = '', CriticalMessage ='', DescriptionText ='' WHERE QueryId = 250	AND ParamId = 25030

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 1 AND ParameterName IN ('Client License Usage', 'Client Usage', 'License Usage')) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (1, 'License Usage', 'Information', -1, -1, -1, -1, 
		'', 
		'', 
		'', 
		'', 
		'', 
		'', 
		'',


		'', 26) 

ELSE 

	UPDATE cf_SurveyHealthParam SET ParameterName = 'License Usage' WHERE QueryId = 1 AND ParameterName IN ('Client License Usage', 'Client Usage')

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 4) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (4, 'Snap Engine Usage', 'Information', -1, -1, -1, -1, 
		'', 
		'', 
		'', 
		'<VDL>', 
		'<VDL>', 
		'<VDL>', 
		'', 
		'', 27)


IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 8) 
	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 8


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 96) 
	insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
	values (96, 'Disk Library Growth', 'Estimated days to be full', 0, 1000, 90, 30, 
		'> #1 days', 
		'#2 - #1 days', 
		'< #2 days', 
		'There is no Disk library configured.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Check the free space for your disk library.<DELIM><VDL>', 
		'Check the free space for your disk library.<DELIM><VDL>', 
		'Disk library would be full in ##op## ##val## days', 29)


ELSE

	UPDATE cf_SurveyHealthParam SET	WarningThreshold = 90, CriticalThreshold = 30 WHERE QueryId = 96

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 97) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (97, 'Network Efficiency', 'Percentage of Network Subclients Using Source Dedup', 0, 100, 90, 50, 
		'>= #1 %', 
		'#2 - #1 %', 
		'< #2 %', 
		'', 
		'Meets Expectation.', 
		'Enable source side deduplication to reduce network impact.<VDL>', 
		'Enable source side deduplication to reduce network impact.<VDL>',


		'', 30)			

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 99) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (99, 'File Data Placement', 'Eligible Percentage of OnePass Archiving clients', 0, 100, 0, 50, 
		'0 %', 
		'#1 - #2 %', 
		'>= #2 %', 
		'', 
		'Meets Expectation.', 
		'Enable OnePass archiving to improve backup window and reclaim primary disk storage.<VDL>', 
		'Enable OnePass archiving to improve backup window and reclaim primary disk storage.<VDL>', 
		'', 31)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 100) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (100, 'Rapid Recovery Capability', 'Average Estimated Recovery Time', -1, -1, -1, -1, 
		'None', 
		'At least one application client exists without IntelliSnap feature that may take longer than 8 HRs to restore', 
		'Not Applicable', 
		'<VDL>', 
		'Meets Expectation.', 
		'Enable Intellisnap technology to reduce recovery time for large applications.<VDL>', 
		'Enable Intellisnap technology to reduce recovery time for large applications.<VDL>', 
		'', 32)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 98) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (98, 'File System Backup Efficiency', 'Percentage of Subclients with long running full jobs', 0, 100, 0, 10, 
		'0 %', 
		'#1 - #2 %', 
		'>= #2 %', 
		'', 
		'Meets Expectation.', 
		'Enable DASH full backups or OnePass archiving to reduce backup window for file system clients.<VDL>', 
		'Enable DASH full backups or OnePass archiving to reduce backup window for file system clients.<VDL>',


		'', 33)

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 101) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (101, 'VM Backup Efficiency', 'Percentage of Subclients with long running full jobs', 0, 100, 0, 10, 
		'0 %', 
		'#1 - #2 %', 
		'>= #2 %', 
		'', 
		'Meets Expectation.', 
		'Enable IntelliSnap technology for the Virtual Server Agent to improve efficiency of VM backups.<VDL>', 
		'Enable IntelliSnap technology for the Virtual Server Agent to improve efficiency of VM backups.<VDL>', 
		'', 34)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 102) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (102, 'Application Backup Efficiency', 'Percentage of Subclients with long running full jobs', 0, 100, 0, 10,  
		'0 %', 
		'#1 - #2 %', 
		'>= #2 %', 
		'', 
		'Meets Expectation.', 
		'Enable IntelliSnap technology for the corresponding agents to improve backup efficiency.<VDL>', 
		'Enable IntelliSnap technology for the corresponding agents to improve backup efficiency.<VDL>', 
		'', 35)


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 7) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (7, 'Scale Statistics', 'Scale Statistics', -1, -1, -1, -1, 

        'No Scale Statistics parameter having critical or warning status',  

        'Any Scale Statistics parameter having warning status', 

        'Any Scale Statistics parameter having critical status', 

        '', 

        '<VDL>', 

        'The CommServe has potentially breached scale limits <DELIM><VDL>' , 

        'The CommServe may be running beyond allowed scale limits.  Needs immediate attention <DELIM><VDL>',

		'', 37)

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 111) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (111, 'Disk Protection Tier Savings', 'Information', 

		-1, -1, -1, -1,  

		'','','','',

		'View the details of the Primary Copies with Deduplication disabled here.<VDL>', 'View the details of the Primary Copies with Deduplication disabled here.<VDL>','View the details of the Primary Copies with Deduplication disabled here.<VDL>',

		'', 38)	

ELSE

UPDATE cf_SurveyHealthParam

		SET ThresholdName ='Information',ThresholdMin = -1, ThresholdMax =  -1, WarningThreshold =  -1,CriticalThreshold =  -1, GoodThresholdText = '', WarningThresholdText = '', CriticalThresholdText = '', GoodMessage ='View the details of the Primary Copies with Deduplication disabled here.<VDL>', WarningMessage = 'View the details of the Primary Copies with Deduplication disabled here.<VDL>', CriticalMessage ='View the details of the Primary Copies with Deduplication disabled here.<VDL>', DescriptionText ='' WHERE QueryId =111		

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 112) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (112, 'Email Data Placement', 'Eligible Percentage of Email Archiving clients', 0, 100, 0, 50, 

		'0 %', 

		'#1 - #2 %', 

		'>= #2 %', 

		'', 

		'Meets Expectation.', 

		'Enable email archiving to reduce backup windows and improve application performance.<VDL>', 

		'Enable email archiving to reduce backup windows and improve application performance.<VDL>',

		'', 39)

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 113) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (113, 'Tape Media Management', '', 0, 100, 0, 10,  

		'Tape libraries exist with Vault Tracker Policies and Vault Tracker Enterprise feature in use (OR) No tape libraries exist.', 

		'Tape libraries exist. Vault Tracker Policies are in use without Vault Tracker Enterprise feature.', 

		'Tape libraries exist but no Vault Tracker Policies policies exist.', 

		'', 

		'Meets Expectation.', 

		'Enable Vault Tracker Enterprise features to improve tape automation, tracking and reporting.', 

		'Configure Vault Tracker Policies and enable Vault Tracker Enterprise features to improve tape automation, tracking and reporting.',

		'', 40)

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 114) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (114, 'Self-Service', '', 0, 100, 0, 10,  

		'WebConsole is installed', 

		'WebConsole is not installed', 

		'Not Applicable', 

		'', 

		'Meets Expectation.<VDL>', 

		'Install the Web Server/Client component to leverage the latest reporting technology.', 

		'',

		'', 41)

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 124) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (124, 'High-risk Settings', '', -1, -1, -1, -1, 

		'Disabled', 

		'Not Applicable', 

		'Enabled', 

		'', 

		'Meets Expectation.', 

		'', 

		'Disable this setting from Control Panel - Media Management Configuration',

		'', 42)	 

ELSE

update cf_SurveyHealthParam

set ParameterName = 'High-risk Settings'

where QueryId = 124

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 144) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (144, 'Database Index Fragmentation', 'Fragmentation of Operational Indices', -1, -1, 30, 50, 
		'V11: Indexes are less than 30% fragmented or the most recent DB maintenance activity occurred fewer than 7 days ago. $MULTICRIT$ V10/V9: Over 50% of indexes are less than 30% fragmented.', 
		'V11: Indexes are more than 30% fragmented and the most recent DB maintenance activity occurred more than 7 days ago. $MULTICRIT$ V10/V9: Over 25% of indexes are 30% to 50% fragmented.', 
		'V11: Indexes are more than 30% fragmented and the most recent DB maintenance activity occurred more than 30 days ago. $MULTICRIT$ V10/V9: Over 25% of indexes are more than 50% fragmented. ', 
		'To reduce fragmentation, run DBMaintenance -recommended when needed. <a class="hc-cell-a" href="' + @doclink + '?p=features/tools/db_maintenance.htm">How to run DBMaintenance</a><VDL>', 
		'Meets Expectation.<DELIM><VDL>', 
		'It is recommended to run DBMaintenance -recommended. <a class="hc-cell-a" href="' + @doclink + '?p=features/tools/db_maintenance.htm">How to run DBMaintenance</a><DELIM><VDL>', 
		'It is strongly recommended to run DBMaintenance -recommended. <a class="hc-cell-a" href="' + @doclink + '?p=features/tools/db_maintenance.htm">How to run DBMaintenance</a><DELIM><VDL>', 
		'Any database has more than ##val## % indices fragmented over 30%', 43)


ELSE

	UPDATE cf_SurveyHealthParam SET	
		ThresholdName = 'Fragmentation of Operational Indices',	
     	GoodThresholdText = 'V11: Indexes are less than 30% fragmented or the most recent DB maintenance activity occurred fewer than 7 days ago. $MULTICRIT$ V10/V9: Over 50% of indexes are less than 30% fragmented.', 
		WarningThresholdText = 'V11: Indexes are more than 30% fragmented and the most recent DB maintenance activity occurred more than 7 days ago. $MULTICRIT$ V10/V9: Over 25% of indexes are 30% to 50% fragmented.', 
		CriticalThresholdText ='V11: Indexes are more than 30% fragmented and the most recent DB maintenance activity occurred more than 30 days ago. $MULTICRIT$ V10/V9: Over 25% of indexes are more than 50% fragmented. ', 
		WarningThreshold = 30,	
		CriticalThreshold = 50,	
		InfoMessage = 'To reduce fragmentation, run DBMaintenance -recommended when needed. <a class="hc-cell-a" href="' + @doclink + '?p=features/tools/db_maintenance.htm">How to run DBMaintenance</a><VDL>', 
		GoodMessage = 'Meets Expectation.<DELIM><VDL>', 
		WarningMessage = 'It is recommended to run DBMaintenance -recommended. <a class="hc-cell-a" href="' + @doclink + '?p=features/tools/db_maintenance.htm">How to run DBMaintenance</a><DELIM><VDL>', 
		CriticalMessage = 'It is strongly recommended to run DBMaintenance -recommended. <a class="hc-cell-a" href="' + @doclink + '?p=features/tools/db_maintenance.htm">How to run DBMaintenance</a><DELIM><VDL>'
	WHERE QueryId = 144


IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=156 and ParameterName = 'Disk Pruning')
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		156,

		'Disk Pruning',

		'Blocks to be deleted from disk', 

		0, 

		100, 

		5,

		10, 

		'< #1% of Primary block count or Records older than 7 days < CommCell SIDB Pending Record Minimum Threshold',

		'#1 - #2% of Primary block count or Records older than 7 days : Between minimum and maximum Threshold of CommCell SIDB Pending Record',

		'> #2% of Primary block count or Records older than 7 days > CommCell SIDB Pending Record Maximum Threshold',

		'It is recommended to use DeDuplication feature for optimal data protection.<DELIM>',

		'Meets Expectation.<DELIM><VDL>',

		'Examine mount path performance and verify the disk library Media Agents are online. Disable Antivirus monitoring on the Disk library mount paths. Check the OS System Event log for any failure logging related to the mount path.<VDL>',

		'Examine mount path performance and verify the disk library Media Agents are online.  Disable Antivirus monitoring on the Disk library mount paths. Check the OS System Event log for any failure logging related to the mount path.<VDL>',

		'Prunable block count ##op## ##val## % of the Primary block count',

		45

	)

ELSE 

	UPDATE cf_SurveyHealthParam 

	SET GoodThresholdText    = '< #1% of Primary block count or Records older than 7 days < CommCell SIDB Pending Record Minimum Threshold',

		WarningThresholdText = '#1 - #2% of Primary block count or Records older than 7 days : Between minimum and maximum Threshold of CommCell SIDB Pending Record',

		CriticalThresholdText= '> #2% of Primary block count or Records older than 7 days > CommCell SIDB Pending Record Maximum Threshold'

	WHERE QueryId = 156

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 721)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'TempDB Size',

		'Size', 

		0, 

		100, 

		8,

		16, 

		'< #1 GB <br>

		or Temp DB is on the same disk as the CommServe DB: < 25% of the CommServe DB size<br>

		or Temp DB is on its own disk separate from the CommServe DB: < 50% of the total disk size ',

		'(#1 - #2 GB <br>

		and Temp DB is on the same disk as the CommServe DB: > 25% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: > 50% of the total disk size)',

		'(> #2 GB <br>

		and Temp DB is on the same disk as the CommServe DB: > 30% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: >75% of the total disk size)',

		'',

		'',

		'',

		'',

		'',

		721

	)

ELSE

	UPDATE 	cf_SurveyHealthParam SET

		WarningThreshold = 8,

		CriticalThreshold = 16,

		GoodThresholdText = '< #1 GB <br>

		or Temp DB is on the same disk as the CommServe DB: < 25% of the CommServe DB size<br>

		or Temp DB is on its own disk separate from the CommServe DB: < 50% of the total disk size',

		WarningThresholdText = '(#1 - #2 GB <br>

		and  Temp DB is on the same disk as the CommServe DB: > 25% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: > 50% of the total disk size',

		CriticalThresholdText = '(> #2 GB <br>

		and Temp DB is on the same disk as the CommServe DB: > 30% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: >75% of the total disk size'

	WHERE QueryId=7 and ParamId = 721

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 722)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'TempDB Log Size',

		'Size', 

		0, 

		100, 

		4,

		8, 

		'< #1 GB <br>

		or Temp DB is on the same disk as the CommServe DB: < 25% of the CommServe DB size<br>

		or Temp DB is on its own disk separate from the CommServe DB: < 50% of the total disk size ',

		'(#1 - #2 GB <br>

		and Temp DB is on the same disk as the CommServe DB: > 25% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: > 50% of the total disk size',

		'(> #2 GB <br>

		and Temp DB is on the same disk as the CommServe DB: > 30% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: >75% of the total disk size',

		'',

		'',

		'',

		'',

		'',

		722

	)

ELSE

	UPDATE 	cf_SurveyHealthParam SET

		WarningThreshold = 4,

		CriticalThreshold = 8,

		GoodThresholdText = '< #1 GB <br>

		or Temp DB is on the same disk as the CommServe DB: < 25% of the CommServe DB size<br>

		or Temp DB is on its own disk separate from the CommServe DB: < 50% of the total disk size',

		WarningThresholdText = '(#1 - #2 GB <br>

		and Temp DB is on the same disk as the CommServe DB: > 25% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: > 50% of the total disk size',

		CriticalThresholdText = '(> #2 GB <br>

		and Temp DB is on the same disk as the CommServe DB: > 30% of the CommServe DB size)<br>

		or Temp DB is on its own disk separate from the CommServe DB: >75% of the total disk size'

	WHERE QueryId=7 and ParamId = 722

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 723)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Database Size',

		'', 

		-1, 

		-1, 

		8,

		9, 

		'< #1 GB for SQL Server Express Edition. No limit for other SQL Server Editions.',

		'#1 - #2 GB for SQL Server Express Edition. No limit for other SQL Server Editions.',

		'> #2 GB for SQL Server Express Edition. No limit for other SQL Server Editions.',

		'',

		'',

		'Database size has exceeded the warning limit of SQL Server Express Edition.<DELIM>Please contact customer support for additional information.<DELIM>',

		'Database size has exceeded the critical limit of SQL Server Express Edition.<DELIM>Backup jobs may stop working.<DELIM>Please contact customer support for additional information.<DELIM>',

		'',

		723

	)

ELSE

	UPDATE 	cf_SurveyHealthParam SET

		ParameterName = 'Database Size', 

		ThresholdName = '',

		WarningThreshold = 8,

		CriticalThreshold = 9,

		GoodThresholdText = '< #1 GB for SQL Server Express Edition. No limit for other SQL Server Editions.',

		WarningThresholdText = '#1 - #2 GB for SQL Server Express Edition. No limit for other SQL Server Editions.',

		CriticalThresholdText = '> #2 GB for SQL Server Express Edition. No limit for other SQL Server Editions.',

		InfoMessage = '', 

		GoodMessage = '', 

		WarningMessage = 'Database size has exceeded the warning limit of SQL Server Express Edition.<DELIM>Please contact customer support for additional information.<DELIM>', 

		CriticalMessage = 'Database size has exceeded the critical limit of SQL Server Express Edition.<DELIM>Backup jobs may stop working.<DELIM>Please contact customer support for additional information.<DELIM>'

	WHERE QueryId=7 and ParamId = 723

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 724)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Top 10 Largest Tables by Size',

		'Bloating size', 

		0, 

		1024, 

		100,

		512, 

		'< #1 MB for Regular Tables $MULTICRIT$ < 5 GB for Big Tables',

		'#1 - #2 MB for Regular Tables $MULTICRIT$ 5 - 10 GB for Big Tables',

		'> #2 MB  for Regular Tables $MULTICRIT$ > 10 GB for Big Tables',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		724

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 725)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Top 10 Largest Tables by Row Count',

		'Bloating rows count', 

		0, 

		1000000, 

		500000,

		1000000, 

		'< #1 rows for Regular Tables $MULTICRIT$ < 5 Million rows for Big Tables',

		'#1 - #2 rows for Regular Tables $MULTICRIT$ 5 - 10 Million rows for Big Tables',

		'> #2 rows for Regular Tables $MULTICRIT$ > 10 Million rows for Big Tables',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		725

	)		

ELSE

	  UPDATE cf_SurveyHealthParam SET 

		GoodThresholdText = '< #1 rows for Regular Tables $MULTICRIT$ < 5 Million rows for Big Tables',

		WarningThresholdText = '#1 - #2 rows for Regular Tables $MULTICRIT$ 5 - 10 Million rows for Big Tables',

		CriticalThresholdText = '> #2 rows for Regular Tables $MULTICRIT$ > 10 Million rows for Big Tables',

		WarningThreshold = 500000 

	  WHERE QueryId = 7 AND ParamId = 725

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 701)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Average Attempts per Job',

		'Average number of attempts per job', 

		0, 

		-1, 

		-1,

		-1, 

		'< 1.5 Attempts/Job',

		'>=1.5 and <2 Attempts/Job',

		'>= 2 Attempts/Job',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		701

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 702)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Average Throughput',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		702

	)					

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 703)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Jobs Completed in One Attempt',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		703

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 704)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Jobs Completed',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		704

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 705)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Job Load in last 24 hours',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		705

	)

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 711)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Chunks Closed',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		711

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 712)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Size of Chunk',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		712

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 713)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Max Number of Streams',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		713

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 714)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Average Number of Streams',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		714

	)											

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 715)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Number of Reservations',

		'Information', 

		-1, 

		-1, 

		-1,

		-1, 

		'',

		'',

		'',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'<VDL>',

		'',

		715

	)

	IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 726)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Client Scale Limit',

		'% of Active clients', 

		 0, 

  		 100, 

		 80,

		 90, 

		'<= #1%',

		'#1 - #2%',

		'> #2%',

		'',

		'',

		'Contact Support to increase the client scale limits.',

		'Contact Support to increase the client scale limits.',

		'Percentage of Active clients is ##op## ##val## %',

		726

	)		

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 727)
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		7,

		'Drive Usage',

		'Free Space in Drive', 

		 0, 

  		 100, 

		 20,

		 5, 

		'> #1%',

		'#2 - #1%',

		'< #2%',

		'No information',

		'All Drives have more than 20% free space. <VDL>',

		'One or more Drives have less than 20% free space. <VDL>',

		'One or more Drives have less that 5% free space. <VDL>',

		'Free Drive Space is ##op## ##val## %',

		727

	)	

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 728)
	    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	    VALUES

	    (

	        7,

	        'Last DB Maintenance Performed',

	        'Information', 

	        -1, 

	        -1, 

	        -1,

	        -1, 

	        '',

	        '',

	        '',

	        '<VDL>',

	        '<VDL>',

	        '<VDL>',

	        '<VDL>',

	        '',

	        728

	    ) 
ELSE 
 UPDATE cf_SurveyHealthParam SET ParameterName = 'Last DB Maintenance Performed' 
								 WHERE QueryId = 7 AND ParamId = 728


IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=161 and ParameterName = 'Search Engines')
	INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	VALUES

	(

		161,

		'Search Engines',

		'', 

		-1, 

		-1, 

		-1, 

		-1,

		'Fragmentation Count < 256 <br> and Search Engine File Size < 500 MB and Free Space > 50% of Index Space <br> or Search Only Nodes',

		'Fragmentation Count between 256 - 512 <br> or Search Engine File Size > 600 MB and per million Successful Object between 20MB - 40 MB <br> or Free Space between 35 - 50% of Index Space',

		'Fragmentation Count > 512 <br> or Search Engine File Size > 600 MB and per million Successful Objects > 40 MB <br> or Free Space  < 35% of Index Space',

		'No Search Clouds are configured.<DELIM>',

		'Meets Expectation.<DELIM><VDL>',

		'Your search engines need optimization. <a href="' + @doclink + '?p=13224.htm">How to optimize search engines</a><DELIM><VDL>',

		'Your search engines need optimization. <a href="' + @doclink + '?p=13224.htm">How to optimize search engines</a><DELIM><VDL>',

		'',

		46

	) 
ELSE 
 UPDATE cf_SurveyHealthParam SET GoodThresholdText = 'Fragmentation Count < 256 <br> and Search Engine File Size < 500 MB and Free Space > 50% of Index Space <br> or Search Only Nodes' , 
								 WarningThresholdText = 'Fragmentation Count between 256 - 512 <br> or Search Engine File Size > 600 MB and per million Successful Object between 20MB - 40 MB <br> or Free Space between 35 - 50% of Index Space', 
								 CriticalThresholdText = 'Fragmentation Count > 512 <br> or Search Engine File Size > 600 MB and per million Successful Objects > 40 MB <br> or Free Space  < 35% of Index Space', 
								 InfoMessage = 'No Search Clouds are configured.<DELIM>', 
								 GoodMessage = 'Meets Expectation.<DELIM><VDL>', 
								 WarningMessage = 'Your search engines need optimization. <a href="' + @doclink + '?p=13224.htm">How to optimize search engines</a><DELIM><VDL>', 
								 CriticalMessage = 'Your search engines need optimization. <a href="' + @doclink + '?p=13224.htm">How to optimize search engines</a><DELIM><VDL>' 
								 WHERE QueryId = 161 AND ParamId = 46


IF EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=171)

	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 171

IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=181)
	INSERT INTO cf_SurveyHealthParam(QueryId, ParameterName, ThresholdName, ThresholdMax, ThresholdMin, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId)


	VALUES

	(

		181, 

		'Replication', 

		'Replication', 

		-1, 

		-1, 

		-1, 

		-1, 

		'VM is synced in last 7 days.', 

		'VM sync is disabled.', 

		'VM sync failed or out of sync for more than 7 days.',

		'', 

		'<VDL>', 

		'Few of your VMs are disabled for Live Sync.<DELIM><VDL>', 

		'Please analyze the failed VMs. You can check <a href="' + @doclink + '?p=products/vs_vmware/r_vmw_livesync_troubleshoot.htm">Troubleshooting</a> for additional information.<DELIM><VDL>', 

		'', 

		48

	)

 UPDATE cf_SurveyHealthParam 

	SET ParameterName = 'Replication',

		 ThresholdName = 'Replication',

		CriticalMessage = 'Please analyze the failed VMs. You can check <a href="' + @doclink + '?p=products/vs_vmware/r_vmw_livesync_troubleshoot.htm">Troubleshooting</a> for additional information.<DELIM><VDL>'

	WHERE QueryId = 181 

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 186) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (186, 'Tape Library Growth', 'Estimated days to be out of spare tapes', 0, 1000, 14, 7, 
		'> #1 days', 
		'#2 - #1 days', 
		'< #2 days', 
		'There is no Tape library configured.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Check the spare tapes for your tape library.<DELIM><VDL>', 
		'Check the spare tapes for your tape library.<DELIM><VDL>', 
		'Tape library would be out of spare tapes in ##op## ##val## days', 57)


ELSE

UPDATE cf_SurveyHealthParam SET

	WarningThreshold = 14,

	CriticalThreshold = 7

WHERE QueryId = 186

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 196) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (196, 'Cloud Library Growth', 'Estimated days to be full', 0, 1000, 180, 90, 
		'> #1 days', 
		'#2 - #1 days', 
		'< #2 days', 
		'There is no cloud library configured.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Check the free space for your cloud library.<DELIM><VDL>', 
		'Check the free space for your cloud library.<DELIM><VDL>', 
		'Cloud library would be full in ##op## ##val## days', 56) 


IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 200 AND ParameterName = 'Index Backup') 

	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 200 AND ParameterName = 'Index Backup' 

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 201 AND ParameterName = 'Index State') 
	insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	values (201, 'Index State', 'Index State', 3, 100, 15, 30, 

			'No index in CommCell having critical or warning status', 

			'Any index in CommCell having warning status',

			'Any index in CommCell having warning status', 

			'There is no index state status.<DELIM>', 

			'Meets Expectation.<DELIM><VDL>', 

			'<a href="' + @doclink + '?p=features/index/r_index_report_solutions.htm">How to troubleshoot Index issues</a> for more information.<DELIM><VDL>',

			'<a href="' + @doclink + '?p=features/index/r_index_report_solutions.htm">How to troubleshoot Index issues</a> for more information.<DELIM><VDL>', 

			'', 50) 

ELSE

	UPDATE cf_SurveyHealthParam SET 

		GoodThresholdText = 'No index in CommCell having critical or warning status', 

		WarningThresholdText = 'Any index in CommCell having warning status',

		CriticalThresholdText = 'Any index in CommCell having warning status', 

		GoodMessage = 'Meets Expectation.<DELIM><VDL>', 

		CriticalMessage = '<a href="' + @doclink + '?p=features/index/r_index_report_solutions.htm">How to troubleshoot Index issues</a> for more information.<DELIM><VDL>',

		WarningMessage = '<a href="' + @doclink + '?p=features/index/r_index_report_solutions.htm">How to troubleshoot Index issues</a> for more information.<DELIM><VDL>',

		ThresholdMin = 3,

		ThresholdMax = 100,

		WarningThreshold = 15,

		CriticalThreshold = 30

	WHERE QueryId = 201 

IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 2) 

DELETE FROM cf_SurveyHealthParam WHERE QueryId = 2

IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 204) 

DELETE FROM cf_SurveyHealthParam WHERE QueryId = 204

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 206) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (206, 'DDB Disk Space Utilization', 'Free DDB Disk Space', 0, 100, 25, 10, 

		'> #1 % and Date to be full more than 90 days', 

		'#2 - #1% or Date to be full in 30 - 90 days', 

		'< #2 % or Date to be full in 30 days', 

		'There is no DDB path configured.<DELIM>', 

		'Meets Expectation.<DELIM><VDL>', 

		'Check disk space usage. If necessary, add more disk to DDB path.<DELIM><VDL>', 

		'Check disk space usage. If necessary, add more disk to DDB path.<DELIM><VDL>', 

		'DDB Path Free Disk Space is ##op## ##val## %', 54) 

ELSE 
	update cf_SurveyHealthParam 


			SET ThresholdName = 'Free Disk Space' ,

			GoodThresholdText    = '> #1 % and Date to be full more than 90 days',

			WarningThresholdText = '#2 - #1% or Date to be full in 30 - 90 days',

			CriticalThresholdText= '< #2 % or Date to be full in 30 days'

			where QueryId = 206 and ParamId = 54

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 207) 
	insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


	values (207, 'Subclients Not Having Full Backup in 60 Days', 'Information', -1, -1, -1, -1, '', '', '', '', '', '', '', '', 55)

ELSE

	UPDATE cf_SurveyHealthParam SET ParamId = 55

	WHERE QueryId = 207 AND ParamId <> 55

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 211) 
	insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
	values (211, 'RTO', 'Information', -1, -1, -1, -1, '', '', '', '', '', '', '', '', 58)


ELSE

BEGIN

	UPDATE cf_SurveyHealthParam SET ParamId = 58 WHERE QueryId = 211 AND ParamId <> 58

	UPDATE cf_SurveyHealthParam SET ParameterName = 'RTO' WHERE QueryId = 211 AND ParamId = 58

END

IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 212) 

	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 212

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 209) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
values (209, 'Fallen Behind Backup Copy Jobs', 'Fallen Behind Days', 0, 1000, 2, 4, 
		'< #1 days', 
		'#1 - #2 days', 
		'> #2 days', 
		'Up-To-Date.<DELIM>', 
		'Meets Expectation.<DELIM><VDL>', 
		'Examine Network & Disk throughput. Check for the DDB performance in case of Backup copy. Contact Support for further information.<DELIM><VDL>', 
		'Examine Network & Disk throughput. Check for the DDB performance in case of Backup copy. Contact Support for further information.<DELIM><VDL>', 
		'Backup copies have fallen behind by ##val## or more days', 60)


ELSE

BEGIN

	UPDATE cf_SurveyHealthParam SET ParameterName = 'Fallen Behind Backup Copy Jobs' WHERE QueryId = 209 AND ParamId = 60

END

IF EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 213) 
	DELETE FROM cf_SurveyHealthParam WHERE QueryId = 213


IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 214) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (214, 'Cleanup', 'Information', -1, -1, 1, 1,  

        '', 

        '', 

        '', 

        '', 

        '', 

        '', 

        '', 

        '', 62) 

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 260) 
	insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 
	values (260, 'Data Aging Troubleshooting', 'Information', -1, -1, -1, -1, '', '', '', 


		'View description of problems in Details and check log files for more information.<DELIM><VDL>', 

		'Meets Expectation.<DELIM><VDL>', 

		'View description of problems in Details and check log files for more information.<DELIM><VDL>', 

		'View description of problems in Details and check log files for more information.<DELIM><VDL>', 

		'', 64)

ELSE

BEGIN

	UPDATE cf_SurveyHealthParam SET ParamId = 64, GoodMessage ='Meets Expectation.<DELIM><VDL>' WHERE QueryId = 260

END

IF NOT EXISTS (SELECT * FROM cf_SurveyHealthParam WHERE QueryId = 261) 
insert into cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


values (261, 'VMs Need Attention', '', -1, -1, 1, 1,  

        '', 

        '', 

        '', 

        '', 

        '', 

        '', 

        '', 

        '', 65) 

	IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 729)
    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


    VALUES

    (

        7,

        'DB File Size',

        'DB File Size in MB', 

         -1, 

         -1, 

         20480,

         51200, 

        '<= #1%',

        '#1 - #2%',

        '> #2%',

        '',

        '',

        'Contact Support to investigate the log Files size.',

        'Contact Support to investigate the log Files size.',

        'DB File Size in MB',

        729

    )  

	IF NOT EXISTS(SELECT * FROM cf_SurveyHealthParam WHERE QueryId=7 and ParamId = 730)
    INSERT INTO cf_SurveyHealthParam (QueryId, ParameterName, ThresholdName, ThresholdMin, ThresholdMax, WarningThreshold, CriticalThreshold, GoodThresholdText, WarningThresholdText, CriticalThresholdText, InfoMessage, GoodMessage, WarningMessage, CriticalMessage, DescriptionText, ParamId) 


    VALUES

    (

        7,

        'Commserv Database Size',

        'Commserv Database Size in GB', 

         -1, 

         -1, 

         100,

         150, 

        '<= #1%',

        '#1 - #2%',

        '> #2%',

        '',

        '',

        'Contact Support to investigate the Commserv Database growth.',

        'Contact Support to investigate the Commserv Database growth.',

        'Commserv Database Size in GB',

        730

    )  

