

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_SurveyDailyDDBRatioByCommCell.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_SurveyDailyDDBRatioByCommCell.script,v $ $Id: cf_SurveyDailyDDBRatioByCommCell.script,v 1.1.2.1 2018/11/18 04:15:50 nbirru Exp $";
-- TABLENAME cf_SurveyDailyDDBRatioByCommCell

print '... inserting Table: cf_SurveyDailyDDBRatioByCommCell'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_SurveyDailyDDBRatioByCommCell

DECLARE @param_isPrivate INT = 0

SELECT  @param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'isPrivate'

IF(@param_isPrivate = 0)

BEGIN

    IF NOT EXISTS (SELECT TOP 1 1 FROM cf_SurveyDailyDDBRatioByCommCell) 

    BEGIN

       IF OBJECT_ID('tempdb.dbo.#dedupeLatestData')      IS NOT null DROP TABLE #dedupeLatestData

        CREATE TABLE #dedupeLatestData      (CommServUniqueId INT, LogDate DATE, SurveyResultId BIGINT)
        INSERT INTO #dedupeLatestData


        SELECT  CommServUniqueId,

                CAST(LogDate AS DATE)AS LogDate  ,

                MAX(SurveyResultId) AS SurveyResultId 

        FROM cf_SurveyDDBRatioBySPCopy WITH (NOLOCK)  

        GROUP BY CommServUniqueId, CAST(LogDate AS DATE) 
        INSERT INTO cf_SurveyDailyDDBRatioByCommCell


        SELECT DISTINCT B.CommServUniqueId, 

                B.LogDate, 

                B.TotalAppSize, 

                B.TotalSizeOnMedia, 

                CAST(((TotalSizeOnMedia*100.0)/ (CASE WHEN TotalAppSize=0 THEN 1 ELSE TotalAppSize END)) AS DECIMAL(10,2)) AS DedupeRatio

        from cf_SurveyDDBRatioBySPCopy B WITH (NOLOCK)     

        INNER JOIN #dedupeLatestData SUB

            ON B.SurveyResultId = SUB.SurveyResultId AND B.CommServUniqueId = SUB.CommServUniqueId

        DROP TABLE #dedupeLatestData

    END

END

