

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/cf_ReportParameterView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: cf_ReportParameterView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_ReportParameterView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[cf_ReportParameterView]
GO

delete from GXDBVersions where name = 'cf_ReportParameterView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'cf_ReportParameterView', '1.9.62.1', 'cf_ReportParameterView', '')
GO
CREATE VIEW cf_ReportParameterView
AS
SELECT	'Health Report' AS ReportName,
		HP.QueryId,
		CASE WHEN LEN(GM.ParameterName) > 0 THEN GM.ParameterName ELSE Q.Name END AS QueryName,
		GM.GroupId AS QueryGroupId,
		G.Name AS QueryGroupName,
		HP.ParameterName,
		HP.ThresholdName, HP.ThresholdMin, HP.ThresholdMax, HP.WarningThreshold, HP.CriticalThreshold,
		HP.GoodThresholdText, HP.WarningThresholdText, HP.CriticalThresholdText,
		HP.InfoMessage,
		REPLACE(HP.GoodMessage, '#1', HP.WarningThreshold) AS GoodMessage,
		REPLACE(REPLACE(HP.WarningMessage, '#1', HP.WarningThreshold), '#2', HP.CriticalThreshold) AS WarningMessage,
		REPLACE(HP.CriticalMessage, '#2', HP.CriticalThreshold) AS CriticalMessage,
		CASE WHEN GM.GroupId = 18 THEN HP.ParamId ELSE GM.SurveySortOrder END AS 'ParamSortOrder',
		ISNULL(HP.DescriptionText, '') AS DescriptionText,
		HP.ParamId
FROM	cf_SurveyHealthParam HP
		INNER JOIN cf_CommservSurveyQueries Q ON HP.QueryId = Q.QueryId
		INNER JOIN cf_CommservSurveyGroupMap GM ON HP.QueryId = GM.SurveyId AND (LEN(GM.ParameterName) = 0 OR GM.ParameterName = HP.ParameterName)
		INNER JOIN cf_CommservSurveyGroups G ON GM.GroupId = G.SurveyGroupId
WHERE (HP.QueryId <> 2 OR (HP.QueryId = 2 AND (SELECT ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'isPrivate') = 0))
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [cf_ReportParameterView]'
END
GO

