

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/SubclientContentAndBackupSchedule.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: SubclientContentAndBackupSchedule"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubclientContentAndBackupSchedule]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[SubclientContentAndBackupSchedule]
GO

delete from GXDBVersions where name = 'SubclientContentAndBackupSchedule' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'SubclientContentAndBackupSchedule', '1.1.2.1', 'SubclientContentAndBackupSchedule', '')
GO
CREATE VIEW [dbo].[SubclientContentAndBackupSchedule]
AS
SELECT  DISTINCT CAST(CC.CommCellID AS INT) AS CommCellID,
		CC.CommServName,
        SA.ClientId,
        SA.clientName AS ClientName,
		ISNULL(SA.PhysicalClientName,SA.clientName) AS PhysicalClientName,
        SA.AppTypeId AS AgentId,
        SA.AgentName,
        SA.InstanceId,
        SA.InstanceName,
        SA.BackupSetId,
        SA.BackupsetName,
        SA.AppId AS SubclientId,
        SA.subclientName,
        ISNULL(SC.Content, '') AS Content,
        SchedulePolicy,
        ScheduleName,
        SchedBackupType,
        SchedPattern,
        SchedBackupDay,
        SchedBackupTime,
        SchedNextBackupTime
FROM    cf_SurveySubclientAssociation AS SA WITH (NOLOCK)
        INNER JOIN cf_CommcellIdNameMap AS CC WITH (NOLOCK)
          ON SA.CommservUniqueId = CC.ID
        LEFT OUTER JOIN cf_SurveySubclientContent AS SC WITH (NOLOCK)
          ON SA.CommservUniqueId = SC.CommservUniqueId
		    AND SC.AppId IN (SA.AppId, SA.SubclientPolicyAppId) AND SC.Type = 1
        LEFT OUTER JOIN cf_SurveyClientGroupAssociation AS CGA WITH (NOLOCK)
          ON SA.CommservUniqueId = CGA.CommservUniqueId
            AND SA.ClientId = CGA.ClientId
        LEFT OUTER JOIN cf_SurveyBackupSchedule AS BS WITH (NOLOCK)
          ON SA.CommservUniqueId = BS.CommservUniqueId
            AND ((BS.ClientGroupId = 0 AND (BS.ClientId > 0 OR BS.AssocType = 2))
              OR (BS.ClientGroupId = CGA.ClientGroupId AND BS.ClientGroupId > 0))
            AND BS.ClientId IN (SA.ClientId, 0)
            AND BS.AppTypeId IN (SA.AppTypeId, 0)
            AND BS.InstanceId IN (SA.InstanceId, 0)
            AND BS.BackupsetId IN (SA.BackupsetId, 0)
            AND BS.AppId IN (SA.AppId, SA.SubclientPolicyAppId, 0)
			AND ISNULL(BS.Exclude, 0) = 0
WHERE   SA.AppId > 0 AND SA.Deleted = 0
        AND (SA.SubclientStatus & (2|4|8|64|128|4096)) IN (0, 8, 64, 128, 4096)
		AND (SA.DataPolicyId > 1 OR SA.LogPolicyId > 1)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [SubclientContentAndBackupSchedule]'
END
GO

