

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/SubclientContent.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: SubclientContent"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubclientContent]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[SubclientContent]
GO

delete from GXDBVersions where name = 'SubclientContent' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'SubclientContent', '1.9', 'SubclientContent', '')
GO
CREATE VIEW [dbo].[SubclientContent]
AS
SELECT
	CAST(C.CommCellID AS INT) AS CommCellID,
	C.CommServName AS CommServName,
	S.ClientId AS ClientID,
	S.clientName AS ClientName,
	ISNULL(S.PhysicalClientName,S.clientName) AS PhysicalClientName,
	S.AppTypeId AS AgentID,
	S.AgentName AS AgentName,
	S.InstanceId AS InstanceID,
	S.InstanceName AS InstanceName,
	S.BackupsetId AS BackupsetID,
	S.BackupsetName AS BackupsetName,
	S.AppId AS SubclientID,
	S.SubclientName AS SubclientName,
	CASE WHEN S.BackupDisabled = 0 THEN 'Yes' ELSE 'No' END AS IsBackupEnabled,
	ISNULL(CAST(SC.Content AS nvarchar(1024)), '') AS Content
FROM
	cf_SurveySubclientAssociation AS S WITH (NOLOCK)
	INNER JOIN cf_CommcellIdNameMap AS C WITH (NOLOCK)
		ON C.ID = S.CommservUniqueId AND (S.SubclientStatus & (2|4|8|64|128|4096)) IN (0,8,64,128,4096)
		AND S.AppId > 0 AND S.Deleted = 0
	LEFT OUTER JOIN cf_SurveySubclientContent AS SC  WITH (NOLOCK)
		ON SC.AppId IN (S.AppId, S.SubclientPolicyAppId)
		AND SC.CommservUniqueId = S.CommservUniqueId AND SC.Type = 1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [SubclientContent]'
END
GO

