

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/MetricsCollectedResultsView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: MetricsCollectedResultsView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MetricsCollectedResultsView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[MetricsCollectedResultsView]
GO

delete from GXDBVersions where name = 'MetricsCollectedResultsView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'MetricsCollectedResultsView', '1.3', 'MetricsCollectedResultsView', '')
GO
CREATE VIEW [dbo].[MetricsCollectedResultsView]
AS
	SELECT
		ccNameMap.ID AS 'CommServUniqueID',
		ccNameMap.CommCellID AS 'CommCellID',
		ccNameMap.CommServGUID AS 'CommServGUID',
		ccNameMap.CustomerName AS 'CustomerName',
		ccNameMap.CommServName AS 'CommServName',
		ccNameMap.CommServTZ AS 'CommServTimeZone',
		ccNameMap.CommServVersion AS 'CommServVersion',
		xmlFile.ID AS 'XMLFileID',
		result.QueryId AS 'QueryId',
		result.CommservSurveyResults_ID AS 'ResultID',
		result.LogDate AS 'LogDate',
		result.LogDateUTC AS 'LogDateUTC',
		result.Flags AS 'SurveyResultFlags'
	FROM dbo.cf_CommservSurveyResults AS result WITH (NOLOCK)
		INNER JOIN dbo.cf_CustomerFeedbackXmlFile AS xmlFile WITH (NOLOCK)
			ON xmlFile.ID = result.CustomerFeedbackXmlFile_id
		INNER JOIN dbo.cf_CommcellIdNameMap AS ccNameMap WITH (NOLOCK)
			ON xmlFile.CommcellIdNameMap_ID = ccNameMap.ID
			AND (ccNameMap.Flags & 1) <> 1 --Remove Blocked CommCells
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [MetricsCollectedResultsView]'
END
GO

