

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/Last7DayRestoreDetails.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: Last7DayRestoreDetails"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Last7DayRestoreDetails]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Last7DayRestoreDetails]
GO

delete from GXDBVersions where name = 'Last7DayRestoreDetails' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'Last7DayRestoreDetails', '1.9.2.1', 'Last7DayRestoreDetails', '')
GO
CREATE VIEW [dbo].[Last7DayRestoreDetails]
AS
SELECT
	CAST(cc.CommCellID AS INT) AS CommCellID,
	cc.CommServName AS CommServName,
	Jobid AS JobID,
    CASE JobStatus
		WHEN 1 THEN 'Success'
		WHEN 2 THEN 'Failed'
		WHEN 3 THEN 'PartialSuccess'
		WHEN 4 THEN 'Killed'
		WHEN 5 THEN 'Stopped'
		WHEN 6 THEN 'Interrupted'
		WHEN 9 THEN 'Failed to Start'
		ELSE 'Unknown'
    END AS JobStatus,
	SrcClientId AS SrcClientID,
	SrcClientName AS SrcClientName,
	ISNULL(SrcPhysicalClientName,SrcClientName) AS SrcPhysicalClientName,
	DestClientId AS DestClientID,
	DestClientName AS DestClientName,
	ISNULL(DestPhysicalClientName,DestClientName) AS DestPhysicalClientName,
	AppTypeId AS AgentID,
	AppType AS AgentName,
	InstanceId AS InstanceID,
	case Instance
		when 'DefaultInstanceName' then ''
		when 'defaultDummyInstanceForOracle' then ''
		else Instance
	end AS InstanceName,
	BkpsetId AS BackupsetID,
	case AppTypeId
		when 6 then 'NULL'
		when 9 then 'NULL'
		when 15 then 'NULL'
		when 27 then 'NULL'
		when 31 then 'NULL'
		else Bkpset
	end AS BackupsetName,
	StartTime,
	DATEADD(second, StartTime, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	EndTime,
	DATEADD(second, EndTime, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	Duration,
	TotFiles2xfer AS TotalObjects,
	TotSuccess AS SuccessfulObjects,
	SkippedObjects,
	FailedObjects,
	TotUnCompMB AS 'ApplicationSizeInMB',
	ErrorCode,
	FailedReason,
	UserName,
	CAST(JobDescription AS nvarchar(1024)) AS 'JobDescription',
	BackupTime AS 'BackupTime'
FROM cf_SurveyRestoreJobStats AS J WITH (NOLOCK)
	INNER JOIN cf_CommcellIdNameMap as cc WITH (NOLOCK)
		ON J.CommservUniqueId = cc.ID
WHERE J.EndTime BETWEEN dbo.GetUnixTimeBig(DATEADD(d, -7, GETUTCDATE())) AND dbo.GetUnixTimeBig(GETUTCDATE())
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [Last7DayRestoreDetails]'
END
GO

