

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/BackupSchedules.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: BackupSchedules"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupSchedules]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[BackupSchedules]
GO

delete from GXDBVersions where name = 'BackupSchedules' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'BackupSchedules', '1.13.34.1', 'BackupSchedules', '')
GO
CREATE VIEW [dbo].[BackupSchedules]
AS
SELECT distinct
    CAST(cc.CommCellID AS INT) AS CommCellID,
    cc.CommServName AS CommServName,
    sc.ClientId AS ClientID,
    SC.clientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
    sc.AppTypeId AS AgentID,
    sc.AgentName AS AgentName,
    sc.InstanceId AS InstanceID,
    sc.InstanceName AS InstanceName,
    sc.BackupsetId AS BackupsetID,
    sc.BackupsetName AS BackupsetName,
    sc.AppId AS SubclientID,
    sc.SubclientName AS SubclientName,
    case when sc.DataPolicyId > 1 or sc.LogPolicyId > 1 then 1 else 0 end as IsStoragePolicyAssociated,
    bs.SchedulePolicy AS SchedulePolicy,
    bs.ScheduleName AS ScheduleName,
    bs.Disabled AS IsScheduleDisabled,
    bs.SchedBackupType AS SchedBackupType,
    bs.SchedPattern AS SchedPattern,
    bs.SchedInterval AS SchedInterval,
    CAST(bs.SchedBackupDay AS varchar(512)) AS SchedBackupDay,
    bs.SchedBackupTime AS SchedBackupTime,
    bs.SchedNextBackupTime AS SchedNextBackupTime,
    CASE WHEN bs.MaxRunningSec > 0 THEN DATEADD(SECOND, bs.MaxRunningSec, bs.SchedNextBackupTime)
		 WHEN ISNULL(rt.MaxRunningSec, -1) > 0 THEN DATEADD(SECOND, rt.MaxRunningSec, bs.SchedNextBackupTime)
		 ELSE NULL
	END AS MaxNextBackupEndTime
FROM
    cf_CommcellIdNameMap AS cc WITH (NOLOCK)
    INNER JOIN cf_SurveySubclientAssociation as sc WITH (NOLOCK)
        ON cc.ID = sc.CommservUniqueId
        AND (sc.SubclientStatus & (2|4|8|64|128|4096)) IN (0, 8, 64, 128, 4096)
        AND sc.AppId > 0 AND sc.Deleted = 0
    LEFT OUTER JOIN cf_SurveyClientGroupAssociation AS cga WITH (NOLOCK)
        ON sc.CommservUniqueId = cga.CommservUniqueId
        AND sc.ClientId = cga.ClientId
    INNER JOIN cf_SurveyBackupSchedule AS bs WITH (NOLOCK)
        ON bs.CommservUniqueId = sc.CommservUniqueId
        AND ((bs.ClientGroupId = 0 AND (bs.ClientId > 0 OR bs.AssocType = 2) )OR (bs.ClientGroupId = cga.ClientGroupId  AND bs.ClientGroupId > 0))
        AND bs.ClientId IN (sc.ClientId, 0)
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
        AND bs.InstanceId IN (sc.InstanceId, 0)
        AND bs.BackupsetId IN (sc.BackupsetId, 0)
        AND bs.AppId IN (sc.AppId, sc.SubclientPolicyAppId, 0)
	LEFT OUTER JOIN cf_SurveyBackupMaxRunningTime AS rt WITH (NOLOCK)
		ON sc.AppTypeId = rt.AppTypeId
    WHERE ISNULL(Exclude,0) = 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [BackupSchedules]'
END
GO

