

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Wr_ManageMetricsQueries.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Wr_ManageMetricsQueries <<<'

IF EXISTS (select * from sysobjects where name='Wr_ManageMetricsQueries')
	drop procedure Wr_ManageMetricsQueries
IF EXISTS (select * from GxQscripts where name='Wr_ManageMetricsQueries')
	delete from GxQscripts where name = 'Wr_ManageMetricsQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Wr_ManageMetricsQueries')
	delete from GXDBVersions where aliasname = 'Wr_ManageMetricsQueries'
GO
print '... Creating Procedure: Wr_ManageMetricsQueries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Wr_ManageMetricsQueries
  @i_UserId INT = -1,
  @i_XMLString NVARCHAR(MAX)
AS
	SET NOCOUNT ON;
	DECLARE @inputXML XML = CAST(@i_XmlString AS XML)
	DECLARE @ProcessSurveyResultTran INT
	SET @ProcessSurveyResultTran = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		IF OBJECT_ID('tempdb..#inputData') IS NOT NULL DROP TABLE #inputData
		CREATE TABLE #inputData (
			QueryId		INT,
			Retention	INT,
			StatusStr	NVARCHAR(MAX),
			Status		INT
		)
		INSERT INTO #inputData (QueryId, Retention, StatusStr)
			SELECT QueryId, CAST([retention] AS INT), [status]
			FROM
			(
				SELECT	queryInfo.value('@queryId','INT') AS QueryId,
						columnsInfo.value('@name','NVARCHAR(MAX)') AS columnName,
						columnsInfo.value('@value','NVARCHAR(MAX)') AS columnValue
				FROM @inputXML.nodes('/WebReport_ReportConfigReq/queryInfo') queryInfo(queryInfo)
				CROSS APPLY queryInfo.nodes('columnsInfo') AS columnsInfo(columnsInfo)
			) AS SourceTable
			PIVOT
			(
				MAX(columnValue)
				FOR columnName IN ([retention],[status])
			) AS PivotTable
		UPDATE	#inputData
		SET		Status = CASE WHEN StatusStr = 'Enabled' THEN 1
							  ELSE 0
						 END
		DECLARE @RetentionForQ51 INT = (SELECT ISNULL(Retention,0) FROM #inputData WHERE QueryId = 51)
		IF (@RetentionForQ51 <> 0 AND (SELECT DataRetentionDays FROM cf_CommServSurveyQueries WITH (NOLOCK) WHERE QueryId = 51) <> @RetentionForQ51)			-- changing retention for both 137 and 51 if user tries to change retention for 51
		BEGIN
			--DECLARE @FlagsForQ137 INT = (SELECT Flags FROM cf_CommServSurveyQueries  WITH (NOLOCK) WHERE QueryId = 137)
			--INSERT INTO #inputData VALUES (137, @RetentionForQ51, CASE WHEN @FlagsForQ137 <> 0 THEN 'Enabled' ELSE 'Disabled' END, CASE WHEN @FlagsForQ137 <> 0 THEN 1 ELSE 0 END)
		/*** include if 137 is to be shown in page ***
		END
		IF EXISTS (SELECT * FROM #inputData WHERE QueryId = 137)
		BEGIN
		***/
			DECLARE @RetentionMonths INT = (@RetentionForQ51/30) + 1
			UPDATE cf_SurveyConfig
			SET Value = CAST(@RetentionMonths AS NVARCHAR(MAX))
			WHERE Name LIKE 'RetentionMonthsForJobDetails'
			/*** include if 137 is to be shown in page ***
			IF NOT EXISTS (SELECT * FROM #inputData WHERE QueryId = 51)
			BEGIN
				DECLARE @FlagsForQ51 INT = (SELECT Flags FROM cf_CommServSurveyQueries  WITH (NOLOCK) WHERE QueryId = 51)
				SELECT @RetentionForQ51 = Retention FROM #inputData WHERE QueryId = 137
				INSERT INTO #inputData VALUES (51, @RetentionForQ51, CASE WHEN @FlagsForQ51 <> 0 THEN 'Enabled' ELSE 'Disabled' END, CASE WHEN @FlagsForQ51 <> 0 THEN 1 ELSE 0 END)
			END
			***/
		END
		IF OBJECT_ID('tempdb..#OldXMLData') IS NOT NULL DROP TABLE #OldXMLData
		CREATE TABLE #OldXMLData (
			QueryId INT,
			Flags INT,
			Status NVARCHAR(MAX)
		)
		IF (NOT EXISTS (SELECT id FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'MetricsQueriesPreviousFlags'))
			INSERT INTO cf_SurveyConfig VALUES ('MetricsQueriesPreviousFlags','',GETUTCDATE())
		DECLARE @OldXML XML = (SELECT CAST(Value AS XML) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'MetricsQueriesPreviousFlags')
		INSERT INTO #OldXMLData (QueryId, Flags, Status)
			SELECT	queries.value('@queryId','INT'),
					queries.value('@flags','INT'),
					queries.value('@status','NVARCHAR(MAX)')
			FROM @OldXML.nodes('/MetricsQueriesPreviousFlags/Query') Q(queries)
		IF OBJECT_ID('tempdb..#QueriesToDisable') IS NOT NULL DROP TABLE #QueriesToDisable
		CREATE TABLE #QueriesToDisable (
			QueryId INT
		)
		INSERT INTO #QueriesToDisable (QueryId)
			SELECT IP.QueryId
			FROM #inputData IP INNER JOIN cf_CommServSurveyQueries CUR WITH (NOLOCK) ON IP.QueryId = CUR.QueryId
			WHERE IP.Status = 0 AND CUR.Flags & 2 <> 0
		/*************************** chargeback reports ***********************
		IF(72 IN (SELECT QueryId FROM #QueriesToDisable))	--Disabling Daily, Monthly and Weekly chargeback reports if chargeback reports are disabled
		BEGIN
			INSERT INTO #inputData (QueryId, Retention, StatusStr, Status)
				SELECT QueryId, DataRetentionDays, 'Disabled', 0 FROM cf_CommServSurveyQueries WITH (NOLOCK) WHERE QueryId IN (136, 162)
			INSERT INTO #QueriesToDisable VALUES(136)
			INSERT INTO #QueriesToDisable VALUES(162)
		END
		ELSE IF(72 IN (SELECT QueryId FROM #inputData) AND (SELECT Flags FROM cf_CommServSurveyQueries WHERE QueryId = 72) = 0)   -- Enabling all chargeback reports together
		BEGIN
			INSERT INTO #inputData (QueryId, Retention, StatusStr, Status)
				SELECT QueryId, DataRetentionDays, 'Enabled', 1 FROM cf_CommServSurveyQueries WITH (NOLOCK) WHERE QueryId IN (136, 162)
		END
		**********************************************************************/
		IF OBJECT_ID('tempdb..#NewQueryData') IS NOT NULL DROP TABLE #NewQueryData
		CREATE TABLE #NewQueryData (
			QueryId INT,
			NewRetention INT,
			NewFlags INT,
			NewStatus NVARCHAR(MAX)
		)
		INSERT INTO #NewQueryData (QueryId, NewRetention, NewFlags, NewStatus)
			SELECT IP.QueryId, IP.Retention,
			CASE
				WHEN IP.Status = 1 AND (CUR.Flags & 2) = 0 AND OLD.Flags IS NOT NULL THEN OLD.Flags
				WHEN IP.Status = 1 AND (CUR.Flags & 2) = 0 THEN 3
				WHEN IP.Status = 1 THEN CUR.Flags
				ELSE 0
			END,
			CASE
				WHEN IP.Status = 1 AND (CUR.Flags & 2) = 0 AND OLD.Status IS NOT NULL THEN OLD.Status
				WHEN IP.Status = 1 AND (CUR.Flags & 2) = 0 THEN 'In Production'
				WHEN IP.Status = 1 THEN CUR.Status
				ELSE 'Disabled'
			END
			FROM #inputData IP INNER JOIN cf_CommServSurveyQueries CUR WITH (NOLOCK) ON IP.QueryId = CUR.QueryId
				LEFT OUTER JOIN #OldXMLData OLD ON IP.QueryId = OLD.QueryId
		UPDATE #OldXMLData
		SET Flags = CUR.Flags,
			Status = CUR.Status
		FROM cf_CommServSurveyQueries CUR WITH (NOLOCK)
		WHERE #OldXMLData.QueryId = CUR.QueryId
		  AND CUR.QueryId IN (SELECT * FROM #QueriesToDisable)
		INSERT INTO #OldXMLData (QueryId, Flags, Status)
			SELECT QueryId, Flags, Status
			FROM cf_CommServSurveyQueries WITH (NOLOCK)
			WHERE QueryId IN (SELECT * FROM #QueriesToDisable)
			  AND QueryId NOT IN (SELECT QueryId FROM #OldXMLData)
		UPDATE cf_CommservSurveyQueries
		SET LastUpdatedBy = @i_UserId,
			LastUpdatedTime = GETUTCDATE(),
			Status = NewStatus,
			Flags = NewFlags,
			DataRetentionDays = NewRetention
		FROM #NewQueryData NEW
		WHERE cf_CommservSurveyQueries.QueryId = NEW.QueryId
		DECLARE @newXML XML = (
			SELECT QueryId AS '@queryId', Flags as '@flags', Status AS '@status'
			FROM #OldXMLData
			FOR XML PATH ('Query'), ROOT ('MetricsQueriesPreviousFlags')
		)
		UPDATE cf_SurveyConfig
		SET Value = CAST(@newXML AS NVARCHAR(MAX)),
			LogDateUTC = GETUTCDATE()
		WHERE Name = 'MetricsQueriesPreviousFlags'
		DROP TABLE #inputData
		DROP TABLE #NewQueryData
		DROP TABLE #OldXMLData
		DROP TABLE #QueriesToDisable
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH
		
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
			ROLLBACK TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END CATCH
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Wr_ManageMetricsQueries')
	delete from GxQscripts where name = 'Wr_ManageMetricsQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Wr_ManageMetricsQueries')
	delete from GXDBVersions where aliasname = 'Wr_ManageMetricsQueries'
GO

insert into GXDBVersions values(2, 'Wr_ManageMetricsQueries',  '00000000000000000000', 'Wr_ManageMetricsQueries', '00000000000000000000')
GO

