

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptUpgradeHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptUpgradeHistory.sp,v $ $Id: RptUpgradeHistory.sp,v 1.13.2.9 2020/12/17 02:29:05 mkhan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptUpgradeHistory')
BEGIN
	print '>>> Drop Stored Procedure: RptUpgradeHistory <<<'
	drop procedure RptUpgradeHistory
END
IF EXISTS (select * from GxQscripts where name='RptUpgradeHistory')
	delete from GxQscripts where name = 'RptUpgradeHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUpgradeHistory')
	delete from GXDBVersions where aliasname = 'RptUpgradeHistory'
GO
print '... Creating Procedure: RptUpgradeHistory'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptUpgradeHistory
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @category int = 0
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 38
SET @blLatestSurvey = 1
IF @category = 0
BEGIN
IF @blaggregate = 1
BEGIN
	IF OBject_ID('tempdb.dbo.#V10Results') IS NOT NULL DROP TABLE #V10Results
	IF OBject_ID('tempdb.dbo.#V11Results') IS NOT NULL DROP TABLE #V11Results
	DECLARE @min100Inst DATETIME
	DECLARE @max100Inst DATETIME
	DECLARE @min110Inst DATETIME
	DECLARE @max110Inst DATETIME
	DECLARE @releaseDateV10	DATETIME
	DECLARE @releaseDateV11	DATETIME
	SET @releaseDateV10 = '10-17-2012'
	SET @releaseDateV11 = '10-15-2015'
	CREATE TABLE #V10Results (InstallTime DATETIME, Version	nvarchar(MAX), CommServUid int)
	CREATE TABLE #V11Results (InstallTime DATETIME, Version	nvarchar(MAX), CommServUid int)
	CREATE TABLE #FinalResults (V10Quarter INT, V10Count INT, V11Count INT, V10QStart BIGINT, V11QStart BIGINT)
	INSERT INTO #V10Results
	SELECT MIN(InstallTime), '10.0', csInfo.CommServUniqueId
	FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.ReleaseId > 14
	GROUP BY csInfo.CommServUniqueId
	HAVING MIN(InstallTime) >= @releaseDateV10 AND MAX(csInfo.ReleaseId) = 15
	INSERT INTO #V11Results
	SELECT MIN(InstallTime), '11.0', csInfo.CommServUniqueId
	FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.ReleaseId > 15
	GROUP BY csInfo.CommServUniqueId
	HAVING MIN(InstallTime) >= @releaseDateV11 AND MAX(csInfo.ReleaseId) = 16
	SELECT @min100Inst = MIN (InstallTime), @max100Inst = MAX(InstallTime) FROM #V10Results
	SELECT @min110Inst = MIN (InstallTime), @max110Inst = MAX(InstallTime) FROM #V11Results
	INSERT INTO #FinalResults
	SELECT	V10.Quarter,
			CASE WHEN V10.InstallTime IS NULL THEN -1 ELSE V10.CcCount END AS 'V10 CommCell Count<NumberNA>',
			CASE WHEN V11.InstallTime IS NULL THEN -1 ELSE V11.CcCount END AS 'V11 CommCell Count<NumberNA>',
			datediff(second, '01/01/1970', V10.InstallTime) AS 'V10 Quarter Start Date<MMMYYYY><HIDDEN>',
			datediff(second, '01/01/1970', V11.InstallTime) AS 'V11 Quarter Start Date<MMMYYYY><HIDDEN>'
	FROM
	(
		SELECT MIN(IT) InstallTime, '10.0' Version, SUM(ISNULL(cccount, 0)) CcCount, ((MNum - 1)/3) + 1 Quarter FROM
		(
			SELECT Version, DATEPART(YEAR, InstallTime) Y, DATEPART(MONTH, InstallTime) M, COUNT(CommServUid) cccount
			FROM #V10Results GROUP BY DATEPART(YEAR, InstallTime), DATEPART(MONTH, InstallTime), Version
		) Results
		RIGHT OUTER JOIN
		(
			SELECT  DATEPART(YEAR, DATEADD(MONTH, x.number, @releaseDateV10)) AS Y, DATEPART(MONTH, DATEADD(MONTH, x.number, @releaseDateV10)) AS M, DATEADD(MONTH, x.number, @releaseDateV10) IT,
					ROW_NUMBER() OVER (ORDER BY DATEADD(MONTH, x.number, @releaseDateV10), DATEADD(MONTH, x.number, @releaseDateV10)) AS MNum
			FROM    SequenceNumbers x
			WHERE
				x.number <= DATEDIFF(MONTH, @releaseDateV10, @max100Inst)
		) Months
		ON Results.Y = Months.Y AND Results.M = Months.M
		GROUP BY (MNum - 1)/3
	) V10
	FULL OUTER JOIN
	(
		SELECT MIN(IT) InstallTime, '11.0' Version, SUM(ISNULL(cccount, 0)) CcCount, ((MNum - 1)/3) + 1 Quarter FROM
		(
			SELECT Version, DATEPART(YEAR, InstallTime) Y, DATEPART(MONTH, InstallTime) M, COUNT(CommServUid) cccount
			FROM #V11Results GROUP BY DATEPART(YEAR, InstallTime), DATEPART(MONTH, InstallTime), Version
		) Results
		RIGHT OUTER JOIN
		(
			SELECT  DATEPART(YEAR, DATEADD(MONTH, x.number, @releaseDateV11)) AS Y, DATEPART(MONTH, DATEADD(MONTH, x.number, @releaseDateV11)) AS M, DATEADD(MONTH, x.number, @releaseDateV11) IT,
					ROW_NUMBER() OVER (ORDER BY DATEADD(MONTH, x.number, @releaseDateV11), DATEADD(MONTH, x.number, @releaseDateV11)) AS MNum
			FROM    SequenceNumbers x
			WHERE
				x.number <= DATEDIFF(MONTH, @releaseDateV11, @max110Inst)
		) Months
		ON Results.Y = Months.Y AND Results.M = Months.M
		GROUP BY (MNum - 1)/3
	) V11
	ON V11.Quarter = V10.Quarter
	SELECT V10Quarter AS 'Quarter',
       (SELECT	CASE WHEN t.V10QStart IS NULL THEN -1 ELSE SUM(V10Count) END
        FROM	#FinalResults t2
        WHERE	t2.V10Quarter <= t.V10Quarter
       ) AS 'V10 CommCell Count<NumberNA>',
	   (SELECT	CASE WHEN t.V11QStart IS NULL THEN -1 ELSE SUM(V11Count) END
        FROM	#FinalResults t2
        WHERE	t2.V10Quarter <= t.V10Quarter
       ) AS 'V11 CommCell Count<NumberNA>',
	   ISNULL(V10QStart, -50) AS 'V10 Quarter Start Date<MMMYYYY><HIDDEN>',
	   ISNULL(V11QStart, -50) AS 'V11 Quarter Start Date<MMMYYYY><HIDDEN>'
	FROM #FinalResults t;
	DROP TABLE #V10Results
	DROP TABLE #V11Results
	DROP TABLE #FinalResults
END
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
	IF OBject_ID('tempdb.dbo.#UpgHistResults') IS NOT NULL DROP TABLE #UpgHistResults
	CREATE TABLE #UpgHistResults (	CommServUniqueId INT,
									CommCellID INT,
									CommServIP VARCHAR(256),
									CommServGUID VARCHAR(256),
									CommCellName VARCHAR(256),
									LogDate DATETIME,
									CommServTimeZone VARCHAR(256),
									RunningTime VARCHAR(256),
									ReleaseId INT,
									Version NVARCHAR(MAX),
									InstallTime DATETIME,
									RowId INT)
	-- Index didn't prove to be useful here as the time taken for Insertion is killing the time saved in select statements
	-- CREATE INDEX UpgHistIndex ON #UpgHistResults(CommServUniqueId, ReleaseId)
	INSERT INTO #UpgHistResults
	SELECT * FROM
	(SELECT
		resultView.CommServUniqueId,
		resultView.CommCellID,
		resultView.CommServIP,
		resultView.CommServGUID,
		resultView.DisplayName AS CommCellName,
		resultView.LogDate,
		resultView.CommServTimeZone,
		CASE
			WHEN resultView.RunningTime = -1 THEN 'N/A'
			ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
		END AS 'RunningTime',
		csInfo.ReleaseId,
		csInfo.Version,
		csInfo.InstallTime,
		ROW_NUMBER() OVER (PARTITION BY resultView.CommServUniqueId, csInfo.ReleaseId ORDER BY resultView.CommServUniqueId, csInfo.ReleaseId DESC) AS RowId
	FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	) AS sub
	WHERE sub.RowId = 1
	ORDER BY sub.LogDate DESC, sub.CommCellName ASC, sub.ReleaseId
	SELECT
		R1.CommServUniqueId AS 'CommServ UniqueId',
		CommCellID AS 'CommCell ID',
		CommServIP AS 'CommServe IP<HIDDEN>',
		CommServGUID AS 'CommServer GUID',
		CommCellName AS 'CommCell Name',
		DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
		ISNULL(CommServTimeZone, '')  AS 'TimeZone',
		RunningTime AS 'Running Time in Seconds',
		Version AS 'Version',
		datediff(second, '01/01/1970', InstallTime) AS 'Installed/Upgraded Date<MMMDDYYYY>',
		CASE WHEN R2.MaxReleaseId IS NULL THEN 'No' ELSE 'Yes' END AS 'Is Current Version',
		(SELECT (CASE ISNULL(MAX(ReleaseId), 0) WHEN 11 THEN '6.1' WHEN 12 THEN '7.0'
			WHEN 14 THEN '9.0' WHEN 15 THEN '10.0' WHEN 16 THEN '11.0' ELSE 'N/A' END)
			FROM #UpgHistResults I WHERE R1.CommServUniqueId = I.CommServUniqueId AND I.ReleaseId < R1.ReleaseId) AS 'Previous Version'
	FROM #UpgHistResults R1
	LEFT OUTER JOIN
	(	SELECT CommServUniqueId, MAX(ReleaseId) MaxReleaseId
		FROM #UpgHistResults GROUP BY CommServUniqueId
	) AS R2
		ON R1.CommServUniqueId = R2.CommServUniqueId AND R1.ReleaseId = R2.MaxReleaseId
	ORDER BY R1.LogDate DESC, R1.CommCellName ASC, R1.ReleaseId
	DROP TABLE #UpgHistResults
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.Version AS 'Version',
	datediff(second, '01/01/1970', csInfo.InstallTime) AS 'Installed/Upgraded Date<MMMDDYYYY>'
FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
ORDER BY csInfo.ReleaseId
END
END
ELSE
BEGIN
SELECT
	resultView.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.Version AS 'Version',
	csInfo.servicePack AS 'Feature Release',
	CASE WHEN csInfo.MaintenancePack IS NULL THEN -1 ELSE csInfo.MaintenancePack END AS 'Maintenance Release<NumberNA>',
	datediff(second, '01/01/1970', csInfo.InstallTime) AS 'Installed/Upgraded Date<MMMDDYYYY>'
FROM cf_SurveyServicePackUpgradeHistory AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY csInfo.Version desc ,csInfo.servicePack desc, csInfo.InstallTime desc
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptUpgradeHistory')
	delete from GxQscripts where name = 'RptUpgradeHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUpgradeHistory')
	delete from GXDBVersions where aliasname = 'RptUpgradeHistory'
GO

insert into GXDBVersions values(2, 'RptUpgradeHistory',  '00010013000200090000', 'RptUpgradeHistory', '00010013000200090000')
GO

