

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptUnprotectedClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptUnprotectedClients.sp,v $ $Id: RptUnprotectedClients.sp,v 1.11.2.14 2020/04/29 23:45:32 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptUnprotectedClients')
BEGIN
	print '>>> Drop Stored Procedure: RptUnprotectedClients <<<'
	drop procedure RptUnprotectedClients
END
IF EXISTS (select * from GxQscripts where name='RptUnprotectedClients')
	delete from GxQscripts where name = 'RptUnprotectedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUnprotectedClients')
	delete from GXDBVersions where aliasname = 'RptUnprotectedClients'
GO
print '... Creating Procedure: RptUnprotectedClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptUnprotectedClients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 0, -- 1 for SLA by Client Group 
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_SLADays INT = 30,
  @i_TenantName NVARCHAR(255) = NULL
AS
IF	@blaggregate NOT IN (0,1)
	RETURN
SET NOCOUNT ON
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
exec GetTenantEntities @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TenantName
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 27
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
IF	@blaggregate = 1
BEGIN
		SELECT
			CG.ClientGroupName AS 'Client Group',
			SUM(ProtectedClients) AS 'Met SLA',
			SUM(NotProtectedClients) AS 'Missed SLA',
			SUM(ExcludedClients) AS 'Excluded',
			CAST((CASE
					WHEN SUM(NotProtectedClients)+SUM(ProtectedClients) > 0
					THEN 100.0*SUM(ProtectedClients)/SUM(NotProtectedClients+ProtectedClients)
					ELSE 0 END) AS INT)
			AS 'SLA (%)',
			(CASE
					WHEN SUM(NotProtectedClients+ProtectedClients) > 0 and 100.0*SUM(ProtectedClients)/SUM(NotProtectedClients+ProtectedClients) < @criticalVal THEN @strCritical
					WHEN SUM(NotProtectedClients+ProtectedClients) > 0 and 100.0*SUM(ProtectedClients)/SUM(NotProtectedClients+ProtectedClients) < @warningVal THEN @strWarning
					ELSE @strGood END
			) AS 'Status<HEALTH_STATUS>'
		FROM
			cf_SurveyClientGroupSLASummary AS S WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey,  @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS R
				ON R.SurverResultId = S.SurveyResultId AND S.Days = @i_SLADays
			INNER JOIN cf_SurveyClientGroup AS CG WITH (NOLOCK)
				ON R.CommServUniqueId = CG.CommServUniqueId AND S.ClientGroupId = CG.ClientGroupId
		GROUP BY CG.ClientGroupName
		ORDER BY 'SLA (%)' ASC
END
ELSE
IF @i_CommServUniqueID = 0
BEGIN
	SET @i_QueryId = 146
	IF @i_SLADays = 30
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			resultView.DisplayName AS 'CommCell Name',
			ProtectedClients as 'Met SLA',
			NotProtectedClients as 'Missed SLA',
			ExcludedClients as 'Excluded',
			cast((CASE
					WHEN NotProtectedClients+ProtectedClients>0
					THEN ProtectedClients*100.0/(NotProtectedClients+ProtectedClients)
					ELSE 0 END) as int) as 'SLA (%)',
			(CASE
					WHEN NotProtectedClients+ProtectedClients>0 and ProtectedClients*100/(NotProtectedClients+ProtectedClients) < @criticalVal THEN @strCritical
					WHEN NotProtectedClients+ProtectedClients>0 and ProtectedClients*100/(NotProtectedClients+ProtectedClients) < @warningVal THEN @strWarning
					ELSE @strGood END ) as 'Status<HEALTH_STATUS>'
		FROM
			cf_CommcellSummary AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey,  @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY	'Status<HEALTH_STATUS>' desc,	cast((CASE
			WHEN NotProtectedClients+ProtectedClients>0
			THEN ProtectedClients*100.0/(NotProtectedClients+ProtectedClients)
			ELSE 0 END) as int) asc
	ELSE
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			resultView.DisplayName AS 'CommCell Name',
			ProtectedClients as 'Met SLA',
			NotProtectedClients as 'Missed SLA',
			ExcludedClients as 'Excluded',
			cast((CASE
					WHEN NotProtectedClients+ProtectedClients>0
					THEN ProtectedClients*100.0/(NotProtectedClients+ProtectedClients)
					ELSE 0 END) as int) as 'SLA (%)',
			(CASE
					WHEN NotProtectedClients+ProtectedClients>0 and ProtectedClients*100/(NotProtectedClients+ProtectedClients) < @criticalVal THEN @strCritical
					WHEN NotProtectedClients+ProtectedClients>0 and ProtectedClients*100/(NotProtectedClients+ProtectedClients) < @warningVal THEN @strWarning
					ELSE @strGood END ) as 'Status<HEALTH_STATUS>'
		FROM
			cf_SurveySLASummary AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey,  @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.Days = @i_SLADays
		ORDER BY	'Status<HEALTH_STATUS>' desc,	cast((CASE
			WHEN NotProtectedClients+ProtectedClients>0
			THEN ProtectedClients*100.0/(NotProtectedClients+ProtectedClients)
			ELSE 0 END) as int) asc
END
ELSE
BEGIN
	CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
	EXEC GetClientGroupsString @i_CommServUniqueID
	CREATE TABLE #LatestResult (SurverResultId INT, CommServUniqueId INT, CommServTimeZone VARCHAR(256))
	INSERT INTO  #LatestResult
	SELECT	SurverResultId, CommServUniqueId, CommServTimeZone
	FROM	dbo.cf_SurveyResultFuncV1(242, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
	UNION
	SELECT	SurverResultId, CommServUniqueId, CommServTimeZone
	FROM	dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		CL.ClientId AS 'ClientId<DONOTSHOW>',
		ISNULL (CL.ClientDisplayName, CL.clientName) AS [Client],
		CL.clientName  AS [Client(classic)<HIDDEN>],
		CASE WHEN SA.AppTypeId IS NULL AND ISNULL(CL.Type, 0)&8 > 0 THEN 106 ELSE SA.AppTypeId END AS 'AppTypeId<DONOTSHOW>',
		CASE WHEN SA.AgentName IS NULL AND ISNULL(CL.Type, 0)&8 > 0 THEN 'Virtual Server' ELSE SA.AgentName END
			+ CASE WHEN SA.AppTypeId = 106 AND CL.ClientName <> SA.ClientName THEN ' in ' + SA.ClientName ELSE '' END AS 'Agent',
		SA.InstanceId AS 'InstanceId<DONOTSHOW>',
		SA.InstanceName As 'Instance',
		SA.BackupsetId AS 'BackupsetId<DONOTSHOW>',
		SA.BackupsetName AS 'Backupset',
		SA.AppId AS 'AppId<DONOTSHOW>',
		SA.SubclientName AS 'Subclient',
		csInfo.Reason AS 'Reason',
		CASE WHEN ISNULL(csInfo.LastProtectedTime, '1970-01-01') = '1970-01-01' THEN -50
			ELSE datediff(second, '01/01/1970', dbo.UTCToLocalDateTimeConversion(csInfo.LastProtectedTime, resultView.CommServTimeZone))
		END AS 'Last Protected Time<MMMDDYYYY>',
		csInfo.LastBackupJobId AS 'Last Job Id<HIDDEN>',
		CASE WHEN ISNULL(csInfo.LastJobStartTime, '1970-01-01') = '1970-01-01' THEN -50
			ELSE datediff(second, '01/01/1970', dbo.UTCToLocalDateTimeConversion(csInfo.LastJobStartTime, resultView.CommServTimeZone))
		END AS 'Last Job Start<MMMDDYYYY>',
		csInfo.LastJobStatus AS 'Last Job Status',
		ISNULL(csInfo.ClientOwners, 'N/A') AS 'Client Owners<HIDDEN>',
		ISNULL(CGS.ClientGroups, '') AS 'Client Groups<HIDDEN>',
		CASE WHEN csInfo.Days < 0 THEN -csInfo.Days ELSE csInfo.Days END AS 'SLA Days'
	FROM cf_SurveySLADetails AS csInfo WITH (NOLOCK)
		INNER JOIN #LatestResult AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId AND (csInfo.Days = @i_SLADays OR csInfo.Days < 0)
		LEFT OUTER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON resultView.CommServUniqueId = SA.CommServUniqueId AND csInfo.AppId = SA.AppId AND (SA.Deleted = 0 OR SA.AppTypeId = 106)
		LEFT OUTER JOIN cf_SurveyClient CL WITH (NOLOCK) ON resultView.CommServUniqueId = CL.CommServUniqueId AND csInfo.ClientId = CL.ClientId AND CL.Deleted = 0
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON CL.CommServUniqueId = TC.CommServUniqueId AND CL.ClientId = TC.ClientId
		LEFT OUTER JOIN #ClientGroupsString CGS ON resultView.CommServUniqueId = CGS.CommServUniqueId AND csInfo.ClientId = CGS.ClientId
	WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
	ORDER BY 'Client', 'Agent', 'Instance', 'Backupset', 'Subclient'
	DROP TABLE #ClientGroupsString
	DROP TABLE #LatestResult
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Months, -36, @i_LogDateEND)
  DECLARE @i_SLADays INT				= 30
exec RptUnprotectedClients @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID,
		@i_LogDateStart, @i_LogDateEND, @i_SLADays
*/

IF EXISTS (select * from GxQscripts where name = 'RptUnprotectedClients')
	delete from GxQscripts where name = 'RptUnprotectedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUnprotectedClients')
	delete from GXDBVersions where aliasname = 'RptUnprotectedClients'
GO

insert into GXDBVersions values(2, 'RptUnprotectedClients',  '00010011000200140000', 'RptUnprotectedClients', '00010011000200140000')
GO

